/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CheckRequiredPluginsActivity
implements StartupActivity,
DumbAware {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Required Plugins", NotificationDisplayType.BALLOON, true);

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity", "runActivity"));
        }
        ExternalDependenciesManager.getInstance(project2);
    }

    public static void runCheck(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity", "runCheck"));
        }
        List<DependencyOnPlugin> dependencies = ExternalDependenciesManager.getInstance(project2).getDependencies(DependencyOnPlugin.class);
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        final ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        final ArrayList<PluginId> notInstalled = new ArrayList<PluginId>();
        for (DependencyOnPlugin dependency : dependencies) {
            String maxVersion;
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            if (plugin == null) {
                errorMessages.add("Plugin '" + dependency.getPluginId() + "' required for '" + project2.getName() + "' project isn't installed.");
                notInstalled.add(pluginId);
                continue;
            }
            if (!plugin.isEnabled()) {
                errorMessages.add("Plugin '" + plugin.getName() + "' required for '" + project2.getName() + "' project is disabled.");
                disabled.add(plugin);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            if (minVersion != null && VersionComparatorUtil.compare((String)plugin.getVersion(), (String)minVersion) < 0) {
                errorMessages.add("Project '" + project2.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + minVersion + "' or higher, but '" + plugin.getVersion() + "' is installed.");
            }
            if ((maxVersion = dependency.getMaxVersion()) == null || VersionComparatorUtil.compare((String)plugin.getVersion(), (String)maxVersion) <= 0) continue;
            errorMessages.add("Project '" + project2.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + minVersion + "' or lower, but '" + plugin.getVersion() + "' is installed.");
        }
        if (!errorMessages.isEmpty()) {
            if (!disabled.isEmpty() && notInstalled.isEmpty()) {
                String plugins2 = disabled.size() == 1 ? ((IdeaPluginDescriptor)disabled.get(0)).getName() : "required plugins";
                errorMessages.add("<a href=\"enable\">Enable " + plugins2 + "</a>");
            } else if (!disabled.isEmpty() || !notInstalled.isEmpty()) {
                errorMessages.add("<a href=\"install\">Install required plugins</a>");
            }
            NOTIFICATION_GROUP.createNotification("Required plugins weren't loaded", StringUtil.join(errorMessages, (String)"<br>"), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(final @NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity$1", "hyperlinkUpdate"));
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("enable".equals(event.getDescription())) {
                            notification.expire();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                PluginManagerCore.enablePlugin(descriptor.getPluginId().getIdString());
                            }
                            PluginManagerMain.notifyPluginsUpdated(project2);
                        } else {
                            HashSet<String> pluginIds = new HashSet<String>();
                            for (IdeaPluginDescriptor descriptor : disabled) {
                                pluginIds.add(descriptor.getPluginId().getIdString());
                            }
                            for (PluginId pluginId : notInstalled) {
                                pluginIds.add(pluginId.getIdString());
                            }
                            PluginsAdvertiser.installAndEnablePlugins(pluginIds, new Runnable(){

                                @Override
                                public void run() {
                                    notification.expire();
                                }
                            });
                        }
                    }
                }
            }).notify(project2);
        }
    }
}

