/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class JavaClassFindUsagesOptions
extends JavaFindUsagesOptions {
    public boolean isMethodsUsages;
    public boolean isFieldsUsages;
    public boolean isDerivedClasses;
    public boolean isImplementingClasses;
    public boolean isDerivedInterfaces;
    public boolean isCheckDeepInheritance;
    public boolean isIncludeInherited;

    public JavaClassFindUsagesOptions(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/JavaClassFindUsagesOptions", "<init>"));
        }
        super(project2);
        this.isMethodsUsages = false;
        this.isFieldsUsages = false;
        this.isDerivedClasses = false;
        this.isImplementingClasses = false;
        this.isDerivedInterfaces = false;
        this.isCheckDeepInheritance = true;
        this.isIncludeInherited = false;
    }

    @Override
    protected void addUsageTypes(@NotNull LinkedHashSet<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/find/findUsages/JavaClassFindUsagesOptions", "addUsageTypes"));
        }
        if (this.isUsages || this.isMethodsUsages || this.isFieldsUsages) {
            strings.add(FindBundle.message("find.usages.panel.title.usages", new Object[0]));
        }
        if (this.isDerivedClasses) {
            strings.add(FindBundle.message("find.usages.panel.title.derived.classes", new Object[0]));
        }
        if (this.isImplementingClasses) {
            strings.add(FindBundle.message("find.usages.panel.title.implementing.classes", new Object[0]));
        }
        if (this.isDerivedInterfaces) {
            strings.add(FindBundle.message("find.usages.panel.title.derived.interfaces", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaClassFindUsagesOptions that = (JavaClassFindUsagesOptions)o;
        if (this.isCheckDeepInheritance != that.isCheckDeepInheritance) {
            return false;
        }
        if (this.isDerivedClasses != that.isDerivedClasses) {
            return false;
        }
        if (this.isDerivedInterfaces != that.isDerivedInterfaces) {
            return false;
        }
        if (this.isFieldsUsages != that.isFieldsUsages) {
            return false;
        }
        if (this.isImplementingClasses != that.isImplementingClasses) {
            return false;
        }
        if (this.isIncludeInherited != that.isIncludeInherited) {
            return false;
        }
        return this.isMethodsUsages == that.isMethodsUsages;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.isMethodsUsages ? 1 : 0);
        result2 = 31 * result2 + (this.isFieldsUsages ? 1 : 0);
        result2 = 31 * result2 + (this.isDerivedClasses ? 1 : 0);
        result2 = 31 * result2 + (this.isImplementingClasses ? 1 : 0);
        result2 = 31 * result2 + (this.isDerivedInterfaces ? 1 : 0);
        result2 = 31 * result2 + (this.isCheckDeepInheritance ? 1 : 0);
        result2 = 31 * result2 + (this.isIncludeInherited ? 1 : 0);
        return result2;
    }
}

