/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFindUsagesOptions
extends FindUsagesOptions {
    public boolean isSkipImportStatements;

    public JavaFindUsagesOptions(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/JavaFindUsagesOptions", "<init>"));
        }
        super(project2);
        this.isSkipImportStatements = false;
        this.isUsages = true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.isSkipImportStatements == ((JavaFindUsagesOptions)o).isSkipImportStatements;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.isSkipImportStatements ? 1 : 0);
        return result2;
    }

    protected void addUsageTypes(@NotNull LinkedHashSet<String> to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/find/findUsages/JavaFindUsagesOptions", "addUsageTypes"));
        }
        if (this.isUsages) {
            to.add(FindBundle.message("find.usages.panel.title.usages", new Object[0]));
        }
    }

    @Override
    @NotNull
    public final String generateUsagesString() {
        String separator = " " + FindBundle.message("find.usages.panel.title.separator", new Object[0]) + " ";
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.addUsageTypes(strings);
        if (strings.isEmpty()) {
            strings.add(FindBundle.message("find.usages.panel.title.usages", new Object[0]));
        }
        String string = StringUtil.join(strings, (String)separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesOptions", "generateUsagesString"));
        }
        return string;
    }
}

