/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.copy.CopyHandler;

public class CopyElementAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        PsiDirectory defaultTargetDirectory;
        PsiElement[] elements;
        DataContext dataContext = e.getDataContext();
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            }
        }, "", null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiElement aElement = CopyElementAction.getTargetElement(editor, project2);
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            elements = new PsiElement[]{aElement};
            if (aElement == null || !CopyHandler.canCopy(elements)) {
                elements = new PsiElement[]{file2};
            }
            defaultTargetDirectory = file2.getContainingDirectory();
        } else {
            PsiElement element = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            defaultTargetDirectory = element instanceof PsiDirectory ? (PsiDirectory)element : null;
            elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        }
        this.doCopy(elements, defaultTargetDirectory);
    }

    protected void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        CopyHandler.doCopy(elements, defaultTargetDirectory);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(false);
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            this.updateForEditor(dataContext, presentation);
        } else {
            String id = ToolWindowManager.getInstance((Project)project2).getActiveToolWindowId();
            this.updateForToolWindow(id, dataContext, presentation);
        }
    }

    protected void updateForEditor(DataContext dataContext, Presentation presentation) {
        boolean result2;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setVisible(false);
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        PsiElement element = CopyElementAction.getTargetElement(editor, project2);
        boolean bl = result2 = element != null && CopyHandler.canCopy(new PsiElement[]{element});
        if (!result2 && file2 != null) {
            result2 = CopyHandler.canCopy(new PsiElement[]{file2});
        }
        presentation.setEnabled(result2);
        presentation.setVisible(true);
    }

    protected void updateForToolWindow(String toolWindowId, DataContext dataContext, Presentation presentation) {
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        presentation.setEnabled(elements != null && CopyHandler.canCopy(elements));
    }

    private static PsiElement getTargetElement(Editor editor, Project project2) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            element = file2;
        }
        return element;
    }
}

