/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.MyZipOutputStream;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"m\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001BE\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!d\u0005\u0005\u0003!\u0011Q\"\u0001M\u00033\rA1!D\u0001\u0019\bQ\u001b\u0019!d\n\t\t5\t\u0001TA\r\u0007\u0011\u0013iA!\u0003\u0002\n\u0003a-\u0001$B\r\u0004\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\b)\u000e\rQ\u0012\u0006\u0003\u0002\u0011!i\u0011\u0001g\u0004\u001a\u0007!EQ\"\u0001\r\n3\u0015A\u0019\"D\u0002\n\u0003\u0011\r\u0001DC\r\u0005\u0011+i!\u0001$\u0001\u0019\u0017Q\u001b\u0019!d\u0012\t\u00185Q\u0011BA\u0005\u00021\u0017IQ!\u0003\u0003\n\u0005%\t\u0001$\u0004M\r11I2\u0001c\u0007\u000e\u0003aq\u0011d\u0001E\u000f\u001b\u0005Ab\"\u0007\u0003\u0005\u0003!yQ\"\u0001M\u00103!!\u0011\u0001\u0003\t\u000e\u000b%\u0011\u0011\"\u0001M\b\u0019\u0003AR\u0001VB\u0002\u001bG!\u0011\u0001#\t\u000e\u0003a=\u0011d\u0001\u0005\u0012\u001b\u0005A\u001a#G\u0002\t%5\t\u0001tB\r\u0004\u0011Ki\u0011\u0001g\u0004U\u0007\u0007\t2\u0002B!\t\u0011\u0001i9\u0001'\u0001R\u0007\u0005!\u0011!U\u0002\u0002\u000b\u0001!61\u0001"}, strings={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ExportSettingsActionKt", "exportInstalledPlugins", "", "zipOut", "Lcom/intellij/ide/actions/MyZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/io/File;", "out", "Ljava/io/OutputStream;", "configPath", "", "getComponentPresentableName", "state", "Lcom/intellij/openapi/components/State;", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/ide/actions/ExportableItem;", "onlyExisting", "", "computePresentableNames", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "onlyPaths", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName"}, moduleName="configuration-store-impl")
public final class ExportSettingsActionKt {
    private static final Logger LOG = Logger.getInstance(ExportSettingsAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends File> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        MyZipOutputStream zipOut = new MyZipOutputStream(out);
        try {
            THashSet writtenItemRelativePaths = new THashSet();
            for (File file2 : exportFiles) {
                String relativePath;
                if (!file2.exists()) continue;
                if (FileUtilRt.getRelativePath((String)configPath, (String)FileUtilRt.toSystemIndependentName((String)file2.getAbsolutePath()), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOut, (File)null, (File)file2, (String)relativePath, (FileFilter)null, (Set)((Set)writtenItemRelativePaths));
            }
            ExportSettingsActionKt.exportInstalledPlugins(zipOut);
            ZipEntry zipEntry = new ZipEntry("IntelliJ IDEA Global Settings");
            zipOut.putNextEntry(zipEntry);
            zipOut.closeEntry();
        }
        finally {
            zipOut.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportInstalledPlugins(MyZipOutputStream zipOut) {
        ArrayList<String> plugins2 = new ArrayList<String>();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        for (int i = 0; i < ideaPluginDescriptorArray.length; ++i) {
            IdeaPluginDescriptor descriptor = ideaPluginDescriptorArray[i];
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            plugins2.add(descriptor.getPluginId().getIdString());
        }
        if (plugins2.isEmpty()) {
            return;
        }
        ZipEntry e = new ZipEntry("installed.txt");
        zipOut.putNextEntry(e);
        try {
            PluginManagerCore.writePluginsList((Collection<String>)plugins2, new OutputStreamWriter((OutputStream)zipOut, CharsetToolkit.UTF8_CHARSET));
        }
        finally {
            zipOut.closeEntry();
        }
    }

    @NotNull
    public static final Map<File, List<ExportableItem>> getExportableComponentsMap(boolean onlyExisting, boolean computePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result2 = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result2){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                List list = ArraysKt.toList((Object[])component.getExportFiles());
                String string = component.getPresentableName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                ExportableItem item = new ExportableItem(list, string, RoamingType.DEFAULT);
                for (File exportFile : item.getFiles()) {
                    UtilKt.putValue(this.$result, exportFile, item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Object[] objectArray = ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class);
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            Object element$iv = $receiver$iv[i];
            processor2.invoke(element$iv);
        }
        $receiver$iv = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        for (Object element$iv : $receiver$iv) {
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros(SchemeManagerFactoryImplKt.getROOT_CONFIG());
        Function1<File, Boolean> isSkipFile$ = new Function1<File, Boolean>(onlyPaths, configPath, onlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $onlyExisting;

            public final boolean invoke(@NotNull File file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)FileUtilKt.getSystemIndependentPath(file2), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)file2.getName(), (char)'.', (boolean)false, (int)2) && !file2.isFile()) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$onlyExisting && !file2.exists();
            }
            {
                this.$onlyPaths = set;
                this.$configPath = string;
                this.$onlyExisting = bl;
                super(1);
            }
        };
        if (onlyExisting || onlyPaths != null) {
            CollectionsKt.removeAll((Iterable)result2.keySet(), (Function1)((Function1)Reflection.function((FunctionReference)new Function1<File, Boolean>(isSkipFile$){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;

                public final boolean invoke(@NotNull File p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$isSkipFile.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/io/File;)Z";
                }
                {
                    this.$isSkipFile = var1_1;
                    super(1);
                }
            })));
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ServiceManagerImpl.processAllImplementationClasses((ApplicationImpl)application, (PairProcessor)new PairProcessor<Class<?>, PluginDescriptor>(storageManager2, isSkipFile$, computePresentableNames, result2){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;
            final /* synthetic */ boolean $computePresentableNames;
            final /* synthetic */ LinkedHashMap $result;

            public boolean process(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                File file2;
                boolean isFileIncluded;
                Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
                State stateAnnotation = StoreUtil.getStateSpec(aClass);
                if (stateAnnotation == null || StringsKt.isNullOrEmpty((CharSequence)stateAnnotation.name()) || ExportableComponent.class.isAssignableFrom(aClass)) {
                    return true;
                }
                Storage storage2 = (Storage)ArraysKt.firstOrNull((Object[])ComponentStoreImplKt.sortStoragesByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                if (!(Intrinsics.areEqual((Object)storage3.roamingType(), (Object)RoamingType.DISABLED) ^ true) || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage3.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class)) || !Intrinsics.areEqual((Object)storage3.scheme(), (Object)StorageScheme.DEFAULT) || StringsKt.isNullOrEmpty((CharSequence)storage3.file())) {
                    return true;
                }
                File additionalExportFile = null;
                String additionalExportPath = stateAnnotation.additionalExportFile();
                if (StringsKt.isNotEmpty((CharSequence)additionalExportPath)) {
                    if (additionalExportPath.charAt(0) != '$') {
                        additionalExportPath = SchemeManagerFactoryImplKt.getROOT_CONFIG() + "/" + additionalExportPath;
                    }
                    if (this.$isSkipFile.invoke(additionalExportFile = new File(this.$storageManager.expandMacros(additionalExportPath)))) {
                        additionalExportFile = null;
                    }
                }
                boolean bl = isFileIncluded = !this.$isSkipFile.invoke(file2 = new File(this.$storageManager.expandMacros(storage3.file())));
                if (isFileIncluded || additionalExportFile != null) {
                    List files = additionalExportFile == null ? CollectionsKt.listOf((Object)file2) : (isFileIncluded ? CollectionsKt.listOf((Object[])new File[]{file2, additionalExportFile}) : CollectionsKt.listOf((Object)additionalExportFile));
                    ExportableItem item = new ExportableItem(files, this.$computePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "", storage3.roamingType());
                    UtilKt.putValue(this.$result, file2, item);
                    if (additionalExportFile != null) {
                        UtilKt.putValue(this.$result, additionalExportFile, item);
                    }
                }
                return true;
            }
            {
                this.$storageManager = $captured_local_variable$0;
                this.$isSkipFile = $captured_local_variable$1;
                this.$computePresentableNames = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
            }
        });
        return result2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set, int n) {
        if ((n & 4) != 0) {
            StateStorageManager stateStorageManager2 = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"ApplicationManager.getAp\u2026Store.stateStorageManager");
            stateStorageManager = stateStorageManager2;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set);
    }

    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        Object classLoader;
        Class presentableName = JvmClassMappingKt.getJavaClass((KClass)Reflection.getOrCreateKotlinClass((Class)state.presentableName()));
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                String string = (String)((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return string;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        String defaultName = state.name();
        String string = pluginDescriptor instanceof IdeaPluginDescriptor && Intrinsics.areEqual((Object)"com.intellij", (Object)((IdeaPluginDescriptor)pluginDescriptor).getPluginId().getIdString()) ^ true ? ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName() : "messages.OptionsBundle";
        if (string == null) {
            return defaultName;
        }
        String resourceBundleName = string;
        Object object = pluginDescriptor;
        if (object == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader != null) {
            String message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName);
            if (message != defaultName) {
                return message;
            }
            if (PlatformUtils.isRubyMine()) {
                return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, "org.jetbrains.plugins.ruby.RBundle", defaultName);
            }
        }
        return defaultName;
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.messageOrDe\u2026table.name\", defaultName)");
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$getComponentPresentableName(@NotNull State state, @NotNull Class aClass, @Nullable PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

