/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UrlUtil {
    private static final String JAR_SEPARATOR = "!/";
    private static final String URL_PATH_SEPARATOR = "/";
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE_PROTOCOL_PREFIX = "file:";

    public static String loadText(URL url) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(URLUtil.openStream((URL)url));
        try {
            String string = new String(FileUtil.loadBytes((InputStream)stream), "UTF-8");
            return string;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public static List<String> getChildrenRelativePaths(URL root) throws IOException {
        String protocol = root.getProtocol();
        if ("jar".equalsIgnoreCase(protocol)) {
            return UrlUtil.getChildPathsFromJar(root);
        }
        if (FILE_PROTOCOL.equalsIgnoreCase(protocol)) {
            return UrlUtil.getChildPathsFromFile(root);
        }
        return Collections.emptyList();
    }

    private static List<String> getChildPathsFromFile(URL root) {
        final ArrayList<String> paths = new ArrayList<String>();
        File rootFile = new File(FileUtil.unquote((String)root.getPath()));
        new Object(){

            void collectFiles(File fromFile, String prefix) {
                File[] list = fromFile.listFiles();
                if (list != null) {
                    for (File file2 : list) {
                        String childRelativePath;
                        String string = childRelativePath = prefix.length() == 0 ? file2.getName() : prefix + UrlUtil.URL_PATH_SEPARATOR + file2.getName();
                        if (file2.isDirectory()) {
                            this.collectFiles(file2, childRelativePath);
                            continue;
                        }
                        paths.add(childRelativePath);
                    }
                }
            }
        }.collectFiles(rootFile, "");
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getChildPathsFromJar(URL root) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        String file2 = root.getFile();
        file2 = StringUtil.trimStart((String)file2, (String)FILE_PROTOCOL_PREFIX);
        int jarSeparatorIndex = file2.indexOf(JAR_SEPARATOR);
        assert (jarSeparatorIndex > 0);
        String rootDirName = file2.substring(jarSeparatorIndex + 2);
        if (!rootDirName.endsWith(URL_PATH_SEPARATOR)) {
            rootDirName = rootDirName + URL_PATH_SEPARATOR;
        }
        ZipFile zipFile = new ZipFile(FileUtil.unquote((String)file2.substring(0, jarSeparatorIndex)));
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String relPath;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(relPath = entry.getName()).startsWith(rootDirName)) continue;
                paths.add(relPath.substring(rootDirName.length()));
            }
            ArrayList<String> arrayList = paths;
            return arrayList;
        }
        finally {
            zipFile.close();
        }
    }
}

