/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.containers.HashMap;
import java.lang.reflect.Array;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class DataValidator<T> {
    private static boolean ourExtensionsLoaded;
    public static final ExtensionPointName<KeyedLazyInstanceEP<DataValidator>> EP_NAME;
    Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataValidator");
    private static final Map<String, DataValidator> ourValidators;
    private static final DataValidator<VirtualFile> VIRTUAL_FILE_VALIDATOR;
    private static final DataValidator<Project> PROJECT_VALIDATOR;

    @Nullable
    public abstract T findInvalid(String var1, T var2, Object var3);

    private static <T> DataValidator<T> getValidator(String dataId) {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (KeyedLazyInstanceEP ep : (KeyedLazyInstanceEP[])Extensions.getExtensions(EP_NAME)) {
                ourValidators.put(ep.key, (DataValidator)ep.getInstance());
            }
        }
        return ourValidators.get(dataId);
    }

    public static <T> T findInvalidData(String dataId, Object data, Object dataSource) {
        if (data == null) {
            return null;
        }
        DataValidator<Object> validator = DataValidator.getValidator(dataId);
        if (validator != null) {
            return (T)validator.findInvalid(dataId, data, dataSource);
        }
        return null;
    }

    static {
        EP_NAME = ExtensionPointName.create((String)"com.intellij.dataValidator");
        ourValidators = new HashMap();
        VIRTUAL_FILE_VALIDATOR = new DataValidator<VirtualFile>(){

            @Override
            public VirtualFile findInvalid(String dataId, VirtualFile file2, Object dataSource) {
                return file2.isValid() ? null : file2;
            }
        };
        PROJECT_VALIDATOR = new DataValidator<Project>(){

            @Override
            public Project findInvalid(String dataId, Project project2, Object dataSource) {
                return project2.isDisposed() ? project2 : null;
            }
        };
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE.getName(), VIRTUAL_FILE_VALIDATOR);
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), new ArrayValidator<VirtualFile>(VIRTUAL_FILE_VALIDATOR));
        ourValidators.put(CommonDataKeys.PROJECT.getName(), PROJECT_VALIDATOR);
    }

    public static class ArrayValidator<T>
    extends DataValidator<T[]> {
        private final DataValidator<T> myElementValidator;

        public ArrayValidator(DataValidator<T> elementValidator) {
            this.myElementValidator = elementValidator;
        }

        @Override
        public T[] findInvalid(String dataId, T[] array, Object dataSource) {
            for (T element : array) {
                T invalid;
                if (element == null) {
                    this.LOG.error("Data isn't valid. " + dataId + "=null Provided by: " + dataSource.getClass().getName() + " (" + dataSource.toString() + ")");
                }
                if ((invalid = this.myElementValidator.findInvalid(dataId, element, dataSource)) == null) continue;
                Object[] result2 = (Object[])Array.newInstance(array[0].getClass(), 1);
                result2[0] = invalid;
                return result2;
            }
            return null;
        }
    }
}

