/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePasswordSafeProvider
extends PasswordSafeProvider {
    @NotNull
    protected abstract byte[] key(@Nullable Project var1, @NotNull Class var2) throws PasswordSafeException;

    @Override
    @Nullable
    public String getPassword(@Nullable Project project2, @NotNull Class requestor, String key) throws PasswordSafeException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider", "getPassword"));
        }
        byte[] k = this.dbKey(project2, requestor, key);
        byte[] ct = this.getEncryptedPassword(k);
        return ct == null ? null : EncryptionUtil.decryptText(this.key(project2, requestor), ct);
    }

    protected abstract byte[] getEncryptedPassword(byte[] var1);

    private byte[] dbKey(@Nullable Project project2, Class requestor, String key) throws PasswordSafeException {
        return EncryptionUtil.dbKey(this.key(project2, requestor), requestor, key);
    }

    @Override
    public void removePassword(@Nullable Project project2, @NotNull Class requester, String key) throws PasswordSafeException {
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider", "removePassword"));
        }
        byte[] k = this.dbKey(project2, requester, key);
        this.removeEncryptedPassword(k);
    }

    protected abstract void removeEncryptedPassword(byte[] var1);

    @Override
    public void storePassword(@Nullable Project project2, @NotNull Class requestor, String key, String value) throws PasswordSafeException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider", "storePassword"));
        }
        byte[] k = this.dbKey(project2, requestor, key);
        byte[] ct = EncryptionUtil.encryptText(this.key(project2, requestor), value);
        this.storeEncryptedPassword(k, ct);
    }

    protected abstract void storeEncryptedPassword(byte[] var1, byte[] var2);
}

