/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.EdtSortingModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionModel
implements ChooseByNameModel,
CustomMatcherModel,
Comparator<Object>,
EdtSortingModel,
DumbAware {
    @Nullable
    private final Project myProject;
    private final Component myContextComponent;
    protected final ActionManager myActionManager = ActionManager.getInstance();
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private Pattern myCompiledPattern;
    protected final SearchableOptionsRegistrar myIndex;
    protected final Map<AnAction, String> myActionGroups = ContainerUtil.newHashMap();
    protected final Map<String, ApplyIntentionAction> myIntentions = new TreeMap<String, ApplyIntentionAction>();
    private final Map<String, String> myConfigurablesNames = ContainerUtil.newTroveMap();
    private final ThreadLocal<PatternMatcher> myMatcher = new ThreadLocal<PatternMatcher>(){

        @Override
        protected PatternMatcher initialValue() {
            return new Perl5Matcher();
        }
    };

    public GotoActionModel(@Nullable Project project2, Component component) {
        this(project2, component, null, null);
    }

    public GotoActionModel(@Nullable Project project2, Component component, @Nullable Editor editor, @Nullable PsiFile file2) {
        ApplyIntentionAction[] children2;
        this.myProject = project2;
        this.myContextComponent = component;
        ActionGroup mainMenu = (ActionGroup)this.myActionManager.getActionOrStub("MainMenu");
        this.collectActions(this.myActionGroups, mainMenu, mainMenu.getTemplatePresentation().getText());
        if (project2 != null && editor != null && file2 != null && (children2 = ApplyIntentionAction.getAvailableIntentions(editor, file2)) != null) {
            for (ApplyIntentionAction action : children2) {
                this.myIntentions.put(action.getName(), action);
            }
        }
        this.myIndex = SearchableOptionsRegistrar.getInstance();
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        this.fillConfigurablesNames(ShowSettingsUtilImpl.getConfigurables(project2, true));
    }

    private void fillConfigurablesNames(Configurable[] configurables) {
        for (Configurable configurable : configurables) {
            if (!(configurable instanceof SearchableConfigurable)) continue;
            this.myConfigurablesNames.put(((SearchableConfigurable)configurable).getId(), configurable.getDisplayName());
        }
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoaction.enter.action", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return null;
    }

    public char getCheckBoxMnemonic() {
        return 'd';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.menu.actions.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.actions.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        return true;
    }

    public void saveInitialCheckBoxState(boolean state) {
    }

    public ListCellRenderer getListCellRenderer() {
        return new GotoActionListCellRenderer(new Function<OptionDescription, String>(){

            public String fun(OptionDescription description) {
                return GotoActionModel.this.getGroupName(description);
            }
        });
    }

    protected String getActionId(@NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/util/gotoByName/GotoActionModel", "getActionId"));
        }
        return this.myActionManager.getId(anAction);
    }

    private static JLabel createIconLabel(Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconWidth() <= EMPTY_ICON.getIconWidth() && icon.getIconHeight() <= EMPTY_ICON.getIconHeight()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        return new JLabel((Icon)layeredIcon);
    }

    protected JLabel createActionLabel(AnAction anAction, String anActionName, Color fg, Color bg, Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconWidth() <= EMPTY_ICON.getIconWidth() && icon.getIconHeight() <= EMPTY_ICON.getIconHeight()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        Shortcut shortcut = GotoActionModel.preferKeyboardShortcut(KeymapManager.getInstance().getActiveKeymap().getShortcuts(this.getActionId(anAction)));
        String actionName = anActionName + (shortcut != null ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")" : "");
        JLabel actionLabel = new JLabel(actionName, (Icon)layeredIcon, 2);
        actionLabel.setBackground(bg);
        actionLabel.setForeground(fg);
        return actionLabel;
    }

    private static Shortcut preferKeyboardShortcut(Shortcut[] shortcuts) {
        if (shortcuts != null) {
            for (Shortcut shortcut : shortcuts) {
                if (!shortcut.isKeyboard()) continue;
                return shortcut;
            }
            return shortcuts.length > 0 ? shortcuts[0] : null;
        }
        return null;
    }

    @Override
    public int compare(@NotNull Object o1, @NotNull Object o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/util/gotoByName/GotoActionModel", "compare"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/util/gotoByName/GotoActionModel", "compare"));
        }
        if ("...".equals(o1)) {
            return 1;
        }
        if ("...".equals(o2)) {
            return -1;
        }
        return ((MatchedValue)o1).compareTo((MatchedValue)o2);
    }

    public static AnActionEvent updateActionBeforeShow(AnAction anAction, DataContext dataContext) {
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"GoToAction", null, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)false);
        ActionUtil.performDumbAwareUpdate((AnAction)anAction, (AnActionEvent)event, (boolean)true);
        return event;
    }

    protected static Color defaultActionForeground(boolean isSelected, @Nullable Presentation presentation) {
        if (isSelected) {
            return UIUtil.getListSelectionForeground();
        }
        if (!(presentation == null || presentation.isEnabled() && presentation.isVisible())) {
            return UIUtil.getInactiveTextColor();
        }
        return UIUtil.getListForeground();
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Object[] getElementsByName(String id, boolean checkBoxState, String pattern) {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getElementsByName"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    String getGroupName(@NotNull OptionDescription description) {
        String settings;
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
        }
        String id = description.getConfigurableId();
        String name = this.myConfigurablesNames.get(id);
        String string = settings = SystemInfo.isMac ? "Preferences" : "Settings";
        if (name == null) {
            String string2 = settings;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
            }
            return string2;
        }
        String string3 = settings + " > " + name;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getGroupName"));
        }
        return string3;
    }

    private void collectActions(Map<AnAction, String> result2, ActionGroup group, String containingGroupName) {
        AnAction[] actions = group.getChildren(null);
        this.includeGroup(result2, group, actions, containingGroupName);
        for (AnAction action : actions) {
            if (action == null) continue;
            if (action instanceof ActionGroup) {
                ActionGroup actionGroup;
                String groupName = (actionGroup = (ActionGroup)action).getTemplatePresentation().getText();
                this.collectActions(result2, actionGroup, StringUtil.isEmpty((String)groupName) || !actionGroup.isPopup() ? containingGroupName : groupName);
                continue;
            }
            String groupName = group.getTemplatePresentation().getText();
            if (result2.containsKey(action)) {
                result2.put(action, null);
                continue;
            }
            result2.put(action, StringUtil.isEmpty((String)groupName) ? containingGroupName : groupName);
        }
    }

    private void includeGroup(Map<AnAction, String> result2, ActionGroup group, AnAction[] actions, String containingGroupName) {
        boolean showGroup = true;
        for (AnAction action : actions) {
            if (this.myActionManager.getId(action) == null) continue;
            showGroup = false;
            break;
        }
        if (showGroup) {
            result2.put((AnAction)group, containingGroupName);
        }
    }

    @Nullable
    public String getFullName(Object element) {
        return this.getElementName(element);
    }

    @NonNls
    public String getHelpId() {
        return "procedures.navigating.goto.action";
    }

    @NotNull
    public String[] getSeparators() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getSeparators"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getElementName(Object mv) {
        return ((MatchedValue)mv).getValueText();
    }

    @Override
    public boolean matches(@NotNull String name, @NotNull String pattern) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/gotoByName/GotoActionModel", "matches"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel", "matches"));
        }
        AnAction anAction = this.myActionManager.getAction(name);
        if (anAction == null) {
            return true;
        }
        return this.actionMatches(pattern, anAction) != MatchMode.NONE;
    }

    protected MatchMode actionMatches(String pattern, @NotNull AnAction anAction) {
        if (anAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anAction", "com/intellij/ide/util/gotoByName/GotoActionModel", "actionMatches"));
        }
        Pattern compiledPattern = this.getPattern(pattern);
        Presentation presentation = anAction.getTemplatePresentation();
        String text = presentation.getText();
        String description = presentation.getDescription();
        String groupName = this.myActionGroups.get(anAction);
        PatternMatcher matcher = this.getMatcher();
        if (text != null && matcher.matches(text, compiledPattern)) {
            return MatchMode.NAME;
        }
        if (description != null && !description.equals(text) && matcher.matches(description, compiledPattern)) {
            return MatchMode.DESCRIPTION;
        }
        if (text == null) {
            return MatchMode.NONE;
        }
        if (groupName == null) {
            return GotoActionModel.matches(pattern, compiledPattern, matcher, text) ? MatchMode.NON_MENU : MatchMode.NONE;
        }
        if (GotoActionModel.matches(pattern, compiledPattern, matcher, groupName + " " + text)) {
            return anAction instanceof ToggleAction ? MatchMode.NAME : MatchMode.GROUP;
        }
        return GotoActionModel.matches(pattern, compiledPattern, matcher, text + " " + groupName) ? MatchMode.GROUP : MatchMode.NONE;
    }

    private static boolean matches(String pattern, Pattern compiledPattern, PatternMatcher matcher, String str) {
        return StringUtil.containsIgnoreCase((String)str, (String)pattern) || matcher.matches(str, compiledPattern);
    }

    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    protected Component getContextComponent() {
        return this.myContextComponent;
    }

    @NotNull
    Pattern getPattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel", "getPattern"));
        }
        String converted = GotoActionModel.convertPattern(pattern.trim());
        Pattern compiledPattern = this.myCompiledPattern;
        if (compiledPattern != null && !Comparing.strEqual((String)converted, (String)compiledPattern.getPattern())) {
            compiledPattern = null;
        }
        if (compiledPattern == null) {
            try {
                this.myCompiledPattern = compiledPattern = new Perl5Compiler().compile(converted, 32768);
            }
            catch (MalformedPatternException malformedPatternException) {
                // empty catch block
            }
        }
        Pattern pattern2 = compiledPattern;
        if (pattern2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "getPattern"));
        }
        return pattern2;
    }

    @Override
    @NotNull
    public SortedSet<Object> sort(@NotNull Set<Object> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/gotoByName/GotoActionModel", "sort"));
        }
        TreeSet objects = ContainerUtilRt.newTreeSet((Comparator)this);
        objects.addAll(elements);
        TreeSet treeSet = objects;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel", "sort"));
        }
        return treeSet;
    }

    static String convertPattern(String pattern) {
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 80) {
            pattern = pattern.substring(0, 80);
        }
        StringBuilder buffer = new StringBuilder();
        boolean allowToLower = true;
        if (GotoActionModel.containsOnlyUppercaseLetters(pattern)) {
            allowToLower = false;
        }
        if (allowToLower) {
            buffer.append(".*");
        }
        boolean firstIdentifierLetter = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    if (!firstIdentifierLetter) {
                        buffer.append("[^A-Z]*");
                    }
                    buffer.append("[");
                    buffer.append(c);
                    if (allowToLower || i == 0) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    buffer.append("]");
                } else if (Character.isLowerCase(c)) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append('|');
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                buffer.append("\\.");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append(".*\\ ");
                firstIdentifierLetter = true;
                continue;
            }
            firstIdentifierLetter = true;
            buffer.append("\\x");
            buffer.append(Integer.toHexString(c + 131072).substring(3));
        }
        buffer.append(".*");
        return buffer.toString();
    }

    private static boolean containsOnlyUppercaseLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*' || c == ' ' || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean willOpenEditor() {
        return false;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    PatternMatcher getMatcher() {
        return this.myMatcher.get();
    }

    public static class GotoActionListCellRenderer
    extends DefaultListCellRenderer {
        private final Function<OptionDescription, String> myGroupNamer;

        public GotoActionListCellRenderer(Function<OptionDescription, String> groupNamer) {
            this.myGroupNamer = groupNamer;
        }

        @Override
        public Component getListCellRendererComponent(@NotNull JList list, Object matchedValue, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "getListCellRendererComponent"));
            }
            boolean showIcon = UISettings.getInstance().SHOW_ICONS_IN_MENUS;
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(IdeBorderFactory.createEmptyBorder((int)2));
            panel.setOpaque(true);
            Color bg = UIUtil.getListBackground((boolean)isSelected);
            panel.setBackground(bg);
            SimpleColoredComponent nameComponent = new SimpleColoredComponent();
            nameComponent.setBackground(bg);
            panel.add((Component)nameComponent, "Center");
            if (matchedValue instanceof String) {
                nameComponent.append((String)matchedValue, new SimpleTextAttributes(0, GotoActionModel.defaultActionForeground(isSelected, null)));
                if (showIcon) {
                    panel.add((Component)new JBLabel(EMPTY_ICON), "West");
                }
                return panel;
            }
            Color groupFg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getLabelDisabledForeground();
            Comparable value = ((MatchedValue)matchedValue).value;
            String pattern = ((MatchedValue)matchedValue).pattern;
            Border eastBorder = IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)2);
            if (value instanceof ActionWrapper) {
                ActionWrapper actionWithParentGroup = (ActionWrapper)value;
                AnAction anAction = actionWithParentGroup.getAction();
                Presentation presentation = anAction.getTemplatePresentation();
                boolean toggle = anAction instanceof ToggleAction;
                String groupName = actionWithParentGroup.getAction() instanceof ApplyIntentionAction ? null : actionWithParentGroup.getGroupName();
                Color fg = GotoActionModel.defaultActionForeground(isSelected, actionWithParentGroup.getPresentation());
                if (showIcon) {
                    panel.add((Component)GotoActionModel.createIconLabel(presentation.getIcon()), "West");
                }
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, this.getName(presentation.getText(), groupName, toggle), pattern, fg, isSelected);
                Shortcut shortcut = GotoActionModel.preferKeyboardShortcut(KeymapManager.getInstance().getActiveKeymap().getShortcuts(ActionManager.getInstance().getId(anAction)));
                if (shortcut != null) {
                    nameComponent.append(" " + KeymapUtil.getShortcutText((Shortcut)shortcut), new SimpleTextAttributes(129, UIUtil.isUnderDarcula() ? groupFg : ColorUtil.shift((Color)groupFg, (double)1.3)));
                }
                if (toggle) {
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((ActionWrapper)value).myDataContext);
                    boolean selected = ((ToggleAction)anAction).isSelected(event);
                    GotoActionListCellRenderer.addOnOffButton(panel, selected);
                } else if (groupName != null) {
                    JLabel groupLabel = new JLabel(groupName);
                    groupLabel.setBackground(bg);
                    groupLabel.setBorder(eastBorder);
                    groupLabel.setForeground(groupFg);
                    panel.add((Component)groupLabel, "East");
                }
            } else if (value instanceof OptionDescription) {
                String hit;
                if (!isSelected && !(value instanceof BooleanOptionDescription)) {
                    Color descriptorBg = UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)UIUtil.getListBackground(), (int)1) : LightColors.SLIGHTLY_GRAY;
                    panel.setBackground(descriptorBg);
                    nameComponent.setBackground(descriptorBg);
                }
                if ((hit = ((OptionDescription)value).getHit()) == null) {
                    hit = ((OptionDescription)value).getOption();
                }
                hit = StringUtil.unescapeXml((String)hit);
                String fullHit = hit = hit.replace("  ", " ");
                hit = StringUtil.first((String)hit, (int)45, (boolean)true);
                Color fg = UIUtil.getListForeground((boolean)isSelected);
                GotoActionListCellRenderer.appendWithColoredMatches(nameComponent, hit.trim(), pattern, fg, isSelected);
                if (showIcon) {
                    panel.add((Component)new JLabel(EMPTY_ICON), "West");
                }
                panel.setToolTipText(fullHit);
                if (value instanceof BooleanOptionDescription) {
                    boolean selected = ((BooleanOptionDescription)value).isOptionEnabled();
                    GotoActionListCellRenderer.addOnOffButton(panel, selected);
                } else {
                    JLabel settingsLabel = new JLabel((String)this.myGroupNamer.fun((Object)((OptionDescription)value)));
                    settingsLabel.setForeground(groupFg);
                    settingsLabel.setBackground(bg);
                    settingsLabel.setBorder(eastBorder);
                    panel.add((Component)settingsLabel, "East");
                }
            }
            return panel;
        }

        private static void addOnOffButton(@NotNull JPanel panel, boolean selected) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/ide/util/gotoByName/GotoActionModel$GotoActionListCellRenderer", "addOnOffButton"));
            }
            OnOffButton button = new OnOffButton();
            button.setSelected(selected);
            panel.add((Component)button, "East");
            panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)2));
        }

        public String getName(String text, String groupName, boolean toggle) {
            return toggle && StringUtil.isNotEmpty((String)groupName) ? groupName + ": " + text : text;
        }

        private static void appendWithColoredMatches(SimpleColoredComponent nameComponent, String name, String pattern, Color fg, boolean selected) {
            int matchStart;
            SimpleTextAttributes plain = new SimpleTextAttributes(0, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(null, fg, null, 64);
            ArrayList fragments = ContainerUtil.newArrayList();
            if (selected && (matchStart = StringUtil.indexOfIgnoreCase((String)name, (String)pattern, (int)0)) >= 0) {
                fragments.add(TextRange.from((int)matchStart, (int)pattern.length()));
            }
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, (Iterable)fragments, (SimpleTextAttributes)plain, (SimpleTextAttributes)highlighted);
        }
    }

    public static class ActionWrapper
    implements Comparable<ActionWrapper> {
        @NotNull
        private final AnAction myAction;
        @NotNull
        private final MatchMode myMode;
        @Nullable
        private final String myGroupName;
        private final DataContext myDataContext;
        private Presentation myPresentation;

        public ActionWrapper(@NotNull AnAction action, @Nullable String groupName, @NotNull MatchMode mode, DataContext dataContext) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "<init>"));
            }
            this.myAction = action;
            this.myMode = mode;
            this.myGroupName = groupName;
            this.myDataContext = dataContext;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "getAction"));
            }
            return anAction;
        }

        @NotNull
        public MatchMode getMode() {
            MatchMode matchMode = this.myMode;
            if (matchMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "getMode"));
            }
            return matchMode;
        }

        @Override
        public int compareTo(@NotNull ActionWrapper o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/ide/util/gotoByName/GotoActionModel$ActionWrapper", "compareTo"));
            }
            int compared = this.myMode.compareTo(o.getMode());
            if (compared != 0) {
                return compared;
            }
            Presentation myPresentation = this.myAction.getTemplatePresentation();
            Presentation oPresentation = o.getAction().getTemplatePresentation();
            String myText = myPresentation.getText();
            String oText = oPresentation.getText();
            int byTextLength = StringUtil.notNullize((String)myText).length() - StringUtil.notNullize((String)oText).length();
            if (byTextLength != 0) {
                return byTextLength;
            }
            int byText = StringUtil.compare((String)myText, (String)oText, (boolean)true);
            if (byText != 0) {
                return byText;
            }
            int byGroup = Comparing.compare((Comparable)((Object)this.myGroupName), (Comparable)((Object)o.getGroupName()));
            if (byGroup != 0) {
                return byGroup;
            }
            int byDesc = StringUtil.compare((String)myPresentation.getDescription(), (String)oPresentation.getDescription(), (boolean)true);
            if (byDesc != 0) {
                return byDesc;
            }
            return 0;
        }

        public boolean isAvailable() {
            return this.getPresentation().isEnabledAndVisible();
        }

        public Presentation getPresentation() {
            if (this.myPresentation != null) {
                return this.myPresentation;
            }
            this.myPresentation = GotoActionModel.updateActionBeforeShow(this.myAction, this.myDataContext).getPresentation();
            return this.myPresentation;
        }

        @Nullable
        public String getGroupName() {
            if (this.myAction instanceof ActionGroup && Comparing.equal((String)this.myAction.getTemplatePresentation().getText(), (String)this.myGroupName)) {
                return null;
            }
            return this.myGroupName;
        }

        public boolean isGroupAction() {
            return this.myAction instanceof ActionGroup;
        }

        public boolean equals(Object obj) {
            return obj instanceof ActionWrapper && this.compareTo((ActionWrapper)obj) == 0;
        }

        public int hashCode() {
            String text = this.myAction.getTemplatePresentation().getText();
            return text != null ? text.hashCode() : 0;
        }

        public String toString() {
            return this.myAction.toString();
        }
    }

    @VisibleForTesting
    public static enum MatchMode {
        NONE,
        INTENTION,
        NAME,
        DESCRIPTION,
        GROUP,
        NON_MENU;

    }

    public static class MatchedValue
    implements Comparable<MatchedValue> {
        @NotNull
        public final Comparable value;
        @NotNull
        final String pattern;

        public MatchedValue(@NotNull Comparable value, @NotNull String pattern) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "<init>"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "<init>"));
            }
            this.value = value;
            this.pattern = pattern;
        }

        @Nullable
        @VisibleForTesting
        public String getValueText() {
            if (this.value instanceof OptionDescription) {
                return ((OptionDescription)this.value).getHit();
            }
            if (!(this.value instanceof ActionWrapper)) {
                return null;
            }
            return ((ActionWrapper)this.value).getAction().getTemplatePresentation().getText();
        }

        public String toString() {
            return this.getMatchingDegree() + " " + this.getValueText();
        }

        private int getMatchingDegree() {
            String text = this.getValueText();
            if (text != null) {
                int degree = this.getRank(text);
                return this.value instanceof ActionWrapper && !((ActionWrapper)this.value).isGroupAction() ? degree + 1 : degree;
            }
            return 0;
        }

        private int getRank(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "getRank"));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)StringUtil.trimEnd((String)text, (String)"..."), (CharSequence)this.pattern)) {
                return 3;
            }
            if (StringUtil.startsWithIgnoreCase((String)text, (String)this.pattern)) {
                return 2;
            }
            if (StringUtil.containsIgnoreCase((String)text, (String)this.pattern)) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compareTo(@NotNull MatchedValue o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/ide/util/gotoByName/GotoActionModel$MatchedValue", "compareTo"));
            }
            boolean edt = ApplicationManager.getApplication().isDispatchThread();
            if (this.value instanceof ActionWrapper && o.value instanceof ActionWrapper) {
                int compared;
                if (edt) {
                    boolean p1Enable = ((ActionWrapper)this.value).isAvailable();
                    boolean p2enable = ((ActionWrapper)o.value).isAvailable();
                    if (p1Enable && !p2enable) {
                        return -1;
                    }
                    if (!p1Enable && p2enable) {
                        return 1;
                    }
                }
                if ((compared = this.value.compareTo(o.value)) != 0) {
                    return compared;
                }
            }
            if (this.value instanceof ActionWrapper && o.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)this.value).isAvailable() ? -1 : 1;
            }
            if (o.value instanceof ActionWrapper && this.value instanceof BooleanOptionDescription) {
                return edt && ((ActionWrapper)o.value).isAvailable() ? 1 : -1;
            }
            if (this.value instanceof OptionDescription && o.value instanceof BooleanOptionDescription) {
                return 1;
            }
            if (o.value instanceof OptionDescription && this.value instanceof BooleanOptionDescription) {
                return -1;
            }
            if (this.value instanceof OptionDescription && !(o.value instanceof OptionDescription)) {
                return 1;
            }
            if (o.value instanceof OptionDescription && !(this.value instanceof OptionDescription)) {
                return -1;
            }
            int diff = o.getMatchingDegree() - this.getMatchingDegree();
            if (diff != 0) {
                return diff;
            }
            diff = StringUtil.notNullize((String)this.getValueText()).length() - StringUtil.notNullize((String)o.getValueText()).length();
            if (diff != 0) {
                return diff;
            }
            diff = this.value.compareTo(o.value);
            if (diff != 0) {
                return diff;
            }
            return o.hashCode() - this.hashCode();
        }
    }
}

