/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project2, @Nullable String scopeName) {
        boolean restrictedToProject;
        NamedScope namedScope;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/scopeChooser/ScopeChooserUtils", "findScopeByName"));
        }
        NamedScope namedScope2 = namedScope = scopeName == null ? null : ChangeListsScopesProvider.getInstance(project2).getCustomScope(scopeName);
        if (namedScope == null) {
            namedScope = NamedScopesHolder.getScope((Project)project2, (String)scopeName);
        }
        if (namedScope == null) {
            namedScope = new ProjectFilesScope();
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)project2, (NamedScope)namedScope);
        boolean bl = restrictedToProject = namedScope instanceof ProjectFilesScope || namedScope instanceof ProjectProductionScope;
        if (!restrictedToProject) {
            scope = scope.intersectWith(ProjectScope.getContentScope((Project)project2));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/scopeChooser/ScopeChooserUtils", "findScopeByName"));
        }
        return globalSearchScope;
    }
}

