/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MarkupModelWindow
extends UserDataHolderBase
implements MarkupModelEx {
    private final DocumentWindow myDocument;
    private final MarkupModelEx myHostModel;

    public MarkupModelWindow(MarkupModelEx editorMarkupModel, DocumentWindow document) {
        this.myDocument = document;
        this.myHostModel = editorMarkupModel;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocument;
        if (documentWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "getDocument"));
        }
        return documentWindow;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/injected/editor/MarkupModelWindow", "addRangeHighlighter"));
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighter rangeHighlighter = this.myHostModel.addRangeHighlighter(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "addRangeHighlighter"));
        }
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArea", "com/intellij/injected/editor/MarkupModelWindow", "addRangeHighlighterAndChangeAttributes"));
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighterEx rangeHighlighterEx = this.myHostModel.addRangeHighlighterAndChangeAttributes(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea, isPersistent, changeAttributesAction);
        if (rangeHighlighterEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "addRangeHighlighterAndChangeAttributes"));
        }
        return rangeHighlighterEx;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/injected/editor/MarkupModelWindow", "changeAttributesInBatch"));
        }
        if (changeAttributesAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeAttributesAction", "com/intellij/injected/editor/MarkupModelWindow", "changeAttributesInBatch"));
        }
        this.myHostModel.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        RangeHighlighter rangeHighlighter = this.myHostModel.addLineHighlighter(hostLine, layer, textAttributes);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "addLineHighlighter"));
        }
        return rangeHighlighter;
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        if (rangeHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeHighlighter", "com/intellij/injected/editor/MarkupModelWindow", "removeHighlighter"));
        }
        this.myHostModel.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myHostModel.removeAllHighlighters();
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        RangeHighlighter[] rangeHighlighterArray = this.myHostModel.getAllHighlighters();
        if (rangeHighlighterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "getAllHighlighters"));
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
        this.myHostModel.dispose();
    }

    @Override
    public RangeHighlighterEx addPersistentLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        return this.myHostModel.addPersistentLineHighlighter(hostLine, layer, textAttributes);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/injected/editor/MarkupModelWindow", "containsHighlighter"));
        }
        return this.myHostModel.containsHighlighter(highlighter);
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/injected/editor/MarkupModelWindow", "addMarkupModelListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/injected/editor/MarkupModelWindow", "addMarkupModelListener"));
        }
        this.myHostModel.addMarkupModelListener(parentDisposable, listener);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/injected/editor/MarkupModelWindow", "setRangeHighlighterAttributes"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/injected/editor/MarkupModelWindow", "setRangeHighlighterAttributes"));
        }
        this.myHostModel.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/injected/editor/MarkupModelWindow", "processRangeHighlightersOverlappingWith"));
        }
        return false;
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/injected/editor/MarkupModelWindow", "processRangeHighlightersOutside"));
        }
        return false;
    }

    @Override
    @NotNull
    public DisposableIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        DisposableIterator<RangeHighlighterEx> disposableIterator = this.myHostModel.overlappingIterator(startOffset, endOffset);
        if (disposableIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/MarkupModelWindow", "overlappingIterator"));
        }
        return disposableIterator;
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/injected/editor/MarkupModelWindow", "fireAttributesChanged"));
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/injected/editor/MarkupModelWindow", "fireAfterAdded"));
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/injected/editor/MarkupModelWindow", "fireBeforeRemoved"));
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/injected/editor/MarkupModelWindow", "addRangeHighlighter"));
        }
    }
}

