/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.persistence.ApplicationStatisticsPersistence;
import com.intellij.internal.statistic.persistence.CollectedUsages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="StatisticsApplicationUsages", storages={@Storage(file="$APP_CONFIG$/statistics.application.usages.xml", roamingType=RoamingType.DISABLED)})
public class ApplicationStatisticsPersistenceComponent
extends ApplicationStatisticsPersistence
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private boolean persistOnClosing = !ApplicationManager.getApplication().isUnitTestMode();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final long PERSIST_PERIOD = 86400000L;
    private static final String TOKENIZER = ",";
    @NonNls
    private static final String GROUP_TAG = "group";
    @NonNls
    private static final String GROUP_NAME_ATTR = "name";
    @NonNls
    private static final String PROJECT_TAG = "project";
    @NonNls
    private static final String COLLECTION_TIME_TAG = "collectionTime";
    @NonNls
    private static final String PROJECT_ID_ATTR = "id";
    @NonNls
    private static final String VALUES_ATTR = "values";

    public static ApplicationStatisticsPersistenceComponent getInstance() {
        return (ApplicationStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(ApplicationStatisticsPersistenceComponent.class);
    }

    public void loadState(Element element) {
        for (Element groupElement : element.getChildren(GROUP_TAG)) {
            GroupDescriptor groupDescriptor = GroupDescriptor.create(groupElement.getAttributeValue(GROUP_NAME_ATTR));
            List projectsList = groupElement.getChildren(PROJECT_TAG);
            for (Element projectElement : projectsList) {
                long collectionTime;
                String projectId = projectElement.getAttributeValue(PROJECT_ID_ATTR);
                String frameworks = projectElement.getAttributeValue(VALUES_ATTR);
                if (StringUtil.isEmptyOrSpaces((String)projectId) || StringUtil.isEmptyOrSpaces((String)frameworks)) continue;
                THashSet frameworkDescriptors = new THashSet();
                for (String key : StringUtil.split((String)frameworks, (String)TOKENIZER)) {
                    UsageDescriptor descriptor = ApplicationStatisticsPersistenceComponent.getUsageDescriptor(key);
                    if (descriptor == null) continue;
                    frameworkDescriptors.add(descriptor);
                }
                try {
                    collectionTime = Long.valueOf(projectElement.getAttributeValue(COLLECTION_TIME_TAG));
                }
                catch (NumberFormatException ignored) {
                    collectionTime = 0L;
                }
                this.getApplicationData(groupDescriptor).put(projectId, new CollectedUsages((Set<UsageDescriptor>)frameworkDescriptors, collectionTime));
            }
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<GroupDescriptor, Map<String, CollectedUsages>> appData : this.getApplicationData().entrySet()) {
            Element groupElement = new Element(GROUP_TAG);
            groupElement.setAttribute(GROUP_NAME_ATTR, appData.getKey().getId());
            boolean isEmptyGroup = true;
            for (Map.Entry<String, CollectedUsages> projectData : appData.getValue().entrySet()) {
                Element projectElement = new Element(PROJECT_TAG);
                projectElement.setAttribute(PROJECT_ID_ATTR, projectData.getKey());
                CollectedUsages projectDataValue = projectData.getValue();
                if (projectDataValue.usages.isEmpty()) continue;
                projectElement.setAttribute(VALUES_ATTR, ApplicationStatisticsPersistenceComponent.joinUsages(projectDataValue.usages));
                projectElement.setAttribute(COLLECTION_TIME_TAG, String.valueOf(projectDataValue.collectionTime));
                groupElement.addContent(projectElement);
                isEmptyGroup = false;
            }
            if (isEmptyGroup) continue;
            element.addContent(groupElement);
        }
        return element;
    }

    private static UsageDescriptor getUsageDescriptor(String usage) {
        try {
            int i = usage.indexOf(61);
            if (i > 0 && i < usage.length() - 1) {
                String key = usage.substring(0, i).trim();
                String value = usage.substring(i + 1).trim();
                if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                    try {
                        int count = Integer.parseInt(value);
                        if (count > 0) {
                            return new UsageDescriptor(key, count);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return new UsageDescriptor(usage, 1);
        }
        catch (AssertionError assertionError) {
            return null;
        }
    }

    private static String joinUsages(@NotNull Set<UsageDescriptor> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistenceComponent", "joinUsages"));
        }
        return StringUtil.join(usages, (Function)new Function<UsageDescriptor, String>(){

            public String fun(UsageDescriptor usageDescriptor) {
                String key = usageDescriptor.getKey();
                int value = usageDescriptor.getValue();
                return value != 1 ? key + "=" + value : key;
            }
        }, (String)TOKENIZER);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ApplicationStatisticsPersistenceComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/ApplicationStatisticsPersistenceComponent", "getComponentName"));
        }
        return "ApplicationStatisticsPersistenceComponent";
    }

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appClosing() {
                ApplicationStatisticsPersistenceComponent.persistOpenedProjects();
                ApplicationStatisticsPersistenceComponent.this.persistOnClosing = false;
            }
        });
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectClosing(Project project2) {
                if (ApplicationStatisticsPersistenceComponent.this.persistOnClosing && project2 != null) {
                    UsagesCollector.doPersistProjectUsages(project2);
                }
            }
        });
        this.persistPeriodically();
    }

    private void persistPeriodically() {
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationStatisticsPersistenceComponent.persistOpenedProjects();
                ApplicationStatisticsPersistenceComponent.this.persistPeriodically();
            }
        }, 86400000L);
    }

    private static void persistOpenedProjects() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            UsagesCollector.doPersistProjectUsages(project2);
        }
    }

    public void disposeComponent() {
    }
}

