/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.codeinsight.JsonStandardComplianceProvider;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStandardComplianceInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(JsonStandardComplianceInspection.class);
    public boolean myWarnAboutComments = true;
    public boolean myWarnAboutMultipleTopLevelValues = true;

    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("inspection.compliance.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "buildVisitor"));
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitComment(PsiComment comment) {
                if (JsonStandardComplianceInspection.this.myWarnAboutComments && JsonStandardComplianceProvider.shouldWarnAboutComment(comment)) {
                    holder.registerProblem((PsiElement)comment, JsonBundle.message("inspection.compliance.msg.comments", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitStringLiteral(@NotNull JsonStringLiteral stringLiteral) {
                if (stringLiteral == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringLiteral", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitStringLiteral"));
                }
                if (JsonPsiUtil.getElementTextWithoutHostEscaping(stringLiteral).startsWith("'")) {
                    holder.registerProblem((PsiElement)stringLiteral, JsonBundle.message("inspection.compliance.msg.single.quoted.strings", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                }
                super.visitStringLiteral(stringLiteral);
            }

            @Override
            public void visitLiteral(@NotNull JsonLiteral literal) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitLiteral"));
                }
                if (JsonPsiUtil.isPropertyKey(literal) && !JsonPsiUtil.getElementTextWithoutHostEscaping(literal).startsWith("\"")) {
                    holder.registerProblem((PsiElement)literal, JsonBundle.message("inspection.compliance.msg.illegal.property.key", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                }
                super.visitLiteral(literal);
            }

            @Override
            public void visitReferenceExpression(@NotNull JsonReferenceExpression reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitReferenceExpression"));
                }
                holder.registerProblem((PsiElement)reference, JsonBundle.message("inspection.compliance.msg.identifier", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
                super.visitReferenceExpression(reference);
            }

            @Override
            public void visitArray(@NotNull JsonArray array) {
                if (array == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitArray"));
                }
                PsiElement trailingComma = JsonStandardComplianceInspection.findTrailingComma(array, JsonElementTypes.R_BRACKET);
                if (trailingComma != null) {
                    holder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
                }
                super.visitArray(array);
            }

            @Override
            public void visitObject(@NotNull JsonObject object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitObject"));
                }
                PsiElement trailingComma = JsonStandardComplianceInspection.findTrailingComma(object, JsonElementTypes.R_CURLY);
                if (trailingComma != null) {
                    holder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
                }
                super.visitObject(object);
            }

            @Override
            public void visitValue(@NotNull JsonValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$1", "visitValue"));
                }
                if (value.getContainingFile() instanceof JsonFile) {
                    JsonFile jsonFile = (JsonFile)value.getContainingFile();
                    if (JsonStandardComplianceInspection.this.myWarnAboutMultipleTopLevelValues && value.getParent() == jsonFile && value != jsonFile.getTopLevelValue()) {
                        holder.registerProblem((PsiElement)value, JsonBundle.message("inspection.compliance.msg.multiple.top.level.values", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (jsonElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "buildVisitor"));
        }
        return jsonElementVisitor;
    }

    @Nullable
    private static PsiElement findTrailingComma(@NotNull JsonContainer container, @NotNull IElementType ending) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "findTrailingComma"));
        }
        if (ending == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ending", "com/intellij/json/codeinsight/JsonStandardComplianceInspection", "findTrailingComma"));
        }
        PsiElement lastChild = container.getLastChild();
        if (lastChild.getNode().getElementType() != ending) {
            return null;
        }
        PsiElement beforeEnding = PsiTreeUtil.skipSiblingsBackward((PsiElement)lastChild, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        if (beforeEnding != null && beforeEnding.getNode().getElementType() == JsonElementTypes.COMMA) {
            return beforeEnding;
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.comments", new Object[0]), "myWarnAboutComments");
        optionsPanel.addCheckbox(JsonBundle.message("inspection.compliance.option.multiple.top.level.values", new Object[0]), "myWarnAboutMultipleTopLevelValues");
        return optionsPanel;
    }

    private static class AddDoubleQuotesFix
    implements LocalQuickFix {
        private AddDoubleQuotesFix() {
        }

        @NotNull
        public String getName() {
            String string = JsonBundle.message("quickfix.add.double.quotes.desc", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            String rawText = element.getText();
            if (element instanceof JsonLiteral || element instanceof JsonReferenceExpression) {
                String content = JsonPsiUtil.stripQuotes(rawText);
                if (element instanceof JsonStringLiteral && rawText.startsWith("'")) {
                    content = AddDoubleQuotesFix.escapeSingleQuotedStringContent(content);
                }
                Object replacement = new JsonElementGenerator(project2).createValue("\"" + content + "\"");
                CodeStyleManager.getInstance((Project)project2).performActionWithFormatterDisabled(new Runnable((PsiElement)replacement){
                    final /* synthetic */ PsiElement val$replacement;
                    {
                        this.val$replacement = psiElement2;
                    }

                    @Override
                    public void run() {
                        element.replace(this.val$replacement);
                    }
                });
            } else {
                LOG.error("Quick fix was applied to unexpected element", new String[]{rawText, element.getParent().getText()});
            }
        }

        @NotNull
        private static String escapeSingleQuotedStringContent(@NotNull String content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "escapeSingleQuotedStringContent"));
            }
            StringBuilder result2 = new StringBuilder();
            boolean nextCharEscaped = false;
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (nextCharEscaped && c != '\'' || !nextCharEscaped && c == '\"') {
                    result2.append('\\');
                }
                if (c != '\\' || nextCharEscaped) {
                    result2.append(c);
                    nextCharEscaped = false;
                    continue;
                }
                nextCharEscaped = true;
            }
            if (nextCharEscaped) {
                result2.append('\\');
            }
            String string = result2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix", "escapeSingleQuotedStringContent"));
            }
            return string;
        }
    }
}

