/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderFactoryImpl
extends PsiBuilderFactory {
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull ASTNode chameleon) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        PsiBuilder psiBuilder = this.createBuilder(project2, chameleon, null, chameleon.getElementType().getLanguage(), chameleon.getChars());
        if (psiBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilder;
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull LighterLazyParseableNode chameleon) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project2, parserDefinition, PsiBuilderFactoryImpl.createLexer(project2, language), chameleon, chameleon.getText());
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project2, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project2, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project2, @NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project2, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project2, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }

    private static Lexer createLexer(Project project2, Language lang) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        assert (parserDefinition != null) : "ParserDefinition absent for language: " + lang.getID();
        return parserDefinition.createLexer(project2);
    }

    @NotNull
    public PsiBuilder createBuilder(@NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull CharSequence seq) {
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(null, null, parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, null, seq, null, null);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }
}

