/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.ide.FrameStateManager;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsAdapter;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationActionProvider;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsManagerImpl
extends NotificationsManager {
    public NotificationsManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(null));
    }

    public void expire(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "expire"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                EventLog.expireNotification(notification);
            }
        });
    }

    public <T extends Notification> T[] getNotificationsOfType(Class<T> klass, @Nullable Project project2) {
        ArrayList<Notification> result2 = new ArrayList<Notification>();
        if (project2 == null || !project2.isDefault() && !project2.isDisposed()) {
            for (Notification notification : EventLog.getLogModel(project2).getNotifications()) {
                if (!klass.isInstance(notification)) continue;
                result2.add(notification);
            }
        }
        return (Notification[])ArrayUtil.toObjectArray(result2, klass);
    }

    private static void doNotify(final @NotNull Notification notification, @Nullable NotificationDisplayType displayType, final @Nullable Project project2) {
        boolean willBeShown;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl", "doNotify"));
        }
        NotificationsConfigurationImpl configuration = NotificationsConfigurationImpl.getInstanceImpl();
        if (!configuration.isRegistered(notification.getGroupId())) {
            configuration.register(notification.getGroupId(), displayType == null ? NotificationDisplayType.BALLOON : displayType);
        }
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(notification.getGroupId());
        boolean shouldLog = settings.isShouldLog();
        boolean displayable = settings.getDisplayType() != NotificationDisplayType.NONE;
        boolean bl = willBeShown = displayable && NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS;
        if (!shouldLog && !willBeShown) {
            notification.expire();
        }
        if (NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS) {
            DumbAwareRunnable runnable2 = new DumbAwareRunnable(){

                public void run() {
                    NotificationsManagerImpl.showNotification(notification, project2);
                }
            };
            if (project2 == null) {
                UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
            } else if (!project2.isDisposed()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized((Runnable)runnable2);
            }
        }
    }

    private static void showNotification(final Notification notification, final @Nullable Project project2) {
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationEx && !((ApplicationEx)application).isLoaded()) {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationsManagerImpl.showNotification(notification, project2);
                }
            }, ModalityState.current());
            return;
        }
        String groupId = notification.getGroupId();
        NotificationSettings settings = NotificationsConfigurationImpl.getSettings(groupId);
        NotificationDisplayType type = settings.getDisplayType();
        String toolWindowId = NotificationsConfigurationImpl.getInstanceImpl().getToolWindowId(groupId);
        if (!(type != NotificationDisplayType.TOOL_WINDOW || toolWindowId != null && project2 != null && ToolWindowManager.getInstance((Project)project2).canShowNotification(toolWindowId))) {
            type = NotificationDisplayType.BALLOON;
        }
        switch (type) {
            case NONE: {
                return;
            }
            default: {
                Balloon balloon = NotificationsManagerImpl.notifyByBalloon(notification, type, project2);
                if (settings.isShouldLog() && type != NotificationDisplayType.STICKY_BALLOON) break;
                if (balloon == null) {
                    notification.expire();
                    break;
                }
                balloon.addListener((JBPopupListener)new JBPopupAdapter(){

                    public void onClosed(LightweightWindowEvent event) {
                        if (!event.isOk()) {
                            notification.expire();
                        }
                    }
                });
                break;
            }
            case TOOL_WINDOW: {
                HyperlinkListener listener;
                MessageType messageType = notification.getType() == NotificationType.ERROR ? MessageType.ERROR : (notification.getType() == NotificationType.WARNING ? MessageType.WARNING : MessageType.INFO);
                final NotificationListener notificationListener = notification.getListener();
                HyperlinkListener hyperlinkListener = listener = notificationListener == null ? null : new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        notificationListener.hyperlinkUpdate(notification, e);
                    }
                };
                assert (toolWindowId != null);
                String msg = notification.getTitle();
                if (StringUtil.isNotEmpty((String)notification.getContent())) {
                    if (StringUtil.isNotEmpty((String)msg)) {
                        msg = msg + "<br>";
                    }
                    msg = msg + notification.getContent();
                }
                ToolWindowManager.getInstance((Project)project2).notifyByBalloon(toolWindowId, messageType, msg, notification.getIcon(), listener);
            }
        }
    }

    @Nullable
    private static Balloon notifyByBalloon(Notification notification, NotificationDisplayType displayType, @Nullable Project project2) {
        if (NotificationsManagerImpl.isDummyEnvironment()) {
            return null;
        }
        Window window = NotificationsManagerImpl.findWindowForBalloon(project2);
        if (window instanceof IdeFrame) {
            final ProjectManager projectManager = ProjectManager.getInstance();
            final boolean noProjects = projectManager.getOpenProjects().length == 0;
            final boolean sticky = NotificationDisplayType.STICKY_BALLOON == displayType || noProjects;
            final Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)window, notification, false, false);
            Disposer.register((Disposable)(project2 != null ? project2 : ApplicationManager.getApplication()), (Disposable)balloon);
            if (notification.isExpired()) {
                return null;
            }
            BalloonLayout layout = ((IdeFrame)window).getBalloonLayout();
            if (layout == null) {
                return null;
            }
            layout.add(balloon);
            ((BalloonImpl)balloon).startFadeoutTimer(0);
            if (NotificationDisplayType.BALLOON == displayType) {
                FrameStateManager.getInstance().getApplicationActive().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        if (balloon.isDisposed()) {
                            return;
                        }
                        if (!sticky) {
                            ((BalloonImpl)balloon).startFadeoutTimer(0);
                            ((BalloonImpl)balloon).setHideOnClickOutside(true);
                        } else if (noProjects) {
                            projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

                                public void projectOpened(Project project2) {
                                    projectManager.removeProjectManagerListener((ProjectManagerListener)this);
                                    if (!balloon.isDisposed()) {
                                        ((BalloonImpl)balloon).startFadeoutTimer(300);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            return balloon;
        }
        return null;
    }

    @Nullable
    public static Window findWindowForBalloon(Project project2) {
        Window frame = WindowManager.getInstance().getFrame(project2);
        if (frame == null && project2 == null) {
            frame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (frame instanceof DialogWrapperDialog && ((DialogWrapperDialog)frame).getDialogWrapper().isModalProgress()) {
                frame = frame.getOwner();
            }
        }
        if (frame == null && project2 == null) {
            frame = (Window)WelcomeFrame.getInstance();
        }
        return frame;
    }

    public static Balloon createBalloon(@NotNull IdeFrame window, Notification notification, boolean showCallout, boolean hideOnClickOutside) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/notification/impl/NotificationsManagerImpl", "createBalloon"));
        }
        return NotificationsManagerImpl.createBalloon(window.getComponent(), notification, showCallout, hideOnClickOutside);
    }

    public static Balloon createBalloon(@Nullable JComponent windowComponent, Notification notification, boolean showCallout, boolean hideOnClickOutside) {
        JEditorPane text = new JEditorPane();
        text.setEditorKit(UIUtil.getHTMLEditorKit());
        HyperlinkListener listener = NotificationsUtil.wrapListener(notification);
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        JLabel label = new JLabel(NotificationsUtil.buildHtml(notification, null));
        text.setText(NotificationsUtil.buildHtml(notification, "width:" + Math.min(JBUI.scale((int)350), label.getPreferredSize().width) + "px;"));
        text.setEditable(false);
        text.setOpaque(false);
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            text.setBackground(UIUtil.TRANSPARENT_COLOR);
        }
        text.setBorder(null);
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label.getIconTextGap() * 1.5), (int)((double)label.getIconTextGap() * 1.5)));
        if (text.getCaret() != null) {
            text.setCaretPosition(0);
        }
        JScrollPane pane = new JScrollPane(text);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setOpaque(false);
        pane.getViewport().setOpaque(false);
        content.add((Component)pane, "Center");
        NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
        north.add((Component)new JLabel(NotificationsUtil.getIcon(notification)), (Object)"North");
        content.add((Component)north, "West");
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        JPanel buttons = null;
        if (notification instanceof NotificationActionProvider) {
            NotificationActionProvider provider = (NotificationActionProvider)notification;
            buttons = new JPanel((LayoutManager)new HorizontalLayout(5));
            buttons.setOpaque(false);
            content.add("South", buttons);
            for (NotificationActionProvider.Action action : provider.getActions(listener)) {
                JButton button = new JButton(action);
                button.setOpaque(false);
                buttons.add("RIGHT", button);
            }
        }
        Dimension preferredSize = text.getPreferredSize();
        text.setSize(preferredSize);
        Dimension paneSize = new Dimension(text.getPreferredSize());
        int maxHeight = JBUI.scale((int)400);
        int maxWidth = JBUI.scale((int)600);
        if (windowComponent != null) {
            maxHeight = Math.min(maxHeight, windowComponent.getHeight() - 20);
            maxWidth = Math.min(maxWidth, windowComponent.getWidth() - 20);
        }
        if (paneSize.height > maxHeight) {
            pane.setPreferredSize(new Dimension(Math.min(maxWidth, paneSize.width + UIUtil.getScrollBarWidth()), maxHeight));
        } else if (paneSize.width > maxWidth) {
            pane.setPreferredSize(new Dimension(maxWidth, paneSize.height + UIUtil.getScrollBarWidth()));
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)content);
        builder.setFillColor((Color)new JBColor((Color)Gray._234, (Color)Gray._92)).setCloseButtonEnabled(buttons == null).setShowCallout(showCallout).setShadow(false).setHideOnClickOutside(hideOnClickOutside).setHideOnAction(hideOnClickOutside).setHideOnKeyOutside(hideOnClickOutside).setHideOnFrameResize(false).setBorderColor((Color)new JBColor((Color)Gray._180, (Color)Gray._110));
        Balloon balloon = builder.createBalloon();
        balloon.setAnimationEnabled(false);
        notification.setBalloon(balloon);
        return balloon;
    }

    private static boolean isDummyEnvironment() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isCommandLine();
    }

    private static class MyNotificationListener
    extends NotificationsAdapter {
        private final Project myProject;

        public MyNotificationListener(@Nullable Project project2) {
            this.myProject = project2;
        }

        public void notify(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsManagerImpl$MyNotificationListener", "notify"));
            }
            NotificationsManagerImpl.doNotify(notification, null, this.myProject);
        }
    }

    public static class ProjectNotificationsComponent {
        public ProjectNotificationsComponent(Project project2) {
            if (NotificationsManagerImpl.isDummyEnvironment()) {
                return;
            }
            project2.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new MyNotificationListener(project2));
        }
    }
}

