/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class NotificationTestAction
extends AnAction
implements DumbAware {
    public static final String TEST_GROUP_ID = "Test Notification";

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/actions/NotificationTestAction", "actionPerformed"));
        }
        new NotificationDialog(event.getProject()).show();
    }

    private static final class NotificationDialog
    extends DialogWrapper {
        private final JTextField myTitle = new JTextField(50);
        private final JTextArea myMessage = new JTextArea(10, 50);
        private final JComboBox myType = new JComboBox<NotificationType>(NotificationType.values());
        private final MessageBus myMessageBus;

        private NotificationDialog(Project project2) {
            super(project2, true, DialogWrapper.IdeModalityType.MODELESS);
            this.myMessageBus = project2 != null ? project2.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
            this.init();
            this.setOKButtonText("Notify");
            this.setTitle(NotificationTestAction.TEST_GROUP_ID);
            this.myMessage.setText("You can close<br>\nthis very very very very long notification\nby clicking <a href=\"close\">this link</a>.\n<p>Long long long long. It should be long. Very long. Too long. And even longer.");
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            panel.add("North", this.myTitle);
            panel.add("Center", new JScrollPane(this.myMessage));
            panel.add("South", this.myType);
            return panel;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog", "createActions"));
            }
            return actionArray;
        }

        protected void doOKAction() {
            String title = this.myTitle.getText();
            String message = this.myMessage.getText();
            Object value = this.myType.getSelectedItem();
            NotificationType type = value instanceof NotificationType ? (NotificationType)value : NotificationType.ERROR;
            final Notification notification = new Notification(NotificationTestAction.TEST_GROUP_ID, title, message, type, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/impl/actions/NotificationTestAction$NotificationDialog$1", "hyperlinkUpdate"));
                    }
                    notification.expire();
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ((Notifications)NotificationDialog.this.myMessageBus.syncPublisher(Notifications.TOPIC)).notify(notification);
                }
            });
        }
    }
}

