/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    private static final Logger LOG = Logger.getInstance(StorageUtil.class);
    public static String DEBUG_LOG = null;

    private StorageUtil() {
    }

    public static void notifyUnknownMacros(final @NotNull IComponentStore store, final @NotNull Project project2, final @NotNull String componentName) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        final TrackingPathMacroSubstitutor substitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (substitutor == null) {
            return;
        }
        Set<String> immutableMacros = substitutor.getUnknownMacros(componentName);
        if (immutableMacros.isEmpty()) {
            return;
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(immutableMacros);
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                SmartList notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project2)) {
                    if (notified == null) {
                        notified = new SmartList();
                    }
                    notified.addAll(notification.getMacros());
                }
                if (!ContainerUtil.isEmpty(notified)) {
                    macros.removeAll((Collection<?>)notified);
                }
                if (macros.isEmpty()) {
                    return;
                }
                LOG.debug("Reporting unknown path macros " + macros + " in component " + componentName);
                StorageUtil.doNotify(macros, project2, Collections.singletonMap(substitutor, store));
            }
        }, project2.getDisposed());
    }

    private static void doNotify(final @NotNull Set<String> macros, final @NotNull Project project2, final @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        if (macros == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/openapi/components/impl/stores/StorageUtil", "doNotify"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "doNotify"));
        }
        if (substitutorToStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorToStore", "com/intellij/openapi/components/impl/stores/StorageUtil", "doNotify"));
        }
        String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String content = String.format(format, StringUtil.join(macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
        new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/components/impl/stores/StorageUtil$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil$2", "hyperlinkUpdate"));
                }
                StorageUtil.checkUnknownMacros(project2, true, macros, substitutorToStore);
            }
        }, macros).notify(project2);
    }

    public static void checkUnknownMacros(@NotNull Project project2, boolean notify) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        LinkedHashSet<String> unknownMacros = new LinkedHashSet<String>();
        LinkedHashMap substitutorToStore = ContainerUtil.newLinkedHashMap();
        StorageUtil.collect((ComponentManager)project2, unknownMacros, substitutorToStore);
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            StorageUtil.collect((ComponentManager)module2, unknownMacros, substitutorToStore);
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        if (notify) {
            StorageUtil.doNotify(unknownMacros, project2, substitutorToStore);
            return;
        }
        StorageUtil.checkUnknownMacros(project2, false, unknownMacros, substitutorToStore);
    }

    private static void checkUnknownMacros(@NotNull Project project2, boolean showDialog, @NotNull Set<String> unknownMacros, @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (unknownMacros == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownMacros", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (substitutorToStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorToStore", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project2, (Set<String>)new THashSet(unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        Iterator<String> it = unknownMacros.iterator();
        while (it.hasNext()) {
            String macro = it.next();
            if (!StringUtil.isEmptyOrSpaces((String)pathMacros.getValue(macro)) || pathMacros.isIgnoredMacroName(macro)) continue;
            it.remove();
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        for (Map.Entry<TrackingPathMacroSubstitutor, IComponentStore> entry : substitutorToStore.entrySet()) {
            TrackingPathMacroSubstitutor substitutor = entry.getKey();
            Set<String> components = substitutor.getComponents(unknownMacros);
            IComponentStore store = entry.getValue();
            if (store.isReloadPossible(components)) {
                substitutor.invalidateUnknownMacros(unknownMacros);
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, project2)) {
                    if (!unknownMacros.containsAll(notification.getMacros())) continue;
                    notification.expire();
                }
                store.reloadStates(components, project2.getMessageBus());
                continue;
            }
            if (Messages.showYesNoDialog((Project)project2, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) != 0) continue;
            ProjectManagerEx.getInstanceEx().reloadProject(project2);
        }
    }

    private static void collect(@NotNull ComponentManager componentManager, @NotNull Set<String> unknownMacros, @NotNull Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/stores/StorageUtil", "collect"));
        }
        if (unknownMacros == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownMacros", "com/intellij/openapi/components/impl/stores/StorageUtil", "collect"));
        }
        if (substitutorToStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorToStore", "com/intellij/openapi/components/impl/stores/StorageUtil", "collect"));
        }
        IComponentStore store = ServiceKt.getStateStore(componentManager);
        TrackingPathMacroSubstitutor substitutor = store.getStateStorageManager().getMacroSubstitutor();
        if (substitutor == null) {
            return;
        }
        Set<String> macros = substitutor.getUnknownMacros(null);
        if (macros.isEmpty()) {
            return;
        }
        unknownMacros.addAll(macros);
        substitutorToStore.put(substitutor, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFile getOrCreateVirtualFile(@Nullable Object requestor, @NotNull File file2) throws IOException {
        VirtualFile parentVirtualFile;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile2;
        }
        File absoluteFile = file2.getAbsoluteFile();
        FileUtil.createParentDirs((File)absoluteFile);
        File parentFile = absoluteFile.getParentFile();
        VirtualFile virtualFile3 = parentVirtualFile = StringUtil.isEmpty((String)parentFile.getPath()) ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
        if (parentVirtualFile == null) {
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFile virtualFile4 = parentVirtualFile.createChildData(requestor, file2.getName());
            if (virtualFile4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile4;
        }
        AccessToken token = WriteAction.start();
        VirtualFile virtualFile5 = parentVirtualFile.createChildData(requestor, file2.getName());
        VirtualFile virtualFile6 = virtualFile5;
        if (virtualFile6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile6;
        finally {
            token.finish();
        }
    }
}

