/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GenericDataProvider
implements DataProvider {
    private final Map<String, Object> myGenericData;
    private final DataProvider myParentProvider;

    public GenericDataProvider() {
        this(null);
    }

    public GenericDataProvider(@Nullable DataProvider provider) {
        this.myParentProvider = provider;
        this.myGenericData = new HashMap<String, Object>();
    }

    public void putData(DataKey key, Object value) {
        this.myGenericData.put(key.getName(), value);
    }

    public void putData(String key, Object value) {
        this.myGenericData.put(key, value);
    }

    public void putData(Map<String, Object> map) {
        this.myGenericData.putAll(map);
    }

    public Object getData(String dataId) {
        Object data = this.myGenericData.get(dataId);
        if (data != null) {
            return data;
        }
        return this.myParentProvider != null ? this.myParentProvider.getData(dataId) : null;
    }
}

