/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MergeVersion {
    public Document createWorkingDocument(Project var1);

    public void applyText(@NotNull String var1, Project var2);

    @Nullable
    public VirtualFile getFile();

    public byte[] getBytes() throws IOException;

    public FileType getContentType();

    public void restoreOriginalContent(Project var1);

    public static class MergeDocumentVersion
    implements MergeVersion {
        private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.mergeTool.MergeVersion.MergeDocumentVersion");
        protected final Document myDocument;
        private final String myOriginalText;
        private String myTextBeforeMerge;

        public MergeDocumentVersion(Document document, String originalText) {
            LOG.assertTrue(originalText != null, (Object)"text should not be null");
            LOG.assertTrue(document != null, (Object)"document should not be null");
            LOG.assertTrue(document.isWritable(), (Object)"document should be writable");
            this.myDocument = document;
            this.myOriginalText = originalText;
        }

        @Override
        public Document createWorkingDocument(final Project project2) {
            final Document workingDocument = this.myDocument;
            workingDocument.setReadOnly(false);
            final DocumentReference ref = DocumentReferenceManager.getInstance().create(workingDocument);
            this.myTextBeforeMerge = this.myDocument.getText();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    UndoManager undoManager;
                    MergeDocumentVersion.setDocumentText(workingDocument, MergeDocumentVersion.this.myOriginalText, DiffBundle.message((String)"merge.init.merge.content.command.name", (Object[])new Object[0]), project2);
                    if (project2 != null && (undoManager = UndoManager.getInstance((Project)project2)) != null) {
                        undoManager.nonundoableActionPerformed(ref, false);
                    }
                }
            });
            return workingDocument;
        }

        @Override
        public void applyText(final @NotNull String text, final Project project2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "applyText"));
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                        @Override
                        public void run() {
                            MergeDocumentVersion.this.doApplyText(text, project2);
                        }
                    }, "Merge changes", null);
                }
            });
        }

        protected void doApplyText(@NotNull String text, Project project2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "doApplyText"));
            }
            MergeDocumentVersion.setDocumentText(this.myDocument, text, DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]), project2);
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
            MergeDocumentVersion.reportProjectFileChangeIfNeeded(project2, this.getFile());
        }

        public static void reportProjectFileChangeIfNeeded(@Nullable Project project2, @Nullable VirtualFile file2) {
            if (project2 != null && file2 != null && !file2.isDirectory() && (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || MergeDocumentVersion.isProjectFile(file2))) {
                ProjectManagerEx.getInstanceEx().saveChangedProjectFile(file2, project2);
            }
        }

        @Nullable
        public static Runnable prepareToReportChangedProjectFiles(@NotNull Project project2, @NotNull Collection<VirtualFile> files) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "prepareToReportChangedProjectFiles"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "prepareToReportChangedProjectFiles"));
            }
            THashSet vfs = new THashSet();
            for (VirtualFile file2 : files) {
                if (file2 == null || file2.isDirectory() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2) && !MergeDocumentVersion.isProjectFile(file2)) continue;
                vfs.add(file2);
            }
            return vfs.isEmpty() ? null : new Runnable((Set)vfs, project2){
                final /* synthetic */ Set val$vfs;
                final /* synthetic */ Project val$project;
                {
                    this.val$vfs = set;
                    this.val$project = project2;
                }

                @Override
                public void run() {
                    ProjectManagerEx ex = ProjectManagerEx.getInstanceEx();
                    for (VirtualFile vf : this.val$vfs) {
                        ex.saveChangedProjectFile(vf, this.val$project);
                    }
                }
            };
        }

        @Override
        public void restoreOriginalContent(final Project project2) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    MergeDocumentVersion.this.doRestoreOriginalContent(project2);
                }
            });
        }

        public static boolean isProjectFile(VirtualFile file2) {
            ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)file2);
            return importProvider != null && importProvider.lookForProjectsInDirectory();
        }

        protected void doRestoreOriginalContent(@Nullable Project project2) {
            MergeDocumentVersion.setDocumentText(this.myDocument, this.myTextBeforeMerge, "", project2);
        }

        @Override
        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myDocument);
        }

        @Override
        public byte[] getBytes() throws IOException {
            VirtualFile file2 = this.getFile();
            return file2 != null ? file2.contentsToByteArray() : this.myDocument.getText().getBytes();
        }

        @Override
        public FileType getContentType() {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return FileTypes.PLAIN_TEXT;
            }
            return file2.getFileType();
        }

        private static void setDocumentText(final @NotNull Document document, final @NotNull String text, @Nullable String name, @Nullable Project project2) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "setDocumentText"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion", "setDocumentText"));
            }
            CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                @Override
                public void run() {
                    document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text));
                }
            }, name, null);
        }
    }
}

