/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.BundledColorSchemeEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(file="$APP_CONFIG$/colors.scheme.xml")}, additionalExportFile="colors")
public class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    @NonNls
    private static final String SCHEME_NODE_NAME = "scheme";
    private static final String DEFAULT_NAME = "Default";
    private final EventDispatcher<EditorColorsListener> myListeners;
    private final DefaultColorSchemesManager myDefaultColorSchemeManager;
    private final SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState;

    public EditorColorsManagerImpl(@NotNull DefaultColorSchemesManager defaultColorSchemeManager, @NotNull SchemesManagerFactory schemeManagerFactory) {
        if (defaultColorSchemeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultColorSchemeManager", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "<init>"));
        }
        if (schemeManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManagerFactory", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "<init>"));
        }
        this.myListeners = EventDispatcher.create(EditorColorsListener.class);
        this.myState = new State();
        this.myDefaultColorSchemeManager = defaultColorSchemeManager;
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, (SchemeProcessor)new BaseSchemeProcessor<EditorColorsSchemeImpl>(){

            @NotNull
            public EditorColorsSchemeImpl readScheme(@NotNull Element element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "readScheme"));
                }
                EditorColorsSchemeImpl scheme = new EditorColorsSchemeImpl(null);
                scheme.readExternal(element);
                EditorColorsSchemeImpl editorColorsSchemeImpl = scheme;
                if (editorColorsSchemeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "readScheme"));
                }
                return editorColorsSchemeImpl;
            }

            public Element writeScheme(@NotNull EditorColorsSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EditorColorsManagerImpl.SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "writeScheme"));
                }
                Element root = new Element(EditorColorsManagerImpl.SCHEME_NODE_NAME);
                try {
                    scheme.writeExternal(root);
                }
                catch (WriteExternalException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
                return root;
            }

            @NotNull
            public SchemeProcessor.State getState(@NotNull EditorColorsSchemeImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", EditorColorsManagerImpl.SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "getState"));
                }
                SchemeProcessor.State state = scheme instanceof ReadOnlyColorsScheme ? SchemeProcessor.State.NON_PERSISTENT : SchemeProcessor.State.POSSIBLY_CHANGED;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "getState"));
                }
                return state;
            }

            public void onCurrentSchemeChanged(@Nullable Scheme oldScheme) {
                LafManager.getInstance().updateUI();
                EditorColorsManagerImpl.schemeChangedOrSwitched();
                EditorColorsManagerImpl.this.fireChanges((EditorColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.getCurrentScheme());
            }

            @NotNull
            @NonNls
            public String getSchemeExtension() {
                if (".icls" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1", "getSchemeExtension"));
                }
                return ".icls";
            }

            public boolean isUpgradeNeeded() {
                return true;
            }
        });
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme = null;
        if (wizardEditorScheme != null) {
            scheme = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        this.setGlobalSchemeInner(scheme == null ? this.getDefaultScheme() : scheme);
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            this.mySchemeManager.addScheme((Scheme)defaultScheme);
        }
        this.loadAdditionalTextAttributes();
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            for (BundledColorSchemeEP ep : (BundledColorSchemeEP[])BundledColorSchemeEP.EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.path + ".xml", (Object)ep, (ThrowableConvertor)new ThrowableConvertor<Element, EditorColorsScheme, Throwable>(){

                    public EditorColorsScheme convert(Element element) throws Throwable {
                        return new ReadOnlyColorsSchemeImpl(element);
                    }
                });
            }
        }
    }

    public static void schemeChangedOrSwitched() {
        EditorFactory.getInstance().refreshAllEditors();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(TextAttributesKey key) {
        boolean dark = UIUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : DEFAULT_NAME).getAttributes(key);
    }

    private void loadAdditionalTextAttributes() {
        for (AdditionalTextAttributesEP attributesEP : (AdditionalTextAttributesEP[])AdditionalTextAttributesEP.EP_NAME.getExtensions()) {
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this.mySchemeManager.findSchemeByName(attributesEP.scheme);
            if (editorColorsScheme == null) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + attributesEP.scheme + " from plugin: " + attributesEP.getPluginDescriptor().getPluginId());
                continue;
            }
            try {
                URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
                assert (resource != null);
                ((AbstractColorsScheme)editorColorsScheme).readAttributes(JDOMUtil.load((InputStream)URLUtil.openStream((URL)resource)));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SCHEME_NODE_NAME, "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addColorsScheme"));
        }
        if (!this.isDefaultScheme(scheme) && !StringUtil.isEmpty((String)scheme.getName())) {
            this.mySchemeManager.addScheme((Scheme)scheme);
        }
    }

    public void removeAllSchemes() {
    }

    public void setSchemes(@NotNull List<EditorColorsScheme> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "setSchemes"));
        }
        this.mySchemeManager.setSchemes(schemes);
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        List schemes = this.mySchemeManager.getAllSchemes();
        EditorColorsScheme[] result2 = schemes.toArray(new EditorColorsScheme[schemes.size()]);
        Arrays.sort(result2, new Comparator<EditorColorsScheme>(){

            @Override
            public int compare(@NotNull EditorColorsScheme s1, @NotNull EditorColorsScheme s2) {
                if (s1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$3", "compare"));
                }
                if (s2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$3", "compare"));
                }
                if (EditorColorsManagerImpl.this.isDefaultScheme(s1) && !EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return -1;
                }
                if (!EditorColorsManagerImpl.this.isDefaultScheme(s1) && EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return 1;
                }
                if (s1.getName().equals(EditorColorsManagerImpl.DEFAULT_NAME)) {
                    return -1;
                }
                if (s2.getName().equals(EditorColorsManagerImpl.DEFAULT_NAME)) {
                    return 1;
                }
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getAllSchemes"));
        }
        return result2;
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme) {
        this.mySchemeManager.setCurrent((Scheme)(scheme == null ? this.getDefaultScheme() : scheme));
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme) {
        this.mySchemeManager.setCurrent((Scheme)(scheme == null ? this.getDefaultScheme() : scheme), false);
    }

    @NotNull
    private DefaultColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultColorsScheme = this.myDefaultColorSchemeManager.getFirstScheme();
        if (defaultColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getDefaultScheme"));
        }
        return defaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme = (EditorColorsScheme)this.mySchemeManager.getCurrentScheme();
        EditorColorsScheme editorColorsScheme = scheme == null ? this.getDefaultScheme() : scheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getGlobalScheme"));
        }
        return editorColorsScheme;
    }

    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getScheme"));
        }
        return (EditorColorsScheme)this.mySchemeManager.findSchemeByName(schemeName);
    }

    private void fireChanges(EditorColorsScheme scheme) {
        ((EditorColorsListener)this.myListeners.getMulticaster()).globalSchemeChange(scheme);
    }

    public void addEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        this.myListeners.addListener((EventListener)listener);
    }

    public void addEditorColorsListener(@NotNull EditorColorsListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "addEditorColorsListener"));
        }
        this.myListeners.addListener((EventListener)listener, disposable);
    }

    public void removeEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "removeEditorColorsListener"));
        }
        this.myListeners.removeListener((EventListener)listener);
    }

    public void setUseOnlyMonospacedFonts(boolean value) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        if (this.mySchemeManager.getCurrentScheme() != null) {
            String name = ((EditorColorsScheme)this.mySchemeManager.getCurrentScheme()).getName();
            this.myState.colorScheme = DEFAULT_NAME.equals(name) ? null : name;
        }
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : (EditorColorsScheme)this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme) {
        return scheme instanceof DefaultColorsScheme;
    }

    @NotNull
    public SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> getSchemeManager() {
        SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> schemesManager = this.mySchemeManager;
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl", "getSchemeManager"));
        }
        return schemesManager;
    }

    static class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static class ReadOnlyColorsSchemeImpl
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        public ReadOnlyColorsSchemeImpl(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$ReadOnlyColorsSchemeImpl", "<init>"));
            }
            super(null);
            this.readExternal(element);
        }
    }
}

