/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel {
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    @NotNull
    private final EditorImpl myEditor;
    @Nullable
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final List<ErrorStripeListener> myErrorMarkerListeners;
    private boolean dimensionsAreValid;
    private int myEditorScrollbarTop;
    private int myEditorTargetHeight;
    private int myEditorSourceHeight;
    @Nullable
    private ProperTextRange myDirtyYPositions;
    private static final ProperTextRange WHOLE_DOCUMENT = new ProperTextRange(0, 0);
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider;
    private int myMinMarkHeight;
    private static final int myPreviewLines = Math.max(2, Math.min(25, Integer.getInteger("preview.lines", 5)));
    private static final int myCachePreviewLines = 100;
    @Nullable
    private LightweightHint myEditorPreviewHint;
    @NotNull
    private final EditorFragmentRenderer myEditorFragmentRenderer;
    private int myRowAdjuster;
    private int myWheelAccumulator;

    private static int getErrorIconWidth() {
        return JBUI.scale((int)14);
    }

    private static int getErrorIconHeight() {
        return JBUI.scale((int)14);
    }

    private static int getThinGap() {
        return JBUI.scale((int)2);
    }

    private static int getMaxStripeSize() {
        return JBUI.scale((int)4);
    }

    private static int getMaxMacThumbWidth() {
        return JBUI.scale((int)10);
    }

    EditorMarkupModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "<init>"));
        }
        super(editor.getDocument());
        this.myErrorMarkerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditorScrollbarTop = -1;
        this.myEditorTargetHeight = -1;
        this.myEditorSourceHeight = -1;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditorPreviewHint = null;
        this.myRowAdjuster = 0;
        this.myWheelAccumulator = 0;
        this.myEditor = editor;
        this.myEditorFragmentRenderer = new EditorFragmentRenderer();
        this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().ERROR_STRIPE_MARK_MIN_HEIGHT);
    }

    private int offsetToLine(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "offsetToLine"));
        }
        if (offset < 0) {
            return 0;
        }
        if (offset > document.getTextLength()) {
            return document.getLineCount();
        }
        return this.myEditor.offsetToVisualLine(offset);
    }

    public void repaintVerticalScrollBar() {
        this.myEditor.getVerticalScrollBar().repaint();
    }

    void recalcEditorDimensions() {
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        int scrollBarHeight = Math.max(0, scrollBar.getSize().height);
        this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight();
        assert (this.myEditorScrollbarTop >= 0);
        int editorScrollbarBottom = scrollBar.getIncScrollButtonHeight();
        this.myEditorTargetHeight = scrollBarHeight - this.myEditorScrollbarTop - editorScrollbarBottom;
        this.myEditorSourceHeight = this.myEditor.getPreferredHeight();
        this.dimensionsAreValid = scrollBarHeight != 0;
    }

    public void repaintTrafficLightIcon() {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.myErrorStripeButton.repaint();
            errorPanel.repaintTrafficTooltip();
        }
    }

    private boolean showToolTipByMouseMove(@NotNull MouseEvent e) {
        int visualY;
        boolean isVisible;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "showToolTipByMouseMove"));
        }
        if (this.myEditor.getVisibleLineCount() == 0) {
            return false;
        }
        MouseEvent me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getY() + 1, e.getClickCount(), e.isPopupTrigger());
        int visualLine = this.getVisualLineByEvent(e);
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        boolean bl = isVisible = area.contains(area.x, visualY = this.myEditor.getLineHeight() * visualLine) && this.myWheelAccumulator == 0;
        if (IJSwingUtilities.findParentByInterface(this.myEditor.getComponent(), EditorWindowHolder.class) == null || isVisible || !UISettings.getInstance().SHOW_EDITOR_TOOLTIP) {
            THashSet highlighters = new THashSet();
            this.getNearestHighlighters(this, me.getY(), (Collection<RangeHighlighter>)highlighters);
            this.getNearestHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getEditor().getProject(), true), me.getY(), (Collection<RangeHighlighter>)highlighters);
            if (highlighters.isEmpty()) {
                return false;
            }
            int y = e.getY();
            RangeHighlighter nearest = this.getNearestRangeHighlighter(e);
            if (nearest != null) {
                ProperTextRange range = this.offsetsToYPositions(nearest.getStartOffset(), nearest.getEndOffset());
                int eachStartY = range.getStartOffset();
                int eachEndY = range.getEndOffset();
                y = eachStartY + (eachEndY - eachStartY) / 2;
            }
            me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), me.getX(), y + 1, e.getClickCount(), e.isPopupTrigger());
            TooltipRenderer bigRenderer = this.myTooltipRendererProvider.calcTooltipRenderer((Collection<RangeHighlighter>)highlighters);
            if (bigRenderer != null) {
                this.showTooltip(me, bigRenderer, EditorMarkupModelImpl.createHint(me));
                return true;
            }
            return false;
        }
        float rowRatio = (float)visualLine / (float)(this.myEditor.getVisibleLineCount() - 1);
        int y = this.myRowAdjuster != 0 ? (int)(rowRatio * (float)this.myEditor.getVerticalScrollBar().getHeight()) : me.getY();
        me = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), y, me.getClickCount(), me.isPopupTrigger());
        ArrayList<RangeHighlighterEx> highlighters = new ArrayList<RangeHighlighterEx>();
        this.collectRangeHighlighters(this, visualLine, highlighters);
        this.collectRangeHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getEditor().getProject(), true), visualLine, highlighters);
        this.myEditorFragmentRenderer.update(visualLine, highlighters, me.isAltDown());
        this.myEditorFragmentRenderer.show(this.myEditor, me.getPoint(), true, ERROR_STRIPE_TOOLTIP_GROUP, EditorMarkupModelImpl.createHint(me));
        return true;
    }

    private static HintHint createHint(MouseEvent me) {
        return new HintHint(me).setAwtTooltip(true).setPreferredPosition(Balloon.Position.atLeft).setBorderInsets(new Insets(1, 1, 1, 1)).setShowImmediately(true).setAnimationEnabled(false);
    }

    private int getVisualLineByEvent(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getVisualLineByEvent"));
        }
        return this.fitLineToEditor(this.myEditor.offsetToVisualLine(this.yPositionToOffset(e.getY() + this.myWheelAccumulator, true)));
    }

    private int fitLineToEditor(int visualLine) {
        return Math.max(0, Math.min(this.myEditor.getVisibleLineCount() - 1, visualLine));
    }

    private int getOffset(int visualLine, boolean startLine) {
        int logicalLine = this.myEditor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line;
        return startLine ? this.myEditor.getDocument().getLineStartOffset(logicalLine) : this.myEditor.getDocument().getLineEndOffset(logicalLine);
    }

    private void collectRangeHighlighters(@NotNull MarkupModelEx markupModel, int visualLine, final @NotNull Collection<RangeHighlighterEx> highlighters) {
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "collectRangeHighlighters"));
        }
        if (highlighters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "collectRangeHighlighters"));
        }
        final int startOffset = this.getOffset(this.fitLineToEditor(visualLine - myPreviewLines), true);
        final int endOffset = this.getOffset(this.fitLineToEditor(visualLine + myPreviewLines), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$1", "process"));
                }
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                    return true;
                }
                if (highlighter.getErrorStripeMarkColor() != null && highlighter.getStartOffset() < endOffset && highlighter.getEndOffset() > startOffset) {
                    highlighters.add(highlighter);
                }
                return true;
            }
        });
    }

    @Nullable
    private RangeHighlighter getNearestRangeHighlighter(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getNearestRangeHighlighter"));
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        this.getNearestHighlighters(this, e.getY(), highlighters);
        this.getNearestHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.myEditor.getProject(), true), e.getY(), highlighters);
        RangeHighlighter nearestMarker = null;
        int yPos = 0;
        for (RangeHighlighter highlighter : highlighters) {
            int newYPos = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset()).getStartOffset();
            if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
            nearestMarker = highlighter;
            yPos = newYPos;
        }
        return nearestMarker;
    }

    private void getNearestHighlighters(@NotNull MarkupModelEx markupModel, final int scrollBarY, final @NotNull Collection<RangeHighlighter> nearest) {
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getNearestHighlighters"));
        }
        if (nearest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nearest", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getNearestHighlighters"));
        }
        int startOffset = this.yPositionToOffset(scrollBarY - this.myMinMarkHeight, true);
        int endOffset = this.yPositionToOffset(scrollBarY + this.myMinMarkHeight, false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(@NotNull RangeHighlighterEx highlighter) {
                ProperTextRange range;
                if (highlighter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$2", "process"));
                }
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                    return true;
                }
                if (highlighter.getErrorStripeMarkColor() != null && scrollBarY >= (range = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset())).getStartOffset() - EditorMarkupModelImpl.this.myMinMarkHeight * 2 && scrollBarY <= range.getEndOffset() + EditorMarkupModelImpl.this.myMinMarkHeight * 2) {
                    nearest.add(highlighter);
                }
                return true;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClick(@NotNull MouseEvent e) {
        int offset;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "doClick"));
        }
        RangeHighlighter marker = this.getNearestRangeHighlighter(e);
        LogicalPosition logicalPositionToScroll = null;
        if (marker == null) {
            if (this.myEditorPreviewHint == null) return;
            logicalPositionToScroll = this.myEditor.visualToLogicalPosition(new VisualPosition(this.myEditorFragmentRenderer.myStartVisualLine, 0));
            offset = this.myEditor.getDocument().getLineStartOffset(logicalPositionToScroll.line);
        } else {
            offset = marker.getStartOffset();
        }
        DocumentEx doc = this.myEditor.getDocument();
        if (doc.getLineCount() > 0 && this.myEditorPreviewHint == null) {
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.myEditor.getCaretModel().moveToOffset(lineEnd);
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getSelectionModel().removeSelection();
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        if (logicalPositionToScroll != null) {
            int lineY = this.myEditor.logicalPositionToXY((LogicalPosition)logicalPositionToScroll).y;
            int relativePopupOffset = this.myEditorFragmentRenderer.myRelativeY;
            scrollingModel.scrollVertically(lineY - relativePopupOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.CENTER);
        }
        scrollingModel.enableAnimation();
        if (marker == null) return;
        this.fireErrorMarkerClicked(marker, e);
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.myEditor.getVerticalScrollBar().setPersistentUI((ScrollBarUI)((Object)new MyErrorPanel()));
            this.myEditor.getHorizontalScrollBar().setPersistentUI(EditorImpl.createEditorScrollbarUI(this.myEditor));
        } else {
            this.myEditor.getVerticalScrollBar().setPersistentUI(EditorImpl.createEditorScrollbarUI(this.myEditor));
            this.myEditor.getHorizontalScrollBar().setPersistentUI(EditorImpl.createEditorScrollbarUI(this.myEditor));
        }
    }

    @Nullable
    private MyErrorPanel getErrorPanel() {
        ScrollBarUI ui = this.myEditor.getVerticalScrollBar().getUI();
        return ui instanceof MyErrorPanel ? (MyErrorPanel)((Object)ui) : null;
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorPanelPopupHandler"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.setPopupHandler(handler2);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorStripTooltipRendererProvider"));
        }
        this.myTooltipRendererProvider = provider;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        ErrorStripTooltipRendererProvider errorStripTooltipRendererProvider = this.myTooltipRendererProvider;
        if (errorStripTooltipRendererProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getErrorStripTooltipRendererProvider"));
        }
        return errorStripTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getEditor"));
        }
        return editorImpl;
    }

    @Override
    public void setErrorStripeRenderer(@NotNull ErrorStripeRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorStripeRenderer"));
        }
        EditorMarkupModelImpl.assertIsDispatchThread();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = renderer;
        this.myEditor.getVerticalScrollBar().updateUI();
        this.repaintVerticalScrollBar();
    }

    private static void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
    }

    @Override
    @Nullable
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        MyErrorPanel panel = this.getErrorPanel();
        if (panel != null) {
            panel.uninstallListeners();
        }
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = null;
        super.dispose();
    }

    void repaint(int startOffset, int endOffset) {
        ProperTextRange range = this.offsetsToYPositions(startOffset, endOffset);
        this.markDirtied(range);
        if (startOffset == -1 || endOffset == -1) {
            this.myDirtyYPositions = WHOLE_DOCUMENT;
        }
        EditorImpl.MyScrollBar bar = this.myEditor.getVerticalScrollBar();
        ((Component)((Object)bar)).repaint(0, range.getStartOffset(), ((JComponent)((Object)bar)).getWidth(), range.getLength() + this.myMinMarkHeight);
    }

    private boolean isMirrored() {
        return this.myEditor.isMirrored();
    }

    private boolean transparent() {
        return Registry.is((String)"editor.transparent.scrollbar", (boolean)false) && EditorUtil.isRealFileEditor(this.myEditor);
    }

    private void showTooltip(@NotNull MouseEvent e, TooltipRenderer tooltipObject, @NotNull HintHint hintHint) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "showTooltip"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "showTooltip"));
        }
        TooltipController tooltipController = TooltipController.getInstance();
        tooltipController.showTooltipByMouseMove(this.myEditor, new RelativePoint(e), tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP, hintHint);
    }

    private void fireErrorMarkerClicked(RangeHighlighter marker, MouseEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.getEditor(), e, marker);
        for (ErrorStripeListener listener : this.myErrorMarkerListeners) {
            listener.errorMarkerClicked(event);
        }
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "addErrorMarkerListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "addErrorMarkerListener"));
        }
        ContainerUtil.add((Object)listener, this.myErrorMarkerListeners, (Disposable)parent);
    }

    public void markDirtied(@NotNull ProperTextRange yPositions) {
        if (yPositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPositions", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "markDirtied"));
        }
        if (this.myDirtyYPositions != WHOLE_DOCUMENT) {
            int start = Math.max(0, yPositions.getStartOffset() - this.myEditor.getLineHeight());
            int end = this.myEditorScrollbarTop + this.myEditorTargetHeight == 0 ? yPositions.getEndOffset() + this.myEditor.getLineHeight() : Math.min(this.myEditorScrollbarTop + this.myEditorTargetHeight, yPositions.getEndOffset() + this.myEditor.getLineHeight());
            ProperTextRange adj = new ProperTextRange(start, Math.max(end, start));
            this.myDirtyYPositions = this.myDirtyYPositions == null ? adj : this.myDirtyYPositions.union((TextRange)adj);
        }
        this.myEditorScrollbarTop = 0;
        this.myEditorSourceHeight = 0;
        this.myEditorTargetHeight = 0;
        this.dimensionsAreValid = false;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        this.myMinMarkHeight = Math.min(minMarkHeight, EditorMarkupModelImpl.getMaxStripeSize());
    }

    @Override
    public boolean isErrorStripeVisible() {
        return this.getErrorPanel() != null;
    }

    @NotNull
    private ProperTextRange offsetsToYPositions(int start, int end) {
        int startY;
        int lineCount;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        DocumentEx document = this.myEditor.getDocument();
        int startLineNumber = end == -1 ? 0 : this.offsetToLine(start, document);
        int editorTargetHeight = Math.max(0, this.myEditorTargetHeight);
        if (this.myEditorSourceHeight < editorTargetHeight) {
            lineCount = 0;
            startY = this.myEditorScrollbarTop + startLineNumber * this.myEditor.getLineHeight();
        } else {
            lineCount = this.myEditorSourceHeight / this.myEditor.getLineHeight();
            startY = this.myEditorScrollbarTop + (int)((float)startLineNumber / (float)lineCount * (float)editorTargetHeight);
        }
        int endLineNumber = this.offsetToLine(end, document);
        int endY = end == -1 || start == -1 ? Math.min(this.myEditorSourceHeight, editorTargetHeight) : (start == end || this.offsetToLine(start, document) == endLineNumber ? startY : (this.myEditorSourceHeight < editorTargetHeight ? this.myEditorScrollbarTop + endLineNumber * this.myEditor.getLineHeight() : this.myEditorScrollbarTop + (int)((float)endLineNumber / (float)lineCount * (float)editorTargetHeight)));
        if (endY < startY) {
            endY = startY;
        }
        ProperTextRange properTextRange = new ProperTextRange(startY, endY);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "offsetsToYPositions"));
        }
        return properTextRange;
    }

    private int yPositionToOffset(int y, boolean beginLine) {
        VisualPosition visual;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        int safeY = Math.max(0, y - this.myEditorScrollbarTop);
        if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
            visual = this.myEditor.xyToVisualPosition(new Point(0, safeY));
        } else {
            float fraction = Math.max(0.0f, Math.min(1.0f, (float)safeY / (float)this.myEditorTargetHeight));
            int lineCount = this.myEditorSourceHeight / this.myEditor.getLineHeight();
            visual = new VisualPosition((int)(fraction * (float)lineCount), 0);
        }
        int line = this.myEditor.visualToLogicalPosition((VisualPosition)visual).line;
        DocumentEx document = this.myEditor.getDocument();
        if (line < 0) {
            return 0;
        }
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (beginLine) {
            int offset = document.getLineStartOffset(line);
            FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
            return startCollapsed != null ? Math.min(offset, startCollapsed.getStartOffset()) : offset;
        }
        int offset = document.getLineEndOffset(line);
        FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
        return startCollapsed != null ? Math.max(offset, startCollapsed.getEndOffset()) : offset;
    }

    private class EditorFragmentRenderer
    implements TooltipRenderer {
        private int myVisualLine;
        private boolean myShowInstantly;
        private final List<RangeHighlighterEx> myHighlighters = new ArrayList<RangeHighlighterEx>();
        @Nullable
        private BufferedImage myCacheLevel1;
        @Nullable
        private BufferedImage myCacheLevel2;
        private int myCacheStartLine;
        private int myCacheEndLine;
        private int myStartVisualLine;
        private int myEndVisualLine;
        private int myRelativeY;
        private boolean myDelayed = false;
        private boolean isDirty = false;
        private final AtomicReference<Point> myPointHolder = new AtomicReference();
        private final AtomicReference<HintHint> myHintHolder = new AtomicReference();

        private EditorFragmentRenderer() {
            this.update(-1, Collections.<RangeHighlighterEx>emptyList(), false);
        }

        void update(int visualLine, @NotNull Collection<RangeHighlighterEx> rangeHighlighters, boolean showInstantly) {
            if (rangeHighlighters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeHighlighters", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "update"));
            }
            this.myVisualLine = visualLine;
            this.myShowInstantly = showInstantly;
            this.myHighlighters.clear();
            if (this.myVisualLine == -1) {
                return;
            }
            int oldStartLine = this.myStartVisualLine;
            int oldEndLine = this.myEndVisualLine;
            this.myStartVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine - myPreviewLines);
            this.myEndVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine + myPreviewLines);
            this.isDirty |= oldStartLine != this.myStartVisualLine || oldEndLine != this.myEndVisualLine;
            for (RangeHighlighterEx rangeHighlighter : rangeHighlighters) {
                this.myHighlighters.add(rangeHighlighter);
            }
            Collections.sort(this.myHighlighters, new Comparator<RangeHighlighterEx>(){

                @Override
                public int compare(@NotNull RangeHighlighterEx ex1, @NotNull RangeHighlighterEx ex2) {
                    if (ex1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1", "compare"));
                    }
                    if (ex2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1", "compare"));
                    }
                    LogicalPosition startPos1 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex1.getAffectedAreaStartOffset());
                    LogicalPosition startPos2 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex2.getAffectedAreaStartOffset());
                    if (startPos1.line != startPos2.line) {
                        return 0;
                    }
                    return startPos1.column - startPos2.column;
                }
            });
        }

        @Override
        @Nullable
        public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintInfo) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (hintInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintInfo", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            boolean needDelay = false;
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                needDelay = true;
                JPanel editorFragmentPreviewPanel = new JPanel(){
                    private static final int R = 6;

                    @Override
                    @NotNull
                    public Dimension getPreferredSize() {
                        int width = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx().getWidth() + ((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollingModel().getVisibleArea().width - EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar().getWidth();
                        if (!ToolWindowManagerEx.getInstanceEx(EditorMarkupModelImpl.this.myEditor.getProject()).getIdsOn(ToolWindowAnchor.LEFT).isEmpty()) {
                            --width;
                        }
                        Dimension dimension = new Dimension(width - 11, EditorMarkupModelImpl.this.myEditor.getLineHeight() * (EditorFragmentRenderer.this.myEndVisualLine - EditorFragmentRenderer.this.myStartVisualLine));
                        if (dimension == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$2", "getPreferredSize"));
                        }
                        return dimension;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(@NotNull Graphics g) {
                        if (g == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$2", "paintComponent"));
                        }
                        if (EditorFragmentRenderer.this.myVisualLine == -1) {
                            return;
                        }
                        Dimension size = this.getPreferredSize();
                        EditorGutterComponentImpl gutterComponentEx = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx();
                        int gutterWidth = gutterComponentEx.getWidth();
                        if (EditorFragmentRenderer.this.myCacheLevel2 == null || EditorFragmentRenderer.this.myCacheStartLine > EditorFragmentRenderer.this.myStartVisualLine || EditorFragmentRenderer.this.myCacheEndLine < EditorFragmentRenderer.this.myEndVisualLine) {
                            EditorFragmentRenderer.this.myCacheStartLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myVisualLine - 100);
                            EditorFragmentRenderer.this.myCacheEndLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myCacheStartLine + 200 + 1);
                            if (EditorFragmentRenderer.this.myCacheLevel2 == null) {
                                EditorFragmentRenderer.this.myCacheLevel2 = UIUtil.createImage((int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.getLineHeight() * 201), (int)1);
                            }
                            Graphics2D cg = EditorFragmentRenderer.this.myCacheLevel2.createGraphics();
                            AffineTransform t = cg.getTransform();
                            EditorUIUtil.setupAntialiasing(cg);
                            int lineShift = -EditorMarkupModelImpl.this.myEditor.getLineHeight() * EditorFragmentRenderer.this.myCacheStartLine;
                            AffineTransform translateInstance = AffineTransform.getTranslateInstance(-3.0, lineShift);
                            translateInstance.preConcatenate(t);
                            cg.setTransform(translateInstance);
                            cg.setClip(0, -lineShift, gutterWidth, EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                            ((JComponent)gutterComponentEx).paint(cg);
                            translateInstance = AffineTransform.getTranslateInstance(gutterWidth - 3, lineShift);
                            translateInstance.preConcatenate(t);
                            cg.setTransform(translateInstance);
                            EditorComponentImpl contentComponent = EditorMarkupModelImpl.this.myEditor.getContentComponent();
                            cg.setClip(0, -lineShift, contentComponent.getWidth(), EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                            contentComponent.paint(cg);
                        }
                        if (EditorFragmentRenderer.this.myCacheLevel1 == null) {
                            EditorFragmentRenderer.this.myCacheLevel1 = UIUtil.createImage((int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.getLineHeight() * (2 * myPreviewLines + 1)), (int)1);
                            EditorFragmentRenderer.this.isDirty = true;
                        }
                        if (EditorFragmentRenderer.this.isDirty) {
                            EditorFragmentRenderer.this.myRelativeY = SwingUtilities.convertPoint((Component)this, (int)0, (int)0, (Component)((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollPane()).y;
                            Graphics2D g2d = EditorFragmentRenderer.this.myCacheLevel1.createGraphics();
                            AffineTransform transform = g2d.getTransform();
                            EditorUIUtil.setupAntialiasing(g2d);
                            GraphicsUtil.setupAAPainting((Graphics)g2d);
                            g2d.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                            AffineTransform translateInstance = AffineTransform.getTranslateInstance(gutterWidth, EditorMarkupModelImpl.this.myEditor.getLineHeight() * (EditorFragmentRenderer.this.myCacheStartLine - EditorFragmentRenderer.this.myStartVisualLine));
                            translateInstance.preConcatenate(transform);
                            g2d.setTransform(translateInstance);
                            UIUtil.drawImage((Graphics)g2d, (Image)EditorFragmentRenderer.this.myCacheLevel2, (int)(-gutterWidth), (int)0, null);
                            TIntIntHashMap rightEdges = new TIntIntHashMap();
                            int h = EditorMarkupModelImpl.this.myEditor.getLineHeight() - 2;
                            for (RangeHighlighterEx ex : EditorFragmentRenderer.this.myHighlighters) {
                                String s;
                                if (!ex.isValid()) continue;
                                int hEndOffset = ex.getAffectedAreaEndOffset();
                                Object tooltip = ex.getErrorStripeTooltip();
                                if (tooltip == null || (s = String.valueOf(tooltip)).isEmpty()) continue;
                                s = s.replaceAll("&nbsp;", " ").replaceAll("\\s+", " ");
                                s = StringUtil.unescapeXml((String)s);
                                LogicalPosition logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(hEndOffset);
                                int endOfLineOffset = EditorMarkupModelImpl.this.myEditor.getDocument().getLineEndOffset(logicalPosition.line);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(endOfLineOffset);
                                Point placeToShow = EditorMarkupModelImpl.this.myEditor.logicalPositionToXY(logicalPosition);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.xyToLogicalPosition(placeToShow);
                                placeToShow.x += 9;
                                placeToShow.y -= EditorFragmentRenderer.this.myCacheStartLine * EditorMarkupModelImpl.this.myEditor.getLineHeight() - 1;
                                Font font = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
                                g2d.setFont(font.deriveFont((float)font.getSize() * 0.8f));
                                int w = g2d.getFontMetrics().stringWidth(s);
                                int rightEdge = rightEdges.get(logicalPosition.line);
                                placeToShow.x = Math.max(placeToShow.x, rightEdge);
                                rightEdge = Math.max(rightEdge, placeToShow.x + w + 18);
                                rightEdges.put(logicalPosition.line, rightEdge);
                                g2d.setColor(MessageType.WARNING.getPopupBackground());
                                g2d.fillRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor((Color)new JBColor((Color)JBColor.GRAY, (Color)Gray._200));
                                g2d.drawRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor(JBColor.foreground());
                                g2d.drawString(s, placeToShow.x + 6, placeToShow.y + h - g2d.getFontMetrics(g2d.getFont()).getDescent() / 2 - 2);
                            }
                            EditorFragmentRenderer.this.isDirty = false;
                        }
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            GraphicsUtil.setupAAPainting((Graphics)g2);
                            g2.setClip(new RoundRectangle2D.Double(0.0, 0.0, (double)size.width - 0.5, (double)size.height - 0.5, 2.0, 2.0));
                            UIUtil.drawImage((Graphics)g2, (Image)EditorFragmentRenderer.this.myCacheLevel1, (int)0, (int)0, (ImageObserver)this);
                            if (UIUtil.isUnderDarcula()) {
                                Rectangle s = new Rectangle(0, 0, size.width, size.height);
                                double cx = size.width / 2;
                                double cy = 0.0;
                                double rx = size.width / 10;
                                int ry = EditorMarkupModelImpl.this.myEditor.getLineHeight() * 3 / 2;
                                g2.setPaint(new GradientPaint(0.0f, 0.0f, Gray._255.withAlpha(75), 0.0f, ry, Gray._255.withAlpha(10)));
                                double pseudoMajorAxis = (double)size.width - rx * 9.0 / 5.0;
                                Ellipse2D.Double topShape1 = new Ellipse2D.Double(cx - rx - pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Ellipse2D.Double topShape2 = new Ellipse2D.Double(cx - rx + pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Area topArea = new Area(topShape1);
                                topArea.add(new Area(topShape2));
                                topArea.add(new Area(new Rectangle2D.Double(cx - pseudoMajorAxis / 2.0, cy, pseudoMajorAxis, ry)));
                                g2.fill(topArea);
                                Area bottomArea = new Area(s);
                                bottomArea.subtract(topArea);
                                g2.setPaint(new GradientPaint(0.0f, size.height - ry, Gray._0.withAlpha(10), 0.0f, size.height, Gray._255.withAlpha(30)));
                                g2.fill(bottomArea);
                            }
                        }
                        finally {
                            g2.dispose();
                        }
                    }
                };
                EditorMarkupModelImpl.this.myEditorPreviewHint = new LightweightHint(editorFragmentPreviewPanel){

                    @Override
                    public void hide(boolean ok) {
                        super.hide(ok);
                        EditorFragmentRenderer.this.myCacheLevel1 = null;
                        if (EditorFragmentRenderer.this.myCacheLevel2 != null) {
                            EditorFragmentRenderer.this.myCacheLevel2 = null;
                            EditorFragmentRenderer.this.myCacheStartLine = -1;
                            EditorFragmentRenderer.this.myCacheEndLine = -1;
                        }
                        EditorFragmentRenderer.this.myDelayed = false;
                    }
                };
                EditorMarkupModelImpl.this.myEditorPreviewHint.setForceLightweightPopup(true);
            }
            Point point = new Point(hintInfo.getOriginalPoint());
            hintInfo.setTextBg(EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultBackground());
            hintInfo.setBorderColor(EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultForeground());
            point = SwingUtilities.convertPoint((Component)((Object)((EditorImpl)editor).getVerticalScrollBar()), point, EditorMarkupModelImpl.this.myEditor.getComponent().getRootPane());
            this.myPointHolder.set(point);
            this.myHintHolder.set(hintInfo);
            if (needDelay && !this.myShowInstantly) {
                this.myDelayed = true;
                Alarm alarm = new Alarm();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorMarkupModelImpl.this.myEditorPreviewHint == null || !EditorFragmentRenderer.this.myDelayed) {
                            return;
                        }
                        EditorFragmentRenderer.this.showEditorHint(hintManager, (Point)EditorFragmentRenderer.this.myPointHolder.get(), (HintHint)EditorFragmentRenderer.this.myHintHolder.get());
                        EditorFragmentRenderer.this.myDelayed = false;
                    }
                }, 300);
            } else if (!this.myDelayed) {
                this.showEditorHint(hintManager, point, hintInfo);
            }
            return EditorMarkupModelImpl.this.myEditorPreviewHint;
        }

        private void showEditorHint(@NotNull HintManagerImpl hintManager, @NotNull Point point, HintHint hintInfo) {
            if (hintManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintManager", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "showEditorHint"));
            }
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "showEditorHint"));
            }
            int flags = 299;
            hintManager.showEditorHint(EditorMarkupModelImpl.this.myEditorPreviewHint, (Editor)EditorMarkupModelImpl.this.myEditor, point, flags, 0, false, hintInfo);
        }
    }

    private static class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
            if (highlighters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer bigRenderer = null;
            Set tooltips = null;
            for (RangeHighlighter highlighter : highlighters) {
                Object tooltipObject = highlighter.getErrorStripeTooltip();
                if (tooltipObject == null) continue;
                String text = tooltipObject.toString();
                if (tooltips == null) {
                    tooltips = new THashSet();
                }
                if (!tooltips.add(text)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text, new Object[]{highlighters});
                    continue;
                }
                bigRenderer.addBelow(text);
            }
            return bigRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text, new Object[]{text});
            if (lineTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text, width, new Object[]{text});
            if (lineTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TrafficTooltipRenderer createTrafficTooltipRenderer(final @NotNull Runnable onHide, @NotNull Editor editor) {
            if (onHide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onHide", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            TrafficTooltipRenderer trafficTooltipRenderer = new TrafficTooltipRenderer(){

                @Override
                public void repaintTooltipWindow() {
                }

                @Override
                @NotNull
                public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (p == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (group == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (hintHint == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    JLabel label = new JLabel("WTF");
                    LightweightHint lightweightHint = new LightweightHint(label){

                        @Override
                        public void hide() {
                            super.hide();
                            onHide.run();
                        }
                    };
                    if (lightweightHint == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    return lightweightHint;
                }
            };
            if (trafficTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            return trafficTooltipRenderer;
        }
    }

    private class MyErrorPanel
    extends ButtonlessScrollBarUI
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    UISettingsListener {
        private PopupHandler myHandler;
        private JButton myErrorStripeButton;
        @Nullable
        private BufferedImage myCachedTrack;
        private int myCachedHeight = -1;
        @Nullable
        private TrafficTooltipRenderer myTrafficTooltipRenderer;

        private MyErrorPanel() {
        }

        public void dropCache() {
            this.myCachedTrack = null;
            this.myCachedHeight = -1;
        }

        @NotNull
        protected JButton createDecreaseButton(int orientation) {
            JButton jButton = this.myErrorStripeButton = EditorMarkupModelImpl.this.myErrorStripeRenderer == null ? super.createDecreaseButton(orientation) : new ErrorStripeButton();
            if (jButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "createDecreaseButton"));
            }
            return jButton;
        }

        protected boolean isMacScrollbarHiddenAndXcodeLikeScrollbar() {
            return super.isMacScrollbarHiddenAndXcodeLikeScrollbar() && EditorUtil.isRealFileEditor(EditorMarkupModelImpl.this.myEditor);
        }

        public boolean alwaysShowTrack() {
            if (this.scrollbar.getOrientation() == 1) {
                return !EditorMarkupModelImpl.this.transparent();
            }
            return super.alwaysShowTrack();
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.dropCache();
        }

        public void uninstallUI(@NotNull JComponent c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "uninstallUI"));
            }
            super.uninstallUI(c);
            this.dropCache();
        }

        protected void installListeners() {
            super.installListeners();
            this.scrollbar.addMouseMotionListener(this);
            this.scrollbar.addMouseListener(this);
            this.scrollbar.addMouseWheelListener(this);
            this.myErrorStripeButton.addMouseMotionListener(this);
            this.myErrorStripeButton.addMouseListener(this);
            UISettings.getInstance().addUISettingsListener((UISettingsListener)this);
        }

        protected void uninstallListeners() {
            this.scrollbar.removeMouseMotionListener(this);
            this.scrollbar.removeMouseListener(this);
            this.myErrorStripeButton.removeMouseMotionListener(this);
            this.myErrorStripeButton.removeMouseListener(this);
            UISettings.getInstance().removeUISettingsListener((UISettingsListener)this);
            super.uninstallListeners();
        }

        public void uiSettingsChanged(UISettings source) {
            if (!UISettings.getInstance().SHOW_EDITOR_TOOLTIP) {
                this.hideMyEditorPreviewHint();
            }
            EditorMarkupModelImpl.this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().ERROR_STRIPE_MARK_MIN_HEIGHT);
            this.repaintTrafficTooltip();
            EditorMarkupModelImpl.this.repaintTrafficLightIcon();
            EditorMarkupModelImpl.this.repaintVerticalScrollBar();
        }

        protected void paintThumb(@NotNull Graphics g, @NotNull JComponent c, Rectangle thumbBounds) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintThumb"));
            }
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintThumb"));
            }
            if (this.isMacOverlayScrollbar()) {
                if (!EditorMarkupModelImpl.this.isMirrored()) {
                    super.paintThumb(g, c, thumbBounds);
                } else {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform old = g2d.getTransform();
                    AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                    tx.translate(-c.getWidth(), 0.0);
                    g2d.transform(tx);
                    super.paintThumb(g, c, thumbBounds);
                    g2d.setTransform(old);
                }
            } else {
                int shift;
                if (Registry.is((String)"editor.full.width.scrollbar")) {
                    shift = EditorMarkupModelImpl.this.isMirrored() ? -EditorMarkupModelImpl.this.myMinMarkHeight + 1 : EditorMarkupModelImpl.this.myMinMarkHeight;
                } else {
                    int half = this.getThickness() / 2;
                    shift = EditorMarkupModelImpl.this.isMirrored() ? -half + 2 : half - 1;
                }
                g.translate(shift, 0);
                super.paintThumb(g, c, thumbBounds);
                g.translate(-shift, 0);
            }
        }

        protected boolean isDark() {
            return EditorMarkupModelImpl.this.myEditor.isDarkEnough();
        }

        protected boolean alwaysPaintThumb() {
            if (this.scrollbar.getOrientation() == 1) {
                return !MyErrorPanel.xcodeLikeScrollbar() || !EditorUtil.isRealFileEditor(EditorMarkupModelImpl.this.myEditor);
            }
            return super.alwaysPaintThumb();
        }

        protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
            Rectangle bounds = super.getMacScrollBarBounds(baseBounds, thumb);
            bounds.width = Math.min(bounds.width, EditorMarkupModelImpl.getMaxMacThumbWidth());
            int b2 = bounds.width / 2;
            bounds.x = EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.myMinMarkHeight + EditorMarkupModelImpl.getErrorIconWidth() / 2 - b2;
            return bounds;
        }

        protected void paintMaxiThumb(@NotNull Graphics2D g, @NotNull Rectangle thumbBounds) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintMaxiThumb"));
            }
            if (thumbBounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thumbBounds", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintMaxiThumb"));
            }
            int arc = 3;
            g.setColor(this.adjustColor((Color)this.getGradientDarkColor()));
            g.fillRoundRect(EditorMarkupModelImpl.this.isMirrored() ? -3 : 2, 0, thumbBounds.width, thumbBounds.height, arc, arc);
        }

        protected int getThickness() {
            return EditorMarkupModelImpl.getErrorIconWidth() + EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.myMinMarkHeight;
        }

        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle trackBounds) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintTrack"));
            }
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintTrack"));
            }
            if (trackBounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackBounds", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintTrack"));
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                this.doPaintTrack(g, c, trackBounds);
            } else {
                super.paintTrack(g, c, trackBounds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPaintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle bounds) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "doPaintTrack"));
            }
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "doPaintTrack"));
            }
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "doPaintTrack"));
            }
            if (this.isMacScrollbarHiddenAndXcodeLikeScrollbar()) {
                this.paintTrackBasement(g, bounds);
                return;
            }
            Rectangle clip = g.getClipBounds().intersection(bounds);
            if (clip.height == 0) {
                return;
            }
            Rectangle componentBounds = c.getBounds();
            ProperTextRange docRange = ProperTextRange.create((int)0, (int)componentBounds.height);
            if (this.myCachedTrack == null || this.myCachedHeight != componentBounds.height) {
                this.myCachedTrack = UIUtil.createImage((int)componentBounds.width, (int)componentBounds.height, (int)2);
                this.myCachedHeight = componentBounds.height;
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                this.paintTrackBasement(this.myCachedTrack.getGraphics(), new Rectangle(0, 0, componentBounds.width, componentBounds.height));
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions == WHOLE_DOCUMENT) {
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions != null) {
                Graphics2D imageGraphics = this.myCachedTrack.createGraphics();
                ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
                try {
                    EditorMarkupModelImpl.this.myDirtyYPositions = EditorMarkupModelImpl.this.myDirtyYPositions.intersection((TextRange)docRange);
                    if (EditorMarkupModelImpl.this.myDirtyYPositions == null) {
                        EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                    }
                    this.repaint(imageGraphics, componentBounds.width, EditorMarkupModelImpl.this.myDirtyYPositions);
                    EditorMarkupModelImpl.this.myDirtyYPositions = null;
                }
                finally {
                    ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
                }
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCachedTrack, null, (int)0, (int)0);
        }

        private void paintTrackBasement(@NotNull Graphics g, @NotNull Rectangle bounds) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintTrackBasement"));
            }
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "paintTrackBasement"));
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setComposite(AlphaComposite.getInstance(1));
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                g2.setComposite(AlphaComposite.getInstance(3));
            } else {
                g.setColor(EditorMarkupModelImpl.this.getEditor().getColorsScheme().getDefaultBackground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        @NotNull
        protected Color adjustColor(Color c) {
            Color color = this.isMacOverlayScrollbar() ? super.adjustColor(c) : EditorImpl.adjustThumbColor(super.adjustColor(c), this.isDark());
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "adjustColor"));
            }
            return color;
        }

        private void repaint(@NotNull Graphics g, int gutterWidth, @NotNull ProperTextRange yrange) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "repaint"));
            }
            if (yrange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yrange", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "repaint"));
            }
            Rectangle clip = new Rectangle(0, yrange.getStartOffset(), gutterWidth, yrange.getLength() + EditorMarkupModelImpl.this.myMinMarkHeight);
            this.paintTrackBasement(g, clip);
            DocumentEx document = EditorMarkupModelImpl.this.myEditor.getDocument();
            int startOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y - EditorMarkupModelImpl.this.myMinMarkHeight, true);
            int endOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y + clip.height, false);
            Shape oldClip = g.getClip();
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            this.drawMarkup(g, startOffset, endOffset, (MarkupModelEx)DocumentMarkupModel.forDocument(document, EditorMarkupModelImpl.this.myEditor.getProject(), true), EditorMarkupModelImpl.this);
            g.setClip(oldClip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawMarkup(final @NotNull Graphics g, int startOffset, int endOffset, @NotNull MarkupModelEx markup1, @NotNull MarkupModelEx markup2) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawMarkup"));
            }
            if (markup1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawMarkup"));
            }
            if (markup2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markup2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawMarkup"));
            }
            final PriorityQueue<PositionedStripe> thinEnds = new PriorityQueue<PositionedStripe>(5, new Comparator<PositionedStripe>(){

                @Override
                public int compare(@NotNull PositionedStripe o1, @NotNull PositionedStripe o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$1", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$1", "compare"));
                    }
                    return o1.yEnd - o2.yEnd;
                }
            });
            final PriorityQueue<PositionedStripe> wideEnds = new PriorityQueue<PositionedStripe>(5, new Comparator<PositionedStripe>(){

                @Override
                public int compare(@NotNull PositionedStripe o1, @NotNull PositionedStripe o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$2", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$2", "compare"));
                    }
                    return o1.yEnd - o2.yEnd;
                }
            });
            final ArrayList<PositionedStripe> thinStripes = new ArrayList<PositionedStripe>();
            final ArrayList<PositionedStripe> wideStripes = new ArrayList<PositionedStripe>();
            final int[] thinYStart = new int[1];
            final int[] wideYStart = new int[1];
            DisposableIterator<RangeHighlighterEx> iterator1 = markup1.overlappingIterator(startOffset, endOffset);
            DisposableIterator<RangeHighlighterEx> iterator2 = markup2.overlappingIterator(startOffset, endOffset);
            IntervalTreeImpl.PeekableIterator<RangeHighlighterEx> iterator = IntervalTreeImpl.mergeIterators((IntervalTreeImpl.PeekableIterator)iterator1, (IntervalTreeImpl.PeekableIterator)iterator2, RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
            try {
                ContainerUtil.process(iterator, (Processor)new Processor<RangeHighlighterEx>(){

                    public boolean process(@NotNull RangeHighlighterEx highlighter) {
                        int i;
                        if (highlighter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$3", "process"));
                        }
                        if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                            return true;
                        }
                        Color color = highlighter.getErrorStripeMarkColor();
                        if (color == null) {
                            return true;
                        }
                        boolean isThin = highlighter.isThinErrorStripeMark();
                        int[] yStart = isThin ? thinYStart : wideYStart;
                        List stripes = isThin ? thinStripes : wideStripes;
                        Queue ends = isThin ? thinEnds : wideEnds;
                        ProperTextRange range = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset());
                        int ys = range.getStartOffset();
                        int ye = range.getEndOffset();
                        if (ye - ys < EditorMarkupModelImpl.this.myMinMarkHeight) {
                            ye = ys + EditorMarkupModelImpl.this.myMinMarkHeight;
                        }
                        yStart[0] = MyErrorPanel.this.drawStripesEndingBefore(ys, ends, stripes, g, yStart[0]);
                        int layer = highlighter.getLayer();
                        PositionedStripe stripe = null;
                        for (i = 0; i < stripes.size(); ++i) {
                            PositionedStripe s = (PositionedStripe)stripes.get(i);
                            if (s.layer == layer) {
                                stripe = s;
                                break;
                            }
                            if (s.layer < layer) break;
                        }
                        if (stripe == null) {
                            if (i == 0 && yStart[0] != ys) {
                                if (!stripes.isEmpty()) {
                                    PositionedStripe top = (PositionedStripe)stripes.get(0);
                                    MyErrorPanel.this.drawSpot(g, top.thin, yStart[0], ys, top.color);
                                }
                                yStart[0] = ys;
                            }
                            stripe = new PositionedStripe(color, ye, isThin, layer);
                            stripes.add(i, stripe);
                            ends.offer(stripe);
                        } else if (stripe.yEnd < ye) {
                            if (!color.equals(stripe.color)) {
                                if (i == 0 && yStart[0] != ys) {
                                    MyErrorPanel.this.drawSpot(g, stripe.thin, yStart[0], ys, stripe.color);
                                    yStart[0] = ys;
                                }
                                stripe.color = color;
                            }
                            ends.remove(stripe);
                            stripe.yEnd = ye;
                            ends.offer(stripe);
                        }
                        return true;
                    }
                });
            }
            finally {
                iterator.dispose();
            }
            this.drawStripesEndingBefore(Integer.MAX_VALUE, thinEnds, thinStripes, g, thinYStart[0]);
            this.drawStripesEndingBefore(Integer.MAX_VALUE, wideEnds, wideStripes, g, wideYStart[0]);
        }

        private int drawStripesEndingBefore(int ys, @NotNull Queue<PositionedStripe> ends, @NotNull List<PositionedStripe> stripes, @NotNull Graphics g, int yStart) {
            PositionedStripe endingStripe;
            if (ends == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ends", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawStripesEndingBefore"));
            }
            if (stripes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stripes", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawStripesEndingBefore"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawStripesEndingBefore"));
            }
            while (!ends.isEmpty() && (endingStripe = ends.peek()).yEnd <= ys) {
                ends.remove();
                int i = stripes.indexOf(endingStripe);
                stripes.remove(i);
                if (i != 0) continue;
                this.drawSpot(g, endingStripe.thin, yStart, endingStripe.yEnd, endingStripe.color);
                yStart = endingStripe.yEnd;
            }
            return yStart;
        }

        private void drawSpot(@NotNull Graphics g, boolean thinErrorStripeMark, int yStart, int yEnd, @NotNull Color color) {
            int x;
            int paintWidth;
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawSpot"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "drawSpot"));
            }
            if (thinErrorStripeMark) {
                paintWidth = EditorMarkupModelImpl.this.myMinMarkHeight;
                int n = x = EditorMarkupModelImpl.this.isMirrored() ? this.getThickness() - paintWidth : 0;
                if (yEnd - yStart < 6) {
                    yEnd += yEnd - --yStart - 1;
                }
            } else {
                x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.this.myMinMarkHeight + EditorMarkupModelImpl.getThinGap();
                paintWidth = EditorMarkupModelImpl.getErrorIconWidth();
            }
            g.setColor(color);
            g.fillRect(x, yStart, paintWidth, yEnd - yStart);
        }

        @Override
        public void mouseClicked(final @NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseClicked"));
            }
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), new Runnable(){

                @Override
                public void run() {
                    MyErrorPanel.this.doMouseClicked(e);
                }
            }, EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mousePressed"));
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseReleased"));
            }
        }

        private int getWidth() {
            return this.scrollbar.getWidth();
        }

        private void doMouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "doMouseClicked"));
            }
            EditorMarkupModelImpl.this.myEditor.getContentComponent().requestFocus();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth()) {
                EditorMarkupModelImpl.this.doClick(e);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseMoved"));
            }
            if (this.isMacScrollbarHiddenAndXcodeLikeScrollbar()) {
                return;
            }
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getY() < buttonHeight && EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                this.showTrafficLightTooltip(e);
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth() && EditorMarkupModelImpl.this.showToolTipByMouseMove(e)) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e, false);
            if (this.scrollbar.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseWheelMoved"));
            }
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                return;
            }
            EditorMarkupModelImpl.this.myWheelAccumulator = EditorMarkupModelImpl.this.myWheelAccumulator + (e.getScrollType() == 0 ? e.getUnitsToScroll() * e.getScrollAmount() : (e.getWheelRotation() < 0 ? -e.getScrollAmount() : e.getScrollAmount()));
            EditorMarkupModelImpl.this.myRowAdjuster = EditorMarkupModelImpl.this.myWheelAccumulator / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            EditorMarkupModelImpl.this.showToolTipByMouseMove(e);
        }

        private void showTrafficLightTooltip(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "showTrafficLightTooltip"));
            }
            if (this.myTrafficTooltipRenderer == null) {
                this.myTrafficTooltipRenderer = EditorMarkupModelImpl.this.myTooltipRendererProvider.createTrafficTooltipRenderer(new Runnable(){

                    @Override
                    public void run() {
                        MyErrorPanel.this.myTrafficTooltipRenderer = null;
                    }
                }, EditorMarkupModelImpl.this.myEditor);
            }
            EditorMarkupModelImpl.this.showTooltip(e, this.myTrafficTooltipRenderer, new HintHint(e).setAwtTooltip(true).setMayCenterPosition(true).setContentActive(false).setPreferredPosition(Balloon.Position.atLeft));
        }

        private void repaintTrafficTooltip() {
            if (this.myTrafficTooltipRenderer != null) {
                this.myTrafficTooltipRenderer.repaintTooltipWindow();
            }
        }

        private void cancelMyToolTips(MouseEvent e, boolean checkIfShouldSurvive) {
            this.hideMyEditorPreviewHint();
            TooltipController tooltipController = TooltipController.getInstance();
            if (!checkIfShouldSurvive || !tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP, e, true);
            }
        }

        private void hideMyEditorPreviewHint() {
            if (EditorMarkupModelImpl.this.myEditorPreviewHint != null) {
                EditorMarkupModelImpl.this.myEditorPreviewHint.hide();
                EditorMarkupModelImpl.this.myEditorPreviewHint = null;
                EditorMarkupModelImpl.this.myRowAdjuster = 0;
                EditorMarkupModelImpl.this.myWheelAccumulator = 0;
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseExited"));
            }
            this.cancelMyToolTips(e, true);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseDragged"));
            }
            this.cancelMyToolTips(e, true);
        }

        private void setPopupHandler(@NotNull PopupHandler handler2) {
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "setPopupHandler"));
            }
            if (this.myHandler != null) {
                this.scrollbar.removeMouseListener((MouseListener)this.myHandler);
                this.myErrorStripeButton.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler2;
            this.scrollbar.addMouseListener((MouseListener)handler2);
            this.myErrorStripeButton.addMouseListener((MouseListener)this.myHandler);
        }
    }

    private class ErrorStripeButton
    extends JButton {
        private ErrorStripeButton() {
            this.setFocusable(false);
            this.setOpaque(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$ErrorStripeButton", "paint"));
            }
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
            try {
                if (!EditorMarkupModelImpl.this.transparent()) {
                    g.setColor(EditorMarkupModelImpl.this.getEditor().getColorsScheme().getDefaultBackground());
                    Rectangle bounds = this.getBounds();
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                if (EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                    int x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.myMinMarkHeight;
                    Rectangle b = new Rectangle(x, 0, EditorMarkupModelImpl.getErrorIconWidth(), EditorMarkupModelImpl.getErrorIconHeight());
                    EditorMarkupModelImpl.this.myErrorStripeRenderer.paint((Component)this, g, b);
                }
            }
            finally {
                ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(EditorMarkupModelImpl.getErrorIconWidth() + EditorMarkupModelImpl.getThinGap(), EditorMarkupModelImpl.getErrorIconHeight() + EditorMarkupModelImpl.getThinGap());
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$ErrorStripeButton", "getPreferredSize"));
            }
            return dimension;
        }
    }

    private static class PositionedStripe {
        @NotNull
        private Color color;
        private int yEnd;
        private final boolean thin;
        private final int layer;

        private PositionedStripe(@NotNull Color color, int yEnd, boolean thin, int layer) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$PositionedStripe", "<init>"));
            }
            this.color = color;
            this.yEnd = yEnd;
            this.thin = thin;
            this.layer = layer;
        }
    }
}

