/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.Dumpable;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JScrollBar;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapApplianceManager
implements Dumpable {
    private static final Logger LOG = Logger.getInstance((String)("#" + SoftWrapApplianceManager.class.getName()));
    private final List<SoftWrapAwareDocumentParsingListener> myListeners;
    private final ProcessingContext myContext;
    private final FontTypesStorage myOffset2fontType;
    private final WidthsStorage myOffset2widthInPixels;
    private final SoftWrapsStorage myStorage;
    private final EditorImpl myEditor;
    private SoftWrapPainter myPainter;
    private final CachingSoftWrapDataMapper myDataMapper;
    private int myLastTopLeftCornerOffset;
    private int myVerticalScrollBarWidth;
    private VisibleAreaWidthProvider myWidthProvider;
    private LineWrapPositionStrategy myLineWrapPositionStrategy;
    private IncrementalCacheUpdateEvent myEventBeingProcessed;
    private boolean myVisualAreaListenerAttached;
    private boolean myCustomIndentUsedLastTime;
    private int myCustomIndentValueUsedLastTime;
    private int myVisibleAreaWidth;
    private boolean myInProgress;
    private boolean myIsDirty;
    private IncrementalCacheUpdateEvent myDocumentChangedEvent;

    public SoftWrapApplianceManager(@NotNull SoftWrapsStorage storage2, @NotNull EditorImpl editor, @NotNull SoftWrapPainter painter, CachingSoftWrapDataMapper dataMapper) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "<init>"));
        }
        this.myListeners = new ArrayList<SoftWrapAwareDocumentParsingListener>();
        this.myContext = new ProcessingContext();
        this.myOffset2fontType = new FontTypesStorage();
        this.myOffset2widthInPixels = new WidthsStorage();
        this.myLastTopLeftCornerOffset = -1;
        this.myVerticalScrollBarWidth = -1;
        this.myIsDirty = true;
        this.myStorage = storage2;
        this.myEditor = editor;
        this.myPainter = painter;
        this.myDataMapper = dataMapper;
        this.myWidthProvider = new DefaultVisibleAreaWidthProvider(editor);
    }

    public void registerSoftWrapIfNecessary() {
        this.recalculateIfNecessary();
    }

    public void reset() {
        this.myIsDirty = true;
        for (SoftWrapAwareDocumentParsingListener listener : this.myListeners) {
            listener.reset();
        }
    }

    public void release() {
        this.myLineWrapPositionStrategy = null;
    }

    private void initListenerIfNecessary() {
        if (this.myVisualAreaListenerAttached) {
            return;
        }
        this.myVisualAreaListenerAttached = true;
        this.myEditor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

            public void visibleAreaChanged(VisibleAreaEvent e) {
                SoftWrapApplianceManager.this.updateLastTopLeftCornerOffset();
            }
        });
        this.updateLastTopLeftCornerOffset();
    }

    public void recalculate(IncrementalCacheUpdateEvent e) {
        if (this.myIsDirty) {
            return;
        }
        this.initListenerIfNecessary();
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        this.recalculateSoftWraps(e);
        this.onRecalculationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate(List<? extends Segment> ranges) {
        if (this.myIsDirty) {
            return;
        }
        this.initListenerIfNecessary();
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        Collections.sort(ranges, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                int startDiff = o1.getStartOffset() - o2.getStartOffset();
                return startDiff == 0 ? o2.getEndOffset() - o1.getEndOffset() : startDiff;
            }
        });
        final int[] lastRecalculatedOffset = new int[]{0};
        SoftWrapAwareDocumentParsingListenerAdapter listener = new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager$3", "onRecalculationEnd"));
                }
                lastRecalculatedOffset[0] = event.getActualEndOffset();
            }
        };
        this.myListeners.add(listener);
        try {
            for (Segment segment : ranges) {
                int lastOffset = lastRecalculatedOffset[0];
                if (segment.getEndOffset() <= lastOffset) continue;
                this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(Math.max(segment.getStartOffset(), lastOffset), segment.getEndOffset(), this.myDataMapper, this.myEditor));
            }
        }
        finally {
            this.myListeners.remove(listener);
        }
        this.onRecalculationEnd();
    }

    private boolean recalculateSoftWraps() {
        this.initListenerIfNecessary();
        if (!this.myIsDirty) {
            return true;
        }
        if (this.myVisibleAreaWidth <= 0) {
            return false;
        }
        this.myIsDirty = false;
        this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(this.myEditor.getDocument()));
        this.onRecalculationEnd();
        return true;
    }

    private void onRecalculationEnd() {
        this.updateLastTopLeftCornerOffset();
        for (SoftWrapAwareDocumentParsingListener listener : this.myListeners) {
            listener.recalculationEnds();
        }
    }

    private void recalculateSoftWraps(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "recalculateSoftWraps"));
        }
        if (this.myEditor.getDocument() instanceof DocumentImpl && ((DocumentImpl)this.myEditor.getDocument()).acceptsSlashR()) {
            LOG.error("Soft wrapping is not supported for documents with non-standard line endings. File: " + this.myEditor.getVirtualFile());
        }
        if (this.myInProgress) {
            LogMessageEx.error(LOG, "Detected race condition at soft wraps recalculation", this.myEditor.dumpState(), event.toString());
        }
        this.myInProgress = true;
        try {
            this.doRecalculateSoftWraps(event);
        }
        finally {
            this.myInProgress = false;
        }
    }

    private void doRecalculateSoftWraps(IncrementalCacheUpdateEvent event) {
        this.myEventBeingProcessed = event;
        this.notifyListenersOnCacheUpdateStart(event);
        this.myContext.reset();
        this.myOffset2fontType.clear();
        this.myOffset2widthInPixels.clear();
        int start = event.getStartOffset();
        LogicalPosition logical = event.getStartLogicalPosition();
        DocumentEx document = this.myEditor.getDocument();
        this.myContext.text = document.getCharsSequence();
        this.myContext.tokenStartOffset = start;
        IterationState iterationState = new IterationState(this.myEditor, start, document.getTextLength(), false);
        TextAttributes attributes = iterationState.getMergedAttributes();
        this.myContext.fontType = attributes.getFontType();
        this.myContext.rangeEndOffset = event.getMandatoryEndOffset();
        EditorPosition position = this.myEditor.myUseNewRendering ? new EditorPosition(logical, event.getStartVisualPosition(), start, this.myEditor) : new EditorPosition(logical, start, this.myEditor);
        position.x = start == 0 ? this.myEditor.getPrefixTextWidthInPixels() : 0;
        int spaceWidth = EditorUtil.getSpaceWidth(this.myContext.fontType, this.myEditor);
        int plainSpaceWidth = EditorUtil.getSpaceWidth(0, this.myEditor);
        this.myContext.logicalLineData.update(logical.line, spaceWidth, plainSpaceWidth);
        this.myContext.currentPosition = position;
        this.myContext.lineStartPosition = position.clone();
        this.myContext.fontType2spaceWidth.put(this.myContext.fontType, spaceWidth);
        this.myContext.softWrapStartOffset = position.offset;
        this.myContext.reservedWidthInPixels = this.myPainter.getMinDrawingWidth(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        SoftWrap softWrapAtStartPosition = this.myStorage.getSoftWrap(start);
        if (softWrapAtStartPosition != null) {
            this.myContext.currentPosition.x = softWrapAtStartPosition.getIndentInPixels();
            this.myContext.lineStartPosition.visualColumn = 0;
            this.myContext.lineStartPosition.softWrapColumnDiff -= softWrapAtStartPosition.getIndentInColumns();
            ++this.myContext.softWrapStartOffset;
            this.notifyListenersOnVisualLineStart(this.myContext.lineStartPosition);
        }
        while (!iterationState.atEnd()) {
            FoldRegion currentFold = iterationState.getCurrentFold();
            if (currentFold == null) {
                this.myContext.tokenEndOffset = iterationState.getEndOffset();
                if (this.processNonFoldToken()) {
                    break;
                }
            } else {
                if (this.processCollapsedFoldRegion(currentFold)) break;
                this.myOffset2widthInPixels.clear();
            }
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            this.myContext.fontType = attributes.getFontType();
            this.myContext.tokenStartOffset = iterationState.getStartOffset();
            this.myOffset2fontType.fill(this.myContext.tokenStartOffset, iterationState.getEndOffset(), this.myContext.fontType);
        }
        if (this.myContext.delayedSoftWrap != null) {
            this.myStorage.remove(this.myContext.delayedSoftWrap);
        }
        this.notifyListenersOnVisualLineEnd();
        event.setActualEndOffset(this.myContext.currentPosition.offset);
        this.validateFinalPosition(event);
        this.notifyListenersOnCacheUpdateEnd(event);
        this.myEventBeingProcessed = null;
    }

    private void validateFinalPosition(IncrementalCacheUpdateEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Soft wrap recalculation done: " + event.toString() + ". " + (event.getActualEndOffset() - event.getStartOffset()) + " characters processed");
        }
        int endOffsetUpperEstimate = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, event.getMandatoryEndOffset());
        int line = this.myEditor.getDocument().getLineNumber(endOffsetUpperEstimate);
        if (line < this.myEditor.getDocument().getLineCount() - 1) {
            endOffsetUpperEstimate = this.myEditor.getDocument().getLineStartOffset(line + 1);
        }
        if (event.getActualEndOffset() > endOffsetUpperEstimate) {
            LOG.error("Unexpected error at soft wrap recalculation", new Attachment[]{new Attachment("softWrapModel.txt", this.myEditor.getSoftWrapModel().toString())});
        }
    }

    private boolean processCollapsedFoldRegion(FoldRegion foldRegion) {
        int j;
        DocumentEx document = this.myEditor.getDocument();
        if (!foldRegion.isValid() || foldRegion.getStartOffset() != this.myContext.tokenStartOffset || foldRegion.getEndOffset() > document.getTextLength()) {
            LOG.error("Inconsistent fold region state: fold region: " + foldRegion + ", soft wrap model state: " + this.myEditor.getSoftWrapModel() + ", folding model state: " + this.myEditor.getFoldingModel());
            return true;
        }
        String placeholder = foldRegion.getPlaceholderText();
        int placeholderWidthInPixels = 0;
        for (int i = 0; i < placeholder.length(); ++i) {
            placeholderWidthInPixels += SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).charWidth(placeholder.charAt(i), this.myContext.fontType);
        }
        if (this.myContext.delayedSoftWrap == null) {
            int newX = this.myContext.currentPosition.x + placeholderWidthInPixels;
            this.notifyListenersOnVisualLineStart(this.myContext.lineStartPosition);
            if (!this.myContext.exceedsVisualEdge(newX) || this.myContext.currentPosition.offset == this.myContext.lineStartPosition.offset) {
                this.myContext.advance(foldRegion, placeholderWidthInPixels);
                return false;
            }
        }
        this.myContext.logicalLineData.update(foldRegion.getStartOffset());
        SoftWrapImpl softWrap = null;
        if (this.myContext.delayedSoftWrap == null && this.myContext.exceedsVisualEdge(this.myContext.currentPosition.x + this.myContext.reservedWidthInPixels)) {
            softWrap = this.registerSoftWrap(this.myContext.softWrapStartOffset, this.myContext.tokenStartOffset, this.myContext.tokenStartOffset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        }
        if (this.myContext.delayedSoftWrap != null) {
            this.myStorage.remove(this.myContext.delayedSoftWrap);
            this.myContext.delayedSoftWrap = null;
        }
        if (softWrap == null) {
            softWrap = this.registerSoftWrap(foldRegion.getStartOffset(), this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        }
        this.myContext.softWrapStartOffset = softWrap.getStart();
        if (softWrap.getStart() < this.myContext.tokenStartOffset) {
            this.revertListeners(softWrap.getStart(), this.myContext.currentPosition.visualLine);
            for (j = foldRegion.getStartOffset() - 1; j >= softWrap.getStart(); --j) {
                int pixelsDiff = this.myOffset2widthInPixels.data[j - this.myOffset2widthInPixels.anchor];
                int columnsDiff = SoftWrapApplianceManager.calculateWidthInColumns(this.myContext.text.charAt(j), pixelsDiff, this.myContext.getPlainSpaceWidth());
                --this.myContext.currentPosition.offset;
                this.myContext.currentPosition.logicalColumn -= columnsDiff;
                this.myContext.currentPosition.visualColumn -= columnsDiff;
            }
        }
        this.notifyListenersOnSoftWrapLineFeed(true);
        this.myContext.currentPosition.visualColumn = 0;
        this.myContext.currentPosition.softWrapColumnDiff = this.myContext.currentPosition.visualColumn - this.myContext.currentPosition.foldingColumnDiff - this.myContext.currentPosition.logicalColumn;
        ++this.myContext.currentPosition.softWrapLinesCurrent;
        ++this.myContext.currentPosition.visualLine;
        this.notifyListenersOnSoftWrapLineFeed(false);
        this.myContext.currentPosition.x = softWrap.getIndentInPixels();
        this.myContext.currentPosition.visualColumn = softWrap.getIndentInColumns();
        this.myContext.currentPosition.softWrapColumnDiff += softWrap.getIndentInColumns();
        this.myContext.clearLastFoldInfo();
        this.myContext.skipToLineEnd = false;
        if (this.checkIsDoneAfterSoftWrap()) {
            return true;
        }
        for (j = softWrap.getStart(); j < this.myContext.tokenStartOffset; ++j) {
            char c = this.myContext.text.charAt(j);
            int newX = this.calculateNewX(c);
            this.myContext.onNonLineFeedSymbol(c, newX);
        }
        this.myOffset2fontType.clear();
        this.myContext.advance(foldRegion, placeholderWidthInPixels);
        return false;
    }

    private boolean processNonFoldToken() {
        int limit = 3 * (this.myContext.tokenEndOffset - this.myContext.lineStartPosition.offset);
        int counter = 0;
        int startOffset = this.myContext.currentPosition.offset;
        while (this.myContext.currentPosition.offset < this.myContext.tokenEndOffset) {
            char c;
            if (counter++ > limit) {
                LogMessageEx.error(LOG, "Cycled soft wraps recalculation detected", String.format("Start recalculation offset: %d, visible area width: %d, calculation context: %s, editor info: %s", startOffset, this.myVisibleAreaWidth, this.myContext, this.myEditor.dumpState()));
                for (int i = this.myContext.currentPosition.offset; i < this.myContext.tokenEndOffset; ++i) {
                    c = this.myContext.text.charAt(i);
                    if (c == '\n') {
                        this.myContext.onNewLine();
                        if (!this.checkIsDoneAfterNewLine()) continue;
                        return true;
                    }
                    this.myContext.onNonLineFeedSymbol(c);
                }
                return false;
            }
            int offset = this.myContext.currentPosition.offset;
            if (this.myContext.delayedSoftWrap != null && this.myContext.delayedSoftWrap.getStart() == offset) {
                this.processSoftWrap(this.myContext.delayedSoftWrap);
                this.myContext.delayedSoftWrap = null;
                if (this.checkIsDoneAfterSoftWrap()) {
                    return true;
                }
            }
            if ((c = this.myContext.text.charAt(offset)) == '\n') {
                this.myContext.onNewLine();
                if (!this.checkIsDoneAfterNewLine()) continue;
                return true;
            }
            if (this.myContext.skipToLineEnd) {
                this.myContext.skipToLineEnd = false;
                if (!this.createSoftWrapIfPossible()) continue;
                return true;
            }
            int newX = this.offsetToX(offset, c);
            if (this.myContext.exceedsVisualEdge(newX) && this.myContext.delayedSoftWrap == null) {
                if (!this.createSoftWrapIfPossible()) continue;
                return true;
            }
            this.myContext.onNonLineFeedSymbol(c, newX);
        }
        return false;
    }

    private boolean checkIsDoneAfterNewLine() {
        return this.myContext.currentPosition.offset > this.myContext.rangeEndOffset;
    }

    private boolean checkIsDoneAfterSoftWrap() {
        SoftWrapImpl lastSoftWrap = this.myDataMapper.getLastSoftWrap();
        LOG.assertTrue(lastSoftWrap != null);
        if (this.myContext.currentPosition.offset > this.myContext.rangeEndOffset && this.myDataMapper.matchesOldSoftWrap(lastSoftWrap, this.myEventBeingProcessed.getLengthDiff())) {
            this.myDataMapper.removeLastCacheEntry();
            return true;
        }
        return false;
    }

    private int offsetToX(int offset, char c) {
        if (this.myOffset2widthInPixels.end > offset && this.myOffset2widthInPixels.anchor + this.myOffset2widthInPixels.end > offset && this.myContext.currentPosition.symbol != '\t') {
            return this.myContext.currentPosition.x + this.myOffset2widthInPixels.data[offset - this.myOffset2widthInPixels.anchor];
        }
        return this.calculateNewX(c);
    }

    private boolean createSoftWrapIfPossible() {
        int offset = this.myContext.currentPosition.offset;
        this.myContext.logicalLineData.update(offset);
        int softWrapStartOffset = this.myContext.softWrapStartOffset;
        int preferredOffset = Math.max(softWrapStartOffset, offset - 1);
        SoftWrapImpl softWrap = this.registerSoftWrap(softWrapStartOffset, preferredOffset, this.myContext.logicalLineData.endLineOffset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        FoldRegion revertedToFoldRegion = null;
        if (softWrap == null) {
            EditorPosition wrapPosition = null;
            if (this.myContext.lastFoldEndPosition != null && this.myStorage.getSoftWrap(this.myContext.lastFoldEndPosition.offset) == null) {
                wrapPosition = this.myContext.lastFoldEndPosition;
            }
            if (wrapPosition == null && this.myContext.lastFoldStartPosition != null && this.myStorage.getSoftWrap(this.myContext.lastFoldStartPosition.offset) == null && this.myContext.lastFoldStartPosition.offset < this.myContext.currentPosition.offset) {
                wrapPosition = this.myContext.lastFoldStartPosition;
            }
            if (wrapPosition != null) {
                this.revertListeners(wrapPosition.offset, wrapPosition.visualLine);
                this.myContext.currentPosition = wrapPosition;
                softWrap = this.registerSoftWrap(wrapPosition.offset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
                this.myContext.tokenStartOffset = wrapPosition.offset;
                revertedToFoldRegion = this.myContext.lastFold;
            } else {
                return this.myContext.tryToShiftToNextLine();
            }
        }
        this.myContext.skipToLineEnd = false;
        this.notifyListenersOnVisualLineStart(this.myContext.lineStartPosition);
        int actualSoftWrapOffset = softWrap.getStart();
        if (actualSoftWrapOffset > this.myContext.tokenEndOffset) {
            this.myContext.delayedSoftWrap = softWrap;
            this.myContext.onNonLineFeedSymbol(this.myContext.text.charAt(offset));
            return false;
        }
        if (actualSoftWrapOffset < offset) {
            if (revertedToFoldRegion == null) {
                this.revertListeners(actualSoftWrapOffset, this.myContext.currentPosition.visualLine);
                for (int j = offset - 1; j >= actualSoftWrapOffset; --j) {
                    int pixelsDiff = this.myOffset2widthInPixels.data[j - this.myOffset2widthInPixels.anchor];
                    int columnsDiff = SoftWrapApplianceManager.calculateWidthInColumns(this.myContext.text.charAt(j), pixelsDiff, this.myContext.getPlainSpaceWidth());
                    --this.myContext.currentPosition.offset;
                    this.myContext.currentPosition.logicalColumn -= columnsDiff;
                    this.myContext.currentPosition.visualColumn -= columnsDiff;
                    this.myContext.currentPosition.x -= pixelsDiff;
                }
            }
        } else if (actualSoftWrapOffset > offset) {
            this.myContext.onNonLineFeedSymbol(this.myContext.text.charAt(offset));
            for (int j = offset + 1; j < actualSoftWrapOffset; ++j) {
                this.myContext.onNonLineFeedSymbol(this.myContext.text.charAt(offset));
            }
        }
        this.processSoftWrap(softWrap);
        this.myContext.currentPosition.offset = actualSoftWrapOffset;
        this.myOffset2fontType.clear();
        this.myOffset2widthInPixels.clear();
        if (this.checkIsDoneAfterSoftWrap()) {
            return true;
        }
        if (revertedToFoldRegion != null && this.myContext.currentPosition.offset == revertedToFoldRegion.getStartOffset()) {
            return this.processCollapsedFoldRegion(revertedToFoldRegion);
        }
        return false;
    }

    private int calculateNewX(char c) {
        if (c == '\t') {
            return EditorUtil.nextTabStop(this.myContext.currentPosition.x, this.myEditor);
        }
        return this.myContext.currentPosition.x + SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).charWidth(c, this.myContext.fontType);
    }

    private static int calculateWidthInColumns(char c, int widthInPixels, int plainSpaceWithInPixels) {
        if (c != '\t') {
            return 1;
        }
        int result2 = widthInPixels / plainSpaceWithInPixels;
        if (widthInPixels % plainSpaceWithInPixels > 0) {
            ++result2;
        }
        return result2;
    }

    @Nullable
    private SoftWrapImpl registerSoftWrap(int minOffset, int preferredOffset, int maxOffset, int spaceSize, LogicalLineData lineData) {
        int softWrapOffset = this.calculateBackwardSpaceOffsetIfPossible(minOffset, preferredOffset);
        if (softWrapOffset < 0) {
            softWrapOffset = this.calculateBackwardOffsetForEasternLanguageIfPossible(minOffset, preferredOffset);
        }
        if (softWrapOffset < 0) {
            DocumentEx document = this.myEditor.getDocument();
            if (this.myLineWrapPositionStrategy == null) {
                this.myLineWrapPositionStrategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor((Editor)this.myEditor);
            }
            softWrapOffset = this.myLineWrapPositionStrategy.calculateWrapPosition((Document)document, this.myEditor.getProject(), minOffset, maxOffset, preferredOffset, true, true);
        }
        if (softWrapOffset >= lineData.endLineOffset || softWrapOffset < 0 || this.myCustomIndentUsedLastTime && softWrapOffset == lineData.nonWhiteSpaceSymbolOffset || softWrapOffset > preferredOffset && this.myContext.lastFoldStartPosition != null && this.myContext.lastFoldStartPosition.offset <= preferredOffset) {
            return null;
        }
        return this.registerSoftWrap(softWrapOffset, spaceSize, lineData);
    }

    @NotNull
    private SoftWrapImpl registerSoftWrap(int offset, int spaceSize, LogicalLineData lineData) {
        int indentInColumns = 0;
        int indentInPixels = this.myPainter.getMinDrawingWidth(SoftWrapDrawingType.AFTER_SOFT_WRAP);
        if (this.myCustomIndentUsedLastTime) {
            indentInColumns = this.myCustomIndentValueUsedLastTime + lineData.indentInColumns;
            indentInPixels += lineData.indentInPixels + this.myCustomIndentValueUsedLastTime * spaceSize;
        }
        SoftWrapImpl result2 = new SoftWrapImpl(new TextChangeImpl("\n" + StringUtil.repeatSymbol((char)' ', (int)indentInColumns), offset, offset), indentInColumns + 1, indentInPixels);
        this.myStorage.storeOrReplace(result2);
        SoftWrapImpl softWrapImpl = result2;
        if (softWrapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "registerSoftWrap"));
        }
        return softWrapImpl;
    }

    private int calculateBackwardSpaceOffsetIfPossible(int minOffset, int preferredOffset) {
        int maxTrackBackSymbolsNumber = 10;
        int minOffsetToUse = minOffset;
        if (preferredOffset - minOffset > maxTrackBackSymbolsNumber) {
            minOffsetToUse = preferredOffset - maxTrackBackSymbolsNumber;
        }
        for (int i = preferredOffset - 1; i >= minOffsetToUse; --i) {
            char c = this.myContext.text.charAt(i);
            if (c != ' ') continue;
            return i + 1;
        }
        return -1;
    }

    public int calculateBackwardOffsetForEasternLanguageIfPossible(int minOffset, int preferredOffset) {
        int maxTrackBackSymbolsNumber = 10;
        int minOffsetToUse = minOffset;
        if (preferredOffset - minOffset > maxTrackBackSymbolsNumber) {
            minOffsetToUse = preferredOffset - maxTrackBackSymbolsNumber;
        }
        for (int i = preferredOffset - 1; i >= minOffsetToUse; --i) {
            char c = this.myContext.text.charAt(i);
            if (c < '\u2f00') continue;
            return i + 1;
        }
        return -1;
    }

    private void processSoftWrap(SoftWrap softWrap) {
        this.notifyListenersOnSoftWrapLineFeed(true);
        EditorPosition position = this.myContext.currentPosition;
        position.visualColumn = 0;
        position.softWrapColumnDiff = position.visualColumn - position.foldingColumnDiff - position.logicalColumn;
        ++position.softWrapLinesCurrent;
        ++position.visualLine;
        this.notifyListenersOnSoftWrapLineFeed(false);
        this.myContext.lineStartPosition.from(this.myContext.currentPosition);
        position.x = softWrap.getIndentInPixels();
        position.visualColumn = softWrap.getIndentInColumns();
        position.softWrapColumnDiff += softWrap.getIndentInColumns();
        this.myContext.softWrapStartOffset = softWrap.getStart() + 1;
        this.myContext.clearLastFoldInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recalculateIfNecessary() {
        int softWrapsNow;
        if (this.myInProgress) {
            return false;
        }
        boolean indentChanged = false;
        IndentType currentIndentType = this.getIndentToUse();
        boolean useCustomIndent = currentIndentType == IndentType.CUSTOM;
        int currentCustomIndent = this.myEditor.getSettings().getCustomSoftWrapIndent();
        if (useCustomIndent ^ this.myCustomIndentUsedLastTime || useCustomIndent && this.myCustomIndentValueUsedLastTime != currentCustomIndent) {
            indentChanged = true;
        }
        this.myCustomIndentUsedLastTime = useCustomIndent;
        this.myCustomIndentValueUsedLastTime = currentCustomIndent;
        int currentVisibleAreaWidth = this.myWidthProvider.getVisibleAreaWidth();
        if (!indentChanged && this.myVisibleAreaWidth == currentVisibleAreaWidth) {
            return this.recalculateSoftWraps();
        }
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        if (this.myVerticalScrollBarWidth < 0) {
            this.myVerticalScrollBarWidth = scrollBar.getWidth();
            if (this.myVerticalScrollBarWidth <= 0) {
                this.myVerticalScrollBarWidth = scrollBar.getPreferredSize().width;
            }
        }
        if (Math.abs(currentVisibleAreaWidth - this.myVisibleAreaWidth) == this.myVerticalScrollBarWidth) {
            this.myVisibleAreaWidth = currentVisibleAreaWidth;
            return this.recalculateSoftWraps();
        }
        int softWrapsBefore = -1;
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        int yScrollOffset = scrollingModel.getVerticalScrollOffset();
        int anchorOffset = this.myLastTopLeftCornerOffset;
        if (anchorOffset >= 0) {
            softWrapsBefore = this.getNumberOfSoftWrapsBefore(anchorOffset);
        }
        this.reset();
        this.myStorage.removeAll();
        this.myVisibleAreaWidth = currentVisibleAreaWidth;
        boolean result2 = this.recalculateSoftWraps();
        if (!result2) {
            return false;
        }
        if (softWrapsBefore >= 0 && (softWrapsNow = this.getNumberOfSoftWrapsBefore(anchorOffset)) != softWrapsBefore) {
            scrollingModel.disableAnimation();
            try {
                scrollingModel.scrollVertically(yScrollOffset + (softWrapsNow - softWrapsBefore) * this.myEditor.getLineHeight());
            }
            finally {
                scrollingModel.enableAnimation();
            }
        }
        this.updateLastTopLeftCornerOffset();
        return true;
    }

    private void updateLastTopLeftCornerOffset() {
        int visualLine = 1 + this.myEditor.getScrollingModel().getVisibleArea().y / this.myEditor.getLineHeight();
        this.myLastTopLeftCornerOffset = this.myEditor.myUseNewRendering ? this.myEditor.visualLineStartOffset(visualLine) : this.myDataMapper.getVisualLineStartOffset(visualLine);
    }

    private int getNumberOfSoftWrapsBefore(int offset) {
        int i = this.myStorage.getSoftWrapIndex(offset);
        return i >= 0 ? i : -i - 1;
    }

    private IndentType getIndentToUse() {
        return this.myEditor.getSettings().isUseCustomSoftWrapIndent() ? IndentType.CUSTOM : IndentType.NONE;
    }

    public boolean addListener(@NotNull SoftWrapAwareDocumentParsingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "addListener"));
        }
        return this.myListeners.add(listener);
    }

    public boolean removeListener(@NotNull SoftWrapAwareDocumentParsingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "removeListener"));
        }
        return this.myListeners.remove(listener);
    }

    private void revertListeners(int offset, int visualLine) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.revertToOffset(offset, visualLine);
        }
    }

    private void notifyListenersOnFoldRegion(@NotNull FoldRegion foldRegion, int collapsedFoldingWidthInColumns, int visualLine) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "notifyListenersOnFoldRegion"));
        }
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onCollapsedFoldRegion(foldRegion, collapsedFoldingWidthInColumns, visualLine);
        }
    }

    private void notifyListenersOnVisualLineStart(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "notifyListenersOnVisualLineStart"));
        }
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onVisualLineStart(position);
        }
    }

    private void notifyListenersOnVisualLineEnd() {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onVisualLineEnd(this.myContext.currentPosition);
        }
    }

    private void notifyListenersOnTabulation(int widthInColumns) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onTabulation(this.myContext.currentPosition, widthInColumns);
        }
    }

    private void notifyListenersOnSoftWrapLineFeed(boolean before) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            if (before) {
                listener.beforeSoftWrapLineFeed(this.myContext.currentPosition);
                continue;
            }
            listener.afterSoftWrapLineFeed(this.myContext.currentPosition);
        }
    }

    private void notifyListenersOnCacheUpdateStart(IncrementalCacheUpdateEvent event) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onCacheUpdateStart(event);
        }
    }

    private void notifyListenersOnCacheUpdateEnd(IncrementalCacheUpdateEvent event) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener = this.myListeners.get(i);
            listener.onRecalculationEnd(event);
        }
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangedEvent = new IncrementalCacheUpdateEvent(event, this.myDataMapper, this.myEditor);
    }

    public void documentChanged(DocumentEvent event) {
        LOG.assertTrue(this.myDocumentChangedEvent != null);
        this.myDocumentChangedEvent.updateAfterDocumentChange(event.getDocument());
        this.recalculate(this.myDocumentChangedEvent);
        this.myDocumentChangedEvent = null;
    }

    public void setWidthProvider(@NotNull VisibleAreaWidthProvider widthProvider) {
        if (widthProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widthProvider", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "setWidthProvider"));
        }
        this.myWidthProvider = widthProvider;
        this.reset();
    }

    @NotNull
    public String dumpState() {
        String string = String.format("recalculation in progress: %b; event being processed: %s", this.myInProgress, this.myEventBeingProcessed);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
    }

    private static class PrimitiveIntMap {
        private int[] myData = new int[16];
        private int myShift;

        private PrimitiveIntMap() {
        }

        public int get(int key) {
            int index = key + this.myShift;
            if (index < 0 || index >= this.myData.length) {
                return -1;
            }
            return this.myData[index];
        }

        public void put(int key, int value) {
            int index = key + this.myShift;
            if (index < 0) {
                int[] tmp = new int[this.myData.length - index];
                System.arraycopy(this.myData, 0, tmp, -index, this.myData.length);
                this.myData = tmp;
                this.myShift -= index;
                index = 0;
            }
            this.myData[index] = value;
        }

        public void reset() {
            this.myShift = 0;
            Arrays.fill(this.myData, 0);
        }
    }

    private class ProcessingContext {
        public final PrimitiveIntMap fontType2spaceWidth = new PrimitiveIntMap();
        public final LogicalLineData logicalLineData = new LogicalLineData();
        public CharSequence text;
        public EditorPosition lineStartPosition;
        public EditorPosition currentPosition;
        public EditorPosition lastFoldStartPosition;
        public EditorPosition lastFoldEndPosition;
        public FoldRegion lastFold;
        public SoftWrapImpl delayedSoftWrap;
        public int reservedWidthInPixels;
        public int softWrapStartOffset;
        public int rangeEndOffset;
        public int tokenStartOffset;
        public int tokenEndOffset;
        @JdkConstants.FontStyle
        public int fontType;
        public boolean skipToLineEnd;

        private ProcessingContext() {
        }

        public String toString() {
            return "reserved width: " + this.reservedWidthInPixels + ", soft wrap start offset: " + this.softWrapStartOffset + ", range end offset: " + this.rangeEndOffset + ", token offsets: [" + this.tokenStartOffset + "; " + this.tokenEndOffset + "], font type: " + this.fontType + ", skip to line end: " + this.skipToLineEnd + ", delayed soft wrap: " + this.delayedSoftWrap + ", current position: " + this.currentPosition + "line start position: " + this.lineStartPosition;
        }

        public void reset() {
            this.text = null;
            this.lineStartPosition = null;
            this.currentPosition = null;
            this.clearLastFoldInfo();
            this.delayedSoftWrap = null;
            this.reservedWidthInPixels = 0;
            this.softWrapStartOffset = 0;
            this.rangeEndOffset = 0;
            this.tokenStartOffset = 0;
            this.tokenEndOffset = 0;
            this.fontType = 0;
            this.skipToLineEnd = false;
            this.fontType2spaceWidth.reset();
            this.logicalLineData.reset();
        }

        public int getSpaceWidth() {
            return this.getSpaceWidth(this.fontType);
        }

        public int getPlainSpaceWidth() {
            return this.getSpaceWidth(0);
        }

        private int getSpaceWidth(@JdkConstants.FontStyle int fontType) {
            int result2 = this.fontType2spaceWidth.get(fontType);
            if (result2 <= 0) {
                result2 = EditorUtil.getSpaceWidth(fontType, SoftWrapApplianceManager.this.myEditor);
                this.fontType2spaceWidth.put(fontType, result2);
            }
            assert (result2 > 0);
            return result2;
        }

        public void onNewLine() {
            SoftWrapApplianceManager.this.notifyListenersOnVisualLineEnd();
            this.currentPosition.onNewLine();
            this.softWrapStartOffset = this.currentPosition.offset;
            this.clearLastFoldInfo();
            this.lineStartPosition.from(this.currentPosition);
            this.logicalLineData.update(this.currentPosition.logicalLine, this.getSpaceWidth(), this.getPlainSpaceWidth());
            this.fontType = SoftWrapApplianceManager.this.myOffset2fontType.get(this.currentPosition.offset);
            SoftWrapApplianceManager.this.myOffset2fontType.clear();
            SoftWrapApplianceManager.this.myOffset2widthInPixels.clear();
            this.skipToLineEnd = false;
        }

        private void clearLastFoldInfo() {
            this.lastFoldStartPosition = null;
            this.lastFoldEndPosition = null;
            this.lastFold = null;
        }

        public void onNonLineFeedSymbol(char c) {
            int newX = ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end > ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset && ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor + ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end > ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset && ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.symbol != '\t' ? ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.x + ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data[((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor] : SoftWrapApplianceManager.this.calculateNewX(c);
            this.onNonLineFeedSymbol(c, newX);
        }

        public void onNonLineFeedSymbol(char c, int newX) {
            int widthInPixels = newX - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.x;
            if (((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor <= 0) {
                ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor = this.currentPosition.offset;
            }
            if (this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor >= ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length) {
                int newLength = Math.max(((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length * 2, this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor + 1);
                int[] newData = new int[newLength];
                System.arraycopy(((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data, 0, newData, 0, ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length);
                ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data = newData;
            }
            ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data[this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor] = widthInPixels;
            ++((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end;
            int widthInColumns = SoftWrapApplianceManager.calculateWidthInColumns(c, widthInPixels, SoftWrapApplianceManager.this.myContext.getPlainSpaceWidth());
            if (c == '\t') {
                SoftWrapApplianceManager.this.notifyListenersOnVisualLineStart(((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.lineStartPosition);
                SoftWrapApplianceManager.this.notifyListenersOnTabulation(widthInColumns);
            }
            this.currentPosition.logicalColumn += widthInColumns;
            this.currentPosition.visualColumn += widthInColumns;
            this.currentPosition.x = newX;
            ++this.currentPosition.offset;
            this.fontType = SoftWrapApplianceManager.this.myOffset2fontType.get(this.currentPosition.offset);
        }

        private void advance(FoldRegion foldRegion, int placeHolderWidthInPixels) {
            this.lastFoldStartPosition = this.currentPosition.clone();
            this.lastFold = foldRegion;
            int visualLineBefore = this.currentPosition.visualLine;
            int logicalLineBefore = this.currentPosition.logicalLine;
            int logicalColumnBefore = this.currentPosition.logicalColumn;
            this.currentPosition.advance(foldRegion, -1);
            this.currentPosition.x += placeHolderWidthInPixels;
            int collapsedFoldingWidthInColumns = this.currentPosition.logicalColumn;
            if (this.currentPosition.logicalLine <= logicalLineBefore) {
                collapsedFoldingWidthInColumns = this.currentPosition.logicalColumn - logicalColumnBefore;
            } else {
                DocumentEx document = SoftWrapApplianceManager.this.myEditor.getDocument();
                int endFoldLine = document.getLineNumber(foldRegion.getEndOffset());
                this.logicalLineData.endLineOffset = document.getLineEndOffset(endFoldLine);
            }
            SoftWrapApplianceManager.this.notifyListenersOnFoldRegion(foldRegion, collapsedFoldingWidthInColumns, visualLineBefore);
            this.tokenStartOffset = ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset;
            this.softWrapStartOffset = foldRegion.getEndOffset();
            this.lastFoldEndPosition = this.currentPosition.clone();
        }

        public boolean tryToShiftToNextLine() {
            for (int i = this.currentPosition.offset; i < this.tokenEndOffset; ++i) {
                char c = this.text.charAt(i);
                this.currentPosition.offset = i;
                if (c == '\n') {
                    this.onNewLine();
                    return SoftWrapApplianceManager.this.checkIsDoneAfterNewLine();
                }
                this.onNonLineFeedSymbol(c, SoftWrapApplianceManager.this.offsetToX(i, c));
            }
            this.skipToLineEnd = true;
            return false;
        }

        public boolean exceedsVisualEdge(int x) {
            return x >= SoftWrapApplianceManager.this.myVisibleAreaWidth;
        }
    }

    private static class FontTypesStorage {
        private int[] myStarts = new int[256];
        private int[] myEnds = new int[256];
        private int[] myData = new int[256];
        private int myLastIndex = -1;

        private FontTypesStorage() {
        }

        public void fill(int start, int end, int value) {
            if (this.myLastIndex >= 0 && this.myData[this.myLastIndex] == value && this.myEnds[this.myLastIndex] == start) {
                this.myEnds[this.myLastIndex] = end;
                return;
            }
            if (++this.myLastIndex >= this.myData.length) {
                this.expand();
            }
            this.myStarts[this.myLastIndex] = start;
            this.myEnds[this.myLastIndex] = end;
            this.myData[this.myLastIndex] = value;
        }

        public int get(int offset) {
            if (this.myLastIndex < 0) {
                return -1;
            }
            for (int i = this.myLastIndex; i >= 0 && this.myEnds[i] >= offset; --i) {
                if (this.myStarts[i] > offset) continue;
                return this.myData[i];
            }
            return -1;
        }

        public void clear() {
            this.myLastIndex = -1;
        }

        private void expand() {
            int[] tmp = new int[this.myStarts.length * 2];
            System.arraycopy(this.myStarts, 0, tmp, 0, this.myStarts.length);
            this.myStarts = tmp;
            tmp = new int[this.myEnds.length * 2];
            System.arraycopy(this.myEnds, 0, tmp, 0, this.myEnds.length);
            this.myEnds = tmp;
            tmp = new int[this.myData.length * 2];
            System.arraycopy(this.myData, 0, tmp, 0, this.myData.length);
            this.myData = tmp;
        }
    }

    private static class WidthsStorage {
        public int[] data = new int[256];
        public int anchor;
        public int end;

        private WidthsStorage() {
        }

        public void clear() {
            this.anchor = 0;
            this.end = 0;
        }
    }

    private static class DefaultVisibleAreaWidthProvider
    implements VisibleAreaWidthProvider {
        private final Editor myEditor;

        DefaultVisibleAreaWidthProvider(Editor editor) {
            this.myEditor = editor;
        }

        @Override
        public int getVisibleAreaWidth() {
            return this.myEditor.getScrollingModel().getVisibleArea().width;
        }
    }

    public static interface VisibleAreaWidthProvider {
        public int getVisibleAreaWidth();
    }

    private class LogicalLineData {
        public int indentInColumns;
        public int indentInPixels;
        public int endLineOffset;
        public int nonWhiteSpaceSymbolOffset;

        private LogicalLineData() {
        }

        public void update(int logicalLine, int spaceWidth, int plainSpaceWidth) {
            int startLineOffset;
            DocumentEx document = SoftWrapApplianceManager.this.myEditor.getDocument();
            if (logicalLine >= document.getLineCount()) {
                startLineOffset = this.endLineOffset = document.getTextLength();
            } else {
                startLineOffset = document.getLineStartOffset(logicalLine);
                this.endLineOffset = document.getLineEndOffset(logicalLine);
            }
            CharSequence text = document.getCharsSequence();
            this.indentInColumns = 0;
            this.indentInPixels = 0;
            this.nonWhiteSpaceSymbolOffset = -1;
            block4: for (int i = startLineOffset; i < this.endLineOffset; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.indentInColumns;
                        this.indentInPixels += spaceWidth;
                        continue block4;
                    }
                    case '\t': {
                        int x = EditorUtil.nextTabStop(this.indentInPixels, SoftWrapApplianceManager.this.myEditor);
                        this.indentInColumns += SoftWrapApplianceManager.calculateWidthInColumns(c, x - this.indentInPixels, plainSpaceWidth);
                        this.indentInPixels = x;
                        continue block4;
                    }
                    default: {
                        this.nonWhiteSpaceSymbolOffset = i;
                        return;
                    }
                }
            }
        }

        public void update(int softWrapOffset) {
            if (this.nonWhiteSpaceSymbolOffset >= 0 && softWrapOffset > this.nonWhiteSpaceSymbolOffset) {
                return;
            }
            this.indentInColumns = 0;
            this.indentInPixels = 0;
        }

        public void reset() {
            this.indentInColumns = 0;
            this.indentInPixels = 0;
            this.endLineOffset = 0;
        }
    }

    static enum IndentType {
        NONE,
        CUSTOM;

    }
}

