/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesOrderEnumerator
extends OrderEnumeratorBase {
    private final Collection<? extends Module> myModules;

    public ModulesOrderEnumerator(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "<init>"));
        }
        super(null);
        this.myModules = modules;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "processRootModules"));
        }
        for (Module module2 : this.myModules) {
            processor2.process((Object)module2);
        }
    }

    @Override
    protected void forEach(@NotNull PairProcessor<OrderEntry, List<OrderEnumerationHandler>> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "forEach"));
        }
        this.myRecursivelyExportedOnly = false;
        THashSet processed = new THashSet();
        for (Module module2 : this.myModules) {
            this.processEntries(this.getRootModel(module2), processor2, (Set<Module>)processed, true, ModulesOrderEnumerator.getCustomHandlers(module2));
        }
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/ModulesOrderEnumerator", "isRootModuleModel"));
        }
        return this.myModules.contains(rootModel.getModule());
    }
}

