/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactStructureConfigurableState;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.InvalidArtifactConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactAdapter;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.InvalidArtifact;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsStructureConfigurable
extends BaseStructureConfigurable {
    private ArtifactsStructureConfigurableContextImpl myPackagingEditorContext;
    private final ArtifactEditorSettings myDefaultSettings;

    public ArtifactsStructureConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "<init>"));
        }
        super(project2, new ArtifactStructureConfigurableState());
        this.myDefaultSettings = new ArtifactEditorSettings();
    }

    protected String getComponentStateKey() {
        return "ArtifactsStructureConfigurable.UI";
    }

    public void init(StructureConfigurableContext context, ModuleStructureConfigurable moduleStructureConfigurable, ProjectLibrariesConfigurable projectLibrariesConfig, GlobalLibrariesConfigurable globalLibrariesConfig) {
        super.init(context);
        this.myPackagingEditorContext = new ArtifactsStructureConfigurableContextImpl(this.myContext, this.myProject, this.myDefaultSettings, new ArtifactAdapter(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$1", "artifactAdded"));
                }
                MasterDetailsComponent.MyNode node = ArtifactsStructureConfigurable.this.addArtifactNode(artifact);
                ArtifactsStructureConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
        });
        context.getModulesConfigurator().addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                for (ProjectStructureElement projectStructureElement : ArtifactsStructureConfigurable.this.getProjectStructureElements()) {
                    ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
                }
            }
        });
        MasterDetailsComponent.ItemsChangeListener listener = new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library || deletedItem instanceof Module) {
                    ArtifactsStructureConfigurable.this.onElementDeleted();
                }
            }

            public void itemsExternallyChanged() {
            }
        };
        moduleStructureConfigurable.addItemsChangeListener(listener);
        projectLibrariesConfig.addItemsChangeListener(listener);
        globalLibrariesConfig.addItemsChangeListener(listener);
        context.addLibraryEditorListener(new LibraryEditorListener(){

            @Override
            public void libraryRenamed(@NotNull Library library, String oldName, String newName) {
                Artifact[] artifacts;
                if (library == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$4", "libraryRenamed"));
                }
                for (Artifact artifact : artifacts = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getArtifactModel().getArtifacts()) {
                    ArtifactsStructureConfigurable.this.updateLibraryElements(artifact, library, oldName, newName);
                }
            }
        });
    }

    private void updateLibraryElements(final Artifact artifact, final Library library, final String oldName, final String newName) {
        if (ArtifactUtil.processPackagingElements(this.myPackagingEditorContext.getRootElement(artifact), LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

            @Override
            public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$5", "process"));
                }
                return !ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName);
            }
        }, this.myPackagingEditorContext, false, artifact.getArtifactType())) {
            return;
        }
        this.myPackagingEditorContext.editLayout(artifact, new Runnable(){

            @Override
            public void run() {
                ModifiableArtifact modifiableArtifact = ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(artifact);
                ArtifactUtil.processPackagingElements((Artifact)modifiableArtifact, LibraryElementType.LIBRARY_ELEMENT_TYPE, new PackagingElementProcessor<LibraryPackagingElement>(){

                    @Override
                    public boolean process(@NotNull LibraryPackagingElement element, @NotNull PackagingElementPath path) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6$1", "process"));
                        }
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$6$1", "process"));
                        }
                        if (ArtifactsStructureConfigurable.isResolvedToLibrary(element, library, oldName)) {
                            element.setLibraryName(newName);
                        }
                        return true;
                    }
                }, (PackagingElementResolvingContext)ArtifactsStructureConfigurable.this.myPackagingEditorContext, false);
            }
        });
        ArtifactEditorImpl artifactEditor = this.myPackagingEditorContext.getArtifactEditor(artifact);
        if (artifactEditor != null) {
            artifactEditor.rebuildTries();
        }
    }

    private static boolean isResolvedToLibrary(LibraryPackagingElement element, Library library, String name) {
        if (!element.getLibraryName().equals(name)) {
            return false;
        }
        LibraryTable table = library.getTable();
        if (table != null) {
            return table.getTableLevel().equals(element.getLevel());
        }
        return element.getLevel().equals("module");
    }

    private void onElementDeleted() {
        for (ArtifactEditorImpl artifactEditorImpl : this.myPackagingEditorContext.getArtifactEditors()) {
            artifactEditorImpl.getSourceItemsTree().rebuildTree();
            artifactEditorImpl.queueValidation();
        }
    }

    protected MasterDetailsState getState() {
        ((ArtifactStructureConfigurableState)this.myState).setDefaultArtifactSettings(this.myDefaultSettings.getState());
        return super.getState();
    }

    public void loadState(MasterDetailsState object) {
        super.loadState(object);
        this.myDefaultSettings.loadState(((ArtifactStructureConfigurableState)this.myState).getDefaultArtifactSettings());
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"display.name.artifacts", (Object[])new Object[0]);
    }

    @Override
    protected void loadTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            this.addArtifactNode(artifact);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ArtifactProjectStructureElement> elements = new ArrayList<ArtifactProjectStructureElement>();
        for (Artifact artifact : this.myPackagingEditorContext.getArtifactModel().getAllArtifactsIncludingInvalid()) {
            elements.add(this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
        }
        ArrayList<ArtifactProjectStructureElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "getProjectStructureElements"));
        }
        return arrayList;
    }

    private MasterDetailsComponent.MyNode addArtifactNode(Artifact artifact) {
        ArtifactConfigurableBase configurable = artifact instanceof InvalidArtifact ? new InvalidArtifactConfigurable((InvalidArtifact)artifact, this.myPackagingEditorContext, this.TREE_UPDATER) : new ArtifactConfigurable(artifact, this.myPackagingEditorContext, this.TREE_UPDATER);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
        this.addNode(node, this.myRoot);
        return node;
    }

    @Override
    public void reset() {
        this.loadComponentState();
        this.myPackagingEditorContext.resetModifiableModel();
        super.reset();
    }

    public boolean isModified() {
        ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null && modifiableModel.isModified()) {
            return true;
        }
        return this.myPackagingEditorContext.getManifestFilesInfo().isManifestFilesModified() || super.isModified();
    }

    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        return this.myPackagingEditorContext;
    }

    public ModifiableArtifactModel getModifiableArtifactModel() {
        return this.myPackagingEditorContext.getOrCreateModifiableArtifactModel();
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArtifactType[] types = ArtifactType.getAllTypes();
                AnAction[] actions = new AnAction[types.length];
                for (int i = 0; i < types.length; ++i) {
                    actions[i] = ArtifactsStructureConfigurable.this.createAddArtifactAction(types[i]);
                }
                if (actions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$7", "getChildren"));
                }
                return actions;
            }
        };
    }

    private AnAction createAddArtifactAction(final @NotNull ArtifactType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "createAddArtifactAction"));
        }
        List templates = type.getNewArtifactTemplates((PackagingElementResolvingContext)this.myPackagingEditorContext);
        ArtifactTemplate emptyTemplate = new ArtifactTemplate(){

            public String getPresentableName() {
                return "Empty";
            }

            public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
                String name = "unnamed";
                return new ArtifactTemplate.NewArtifactConfiguration(type.createRootElement("unnamed"), "unnamed", type);
            }
        };
        if (templates.isEmpty()) {
            return new AddArtifactAction(type, emptyTemplate, type.getPresentableName(), type.getIcon());
        }
        DefaultActionGroup group = new DefaultActionGroup(type.getPresentableName(), true);
        group.getTemplatePresentation().setIcon(type.getIcon());
        group.add((AnAction)new AddArtifactAction(type, emptyTemplate, emptyTemplate.getPresentableName(), null));
        group.addSeparator();
        for (ArtifactTemplate template : templates) {
            group.add((AnAction)new AddArtifactAction(type, template, template.getPresentableName(), null));
        }
        return group;
    }

    private void addArtifact(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "addArtifact"));
        }
        if (artifactTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactTemplate", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "addArtifact"));
        }
        Artifact artifact = ArtifactUtil.addArtifact(this.myPackagingEditorContext.getOrCreateModifiableArtifactModel(), type, artifactTemplate);
        this.selectNodeInTree((DefaultMutableTreeNode)ArtifactsStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)artifact));
    }

    public void apply() throws ConfigurationException {
        this.myPackagingEditorContext.saveEditorSettings();
        this.checkForEmptyAndDuplicatedNames("Artifact", CommonBundle.getErrorTitle(), ArtifactConfigurableBase.class);
        super.apply();
        this.myPackagingEditorContext.getManifestFilesInfo().saveManifestFiles();
        final ModifiableArtifactModel modifiableModel = this.myPackagingEditorContext.getActualModifiableModel();
        if (modifiableModel != null) {
            new WriteAction(){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$9", "run"));
                    }
                    modifiableModel.commit();
                }
            }.execute();
            this.myPackagingEditorContext.resetModifiableModel();
        }
        this.reset();
    }

    @Override
    public void disposeUIResources() {
        this.myPackagingEditorContext.saveEditorSettings();
        super.disposeUIResources();
        this.myPackagingEditorContext.disposeUIResources();
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        ArtifactEditorImpl editor;
        boolean selectionChanged;
        boolean bl = selectionChanged = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (selectionChanged && this.myCurrentConfigurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)this.myCurrentConfigurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().saveElementProperties();
        }
        super.updateSelection(configurable);
        if (selectionChanged && configurable instanceof ArtifactConfigurable && (editor = this.myPackagingEditorContext.getArtifactEditor(((ArtifactConfigurable)configurable).getArtifact())) != null) {
            editor.getLayoutTreeComponent().resetElementProperties();
        }
    }

    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        return topic != null ? topic : "reference.settingsdialog.project.structure.artifacts";
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new ArtifactRemoveHandler());
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @NotNull
    public String getId() {
        if ("project.artifacts" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable", "getId"));
        }
        return "project.artifacts";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void dispose() {
    }

    private class AddArtifactAction
    extends DumbAwareAction {
        private final ArtifactType myType;
        private final ArtifactTemplate myArtifactTemplate;

        public AddArtifactAction(@NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate, String actionText, Icon icon) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction", "<init>"));
            }
            if (artifactTemplate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactTemplate", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction", "<init>"));
            }
            if (actionText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionText", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$AddArtifactAction", "<init>"));
            }
            super(actionText, null, icon);
            this.myType = type;
            this.myArtifactTemplate = artifactTemplate;
        }

        public void actionPerformed(AnActionEvent e) {
            ArtifactsStructureConfigurable.this.addArtifact(this.myType, this.myArtifactTemplate);
        }
    }

    private class ArtifactRemoveHandler
    extends RemoveConfigurableHandler<Artifact> {
        public ArtifactRemoveHandler() {
            super(ArtifactConfigurableBase.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Artifact> artifacts) {
            if (artifacts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactsStructureConfigurable$ArtifactRemoveHandler", "remove"));
            }
            for (Artifact artifact : artifacts) {
                ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateModifiableArtifactModel().removeArtifact(artifact);
                ArtifactsStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(ArtifactsStructureConfigurable.this.myPackagingEditorContext.getOrCreateArtifactElement(artifact));
            }
            return true;
        }
    }
}

