/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureChooseLibrariesDialog
extends ChooseLibrariesFromTablesDialog {
    private final ClasspathPanel myClasspathPanel;
    private final StructureConfigurableContext myContext;
    private final Predicate<Library> myAcceptedLibraries;
    private final List<Library> myCreatedModuleLibraries = new ArrayList<Library>();
    private JButton myCreateLibraryButton;

    public ProjectStructureChooseLibrariesDialog(ClasspathPanel classpathPanel, StructureConfigurableContext context, Predicate<Library> acceptedLibraries) {
        super(classpathPanel.getComponent(), "Choose Libraries", classpathPanel.getProject(), true);
        this.myClasspathPanel = classpathPanel;
        this.myContext = context;
        this.myAcceptedLibraries = acceptedLibraries;
        this.setOKButtonText("Add Selected");
        this.init();
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        this.removeCreatedModuleLibraries(this.getSelectedLibraries());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeCreatedModuleLibraries(Collections.<Library>emptyList());
    }

    private void removeCreatedModuleLibraries(Collection<Library> selected) {
        for (Library library : this.myCreatedModuleLibraries) {
            if (selected.contains(library)) continue;
            this.myClasspathPanel.getRootModel().getModuleLibraryTable().removeLibrary(library);
        }
    }

    @Override
    protected void collectChildren(Object element, List<Object> result2) {
        if (element instanceof Application && !this.myCreatedModuleLibraries.isEmpty()) {
            result2.add(this.myClasspathPanel.getRootModel().getModuleLibraryTable());
        }
        super.collectChildren(element, result2);
    }

    @Override
    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraries"));
        }
        if (table.getTableLevel().equals("module")) {
            Library[] libraryArray = this.myCreatedModuleLibraries.toArray(new Library[this.myCreatedModuleLibraries.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraries"));
            }
            return libraryArray;
        }
        LibrariesModifiableModel model = this.getLibrariesModifiableModel(table);
        if (model == null) {
            if (Library.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraries"));
            }
            return Library.EMPTY_ARRAY;
        }
        Library[] libraryArray = model.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraries"));
        }
        return libraryArray;
    }

    @Nullable
    private LibrariesModifiableModel getLibrariesModifiableModel(LibraryTable table) {
        return table != null ? this.myContext.myLevel2Providers.get(table.getTableLevel()) : null;
    }

    @Override
    protected boolean acceptsElement(Object element) {
        if (element instanceof Library) {
            Library library = (Library)element;
            return this.myAcceptedLibraries.apply((Object)library);
        }
        return true;
    }

    @NotNull
    private String getLibraryName(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraryName"));
        }
        LibrariesModifiableModel model = this.getLibrariesModifiableModel(library.getTable());
        if (model != null && model.hasLibraryEditor(library)) {
            String string = model.getLibraryEditor(library).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraryName"));
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "getLibraryName"));
        }
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getCancelAction(), new CreateNewLibraryAction(), this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), new CreateNewLibraryAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog", "createActions"));
        }
        return actionArray;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action instanceof CreateNewLibraryAction) {
            this.myCreateLibraryButton = button;
        }
        return button;
    }

    @Override
    protected ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> createLibraryDescriptor(NodeDescriptor parentDescriptor, Library library) {
        String libraryName = this.getLibraryName(library);
        return new LibraryEditorDescriptor(this.getProject(), parentDescriptor, library, libraryName, this.myContext);
    }

    private class CreateNewLibraryAction
    extends DialogWrapper.DialogWrapperAction {
        private CreateNewLibraryAction() {
            super((DialogWrapper)ProjectStructureChooseLibrariesDialog.this, "New Library...");
            this.putValue("MnemonicKey", 78);
        }

        protected void doAction(ActionEvent e) {
            AddNewLibraryDependencyAction.chooseTypeAndCreate(ProjectStructureChooseLibrariesDialog.this.myClasspathPanel, ProjectStructureChooseLibrariesDialog.this.myContext, ProjectStructureChooseLibrariesDialog.this.myCreateLibraryButton, new AddNewLibraryDependencyAction.LibraryCreatedCallback(){

                @Override
                public void libraryCreated(@NotNull Library library) {
                    if (library == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog$CreateNewLibraryAction$1", "libraryCreated"));
                    }
                    if (library.getTable() == null) {
                        ProjectStructureChooseLibrariesDialog.this.myCreatedModuleLibraries.add(library);
                    }
                    ProjectStructureChooseLibrariesDialog.this.queueUpdateAndSelect(library);
                }
            });
        }
    }

    private static class LibraryEditorDescriptor
    extends ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> {
        protected LibraryEditorDescriptor(Project project2, NodeDescriptor parentDescriptor, Library element, String libraryName, StructureConfigurableContext context) {
            super(project2, parentDescriptor, element);
            PresentationData templatePresentation = this.getTemplatePresentation();
            Icon icon = LibraryPresentationManager.getInstance().getNamedLibraryIcon(element, context);
            templatePresentation.setIcon(icon);
            templatePresentation.addText(libraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

