/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0011\u001f)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\t\u0015\tA1A\u0003\u0002\u0011\u001d)\u0011\u0001\"\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0003\r\u0001e!\u0011BA\u0005\u00021\u0001A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BAS\t\t-#\u0001\u0002E\u0007\u00021\u001fI2\u0001#\t\u000e\u0003a\u0001Q\u0005\u0003\u0005\u0012\u001b\ta\t\u0001'\u0007\u001a\u0007!\rR\"\u0001\r\u0004K\u0011A!#\u0004\u0002\r\u0002aeQ\u0005\u0002\u0003\f\u0011Ki\u0011\u0001g\u0005*\u0015\u0011\u0019\u0005\u0002#\u0002\u000e\u0003a\u0019\u0011k\u0001\u0003\u0006\u00015\u0011Aq\u0001\u0005\u0005S5!1\t\u0003E\u0005\u001b\u0011I!!C\u0001\u0019\fa)\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0002E\u0007S)!1\t\u0003\u0005\b\u001b\u0005Az\u0001H\u0012R\u0007\ri!\u0001\u0002\u0005\t\u0012%RAa\u0011\u0005\t\u00135\t\u00014C)\u0004\t\u0015\u0001QB\u0001\u0003\u000b\u0011+I#\u0002B\"\t\u0011-i\u0011\u0001G\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0018!!\u0011F\u0003\u0003B\u0011!aQ\u0002B\u0005\u0003\u0013\u0005AJ\u0002G\u0003R\u0007\u0005)\u0001!K\u0006\u0005\u0007\"AQ\"\u0004\u0002\r\u0002am\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0004E\u000fS)!1\t\u0003\u0005\u0010\u001b\u0005A\u001a\"U\u0002\u0005\u000b\u0001i!\u0001b\b\t\u0016\u0001"}, strings={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "buttons", "", "Lcom/intellij/openapi/updateSettings/impl/ButtonInfo;", "getButtons", "()Ljava/util/List;", "majorVersion", "", "getMajorVersion", "()I", "message", "", "getMessage", "()Ljava/lang/String;", "number", "getNumber", "patches", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "version", "getVersion", "compareTo", "other", "findPatchForBuild", "currentBuild", "findPatchForCurrentBuild", "toString"}, moduleName="platform-impl")
public final class BuildInfo
implements Comparable<BuildInfo> {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final Date releaseDate;
    @NotNull
    private final List<ButtonInfo> buttons;
    private final List<PatchInfo> patches;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @NotNull
    public final List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    public final int getMajorVersion() {
        int dotIndex = StringsKt.indexOf$default((CharSequence)this.version, (char)'.', (int)0, (boolean)false, (int)6);
        if (dotIndex > 0) {
            try {
                return StringsKt.toInt((String)StringsKt.substring((String)this.version, (int)0, (int)dotIndex));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    public final PatchInfo findPatchForCurrentBuild() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        return this.findPatchForBuild(buildNumber);
    }

    @Nullable
    public final PatchInfo findPatchForBuild(@NotNull BuildNumber currentBuild) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
            Iterable $receiver$iv = this.patches;
            Iterable $receiver$iv$iv = $receiver$iv;
            for (Object element$iv$iv : $receiver$iv$iv) {
                PatchInfo it = (PatchInfo)element$iv$iv;
                if (!(it.isAvailable() && Intrinsics.areEqual((Object)it.getFromBuild().asStringWithoutProductCode(), (Object)currentBuild.asStringWithoutProductCode()))) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public int compareTo(@NotNull BuildInfo other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.number.compareTo(other.number);
    }

    @NotNull
    public String toString() {
        return "BuildInfo(number=" + this.number + ")";
    }

    public BuildInfo(@NotNull Element node) {
        Object object;
        Element it;
        Collection destination$iv$iv;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Date date;
        Object $i$a$1;
        Object object2;
        String string;
        Object object3;
        Object it2;
        Object $receiver$iv;
        BuildInfo buildInfo;
        block14: {
            Object object4;
            BuildInfo buildInfo2;
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                String string2 = node.getAttributeValue("number");
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                BuildNumber buildNumber = BuildNumber.fromString((String)string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"BuildNumber.fromString(n\u2026tributeValue(\"number\")!!)");
                this.number = buildNumber;
                buildInfo2 = this;
                object4 = node.getAttributeValue("apiVersion");
                if (object4 == null) break block13;
                String string3 = object4;
                buildInfo = buildInfo2;
                it2 = (String)$receiver$iv;
                object3 = BuildNumber.fromString((String)it2, (String)this.number.getProductCode());
                buildInfo2 = buildInfo;
                object4 = object3;
                if (object4 != null) break block14;
            }
            object4 = buildInfo2.apiVersion = this.number;
        }
        if ((string = node.getAttributeValue("version")) == null) {
            string = this.version = "";
        }
        if ((object2 = node.getChild("message")) == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        this.message = object2;
        BuildInfo buildInfo3 = this;
        String string4 = node.getAttributeValue("releaseDate");
        if (string4 != null) {
            $receiver$iv = string4;
            buildInfo = buildInfo3;
            it2 = $receiver$iv;
            try {
                $i$a$1 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse((String)it2);
            }
            catch (ParseException e) {
                Logger.getInstance(BuildInfo.class).info("Failed to parse build release date " + (String)it2);
                $i$a$1 = null;
            }
            object3 = $i$a$1;
            buildInfo3 = buildInfo;
            date = (Date)object3;
        } else {
            date = null;
        }
        buildInfo3.releaseDate = date;
        $receiver$iv = node.getChildren("button");
        buildInfo = this;
        it2 = $receiver$iv;
        $i$a$1 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            Element $i$f$let = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            void v9 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
            object = new ButtonInfo((Element)v9);
            object3.add(object);
        }
        buildInfo.buttons = object3 = (List)destination$iv$iv;
        $receiver$iv = node.getChildren("patch");
        buildInfo = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            Element element = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
            object = new PatchInfo(element);
            object3.add(object);
        }
        buildInfo.patches = object3 = (List)destination$iv$iv;
    }
}

