/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"5\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0002\t\u0007)\u0011\u0001C\u0004\u0006\u0003\u00115Q!\u0001\u0007\u0002\u000b\u0005!1\u0001\u0004\u0001\u0011\"e\t\u0001\u0014AO\u0001\"\u00056\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u0011\t)C\u0001C\b\u000e\u00051\u0005\u0001tA\u0013\t\u0011=i!\u0001$\u0001\u0019\be\u0019\u0001rD\u0007\u00021\u0013)C\u0002B\u0001\t!5\u0011A\u0012\u0001M\u00043\u0019A)!\u0004\u0003\n\u0005%\t\u0001t\u0001\r\u0004S)!\u0011\t\u0003E\u0003\u001b\u0011I!!C\u0001\u0019\ba\u0019\u0011kA\u0001\u0006\u0001%RAa\u0011\u0005\t\t5\t\u0001\u0014B)\u0004\t\u0015\u0001QB\u0001\u0003\u0006\u0011\u0017I3\u0002B\"\t\u0011\u0019i!\u0001$\u0001\u0019\u000eE\u001bA!\u0002\u0001\u000e\u0005\u00119\u0001rB\u0015\f\t\rC\u0001\u0002C\u0007\u0003\u0019\u0003Aj!U\u0002\u0005\u000b\u0001i!\u0001\"\u0005\t\u0010%RAa\u0011\u0005\t\u00135\t\u0001TB)\u0004\t\u0015\u0001QB\u0001C\n\u0011\u001fI#\u0002B\"\t\u0011)i\u0011\u0001'\u0004R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0016!=\u0011F\u0003\u0003D\u0011!YQ\"\u0001M\u0005#\u000e!Q\u0001A\u0007\u0003\t/AY!\u000b\u0006\u0005\u0007\"AA\"D\u0001\u0019\u000eE\u001bA!\u0002\u0001\u000e\u0005\u0011e\u0001rB\u0015\u000b\t\rC\u0001\"D\u0007\u000217\t6\u0001B\u0003\u0001\u001b\t!a\u0002#\b"}, strings={"Lcom/intellij/openapi/updateSettings/impl/UpdateChannel;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "builds", "", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "evalDays", "", "getEvalDays", "()I", "feedbackUrl", "", "getFeedbackUrl", "()Ljava/lang/String;", "homePageUrl", "getHomePageUrl", "id", "getId", "licensing", "getLicensing", "majorVersion", "getMajorVersion", "name", "getName", "status", "Lcom/intellij/openapi/updateSettings/impl/ChannelStatus;", "getStatus", "()Lcom/intellij/openapi/updateSettings/impl/ChannelStatus;", "getLatestBuild", "baseline", "latestBuild", "Companion"}, moduleName="platform-impl")
public final class UpdateChannel {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final ChannelStatus status;
    @NotNull
    private final String licensing;
    private final int majorVersion;
    @Nullable
    private final String homePageUrl;
    @Nullable
    private final String feedbackUrl;
    private final int evalDays;
    private final List<BuildInfo> builds;
    @NotNull
    public static final String LICENSING_EAP = "eap";
    @NotNull
    public static final String LICENSING_PRODUCTION = "production";
    public static final Companion Companion = com.intellij.openapi.updateSettings.impl.UpdateChannel$Companion.INSTANCE;

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ChannelStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final String getLicensing() {
        return this.licensing;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    @Nullable
    public final String getHomePageUrl() {
        return this.homePageUrl;
    }

    @Nullable
    public final String getFeedbackUrl() {
        return this.feedbackUrl;
    }

    public final int getEvalDays() {
        return this.evalDays;
    }

    @Nullable
    public final BuildInfo getLatestBuild() {
        return this.latestBuild(this.builds);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BuildInfo getLatestBuild(int baseline) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.builds;
        UpdateChannel updateChannel = this;
        void var3_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BuildInfo it = (BuildInfo)element$iv$iv;
            if (!(it.getNumber().getBaselineVersion() == baseline)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return updateChannel.latestBuild(list);
    }

    /*
     * WARNING - void declaration
     */
    private final BuildInfo latestBuild(List<BuildInfo> builds) {
        void $receiver$iv;
        Iterable iterable = builds;
        BuildInfo initial$iv = null;
        BuildInfo accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void candidate;
            BuildInfo buildInfo = (BuildInfo)element$iv;
            BuildInfo best = accumulator$iv;
            accumulator$iv = best == null || best.compareTo((BuildInfo)candidate) < 0 ? candidate : best;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    public UpdateChannel(@NotNull Element node) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        String string = node.getAttributeValue("id");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.id = string;
        String string2 = node.getAttributeValue("name");
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        this.name = string2;
        ChannelStatus channelStatus = ChannelStatus.fromCode(node.getAttributeValue("status"));
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)channelStatus), (String)"ChannelStatus.fromCode(n\u2026AttributeValue(\"status\"))");
        this.status = channelStatus;
        String string3 = node.getAttributeValue("licensing", Companion.getLICENSING_PRODUCTION());
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.getAttributeValue(\"\u2026g\", LICENSING_PRODUCTION)");
        this.licensing = string3;
        String string4 = node.getAttributeValue("majorVersion");
        this.majorVersion = string4 != null ? StringsKt.toInt((String)string4) : -1;
        this.homePageUrl = node.getAttributeValue("url");
        this.feedbackUrl = node.getAttributeValue("feedback");
        String string5 = node.getAttributeValue("evalDays");
        this.evalDays = string5 != null ? StringsKt.toInt((String)string5) : 30;
        Iterable iterable = node.getChildren("build");
        UpdateChannel updateChannel = this;
        void var3_4 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            list = destination$iv$iv;
            void v6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
            BuildInfo buildInfo = new BuildInfo((Element)v6);
            list.add(buildInfo);
        }
        updateChannel.builds = list = (List)destination$iv$iv;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u0003\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!k\u0006\u0005\u0007\"\f\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%^Aa\u00115\u0002\u0011\u000fi\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011!\u0001b\u0001"}, strings={"Lcom/intellij/openapi/updateSettings/impl/UpdateChannel$Companion;", "", "()V", "LICENSING_EAP", "", "getLICENSING_EAP", "()Ljava/lang/String;", "LICENSING_PRODUCTION", "getLICENSING_PRODUCTION"}, moduleName="platform-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getLICENSING_EAP() {
            return LICENSING_EAP;
        }

        @NotNull
        public final String getLICENSING_PRODUCTION() {
            return LICENSING_PRODUCTION;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

