/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.EnsureUpToDateFromNonAWTThread;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlusMinusModify;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.continuation.ContinuationPause;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
JDOMExternalizable {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final UpdateRequestsQueue myUpdater;
    private static final AtomicReference<ScheduledExecutorService> ourUpdateAlarm = new AtomicReference();
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private final EventDispatcher<ChangeListListener> myListeners = EventDispatcher.create(ChangeListListener.class);
    private final Object myDataLock = new Object();
    private final List<CommitExecutor> myExecutors = new ArrayList<CommitExecutor>();
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private boolean myExcludedConvertedToIgnored;
    @NotNull
    private volatile ProgressIndicator myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED;
    private boolean myShowLocalChangesInvalidated;
    private final AtomicReference<String> myFreezeName;
    private final DelayedNotificator myDelayedNotificator;
    private final VcsListener myVcsListener = new VcsListener(){

        public void directoryMappingChanged() {
            VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
        }
    };
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private final VcsDirtyScopeVfsListener myVfsListener;
    private boolean myModalNotificationsBlocked;
    @NotNull
    private final Collection<LocalChangeList> myListsToBeDeleted = new HashSet<LocalChangeList>();

    private static ScheduledExecutorService createChangeListExecutor() {
        return VcsUtil.createExecutor((String)"Change List Updater");
    }

    public static ChangeListManagerImpl getInstanceImpl(Project project2) {
        return (ChangeListManagerImpl)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ChangeListManager.class);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(Project project2, final VcsConfiguration config) {
        this.myProject = project2;
        this.myConfig = config;
        this.myFreezeName = new AtomicReference<Object>(null);
        this.myAdditionalInfo = null;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myVfsListener = (VcsDirtyScopeVfsListener)ApplicationManager.getApplication().getComponent(VcsDirtyScopeVfsListener.class);
        project2.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectClosing(Project project2) {
                ChangeListManagerImpl.this.myVfsListener.flushDirt();
            }
        });
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myComposite = new FileHolderComposite(project2);
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, ourUpdateAlarm, new ActualUpdater());
        this.myWorker = new ChangeListWorker(this.myProject, new MyChangesDeltaForwarder(this.myProject, ourUpdateAlarm));
        this.myDelayedNotificator = new DelayedNotificator(this.myListeners, ourUpdateAlarm);
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myConflictTracker = new ChangelistConflictTracker(project2, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project2));
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    ChangeListManagerImpl.this.scheduleAutomaticChangeListDeletionIfEmpty(oldList, config);
                }
            }
        });
    }

    private void scheduleAutomaticChangeListDeletionIfEmpty(final LocalChangeList oldList, final VcsConfiguration config) {
        if (oldList.isReadOnly() || !oldList.getChanges().isEmpty()) {
            return;
        }
        this.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                LocalChangeList actualList = ChangeListManagerImpl.this.getChangeList(oldList.getId());
                if (actualList == null) {
                    return;
                }
                if (ChangeListManagerImpl.this.myModalNotificationsBlocked && config.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                    ChangeListManagerImpl.this.myListsToBeDeleted.add(oldList);
                } else {
                    ChangeListManagerImpl.this.deleteEmptyChangeLists(Collections.singletonList(actualList));
                }
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    private void deleteEmptyChangeLists(@NotNull Collection<LocalChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "deleteEmptyChangeLists"));
        }
        if (lists.isEmpty() || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        ChangeListRemoveConfirmation.processLists(this.myProject, false, lists, new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> toAsk) {
                if (toAsk == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAsk", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$5", "askIfShouldRemoveChangeLists"));
                }
                return ((ChangeListManagerImpl)ChangeListManagerImpl.this).myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsShowConfirmationOption.Value.SHOW_CONFIRMATION || ChangeListManagerImpl.this.showRemoveEmptyChangeListsProposal(ChangeListManagerImpl.this.myConfig, toAsk);
            }
        });
    }

    private boolean showRemoveEmptyChangeListsProposal(final @NotNull VcsConfiguration config, @NotNull Collection<? extends LocalChangeList> lists) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, (Function)new Function<LocalChangeList, String>(){

            public String fun(LocalChangeList list) {
                return StringUtil.first((String)list.getName(), (int)30, (boolean)true);
            }
        }, (String)"<br/>"));
        VcsConfirmationDialog dialog = new VcsConfirmationDialog(this.myProject, new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists(this.myListsToBeDeleted);
        this.myListsToBeDeleted.clear();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            vcsManager.addVcsListener(this.myVcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)new DumbAwareRunnable(){

                public void run() {
                    ChangeListManagerImpl.this.myUpdater.initialized();
                    ChangeListManagerImpl.this.broadcastStateAfterLoad();
                    vcsManager.addVcsListener(ChangeListManagerImpl.this.myVcsListener);
                }
            });
            this.myConflictTracker.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastStateAfterLoad() {
        List<LocalChangeList> listCopy;
        Object object = this.myDataLock;
        synchronized (object) {
            listCopy = this.getChangeListsCopy();
        }
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    private void initializeForNewProject() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    if (ChangeListManagerImpl.this.myWorker.isEmpty()) {
                        LocalChangeList list = ChangeListManagerImpl.this.myWorker.addChangeList(VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]), null, null);
                        ChangeListManagerImpl.this.setDefaultChangeList(list);
                        if (ChangeListManagerImpl.this.myIgnoredIdeaLevel.isEmpty()) {
                            for (String path : ChangeListManagerImpl.this.predefinedIgnorePaths()) {
                                ChangeListManagerImpl.this.myIgnoredIdeaLevel.add(IgnoredBeanFactory.ignoreFile((String)path, (Project)ChangeListManagerImpl.this.myProject));
                            }
                        }
                    }
                    if (!Registry.is((String)"ide.hide.excluded.files") && !ChangeListManagerImpl.this.myExcludedConvertedToIgnored) {
                        ChangeListManagerImpl.this.convertExcludedToIgnored();
                        ChangeListManagerImpl.this.myExcludedConvertedToIgnored = true;
                    }
                }
            }
        });
    }

    @NotNull
    List<String> predefinedIgnorePaths() {
        ArrayList<String> myIgnoredIdeaLevel = new ArrayList<String>();
        myIgnoredIdeaLevel.add(this.myProject.getName() + ".iws");
        myIgnoredIdeaLevel.add(".idea/workspace.xml");
        ArrayList<String> arrayList = myIgnoredIdeaLevel;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "predefinedIgnorePaths"));
        }
        return arrayList;
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (VirtualFile file2 : policy.getExcludeRootsForProject()) {
                this.addDirectoryToIgnoreImplicitly(file2.getPath());
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module2).getExcludeRootUrls()) {
                VirtualFile file3 = virtualFileManager.findFileByUrl(url);
                if (file3 != null && !fileIndex.isExcluded(file3)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        ProjectLevelVcsManager.getInstance((Project)this.myProject).removeVcsListener(this.myVcsListener);
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getComponentName"));
        }
        return "ChangeListManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, dirtyScopeManagerFiller, state);
    }

    public void freeze(final ContinuationPause context, final String reason) {
        this.myUpdater.setIgnoreBackgroundOperation(true);
        this.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                ChangeListManagerImpl.this.freezeImmediately(reason);
                context.ping();
            }
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.NON_MODAL);
        context.suspend();
    }

    @Override
    public void freezeImmediately(@Nullable String reason) {
        this.myUpdater.setIgnoreBackgroundOperation(false);
        this.myUpdater.pause();
        this.myFreezeName.set(reason);
    }

    public void letGo() {
        this.myUpdater.go();
        this.myFreezeName.set(null);
    }

    public String isFreezed() {
        return this.myFreezeName.get();
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet<VirtualFile> refreshFiles = new HashSet<VirtualFile>();
        try {
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                IgnoredFilesHolder fileHolder = (IgnoredFilesHolder)this.myComposite.get(FileHolder.HolderType.IGNORED);
                Iterator<VcsDirtyScope> iterator2 = scopes.iterator();
                while (iterator2.hasNext()) {
                    VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator2.next();
                    VcsDirtyScopeModifier modifier = scope.getModifier();
                    if (modifier == null) continue;
                    fileHolder.notifyVcsStarted(scope.getVcs());
                    Iterator filesIterator = modifier.getDirtyFilesIterator();
                    while (filesIterator.hasNext()) {
                        FilePath dirtyFile = (FilePath)filesIterator.next();
                        if (dirtyFile.getVirtualFile() == null || !this.isIgnoredFile(dirtyFile.getVirtualFile())) continue;
                        filesIterator.remove();
                        fileHolder.addFile(dirtyFile.getVirtualFile());
                        refreshFiles.add(dirtyFile.getVirtualFile());
                    }
                    Collection roots = modifier.getAffectedVcsRoots();
                    for (VirtualFile root : roots) {
                        Iterator dirIterator = modifier.getDirtyDirectoriesIterator(root);
                        while (dirIterator.hasNext()) {
                            FilePath dir = (FilePath)dirIterator.next();
                            if (dir.getVirtualFile() == null || !this.isIgnoredFile(dir.getVirtualFile())) continue;
                            dirIterator.remove();
                            fileHolder.addFile(dir.getVirtualFile());
                            refreshFiles.add(dir.getVirtualFile());
                        }
                    }
                    modifier.recheckDirtyKeys();
                    if (!scope.isEmpty()) continue;
                    iterator2.remove();
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        catch (AssertionError ex) {
            LOG.error((Throwable)((Object)ex));
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
        if (this.checkScopeIsEmpty(invalidated)) {
            this.myDirtyScopeManager.changesProcessed();
            return;
        }
        final boolean wasEverythingDirty = invalidated.isEverythingDirty();
        final List scopes = invalidated.getScopes();
        try {
            boolean takeChanges;
            DataHolder dataHolder;
            this.checkIfDisposed();
            ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
            Object object = this.myDataLock;
            synchronized (object) {
                dataHolder = new DataHolder((FileHolderComposite)this.myComposite.copy(), this.myWorker.copy(), wasEverythingDirty);
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                    this.myAdditionalInfo = null;
                }
                this.myUpdateChangesProgressIndicator = indicator;
            }
            if (LOG.isDebugEnabled()) {
                String scopeInString = StringUtil.join((Collection)scopes, (Function)new Function<VcsDirtyScope, String>(){

                    public String fun(VcsDirtyScope scope) {
                        return scope.toString();
                    }
                }, (String)"->\n");
                LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\ncurrent changes: " + this.myWorker);
            }
            dataHolder.notifyStart();
            this.myChangesViewManager.scheduleRefresh();
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    ChangeListManagerImpl.this.iterateScopes(dataHolder, scopes, wasEverythingDirty);
                }
            }, indicator);
            boolean bl = takeChanges = this.myUpdateException == null;
            if (takeChanges) {
                this.updateIgnoredFiles(dataHolder.getComposite());
            }
            this.clearCurrentRevisionsCache(invalidated);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (ChangeListManagerImpl.this.myProject.isDisposed()) {
                        return;
                    }
                    Object object = ChangeListManagerImpl.this.myDataLock;
                    synchronized (object) {
                        dataHolder.notifyEnd();
                        ChangeListManagerImpl.this.myModifier.finishUpdate(dataHolder.getChangeListWorker());
                        if (takeChanges) {
                            ChangeListWorker oldWorker = ChangeListManagerImpl.this.myWorker;
                            ChangeListManagerImpl.this.myWorker = dataHolder.getChangeListWorker();
                            ChangeListManagerImpl.this.myWorker.onAfterWorkerSwitch(oldWorker);
                            ChangeListManagerImpl.this.myModifier.setWorker(ChangeListManagerImpl.this.myWorker);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getSize() + "\nchanges: " + ChangeListManagerImpl.this.myWorker);
                            }
                            boolean statusChanged = !ChangeListManagerImpl.this.myComposite.equals(dataHolder.getComposite());
                            ChangeListManagerImpl.this.myComposite = dataHolder.getComposite();
                            if (statusChanged) {
                                ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher().unchangedFileStatusChanged();
                            }
                        }
                        ChangeListManagerImpl.this.myShowLocalChangesInvalidated = false;
                    }
                }
            });
            for (VcsDirtyScope scope : scopes) {
                AbstractVcs vcs = scope.getVcs();
                if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                scope.iterateExistingInsideScope((Processor)new Processor<VirtualFile>(){

                    public boolean process(VirtualFile file2) {
                        LastUnchangedContentTracker.markUntouched(file2);
                        return true;
                    }
                });
            }
            this.myChangesViewManager.scheduleRefresh();
        }
        catch (DisposedException dataHolder222) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder222 = this.myDataLock;
            synchronized (dataHolder222) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (ProcessCanceledException dataHolder222) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder222 = this.myDataLock;
            synchronized (dataHolder222) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (RuntimeInterruptedException dataHolder222) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder222 = this.myDataLock;
            synchronized (dataHolder222) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        catch (AssertionError ex) {
            LOG.error((Throwable)((Object)ex));
        }
        finally {
            this.myDirtyScopeManager.changesProcessed();
            Object ex = this.myDataLock;
            synchronized (ex) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    private boolean checkScopeIsAllIgnored(VcsInvalidated invalidated) {
        if (!invalidated.isEverythingDirty()) {
            this.filterOutIgnoredFiles(invalidated.getScopes());
            if (invalidated.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null || invalidated.isEmpty()) {
            if (invalidated != null && invalidated.isEmpty() && invalidated.isEverythingDirty()) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
            }
            return true;
        }
        return this.checkScopeIsAllIgnored(invalidated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<VcsDirtyScope> scopes, boolean wasEverythingDirty) {
        ChangeListManagerGate gate = dataHolder.getChangeListWorker().createSelfGate();
        Getter<Boolean> disposedGetter = new Getter<Boolean>(){

            public Boolean get() {
                return ChangeListManagerImpl.this.myProject.isDisposed() || (Boolean)ChangeListManagerImpl.this.myUpdater.getIsStoppedGetter().get() != false;
            }
        };
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(dataHolder.getChangeListWorker(), dataHolder.getComposite(), disposedGetter, this.myIgnoredIdeaLevel, gate);
        for (VcsDirtyScope scope : scopes) {
            this.myUpdateChangesProgressIndicator.checkCanceled();
            AbstractVcs vcs = scope.getVcs();
            if (vcs == null) continue;
            scope.setWasEverythingDirty(wasEverythingDirty);
            this.myChangesViewManager.setBusy(true);
            dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
            this.actualUpdate(builder, scope, vcs, dataHolder, gate);
            if (this.myUpdateException == null) continue;
            break;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (gate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gate", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                FoldersCutDownWorker foldersCutDownWorker = new FoldersCutDownWorker();
                try {
                    builder.setCurrent(scope, foldersCutDownWorker);
                    changeProvider.getChanges(scope, (ChangelistBuilder)builder, this.myUpdateChangesProgressIndicator, gate);
                }
                catch (VcsException e) {
                    this.handleUpdateException(e);
                }
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    private void handleUpdateException(final VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((VcsConnectionProblem)e).attemptQuickFix(false);
                }
            });
        }
        if (this.myUpdateException == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
                if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                    return;
                }
                e.printStackTrace();
            }
            this.myUpdateException = e;
        }
    }

    private void checkIfDisposed() {
        if (this.myUpdater.isStopped()) {
            throw new DisposedException();
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after2 = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalChangeList> getChangeListsCopy() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list = this.getChangeListsCopy();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeLists"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAffectedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAllChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getUnversionedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Couple<Integer> getUnversionedFilesSize() {
        Object object = this.myDataLock;
        synchronized (object) {
            VirtualFileHolder holder = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
            return Couple.of((Object)holder.getSize(), (Object)holder.getNumDirs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getModifiedWithoutEditing() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<VirtualFile> getIgnoredFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return new HashMap<VirtualFile, LogicalLock>(((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogicallyLocked(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return ((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).containsKey(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.isContainedInLocallyDeleted(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocallyDeletedChange> getDeletedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getLocallyDeleted().getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getSwitchedHolder().getBranchToFileMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        Object object = this.myDataLock;
        synchronized (object) {
            return ((SwitchedFileHolder)this.myComposite.get(FileHolder.HolderType.ROOT_SWITCH)).getFilesMapCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getCopyByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeList(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return this.addChangeList(name, comment, null);
    }

    @Override
    public LocalChangeList addChangeList(final @NotNull String name, final @Nullable String comment, final @Nullable Object data) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return (LocalChangeList)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LocalChangeList>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LocalChangeList compute() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    LocalChangeList changeList = ChangeListManagerImpl.this.myModifier.addChangeList(name, comment, data);
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                    return changeList;
                }
            }
        });
    }

    public void removeChangeList(final String name) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    ChangeListManagerImpl.this.myModifier.removeChangeList(name);
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                }
            }
        });
    }

    public void removeChangeList(LocalChangeList list) {
        this.removeChangeList(list.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Runnable prepareForChangeDeletion(Collection<Change> changes) {
        Map<String, List<Change>> map;
        final HashMap<String, LocalChangeList> lists = new HashMap<String, LocalChangeList>();
        Object object = this.myDataLock;
        synchronized (object) {
            map = this.myWorker.listsForChanges(changes, lists);
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                final ChangeListListener multicaster = ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ChangeListManagerImpl.this.myDataLock;
                        synchronized (object) {
                            for (Map.Entry entry : map.entrySet()) {
                                List changes = (List)entry.getValue();
                                Iterator iterator = changes.iterator();
                                while (iterator.hasNext()) {
                                    Change change = (Change)iterator.next();
                                    if (ChangeListManagerImpl.this.getChangeList(change) == null) continue;
                                    iterator.remove();
                                }
                                multicaster.changesRemoved((Collection)changes, (ChangeList)lists.get(entry.getKey()));
                            }
                            for (String listName : map.keySet()) {
                                LocalChangeList byName = ChangeListManagerImpl.this.myWorker.getCopyByName(listName);
                                if (byName == null || byName.isDefault()) continue;
                                ChangeListManagerImpl.this.scheduleAutomaticChangeListDeletionIfEmpty(byName, ChangeListManagerImpl.this.myConfig);
                            }
                        }
                    }
                });
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "prepareForChangeDeletion"));
        }
        return runnable2;
    }

    public void setDefaultChangeList(final @NotNull LocalChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "setDefaultChangeList"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    ChangeListManagerImpl.this.myModifier.setDefault(list.getName());
                }
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListCopy();
        }
    }

    public boolean isDefaultChangeList(ChangeList list) {
        return list instanceof LocalChangeList && this.myWorker.isDefaultList((LocalChangeList)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(Collection<Change> changes, List<Change> validChanges) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<LocalChangeList> collection = this.myWorker.getInvolvedListsFilterChanges(changes, validChanges);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getInvolvedListsFilterChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listForChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listNameIfOnlyOne(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList getIdentityChangeList(Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getListsCopy();
            for (LocalChangeList list : lists) {
                for (Change oldChange : list.getChanges()) {
                    if (oldChange != change) continue;
                    return list;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUpdate() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChange"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            LocalChangeList list = this.myWorker.getListCopy(file2);
            if (list != null) {
                for (Change change : list.getChanges()) {
                    String revisionPath;
                    String revisionPath2;
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision != null && FileUtil.pathsEqual((String)(revisionPath2 = FileUtil.toSystemIndependentName((String)afterRevision.getFile().getIOFile().getPath())), (String)file2.getPath())) {
                        return change;
                    }
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    if (beforeRevision == null || !FileUtil.pathsEqual((String)(revisionPath = FileUtil.toSystemIndependentName((String)beforeRevision.getFile().getIOFile().getPath())), (String)file2.getPath())) continue;
                    return change;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListCopy(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnversioned(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public FileStatus getStatus(VirtualFile file2) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.HIJACKED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        boolean switched = this.myWorker.isSwitched(file2);
        FileStatus status = this.myWorker.getStatus(file2);
        if (status != null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED.equals(status) && switched ? FileStatus.SWITCHED : status;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (switched) {
            FileStatus fileStatus = FileStatus.SWITCHED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        // MONITOREXIT : object
        if (fileStatus != null) return fileStatus;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
    }

    @NotNull
    public Collection<Change> getChangesIn(VirtualFile dir) {
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(FilePath dirPath) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getChangesIn(dirPath);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
    }

    @Override
    public void moveChangesTo(final LocalChangeList list, final Change ... changes) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    ChangeListManagerImpl.this.myModifier.moveChangesTo(list.getName(), changes);
                }
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    @Override
    public void addUnversionedFiles(LocalChangeList list, @NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        this.addUnversionedFiles(list, files, new Condition<FileStatus>(){

            public boolean value(FileStatus status) {
                return status == FileStatus.UNKNOWN;
            }
        });
    }

    @Deprecated
    public void addUnversionedFiles(final LocalChangeList list, @NotNull List<VirtualFile> files, final Condition<FileStatus> statusChecker) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        final ArrayList exceptions = new ArrayList();
        final HashSet allProcessedFiles = new HashSet();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

            public void process(AbstractVcs vcs, List<VirtualFile> items) {
                final CheckinEnvironment environment = vcs.getCheckinEnvironment();
                if (environment != null) {
                    final Set descendants = ChangeListManagerImpl.this.getUnversionedDescendantsRecursively(items, (Condition<FileStatus>)statusChecker);
                    Set parents = vcs.areDirectoriesVersionedItems() ? ChangeListManagerImpl.this.getUnversionedParents(items, (Condition<FileStatus>)statusChecker) : Collections.emptySet();
                    final ArrayList result2 = ContainerUtil.newArrayList();
                    ProgressManager.getInstance().run((Task)new Task.Modal(ChangeListManagerImpl.this.myProject, "Adding files to VCS...", true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$23$1", "run"));
                            }
                            indicator.setIndeterminate(true);
                            List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
                            if (exs != null) {
                                ContainerUtil.addAll((Collection)result2, (Iterable)exs);
                            }
                        }
                    });
                    allProcessedFiles.addAll(descendants);
                    allProcessedFiles.addAll(parents);
                    exceptions.addAll(result2);
                }
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file2 : allProcessedFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(allProcessedFiles, null);
        if (!list.isDefault()) {
            this.invokeAfterUpdate(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = ChangeListManagerImpl.this.myDataLock;
                            synchronized (object) {
                                ArrayList<Change> changesToMove = new ArrayList<Change>();
                                LocalChangeList defaultList = ChangeListManagerImpl.this.getDefaultChangeList();
                                for (Change change : defaultList.getChanges()) {
                                    VirtualFile vFile;
                                    ContentRevision afterRevision = change.getAfterRevision();
                                    if (afterRevision == null || !allProcessedFiles.contains(vFile = afterRevision.getFile().getVirtualFile())) continue;
                                    changesToMove.add(change);
                                }
                                if (!changesToMove.isEmpty()) {
                                    ChangeListManagerImpl.this.moveChangesTo(list, changesToMove.toArray(new Change[changesToMove.size()]));
                                }
                            }
                        }
                    });
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                }
            }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE_NOT_AWT, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
    }

    @NotNull
    private Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull List<VirtualFile> items, final @NotNull Condition<FileStatus> condition) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        final HashSet result2 = ContainerUtil.newHashSet();
        Processor<VirtualFile> addToResultProcessor = new Processor<VirtualFile>(){

            public boolean process(VirtualFile file2) {
                if (condition.value((Object)ChangeListManagerImpl.this.getStatus(file2))) {
                    result2.add(file2);
                }
                return true;
            }
        };
        for (VirtualFile item : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, item, addToResultProcessor);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedParents(@NotNull Collection<VirtualFile> items, @NotNull Condition<FileStatus> condition) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile item : items) {
            for (VirtualFile parent = item.getParent(); parent != null && condition.value((Object)this.getStatus(parent)); parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        return hashSet;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(ChangeListListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeChangeListListener(ChangeListListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    public void registerCommitExecutor(CommitExecutor executor) {
        this.myExecutors.add(executor);
    }

    public void commitChanges(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, false);
    }

    private boolean doCommit(LocalChangeList changeList, List<Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        return new CommitHelper(this.myProject, (ChangeList)changeList, changes, changeList.getName(), StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment(), new ArrayList<CheckinHandler>(), false, synchronously, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null).doCommit();
    }

    public void commitChangesSynchronously(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, true);
    }

    public boolean commitChangesSynchronouslyWithResult(LocalChangeList changeList, List<Change> changes) {
        return this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(Element element) throws InvalidDataException {
        if (!this.myProject.isDefault()) {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myIgnoredIdeaLevel.clear();
                new ChangeListManagerSerialization(this.myIgnoredIdeaLevel, this.myWorker).readExternal(element);
                if (!this.myWorker.isEmpty() && this.getDefaultChangeList() == null) {
                    this.setDefaultChangeList(this.myWorker.getListsCopy().get(0));
                }
            }
            this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
            this.myConflictTracker.loadState(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.myProject.isDefault()) {
            ChangeListWorker worker;
            IgnoredFilesComponent ignoredFilesComponent;
            Object object = this.myDataLock;
            synchronized (object) {
                ignoredFilesComponent = new IgnoredFilesComponent(this.myIgnoredIdeaLevel);
                worker = this.myWorker.copy();
            }
            new ChangeListManagerSerialization(ignoredFilesComponent, worker).writeExternal(element);
            if (this.myExcludedConvertedToIgnored) {
                JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)String.valueOf(true));
            }
            this.myConflictTracker.saveState(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(List<FilePath> paths) {
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ChangeListManagerImpl.collectFiles(paths));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    public List<CommitExecutor> getRegisteredExecutors() {
        return Collections.unmodifiableList(this.myExecutors);
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addDirectoryToIgnoreImplicitly"));
        }
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUnversionedUpdate() {
        MyDirtyFilesScheduler scheduler = new MyDirtyFilesScheduler(this.myProject);
        Object object = this.myDataLock;
        synchronized (object) {
            VirtualFileHolder unversionedHolder = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
            IgnoredFilesHolder ignoredHolder = (IgnoredFilesHolder)this.myComposite.get(FileHolder.HolderType.IGNORED);
            scheduler.accept(unversionedHolder.getFiles());
            scheduler.accept(ignoredHolder.values());
        }
        scheduler.arise();
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<VirtualFile> unversionedFiles) {
        for (VirtualFile file2 : unversionedFiles) {
            if (!this.isIgnoredFile(file2)) continue;
            vfHolder.removeFile(file2);
            composite.getIgnoredFileHolder().addFile(file2);
        }
    }

    public IgnoredFileBean[] getFilesToIgnore() {
        return this.myIgnoredIdeaLevel.getFilesToIgnore();
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "isIgnoredFile"));
        }
        return this.myIgnoredIdeaLevel.isIgnoredFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSwitchedBranch(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getBranchForFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultListName() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListName();
        }
    }

    private static VirtualFile[] collectFiles(List<FilePath> paths) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (FilePath path : paths) {
            if (path.getVirtualFile() == null) continue;
            result2.add(path.getVirtualFile());
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public boolean setReadOnly(final String name, final boolean value) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    boolean result2 = ChangeListManagerImpl.this.myModifier.setReadOnly(name, value);
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                    return result2;
                }
            }
        });
    }

    public boolean editName(final @NotNull String fromName, final @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    boolean result2 = ChangeListManagerImpl.this.myModifier.editName(fromName, toName);
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                    return result2;
                }
            }
        });
    }

    public String editComment(final @NotNull String fromName, final String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editComment"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String compute() {
                Object object = ChangeListManagerImpl.this.myDataLock;
                synchronized (object) {
                    String oldComment = ChangeListManagerImpl.this.myModifier.editComment(fromName, newComment);
                    ChangeListManagerImpl.this.myChangesViewManager.scheduleRefresh();
                    return oldComment;
                }
            }
        });
    }

    public void waitUntilRefreshed() {
        this.myVfsListener.flushDirt();
        this.myUpdater.waitUntilRefreshed();
        ChangeListManagerImpl.waitUpdateAlarm();
    }

    private static void waitUpdateAlarm() {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        ourUpdateAlarm.get().execute(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourUpdateAlarm.get().shutdownNow();
        ourUpdateAlarm.set(ChangeListManagerImpl.createChangeListExecutor());
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public void executeOnUpdaterThread(Runnable r) {
        ourUpdateAlarm.get().execute(r);
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        this.myVfsListener.flushDirt();
        EnsureUpToDateFromNonAWTThread worker = new EnsureUpToDateFromNonAWTThread(this.myProject);
        worker.execute();
        this.myUpdater.waitUntilRefreshed();
        ChangeListManagerImpl.waitUpdateAlarm();
        return worker.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLocalChangesInvalidated() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myShowLocalChangesInvalidated = true;
        }
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason != null) {
            if (modalTitle != null) {
                Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
            } else {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
            }
        }
        return freezeReason != null;
    }

    static {
        ourUpdateAlarm.set(ChangeListManagerImpl.createChangeListExecutor());
        LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    }

    private static class MyChangesDeltaForwarder
    implements PlusMinusModify<BaseRevision> {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final AtomicReference<ScheduledExecutorService> myService;

        public MyChangesDeltaForwarder(Project project2, AtomicReference<ScheduledExecutorService> service) {
            this.myProject = project2;
            this.myService = service;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project2);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        }

        public void modify(final BaseRevision was, final BaseRevision become) {
            this.myService.get().submit(new Runnable(){

                @Override
                public void run() {
                    AbstractVcs vcs = MyChangesDeltaForwarder.this.getVcs(was);
                    if (vcs != null) {
                        MyChangesDeltaForwarder.this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)was.getPath().getPath(), (Object)vcs));
                    }
                    ((VcsAnnotationRefresher)MyChangesDeltaForwarder.this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
                }
            });
        }

        public void plus(final BaseRevision baseRevision) {
            this.myService.get().submit(new Runnable(){

                @Override
                public void run() {
                    AbstractVcs vcs = MyChangesDeltaForwarder.this.getVcs(baseRevision);
                    if (vcs != null) {
                        MyChangesDeltaForwarder.this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath().getPath(), (Object)vcs));
                    }
                    ((VcsAnnotationRefresher)MyChangesDeltaForwarder.this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision);
                }
            });
        }

        public void minus(final BaseRevision baseRevision) {
            this.myService.get().submit(new Runnable(){

                @Override
                public void run() {
                    AbstractVcs vcs = MyChangesDeltaForwarder.this.getVcs(baseRevision);
                    if (vcs != null) {
                        MyChangesDeltaForwarder.this.myRevisionsCache.minus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath().getPath(), (Object)vcs));
                    }
                    ((VcsAnnotationRefresher)MyChangesDeltaForwarder.this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath().getPath());
                }
            });
        }

        @Nullable
        private AbstractVcs getVcs(BaseRevision baseRevision) {
            FilePath path;
            VcsKey vcsKey = baseRevision.getVcs();
            if (vcsKey == null && (vcsKey = this.findVcs(path = baseRevision.getPath())) == null) {
                return null;
            }
            return this.myVcsManager.findVcsByName(vcsKey.getName());
        }

        @Nullable
        private VcsKey findVcs(FilePath path) {
            VirtualFile vf = path.getVirtualFile();
            if (vf == null) {
                vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path.getIOFile());
            }
            if (vf == null) {
                return null;
            }
            AbstractVcs vcs = this.myVcsManager.getVcsFor(vf);
            return vcs == null ? null : vcs.getKeyInstanceMethod();
        }
    }

    private static class MyDirtyFilesScheduler {
        private static final int ourPiecesLimit = 100;
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myDirs = new ArrayList<VirtualFile>();
        private boolean myEveryThing;
        private int myCnt;
        private final Project myProject;

        private MyDirtyFilesScheduler(Project project2) {
            this.myProject = project2;
            this.myCnt = 0;
            this.myEveryThing = false;
        }

        public void accept(Collection<VirtualFile> coll) {
            for (VirtualFile vf : coll) {
                if (this.myCnt > 100) {
                    this.myEveryThing = true;
                    break;
                }
                if (vf.isDirectory()) {
                    this.myDirs.add(vf);
                } else {
                    this.myFiles.add(vf);
                }
                ++this.myCnt;
            }
        }

        public void arise() {
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            if (this.myEveryThing) {
                vcsDirtyScopeManager.markEverythingDirty();
            } else {
                vcsDirtyScopeManager.filesDirty(this.myFiles, this.myDirs);
            }
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker myChangeListWorker;

        private DataHolder(FileHolderComposite composite, ChangeListWorker changeListWorker, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListWorker = changeListWorker;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListWorker.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListWorker.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
            this.myChangeListWorker.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher());
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher());
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        ChangeListWorker getChangeListWorker() {
            return this.myChangeListWorker;
        }
    }

    private class ActualUpdater
    implements Runnable {
        private ActualUpdater() {
        }

        @Override
        public void run() {
            ChangeListManagerImpl.this.updateImmediately();
        }
    }

    static class DisposedException
    extends RuntimeException {
        DisposedException() {
        }
    }
}

