/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchCommitExecutor
extends LocalCommitExecutor
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    public String PATCH_PATH = "";

    public static CreatePatchCommitExecutor getInstance(Project project2) {
        return (CreatePatchCommitExecutor)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, CreatePatchCommitExecutor.class));
    }

    public CreatePatchCommitExecutor(Project project2, ChangeListManager changeListManager) {
        this.myProject = project2;
        this.myChangeListManager = changeListManager;
    }

    @Nls
    public String getActionText() {
        return "Create Patch...";
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.patch.create";
    }

    @NotNull
    public CommitSession createCommitSession() {
        CreatePatchCommitSession createPatchCommitSession = new CreatePatchCommitSession();
        if (createPatchCommitSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor", "createCommitSession"));
        }
        return createPatchCommitSession;
    }

    public void projectOpened() {
        this.myChangeListManager.registerCommitExecutor((CommitExecutor)this);
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CreatePatchCommitExecutor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor", "getComponentName"));
        }
        return "CreatePatchCommitExecutor";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    private class CreatePatchCommitSession
    implements CommitSession,
    CommitSessionContextAware {
        private final CreatePatchConfigurationPanel myPanel;
        private CommitContext myCommitContext;

        public CreatePatchCommitSession() {
            this.myPanel = new CreatePatchConfigurationPanel(CreatePatchCommitExecutor.this.myProject);
        }

        public void setContext(CommitContext context) {
            this.myCommitContext = context;
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI() {
            return this.myPanel.getPanel();
        }

        public JComponent getAdditionalConfigurationUI(Collection<Change> changes, String commitMessage) {
            if (CreatePatchCommitExecutor.this.PATCH_PATH.length() == 0) {
                VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
                CreatePatchCommitExecutor.this.PATCH_PATH = settings.PATCH_STORAGE_LOCATION;
                if (CreatePatchCommitExecutor.this.PATCH_PATH == null) {
                    CreatePatchCommitExecutor.this.PATCH_PATH = CreatePatchCommitExecutor.this.myProject.getBaseDir() == null ? PathManager.getHomePath() : CreatePatchCommitExecutor.this.myProject.getBaseDir().getPresentableUrl();
                }
            }
            this.myPanel.setFileName(ShelveChangesManager.suggestPatchName(CreatePatchCommitExecutor.this.myProject, commitMessage, new File(CreatePatchCommitExecutor.this.PATCH_PATH), null));
            this.myPanel.setReversePatch(false);
            this.myPanel.setChanges(ContainerUtil.filter(changes, (Condition)new Condition<Change>(){

                public boolean value(Change change) {
                    return change.getBeforeRevision() != null && change.getAfterRevision() != null;
                }
            }));
            this.myPanel.showTextStoreOption();
            JComponent panel = this.myPanel.getPanel();
            panel.putClientProperty("Vcs.SessionDialog.title", "Patch File Settings");
            return panel;
        }

        public boolean canExecute(Collection<Change> changes, String commitMessage) {
            return this.myPanel.isOkToExecute();
        }

        public void execute(Collection<Change> changes, String commitMessage) {
            if (!this.myPanel.isOkToExecute()) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{CreatePatchCommitSession.this.myPanel.getError()}), (String)CommonBundle.getErrorTitle());
                    }
                }, (ModalityState)ModalityState.NON_MODAL, (Project)CreatePatchCommitExecutor.this.myProject);
                return;
            }
            String fileName = this.myPanel.getFileName();
            final File file2 = new File(fileName).getAbsoluteFile();
            if (file2.exists()) {
                final int[] result2 = new int[1];
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        result2[0] = Messages.showYesNoDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)("File " + file2.getName() + " (" + file2.getParent() + ")" + " already exists.\nDo you want to overwrite it?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
                    }
                });
                if (1 == result2[0]) {
                    return;
                }
            }
            if (file2.getParentFile() == null) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{"Can not write patch to specified file: " + file2.getPath()}), (String)CommonBundle.getErrorTitle());
                    }
                }, (ModalityState)ModalityState.NON_MODAL, (Project)CreatePatchCommitExecutor.this.myProject);
                return;
            }
            this.myPanel.onOk();
            this.myCommitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)this.myPanel.isStoreTexts());
            ArrayList<FilePath> list = new ArrayList<FilePath>();
            for (Change change : this.myPanel.getIncludedChanges()) {
                list.add(ChangesUtil.getFilePath((Change)change));
            }
            this.myCommitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisionPaths, list);
            int binaryCount = 0;
            for (Change change : changes) {
                if (!ChangesUtil.isBinaryChange((Change)change)) continue;
                ++binaryCount;
            }
            if (binaryCount == changes.size()) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showInfoMessage((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.all.binary", (Object[])new Object[0]), (String)VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]));
                    }
                }, null, (Project)CreatePatchCommitExecutor.this.myProject);
                return;
            }
            try {
                file2.getParentFile().mkdirs();
                VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject).acceptLastCreatedPatchName(file2.getName());
                VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION = CreatePatchCommitExecutor.this.PATCH_PATH = file2.getParent();
                boolean bl = this.myPanel.isReversePatch();
                List patches = IdeaTextPatchBuilder.buildPatch((Project)CreatePatchCommitExecutor.this.myProject, changes, (String)CreatePatchCommitExecutor.this.myProject.getBaseDir().getPresentableUrl(), (boolean)bl);
                PatchWriter.writePatches(CreatePatchCommitExecutor.this.myProject, fileName, patches, this.myCommitContext, this.myPanel.getEncoding());
                final String message = binaryCount == 0 ? VcsBundle.message((String)"create.patch.success.confirmation", (Object[])new Object[]{file2.getPath()}) : VcsBundle.message((String)"create.patch.partial.success.confirmation", (Object[])new Object[]{file2.getPath(), binaryCount});
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject);
                        if (Boolean.TRUE.equals(configuration.SHOW_PATCH_IN_EXPLORER)) {
                            ShowFilePathAction.openFile(file2);
                        } else {
                            if (Boolean.FALSE.equals(configuration.SHOW_PATCH_IN_EXPLORER)) {
                                return;
                            }
                            configuration.SHOW_PATCH_IN_EXPLORER = ShowFilePathAction.showDialog(CreatePatchCommitExecutor.this.myProject, message, VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]), file2);
                        }
                    }
                }, null, (Project)CreatePatchCommitExecutor.this.myProject);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception exception) {
                LOG.info((Throwable)exception);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{exception.getMessage()}), (String)CommonBundle.getErrorTitle());
                    }
                }, null, (Project)CreatePatchCommitExecutor.this.myProject);
            }
        }

        public void executionCanceled() {
        }

        public String getHelpId() {
            return null;
        }
    }
}

