/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CacheChangeProcessor;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitExecutorWithHelp;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.PseudoMap;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.ui.AlienChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.AlienLocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserExtender;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.changes.ui.MultipleChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.OnOffListener;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChangeListDialog
extends DialogWrapper
implements CheckinProjectPanel,
TypeSafeDataProvider {
    private static final String outCommitHelpId = "reference.dialogs.vcs.commit";
    private static final int LAYOUT_VERSION = 2;
    private static final Logger LOG = Logger.getInstance(CommitChangeListDialog.class);
    private final CommitContext myCommitContext;
    private final CommitMessage myCommitMessageArea;
    private Splitter mySplitter;
    @Nullable
    private final JPanel myAdditionalOptionsPanel;
    private final ChangesBrowser myBrowser;
    private final ChangesBrowserExtender myBrowserExtender;
    private CommitLegendPanel myLegend;
    private final MyChangeProcessor myDiffDetails;
    private final List<RefreshableOnComponent> myAdditionalComponents = new ArrayList<RefreshableOnComponent>();
    private final List<CheckinHandler> myHandlers = new ArrayList<CheckinHandler>();
    private final String myActionName;
    private final Project myProject;
    private final List<CommitExecutor> myExecutors;
    private final Alarm myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private String myLastKnownComment = "";
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    @NonNls
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private final CommitExecutorAction[] myExecutorActions;
    private final boolean myShowVcsCommit;
    private final Map<AbstractVcs, JPanel> myPerVcsOptionsPanels = new HashMap<AbstractVcs, JPanel>();
    @Nullable
    private final AbstractVcs myVcs;
    private final boolean myIsAlien;
    private boolean myDisposed = false;
    private final JLabel myWarningLabel;
    private final Map<String, CheckinChangeListSpecificComponent> myCheckinChangeListSpecificComponents;
    private final Map<String, String> myListComments;
    private String myLastSelectedListName;
    private ChangeInfoCalculator myChangesInfoCalculator;
    private final PseudoMap<Object, Object> myAdditionalData;
    private String myHelpId;
    private SplitterWithSecondHideable myDetailsSplitter;
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private final String myOkActionText;
    private CommitAction myCommitAction;
    @Nullable
    private CommitResultHandler myResultHandler;
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = false;
    private final MyUpdateButtonsRunnable myUpdateButtonsRunnable = new MyUpdateButtonsRunnable(this);

    public static boolean commitChanges(Project project2, List<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, executors, showVcsCommit, null, comment, customResultHandler, cancelIfNoChanges);
    }

    public static boolean commitChanges(Project project2, List<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, @Nullable AbstractVcs singleVcs, String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        if (cancelIfNoChanges && changes.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Messages.showInfoMessage((Project)project2, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return false;
        }
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project2)) {
            BeforeCheckinDialogHandler handler2 = factory.createSystemReadyHandler(project2);
            if (handler2 == null || handler2.beforeCommitDialogShown(project2, changes, executors, showVcsCommit)) continue;
            return false;
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        CommitChangeListDialog dialog = new CommitChangeListDialog(project2, changes, initialSelection, executors, showVcsCommit, manager.getDefaultChangeList(), manager.getChangeListsCopy(), singleVcs, false, comment, customResultHandler);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            dialog.show();
        } else {
            dialog.doOKAction();
        }
        return dialog.isOK();
    }

    private static List<BaseCheckinHandlerFactory> getCheckInFactories(Project project2) {
        return CheckinHandlersManager.getInstance().getRegisteredCheckinHandlerFactories(ProjectLevelVcsManager.getInstance((Project)project2).getAllActiveVcss());
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List<RefreshableOnComponent> list = Collections.unmodifiableList(this.myAdditionalComponents);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getAdditionalComponents"));
        }
        return list;
    }

    public static void commitPaths(Project project2, Collection<FilePath> paths, LocalChangeList initialSelection, @Nullable CommitExecutor executor, String comment) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project2);
        HashSet<Change> changes = new HashSet<Change>();
        for (FilePath path : paths) {
            changes.addAll(manager.getChangesIn(path));
        }
        CommitChangeListDialog.commitChanges(project2, changes, initialSelection, executor, comment);
    }

    public static boolean commitChanges(Project project2, Collection<Change> changes, LocalChangeList initialSelection, @Nullable CommitExecutor executor, String comment) {
        if (executor == null) {
            return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, CommitChangeListDialog.collectExecutors(project2, changes), true, comment, null);
        }
        return CommitChangeListDialog.commitChanges(project2, changes, initialSelection, Collections.singletonList(executor), false, comment, null);
    }

    public static List<CommitExecutor> collectExecutors(Project project2, Collection<Change> changes) {
        ArrayList<CommitExecutor> result2 = new ArrayList<CommitExecutor>();
        for (AbstractVcs vcs : CommitChangeListDialog.getAffectedVcses(project2, changes)) {
            result2.addAll(vcs.getCommitExecutors());
        }
        result2.addAll(ChangeListManager.getInstance((Project)project2).getRegisteredExecutors());
        return result2;
    }

    public static boolean commitChanges(Project project2, Collection<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, String comment, @Nullable CommitResultHandler customResultHandler) {
        return CommitChangeListDialog.commitChanges(project2, new ArrayList<Change>(changes), initialSelection, executors, showVcsCommit, comment, customResultHandler, true);
    }

    public static void commitAlienChanges(Project project2, List<Change> changes, AbstractVcs vcs, String changelistName, String comment) {
        AlienLocalChangeList lcl = new AlienLocalChangeList(changes, changelistName);
        new CommitChangeListDialog(project2, changes, null, null, true, AlienLocalChangeList.DEFAULT_ALIEN, Collections.singletonList(lcl), vcs, true, comment, null).show();
    }

    private CommitChangeListDialog(Project project2, List<Change> changes, LocalChangeList initialSelection, List<CommitExecutor> executors, boolean showVcsCommit, LocalChangeList defaultChangeList, List<LocalChangeList> changeLists, @Nullable AbstractVcs singleVcs, boolean isAlien, String comment, @Nullable CommitResultHandler customResultHandler) {
        super(project2, true);
        ChangesBrowser browser;
        this.myCommitContext = new CommitContext();
        this.myProject = project2;
        this.myExecutors = executors;
        this.myShowVcsCommit = showVcsCommit;
        this.myVcs = singleVcs;
        this.myResultHandler = customResultHandler;
        this.myListComments = new HashMap<String, String>();
        this.myAdditionalData = new PseudoMap();
        this.myDiffDetails = new MyChangeProcessor(this.myProject);
        if (!(this.myShowVcsCommit || this.myExecutors != null && this.myExecutors.size() != 0)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.myAllOfDefaultChangeListChangesIncluded = new HashSet<Change>(changes).containsAll(new HashSet(defaultChangeList.getChanges()));
        this.myIsAlien = isAlien;
        if (isAlien) {
            this.myBrowser = browser = new AlienChangeListBrowser(project2, changeLists, changes, (ChangeList)initialSelection, true, true, singleVcs);
            this.myBrowserExtender = browser;
        } else {
            this.myBrowser = browser = new MultipleChangeListBrowser(project2, changeLists, changes, this.getDisposable(), (ChangeList)initialSelection, true, true, new Runnable(){

                @Override
                public void run() {
                    CommitChangeListDialog.this.updateWarning();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    for (CheckinHandler handler2 : CommitChangeListDialog.this.myHandlers) {
                        handler2.includedChangesChanged();
                    }
                }
            }, new AnAction[0]){

                @Override
                protected void afterDiffRefresh() {
                    CommitChangeListDialog.this.myBrowser.rebuildList();
                    CommitChangeListDialog.this.myBrowser.setDataIsDirty(false);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IdeFocusManager.findInstance().requestFocus((Component)CommitChangeListDialog.this.myBrowser.getViewer().getPreferredFocusedComponent(), true);
                        }
                    });
                }
            };
            this.myBrowser.setAlwayExpandList(false);
            this.myBrowserExtender = ((MultipleChangeListBrowser)browser).getExtender();
        }
        this.myBrowser.getViewer().addSelectionListener(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommitChangeListDialog.this.changeDetails();
                    }
                });
            }
        });
        this.myBrowserExtender.addToolbarActions(this);
        this.myBrowserExtender.addSelectedListChangeListener(new SelectedListChangeListener(){

            @Override
            public void selectedListChanged() {
                CommitChangeListDialog.this.updateOnListSelection();
            }
        });
        this.myCommitMessageArea = new CommitMessage(project2);
        if (!VcsConfiguration.getInstance((Project)project2).CLEAR_INITIAL_COMMIT_MESSAGE) {
            this.setComment(project2, initialSelection, comment);
        }
        this.myBrowser.setDiffBottomComponent(new DiffCommitMessageEditor(this));
        this.myActionName = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
        Box optionsBox = Box.createVerticalBox();
        boolean hasVcsOptions = false;
        Box vcsCommitOptions = Box.createVerticalBox();
        ArrayList<AbstractVcs> vcses = new ArrayList<AbstractVcs>(this.getAffectedVcses());
        Collections.sort(vcses, new Comparator<AbstractVcs>(){

            @Override
            public int compare(AbstractVcs o1, AbstractVcs o2) {
                return o1.getKeyInstanceMethod().getName().compareToIgnoreCase(o2.getKeyInstanceMethod().getName());
            }
        });
        this.myCheckinChangeListSpecificComponents = new HashMap<String, CheckinChangeListSpecificComponent>();
        for (AbstractVcs vcs : vcses) {
            RefreshableOnComponent options;
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (checkinEnvironment == null || (options = checkinEnvironment.createAdditionalOptionsPanel((CheckinProjectPanel)this, this.myAdditionalData)) == null) continue;
            JPanel vcsOptions = new JPanel(new BorderLayout());
            vcsOptions.add((Component)options.getComponent(), "Center");
            vcsOptions.setBorder((Border)IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName(), (boolean)true));
            vcsCommitOptions.add(vcsOptions);
            this.myPerVcsOptionsPanels.put(vcs, vcsOptions);
            this.myAdditionalComponents.add(options);
            if (options instanceof CheckinChangeListSpecificComponent) {
                this.myCheckinChangeListSpecificComponents.put(vcs.getName(), (CheckinChangeListSpecificComponent)options);
            }
            hasVcsOptions = true;
        }
        if (hasVcsOptions) {
            vcsCommitOptions.add(Box.createVerticalGlue());
            optionsBox.add(vcsCommitOptions);
        }
        boolean beforeVisible = false;
        boolean afterVisible = false;
        Box beforeBox = Box.createVerticalBox();
        Box afterBox = Box.createVerticalBox();
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project2)) {
            RefreshableOnComponent afterPanel;
            CheckinHandler handler2 = factory.createHandler((CheckinProjectPanel)this, this.myCommitContext);
            if (CheckinHandler.DUMMY.equals(handler2)) continue;
            this.myHandlers.add(handler2);
            RefreshableOnComponent beforePanel = handler2.getBeforeCheckinConfigurationPanel();
            if (beforePanel != null) {
                beforeBox.add(beforePanel.getComponent());
                beforeVisible = true;
                this.myAdditionalComponents.add(beforePanel);
            }
            if ((afterPanel = handler2.getAfterCheckinConfigurationPanel(this.getDisposable())) == null) continue;
            afterBox.add(afterPanel.getComponent());
            afterVisible = true;
            this.myAdditionalComponents.add(afterPanel);
        }
        String actionName = this.getCommitActionName();
        String borderTitleName = actionName.replace("_", "").replace("&", "");
        if (beforeVisible) {
            beforeBox.add(Box.createVerticalGlue());
            JPanel beforePanel = new JPanel(new BorderLayout());
            beforePanel.add(beforeBox);
            beforePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(beforePanel);
        }
        if (afterVisible) {
            afterBox.add(Box.createVerticalGlue());
            JPanel afterPanel = new JPanel(new BorderLayout());
            afterPanel.add(afterBox);
            afterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])new Object[]{borderTitleName}), (boolean)true));
            optionsBox.add(afterPanel);
        }
        if (hasVcsOptions || beforeVisible || afterVisible) {
            optionsBox.add(Box.createVerticalGlue());
            this.myAdditionalOptionsPanel = new JPanel(new BorderLayout());
            this.myAdditionalOptionsPanel.add((Component)optionsBox, "North");
        } else {
            this.myAdditionalOptionsPanel = null;
        }
        this.myOkActionText = actionName;
        if (this.myShowVcsCommit) {
            this.setTitle(this.myActionName);
        } else {
            this.setTitle(CommitChangeListDialog.trimEllipsis(this.myExecutors.get(0).getActionText()));
        }
        this.restoreState();
        if (this.myExecutors != null) {
            this.myExecutorActions = new CommitExecutorAction[this.myExecutors.size()];
            for (int i = 0; i < this.myExecutors.size(); ++i) {
                CommitExecutor commitExecutor = this.myExecutors.get(i);
                this.myExecutorActions[i] = new CommitExecutorAction(commitExecutor, i == 0 && !this.myShowVcsCommit);
            }
        } else {
            this.myExecutorActions = null;
        }
        this.myWarningLabel = new JLabel();
        this.myWarningLabel.setUI((LabelUI)new MultiLineLabelUI());
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.updateWarning();
        this.init();
        this.updateButtons();
        this.updateVcsOptionsVisibility();
        this.updateOnListSelection();
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)project2)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
    }

    private void setComment(Project project2, LocalChangeList initialSelection, String comment) {
        if (comment != null) {
            this.setCommitMessage(comment);
            this.myLastKnownComment = comment;
            this.myLastSelectedListName = initialSelection == null ? this.myBrowser.getSelectedChangeList().getName() : initialSelection.getName();
        } else {
            this.updateComment();
            if (StringUtil.isEmptyOrSpaces((String)this.myCommitMessageArea.getComment())) {
                this.setCommitMessage(VcsConfiguration.getInstance((Project)project2).LAST_COMMIT_MESSAGE);
                String messageFromVcs = this.getInitialMessageFromVcs();
                if (messageFromVcs != null) {
                    this.myCommitMessageArea.setText(messageFromVcs);
                }
            }
        }
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, false);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommitChangeListDialog.this.changeDetails();
            }
        });
    }

    private void updateOnListSelection() {
        this.updateComment();
        this.updateVcsOptionsVisibility();
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.onChangeListSelected((LocalChangeList)this.myBrowser.getSelectedChangeList());
        }
    }

    private void updateWarning() {
        if (this.myWarningLabel != null) {
            String[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)this.myProject)).getUpdateException();
            if (updateException != null && (messages = updateException.getMessages()) != null && messages.length > 0) {
                String message = messages[0];
                this.myWarningLabel.setText("Warning: not all local changes may be shown due to an error: " + message);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    private void updateVcsOptionsVisibility() {
        Collection<AbstractVcs> affectedVcses = CommitChangeListDialog.getAffectedVcses(this.myProject, this.myBrowser.getSelectedChangeList().getChanges());
        for (Map.Entry<AbstractVcs, JPanel> entry : this.myPerVcsOptionsPanels.entrySet()) {
            entry.getValue().setVisible(affectedVcses.contains(entry.getKey()));
        }
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    protected void doOKAction() {
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        final DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
        Runnable callCommit = new Runnable(){

            @Override
            public void run() {
                try {
                    CheckinHandler.ReturnResult result2 = CommitChangeListDialog.this.runBeforeCommitHandlers(new Runnable(){

                        @Override
                        public void run() {
                            CommitChangeListDialog.super.doOKAction();
                            CommitChangeListDialog.this.doCommit(CommitChangeListDialog.this.myResultHandler);
                        }
                    }, null);
                    if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                        defaultListCleaner.clean();
                    }
                }
                catch (InputException ex) {
                    ex.show();
                }
            }
        };
        if (this.myBrowser.isDataIsDirty()) {
            this.ensureDataIsActual(callCommit);
        } else {
            callCommit.run();
        }
    }

    @NotNull
    protected Action getOKAction() {
        CommitAction commitAction = new CommitAction();
        if (commitAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getOKAction"));
        }
        return commitAction;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myCommitAction = null;
        if (this.myShowVcsCommit) {
            this.myCommitAction = new CommitAction();
            actions.add(this.myCommitAction);
            this.myHelpId = outCommitHelpId;
        }
        if (this.myExecutors != null) {
            if (this.myCommitAction != null) {
                this.myCommitAction.setOptions(this.myExecutorActions);
            } else {
                actions.addAll(Arrays.asList(this.myExecutorActions));
            }
            for (CommitExecutor executor : this.myExecutors) {
                if (this.myHelpId != null) break;
                if (!(executor instanceof CommitExecutorWithHelp)) continue;
                this.myHelpId = ((CommitExecutorWithHelp)executor).getHelpId();
            }
        }
        actions.add(this.getCancelAction());
        if (this.myHelpId != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "createActions"));
        }
        return actionArray;
    }

    private void execute(final CommitExecutor commitExecutor) {
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        final CommitSession session = commitExecutor.createCommitSession();
        if (session instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)session).setContext(this.myCommitContext);
        }
        if (session == CommitSession.VCS_COMMIT) {
            this.doOKAction();
            return;
        }
        boolean isOK = true;
        JComponent configurationUI = SessionDialog.createConfigurationUI(session, this.getIncludedChanges(), this.getCommitMessage());
        if (configurationUI != null) {
            SessionDialog sessionDialog = new SessionDialog(commitExecutor.getActionText(), this.getProject(), session, this.getIncludedChanges(), this.getCommitMessage(), configurationUI);
            isOK = sessionDialog.showAndGet();
        }
        if (isOK) {
            final DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
            this.runBeforeCommitHandlers(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean success = false;
                    try {
                        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                            @Override
                            public void run() {
                                DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        session.execute((Collection)CommitChangeListDialog.this.getIncludedChanges(), CommitChangeListDialog.this.getCommitMessage());
                                    }
                                });
                            }
                        }, commitExecutor.getActionText(), true, CommitChangeListDialog.this.getProject());
                        if (completed) {
                            for (CheckinHandler handler2 : CommitChangeListDialog.this.myHandlers) {
                                handler2.checkinSuccessful();
                            }
                            success = true;
                            defaultListCleaner.clean();
                            CommitChangeListDialog.this.close(0);
                        } else {
                            session.executionCanceled();
                        }
                    }
                    catch (Throwable e) {
                        Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{commitExecutor.getActionText(), e.getLocalizedMessage()}), (String)commitExecutor.getActionText());
                        for (CheckinHandler handler3 : CommitChangeListDialog.this.myHandlers) {
                            handler3.checkinFailed(Collections.singletonList(new VcsException(e)));
                        }
                    }
                    finally {
                        if (CommitChangeListDialog.this.myResultHandler != null) {
                            if (success) {
                                CommitChangeListDialog.this.myResultHandler.onSuccess(CommitChangeListDialog.this.getCommitMessage());
                            } else {
                                CommitChangeListDialog.this.myResultHandler.onFailure();
                            }
                        }
                    }
                }
            }, commitExecutor);
        } else {
            session.executionCanceled();
        }
    }

    @Nullable
    private String getInitialMessageFromVcs() {
        List<Change> list = this.getIncludedChanges();
        final Ref result2 = new Ref();
        ChangesUtil.processChangesByVcs((Project)this.myProject, list, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(){

            public void process(AbstractVcs vcs, List<Change> items) {
                List paths;
                String defaultMessage;
                CheckinEnvironment checkinEnvironment;
                if (result2.isNull() && (checkinEnvironment = vcs.getCheckinEnvironment()) != null && (defaultMessage = checkinEnvironment.getDefaultMessageFor((paths = ChangesUtil.getPaths(items)).toArray(new FilePath[paths.size()]))) != null) {
                    result2.set((Object)defaultMessage);
                }
            }
        });
        return (String)result2.get();
    }

    private void saveCommentIntoChangeList() {
        if (this.myLastSelectedListName != null) {
            String actualCommentText = this.myCommitMessageArea.getComment();
            String saved = this.myListComments.get(this.myLastSelectedListName);
            if (!Comparing.equal((String)saved, (String)actualCommentText)) {
                this.myListComments.put(this.myLastSelectedListName, actualCommentText);
            }
        }
    }

    private static boolean isDefaultList(LocalChangeList list) {
        return VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]).equals(list.getName());
    }

    private void updateComment() {
        if (VcsConfiguration.getInstance((Project)this.getProject()).CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        LocalChangeList list = (LocalChangeList)this.myBrowser.getSelectedChangeList();
        if (list == null || list.getName().equals(this.myLastSelectedListName)) {
            return;
        }
        if (this.myLastSelectedListName != null) {
            this.saveCommentIntoChangeList();
        }
        this.myLastSelectedListName = list.getName();
        String listComment = list.getComment();
        if (StringUtil.isEmptyOrSpaces((String)listComment)) {
            String listTitle = list.getName();
            listComment = !CommitChangeListDialog.isDefaultList(list) ? listTitle : this.myLastKnownComment;
        }
        this.myCommitMessageArea.setText(listComment);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myBrowser.dispose();
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        this.myUpdateButtonsRunnable.cancel();
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), false);
    }

    public String getCommitActionName() {
        String name = null;
        for (AbstractVcs vcs : this.getAffectedVcses()) {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            if (name == null && checkinEnvironment != null) {
                name = checkinEnvironment.getCheckinOperationName();
                continue;
            }
            name = VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
        }
        return name != null ? name : VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
    }

    public boolean isCheckSpelling() {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        return configuration == null || configuration.CHECK_COMMIT_MESSAGE_SPELLING;
    }

    public void setCheckSpelling(boolean checkSpelling) {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        if (configuration != null) {
            configuration.CHECK_COMMIT_MESSAGE_SPELLING = checkSpelling;
        }
        this.myCommitMessageArea.setCheckSpelling(checkSpelling);
    }

    private boolean checkComment() {
        if (VcsConfiguration.getInstance((Project)this.myProject).FORCE_NON_EMPTY_COMMENT && this.getCommitMessage().length() == 0) {
            int requestForCheckin = Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return requestForCheckin == 0;
        }
        return true;
    }

    private void stopUpdate() {
        this.myDisposed = true;
        this.myUpdateButtonsRunnable.cancel();
    }

    private void restartUpdate() {
        this.myDisposed = false;
        this.myUpdateButtonsRunnable.restart(this);
    }

    private CheckinHandler.ReturnResult runBeforeCommitHandlers(final Runnable okAction, final CommitExecutor executor) {
        Computable<CheckinHandler.ReturnResult> proceedRunnable = new Computable<CheckinHandler.ReturnResult>(){

            public CheckinHandler.ReturnResult compute() {
                FileDocumentManager.getInstance().saveAllDocuments();
                for (CheckinHandler handler2 : CommitChangeListDialog.this.myHandlers) {
                    CheckinHandler.ReturnResult result2;
                    if (!handler2.acceptExecutor(executor) || (result2 = handler2.beforeCheckin(executor, (PairConsumer)CommitChangeListDialog.this.myAdditionalData)) == CheckinHandler.ReturnResult.COMMIT) continue;
                    if (result2 == CheckinHandler.ReturnResult.CANCEL) {
                        CommitChangeListDialog.this.restartUpdate();
                        return CheckinHandler.ReturnResult.CANCEL;
                    }
                    if (result2 != CheckinHandler.ReturnResult.CLOSE_WINDOW) continue;
                    ChangeList changeList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
                    CommitHelper.moveToFailedList(changeList, CommitChangeListDialog.this.getCommitMessage(), CommitChangeListDialog.this.getIncludedChanges(), VcsBundle.message((String)"commit.dialog.rejected.commit.template", (Object[])new Object[]{changeList.getName()}), CommitChangeListDialog.this.myProject);
                    CommitChangeListDialog.this.doCancelAction();
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                okAction.run();
                return CheckinHandler.ReturnResult.COMMIT;
            }
        };
        this.stopUpdate();
        final Ref compoundResultRef = Ref.create();
        Runnable runnable2 = new Runnable((Computable)proceedRunnable){
            final /* synthetic */ Computable val$proceedRunnable;
            {
                this.val$proceedRunnable = computable;
            }

            @Override
            public void run() {
                compoundResultRef.set(this.val$proceedRunnable.compute());
            }
        };
        for (final CheckinHandler handler2 : this.myHandlers) {
            if (!(handler2 instanceof CheckinMetaHandler)) continue;
            final Runnable previousRunnable = runnable2;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    ((CheckinMetaHandler)handler2).runCheckinHandlers(previousRunnable);
                }
            };
        }
        runnable2.run();
        return (CheckinHandler.ReturnResult)compoundResultRef.get();
    }

    private boolean saveDialogState() {
        if (!this.checkComment()) {
            return false;
        }
        this.saveCommentIntoChangeList();
        VcsConfiguration.getInstance((Project)this.myProject).saveCommitMessage(this.getCommitMessage());
        try {
            this.saveState();
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
        return true;
    }

    private void saveComments(boolean isOk) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        if (isOk) {
            int selectedSize = this.getIncludedChanges().size();
            ChangeList selectedList = this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            if (totalSize > selectedSize) {
                this.myListComments.remove(this.myLastSelectedListName);
            }
        }
        for (Map.Entry<String, String> entry : this.myListComments.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            clManager.editComment(name, value);
        }
    }

    public void doCancelAction() {
        for (CheckinChangeListSpecificComponent component : this.myCheckinChangeListSpecificComponents.values()) {
            component.saveState();
        }
        this.saveCommentIntoChangeList();
        this.saveComments(false);
        super.doCancelAction();
    }

    private void doCommit(@Nullable CommitResultHandler customResultHandler) {
        CommitHelper helper = new CommitHelper(this.myProject, this.myBrowser.getSelectedChangeList(), this.getIncludedChanges(), this.myActionName, this.getCommitMessage(), this.myHandlers, this.myAllOfDefaultChangeListChangesIncluded, false, (NullableFunction<Object, Object>)this.myAdditionalData, customResultHandler);
        if (this.myIsAlien) {
            helper.doAlienCommit(this.myVcs);
        } else {
            helper.doCommit(this.myVcs);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Object mainPanel;
        this.mySplitter = new Splitter(true);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)this.myBrowser);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.initMainSplitter();
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        this.myBrowser.getBottomPanel().add((Component)JBUI.Panels.simplePanel().addToRight((Component)this.myLegend.getComponent()), "South");
        if (this.myAdditionalOptionsPanel != null) {
            JScrollPane optionsPane = ScrollPaneFactory.createScrollPane((Component)this.myAdditionalOptionsPanel, (boolean)true);
            optionsPane.getVerticalScrollBar().setUnitIncrement(10);
            optionsPane.setVerticalScrollBarPolicy(22);
            optionsPane.getVerticalScrollBar().setUI(ButtonlessScrollBarUI.createTransparent());
            JBPanel infoPanel = JBUI.Panels.simplePanel((Component)optionsPane).withBorder((Border)JBUI.Borders.emptyLeft((int)10));
            mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, (JComponent)infoPanel, 150)));
            ((Container)mainPanel).add((Component)this.mySplitter);
            ((Container)mainPanel).add((Component)infoPanel);
        } else {
            mainPanel = this.mySplitter;
        }
        this.myWarningLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myWarningLabel, new GridBag().anchor(18).weightx(1.0));
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)panel);
        this.myDetailsSplitter = new SplitterWithSecondHideable(true, "Details", (JComponent)rootPane, (OnOffListener)new OnOffListener<Integer>(){

            public void on(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.refresh();
                CommitChangeListDialog.this.mySplitter.skipNextLayouting();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayouting();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + integer);
                CommitChangeListDialog.this.repaint();
            }

            public void off(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayouting();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayouting();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - integer);
                CommitChangeListDialog.this.repaint();
            }
        }){

            @Override
            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel((JPanel)panel){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    @Override
                    public boolean refreshDataSynch() {
                        return false;
                    }

                    @Override
                    public void dataChanged() {
                    }

                    @Override
                    public void refresh() {
                    }

                    @Override
                    public JPanel getPanel() {
                        return this.val$panel;
                    }

                    @Override
                    public void away() {
                    }

                    public boolean isStillValid(Object o) {
                        return false;
                    }

                    public void dispose() {
                    }
                };
            }

            @Override
            protected float getSplitterInitialProportion() {
                float value = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                if ((double)value <= 0.05 || (double)value >= 0.95) {
                    return 0.6f;
                }
                return value;
            }
        };
        return this.myDetailsSplitter.getComponent();
    }

    private void initMainSplitter() {
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
    }

    public Collection<AbstractVcs> getAffectedVcses() {
        if (!this.myShowVcsCommit) {
            return Collections.emptySet();
        }
        return this.myBrowserExtender.getAffectedVcses();
    }

    private static Collection<AbstractVcs> getAffectedVcses(Project project2, Collection<Change> changes) {
        THashSet result2 = new THashSet();
        for (Change change : changes) {
            ContainerUtilRt.addIfNotNull((Collection)result2, (Object)ChangesUtil.getVcsForChange((Change)change, (Project)project2));
        }
        return result2;
    }

    public Collection<VirtualFile> getRoots() {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (Change change : this.myBrowser.getCurrentDisplayedChanges()) {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            VirtualFile root = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsRootFor(filePath);
            if (root == null) continue;
            result2.add(root);
        }
        return result2;
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty();
    }

    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Change change : this.getIncludedChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            VirtualFile vFile = path.getVirtualFile();
            if (vFile == null) continue;
            result2.add(vFile);
        }
        return result2;
    }

    public Collection<Change> getSelectedChanges() {
        return new ArrayList<Change>(this.getIncludedChanges());
    }

    public Collection<File> getFiles() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Change change : this.getIncludedChanges()) {
            FilePath path = ChangesUtil.getFilePath((Change)change);
            File file2 = path.getIOFile();
            result2.add(file2);
        }
        return result2;
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean vcsIsAffected(String name) {
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive(name)) {
            return false;
        }
        Collection<AbstractVcs> affected = this.myBrowserExtender.getAffectedVcses();
        for (AbstractVcs vcs : affected) {
            if (!Comparing.equal((String)vcs.getName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    public void setCommitMessage(String currentDescription) {
        this.setCommitMessageText(currentDescription);
        this.myCommitMessageArea.requestFocusInMessage();
    }

    public Object getContextInfo(Object object) {
        return null;
    }

    public void setWarning(String s) {
    }

    private void setCommitMessageText(String currentDescription) {
        this.myLastKnownComment = currentDescription;
        this.myCommitMessageArea.setText(currentDescription);
    }

    public String getCommitMessage() {
        return this.myCommitMessageArea.getComment();
    }

    public void refresh() {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                CommitChangeListDialog.this.myBrowser.rebuildList();
                for (RefreshableOnComponent component : CommitChangeListDialog.this.myAdditionalComponents) {
                    component.refresh();
                }
            }
        }, InvokeAfterUpdateMode.SILENT, "commit dialog", ModalityState.current());
    }

    public void saveState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.saveState();
        }
    }

    public void restoreState() {
        for (RefreshableOnComponent component : this.myAdditionalComponents) {
            component.restoreState();
        }
    }

    private void updateButtons() {
        if (this.myDisposed) {
            return;
        }
        boolean enabled = this.hasDiffs();
        this.setOKActionEnabled(enabled);
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        if (this.myExecutorActions != null) {
            for (CommitExecutorAction executorAction : this.myExecutorActions) {
                executorAction.updateEnabled(enabled);
            }
        }
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest((Runnable)this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.myBrowser));
    }

    private void updateLegend() {
        if (this.myDisposed) {
            return;
        }
        this.myChangesInfoCalculator.update(this.myBrowser.getCurrentDisplayedChanges(), this.myBrowserExtender.getCurrentIncludedChanges());
        this.myLegend.update();
    }

    @NotNull
    private List<Change> getIncludedChanges() {
        List<Change> list = this.myBrowserExtender.getCurrentIncludedChanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog", "getIncludedChanges"));
        }
        return list;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog2";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key == Refreshable.PANEL_KEY) {
            sink.put(Refreshable.PANEL_KEY, (Object)this);
        } else {
            this.myBrowser.calcData(key, sink);
        }
    }

    static String trimEllipsis(String title) {
        if (title.endsWith("...")) {
            return title.substring(0, title.length() - 3);
        }
        return title;
    }

    private void ensureDataIsActual(Runnable runnable2) {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(runnable2, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing changelists...", ModalityState.current());
    }

    public void setMessageConsumer(Consumer<String> messageConsumer) {
        this.myCommitMessageArea.setMessageConsumer(messageConsumer);
    }

    private void changeDetails() {
        if (this.myDetailsSplitter.isOn()) {
            this.myDiffDetails.refresh();
        }
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        private final JComponent myPanel;
        private final JComponent myOptions;
        private final int myMinOptionsWidth;

        public MyOptionsLayout(@NotNull JComponent panel, @NotNull JComponent options, int minOptionsWidth) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout", "<init>"));
            }
            this.myPanel = panel;
            this.myOptions = options;
            this.myMinOptionsWidth = minOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptions.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(Container parent) {
            Rectangle bounds = parent.getBounds();
            int availableWidth = bounds.width - this.myPanel.getPreferredSize().width;
            int preferredWidth = this.myOptions.getPreferredSize().width;
            int optionsWidth = Math.max(Math.min(availableWidth, preferredWidth), this.myMinOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds.width - optionsWidth, bounds.height));
            this.myOptions.setBounds(new Rectangle(bounds.width - optionsWidth, 0, optionsWidth, bounds.height));
        }
    }

    private class MyChangeProcessor
    extends CacheChangeProcessor {
        public MyChangeProcessor(Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "<init>"));
            }
            super(project2, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
        }

        @Override
        @NotNull
        protected List<Change> getSelectedChanges() {
            List<Change> list = CommitChangeListDialog.this.myBrowser.getViewer().getSelectedChanges();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "getSelectedChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected List<Change> getAllChanges() {
            List<Change> list = CommitChangeListDialog.this.myBrowser.getViewer().getChanges();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "getAllChanges"));
            }
            return list;
        }

        @Override
        protected void selectChange(@NotNull Change change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor", "selectChange"));
            }
            CommitChangeListDialog.this.myBrowser.select(Collections.singletonList(change));
        }

        @Override
        protected void onAfterNavigate() {
            CommitChangeListDialog.this.doCancelAction();
        }
    }

    private static class DiffCommitMessageEditor
    extends CommitMessage
    implements Disposable {
        public DiffCommitMessageEditor(CommitChangeListDialog dialog) {
            super(dialog.getProject());
            this.getEditorField().setDocument(dialog.myCommitMessageArea.getEditorField().getDocument());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(400, 120);
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        private final CommitExecutor myCommitExecutor;

        public CommitExecutorAction(CommitExecutor commitExecutor, boolean isDefault) {
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
            if (isDefault) {
                this.putValue("DefaultAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable callExecutor = new Runnable(){

                @Override
                public void run() {
                    CommitChangeListDialog.this.execute(CommitExecutorAction.this.myCommitExecutor);
                }
            };
            if (CommitChangeListDialog.this.myBrowser.isDataIsDirty()) {
                CommitChangeListDialog.this.ensureDataIsActual(callExecutor);
            } else {
                callExecutor.run();
            }
        }

        public void updateEnabled(boolean hasDiffs) {
            this.setEnabled(hasDiffs || this.myCommitExecutor instanceof CommitExecutorBase && !((CommitExecutorBase)this.myCommitExecutor).areChangesRequired());
        }
    }

    private class DefaultListCleaner {
        private final boolean myToClean;

        private DefaultListCleaner() {
            int selectedSize = CommitChangeListDialog.this.getIncludedChanges().size();
            ChangeList selectedList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            this.myToClean = totalSize == selectedSize && CommitChangeListDialog.isDefaultList((LocalChangeList)selectedList);
        }

        void clean() {
            if (this.myToClean) {
                ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitChangeListDialog.this.myProject);
                clManager.editComment(VcsBundle.message((String)"changes.default.changelist.name", (Object[])new Object[0]), "");
            }
        }
    }

    private class CommitAction
    extends AbstractAction
    implements OptionAction {
        private Action[] myOptions;

        private CommitAction() {
            super(CommitChangeListDialog.this.myOkActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommitChangeListDialog.this.doOKAction();
        }

        @NotNull
        public Action[] getOptions() {
            if (this.myOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction", "getOptions"));
            }
            return this.myOptions;
        }

        public void setOptions(Action[] actions) {
            this.myOptions = actions;
        }
    }

    private static class MyUpdateButtonsRunnable
    implements Runnable {
        private CommitChangeListDialog myDialog;

        private MyUpdateButtonsRunnable(CommitChangeListDialog dialog) {
            this.myDialog = dialog;
        }

        public void cancel() {
            this.myDialog = null;
        }

        @Override
        public void run() {
            if (this.myDialog != null) {
                this.myDialog.updateButtons();
                this.myDialog.updateLegend();
            }
        }

        public void restart(CommitChangeListDialog dialog) {
            this.myDialog = dialog;
            this.run();
        }
    }
}

