/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.GroupTreeNode;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UpdateRootNode
extends GroupTreeNode {
    private final Project myProject;

    public UpdateRootNode(UpdatedFiles updatedFiles, Project project2, String rootName, ActionInfo actionInfo) {
        super(rootName, false, SimpleTextAttributes.ERROR_ATTRIBUTES, project2, Collections.<String, String>emptyMap(), null);
        this.myProject = project2;
        this.addGroupsToNode(updatedFiles.getTopLevelGroups(), this, actionInfo);
    }

    private void addGroupsToNode(List<FileGroup> groups, AbstractTreeNode owner, ActionInfo actionInfo) {
        for (FileGroup fileGroup : groups) {
            GroupTreeNode node = this.addFileGroup(fileGroup, owner, actionInfo);
            if (node == null) continue;
            this.addGroupsToNode(fileGroup.getChildren(), node, actionInfo);
        }
    }

    @Nullable
    private GroupTreeNode addFileGroup(FileGroup fileGroup, AbstractTreeNode parent, ActionInfo actionInfo) {
        if (fileGroup.isEmpty()) {
            return null;
        }
        GroupTreeNode group = new GroupTreeNode(actionInfo.getGroupName(fileGroup), fileGroup.getSupportsDeletion(), fileGroup.getInvalidAttributes(), this.myProject, fileGroup.getErrorsMap(), fileGroup.getId());
        Disposer.register((Disposable)this, (Disposable)group);
        parent.add(group);
        for (String s : fileGroup.getFiles()) {
            group.addFilePath(s);
        }
        return group;
    }

    @Override
    public boolean getSupportsDeletion() {
        return false;
    }
}

