/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;

public class ClassFileViewProvider
extends SingleRootFileViewProvider {
    private static final Key<Boolean> IS_INNER_CLASS = Key.create((String)"java.is.inner.class.key");

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file2);
    }

    public ClassFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "<init>"));
        }
        super(manager, file2, eventSystemEnabled, JavaClassFileType.INSTANCE);
    }

    @Override
    protected PsiFile createFile(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull FileType fileType) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/ClassFileViewProvider", "createFile"));
        }
        FileIndexFacade fileIndex = (FileIndexFacade)ServiceManager.getService((Project)project2, FileIndexFacade.class);
        if (!fileIndex.isInLibraryClasses(file2) && fileIndex.isInSource(file2)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (ClassFileViewProvider.isInnerClass(file2)) {
            return null;
        }
        return new ClsFileImpl(this);
    }

    public static boolean isInnerClass(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/ClassFileViewProvider", "isInnerClass"));
        }
        String name = file2.getNameWithoutExtension();
        int index = name.lastIndexOf(36);
        if (index > 0 && index < name.length() - 1) {
            String parentName = name.substring(0, index);
            String childName = name.substring(index + 1);
            if (file2.getParent().findChild(parentName + ".class") != null) {
                return ClassFileViewProvider.isInnerClass(file2, parentName, childName);
            }
        }
        return false;
    }

    private static boolean isInnerClass(VirtualFile file2, final String parentName, final String childName) {
        Boolean isInner = (Boolean)IS_INNER_CLASS.get((UserDataHolder)file2);
        if (isInner != null) {
            return isInner;
        }
        final Ref ref = Ref.create((Object)Boolean.FALSE);
        try {
            new MyClassReader(file2.contentsToByteArray(false)).accept(new ClassVisitor(327680){

                public void visitOuterClass(String owner, String name, String desc) {
                    ref.set((Object)Boolean.TRUE);
                    throw new ProcessCanceledException();
                }

                public void visitInnerClass(String name, String outer, String inner, int access) {
                    if ((inner == null || childName.equals(inner)) && outer != null && parentName.equals(outer.substring(outer.lastIndexOf(47) + 1)) || inner == null && outer == null && name.substring(name.lastIndexOf(47) + 1).equals(parentName + '$' + childName)) {
                        ref.set((Object)Boolean.TRUE);
                        throw new ProcessCanceledException();
                    }
                }
            }, 7);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            Logger.getInstance(ClassFileViewProvider.class).warn(file2.getPath(), (Throwable)e);
        }
        isInner = (Boolean)ref.get();
        IS_INNER_CLASS.set((UserDataHolder)file2, (Object)isInner);
        return isInner;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(this.getManager(), copy, false);
        if (classFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ClassFileViewProvider", "createCopy"));
        }
        return classFileViewProvider;
    }

    private static class MyClassReader
    extends ClassReader {
        public MyClassReader(byte[] b) {
            super(b);
        }

        protected Label readLabel(int offset, Label[] labels) {
            return null;
        }
    }
}

