/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiSuperMethodImplUtil");
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_FOR_CLASS_KEY = PsiCacheKey.create((String)"SIGNATURES_FOR_CLASS_KEY", (Function)new NotNullFunction<PsiClass, Map<MethodSignature, HierarchicalMethodSignature>>(){

        @NotNull
        public Map<MethodSignature, HierarchicalMethodSignature> fun(PsiClass dom) {
            Map map = PsiSuperMethodImplUtil.buildMethodHierarchy(dom, null, PsiSubstitutor.EMPTY, true, (Set)new THashSet(), false, dom.getResolveScope());
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil$1", "fun"));
            }
            return map;
        }
    });
    private static final PsiCacheKey<FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>, PsiClass> SIGNATURES_BY_NAME_KEY = PsiCacheKey.create((String)"SIGNATURES_BY_NAME_KEY", (Function)new Function<PsiClass, FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>>(){

        public FactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>> fun(final PsiClass psiClass) {
            return new ConcurrentFactoryMap<String, Map<MethodSignature, HierarchicalMethodSignature>>(){

                @Nullable
                protected Map<MethodSignature, HierarchicalMethodSignature> create(String methodName) {
                    return PsiSuperMethodImplUtil.buildMethodHierarchy(psiClass, methodName, PsiSubstitutor.EMPTY, true, (Set)new THashSet(), false, psiClass.getResolveScope());
                }
            };
        }
    });
    private static final Key<ParameterizedCachedValue<HierarchicalMethodSignature, PsiMethod>> HIERARCHICAL_SIGNATURE_KEY = Key.create((String)"HierarchicalMethodSignature");
    private static final ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod> HIERARCHICAL_SIGNATURE_PROVIDER = new ParameterizedCachedValueProvider<HierarchicalMethodSignature, PsiMethod>(){

        public CachedValueProvider.Result<HierarchicalMethodSignature> compute(PsiMethod method) {
            PsiClass aClass = method.getContainingClass();
            HierarchicalMethodSignatureImpl result2 = null;
            if (aClass != null) {
                result2 = (HierarchicalMethodSignature)((Map)((FactoryMap)SIGNATURES_BY_NAME_KEY.getValue((PsiElement)aClass)).get((Object)method.getName())).get(method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (result2 == null) {
                result2 = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)method.getSignature(PsiSubstitutor.EMPTY));
            }
            if (!(method.isPhysical() || method instanceof SyntheticElement || method instanceof LightElement)) {
                return CachedValueProvider.Result.create((Object)((Object)result2), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, method});
            }
            return CachedValueProvider.Result.create((Object)((Object)result2), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }
    };

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodsInternal"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
            }
            return list;
        }
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(@NotNull PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search((PsiMethod)method, (PsiClass)parentClass, (boolean)true, (boolean)allowStaticMethod).findAll());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findSuperMethodSignatures"));
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(@NotNull PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "canHaveSuperMethod"));
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethod"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
    }

    @NotNull
    public static PsiMethod[] findDeepestSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection collection = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        PsiMethod[] psiMethodArray = collection.toArray(new PsiMethod[collection.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(@NotNull PsiClass aClass, @Nullable String nameHint, @NotNull PsiSubstitutor substitutor, boolean includePrivates, @NotNull Set<PsiClass> visited, boolean isInRawContext, GlobalSearchScope resolveScope) {
        void var13_15;
        PsiMethod[] valuesMethod;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        ProgressManager.checkCanceled();
        LinkedHashMap result2 = new LinkedHashMap((EqualityPolicy)new EqualityPolicy<MethodSignature>(){

            public int getHashCode(MethodSignature object) {
                return object.hashCode();
            }

            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                if (o1.equals(o2)) {
                    PsiMethod method1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                    PsiType returnType1 = method1.getReturnType();
                    PsiMethod method2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                    PsiType returnType2 = method2.getReturnType();
                    if (method1.hasModifierProperty("static") || method2.hasModifierProperty("static")) {
                        return true;
                    }
                    if (MethodSignatureUtil.isReturnTypeSubstitutable((MethodSignature)o1, (MethodSignature)o2, (PsiType)returnType1, (PsiType)returnType2)) {
                        return true;
                    }
                    PsiClass containingClass1 = method1.getContainingClass();
                    PsiClass containingClass2 = method2.getContainingClass();
                    if (containingClass1 != null && containingClass2 != null) {
                        return containingClass1.isAnnotationType() || containingClass2.isAnnotationType();
                    }
                }
                return false;
            }
        });
        THashMap sameParameterErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashMap map = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<MethodSignature>((Map)sameParameterErasureMethods){
            final /* synthetic */ Map val$sameParameterErasureMethods;
            {
                this.val$sameParameterErasureMethods = map;
            }

            public int computeHashCode(MethodSignature signature) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)signature);
            }

            public boolean equals(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)o1, (Object)o2)) {
                    return false;
                }
                List list = (List)this.val$sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list != null && list.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure((PsiType)o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure((PsiType)o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        PsiMethod[] methods = aClass.getMethods();
        if ((nameHint == null || "values".equals(nameHint)) && aClass instanceof PsiClassImpl && (valuesMethod = ((PsiClassImpl)aClass).getValuesMethod()) != null) {
            methods = (PsiMethod[])ArrayUtil.append((Object[])methods, (Object)valuesMethod);
        }
        valuesMethod = methods;
        int n = valuesMethod.length;
        boolean bl = false;
        while (var13_15 < n) {
            PsiMethod method = valuesMethod[var13_15];
            if (!method.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)method, "class.valid=" + aClass.isValid() + "; name=" + method.getName());
            }
            if (!(nameHint != null && !nameHint.equals(method.getName()) || !includePrivates && method.hasModifierProperty("private"))) {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)isInRawContext);
                HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)substitutor, (boolean)isInRawContext));
                List list = (List)sameParameterErasureMethods.get(signature);
                if (list == null) {
                    list = new SmartList();
                    sameParameterErasureMethods.put(signature, list);
                }
                list.add(method);
                LOG.assertTrue(newH.getMethod().isValid());
                result2.put(signature, newH);
                map.put(signature, newH);
            }
            ++var13_15;
        }
        List<PsiClassType.ClassResolveResult> superTypes = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, resolveScope);
        for (PsiClassType.ClassResolveResult classResolveResult : superTypes) {
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || !visited.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = classResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodImplUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)superClass, (PsiSubstitutor)superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, nameHint, finalSubstitutor, false, visited, isInRawContextSuper, resolveScope);
            visited.remove(superClass);
            ArrayList<Pair> flattened = new ArrayList<Pair>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)hms.getMethod(), (PsiSubstitutor)hms.getSubstitutor(), (boolean)hms.isRaw());
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList supers = new ArrayList(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(Pair.create((Object)signature, (Object)aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass, (Map<MethodSignature, HierarchicalMethodSignature>)result2, (Map<MethodSignature, HierarchicalMethodSignatureImpl>)map, hms, (MethodSignature)signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass, (Map<MethodSignature, HierarchicalMethodSignature>)result2, (Map<MethodSignature, HierarchicalMethodSignatureImpl>)map, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)((Object)entry.getValue());
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result2.get(methodSignature) != null || !PsiUtil.isAccessible((Project)aClass.getProject(), (PsiMember)hierarchicalMethodSignature.getMethod(), (PsiElement)aClass, (PsiClass)aClass)) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(methodSignature, hierarchicalMethodSignature);
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "buildMethodHierarchy"));
        }
        return linkedHashMap;
    }

    private static void putInMap(@NotNull PsiClass aClass, @NotNull Map<MethodSignature, HierarchicalMethodSignature> result2, @NotNull Map<MethodSignature, HierarchicalMethodSignatureImpl> map, @NotNull HierarchicalMethodSignature hierarchicalMethodSignature, @NotNull MethodSignature signature) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "putInMap"));
        }
        if (!PsiUtil.isAccessible((Project)aClass.getProject(), (PsiMember)hierarchicalMethodSignature.getMethod(), (PsiElement)aClass, (PsiClass)aClass)) {
            return;
        }
        HierarchicalMethodSignatureImpl existing = map.get(signature);
        if (existing == null) {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy.getMethod().isValid());
            map.put(signature, copy);
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass, (MethodSignatureBackedByPsiMethod)hierarchicalMethodSignature, (MethodSignatureBackedByPsiMethod)existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            LOG.assertTrue(newSuper.getMethod().isValid());
            map.put(signature, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass, (MethodSignatureBackedByPsiMethod)existing, (MethodSignatureBackedByPsiMethod)hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result2.containsKey(signature)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        if (thisSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        if (thatSig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thatSig", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isReturnTypeIsMoreSpecificThan"));
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable((PsiType)thatRet, (PsiType)thisRet, (boolean)false);
    }

    private static void mergeSupers(@NotNull HierarchicalMethodSignatureImpl existing, @NotNull HierarchicalMethodSignature superSignature) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        if (superSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "mergeSupers"));
        }
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    private static boolean isSuperMethod(@NotNull PsiClass aClass, @NotNull MethodSignatureBackedByPsiMethod hierarchicalMethodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignatureHierarchical) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (hierarchicalMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchicalMethodSignature", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        if (superSignatureHierarchical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignatureHierarchical", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethod"));
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiMethod method = hierarchicalMethodSignature.getMethod();
        PsiClass containingClass = method.getContainingClass();
        if (!superMethod.isConstructor() && !aClass.equals(superClass) && PsiUtil.isAccessible((Project)aClass.getProject(), (PsiMember)superMethod, (PsiElement)aClass, (PsiClass)aClass) && MethodSignatureUtil.isSubsignature((MethodSignature)superSignatureHierarchical, (MethodSignature)hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("static") || superMethod.hasModifierProperty("default") && method.hasModifierProperty("static") && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)superClass, (boolean)true)) {
                    return false;
                }
                if (superMethod.hasModifierProperty("default") || method.hasModifierProperty("default")) {
                    return superMethod.equals(method) || !InheritanceUtil.isInheritorOrSelf((PsiClass)superClass, (PsiClass)containingClass, (boolean)true);
                }
                return true;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    return false;
                }
                if (!aClass.isInterface() && !InheritanceUtil.isInheritorOrSelf((PsiClass)superClass, (PsiClass)containingClass, (boolean)true)) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static HierarchicalMethodSignatureImpl copy(@NotNull HierarchicalMethodSignature hi) {
        if (hi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hi", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = hierarchicalMethodSignature;
        if (hierarchicalMethodSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "copy"));
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (superSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSubstitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        if (inRawContext) {
            Set typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(new PsiTypeParameter[typeParams.size()]));
        }
        THashMap map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new THashMap();
            }
            map.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance((Project)superClass.getProject()).getElementFactory().createSubstitutor(map);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "obtainFinalSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        Map<MethodSignature, HierarchicalMethodSignature> map = PsiSuperMethodImplUtil.getSignaturesMap(aClass);
        Collection<HierarchicalMethodSignature> collection = map.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getVisibleSignatures"));
        }
        return collection;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        Project project2 = method.getProject();
        HierarchicalMethodSignature hierarchicalMethodSignature = (HierarchicalMethodSignature)CachedValuesManager.getManager((Project)project2).getParameterizedCachedValue((UserDataHolder)method, HIERARCHICAL_SIGNATURE_KEY, HIERARCHICAL_SIGNATURE_PROVIDER, false, (Object)method);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        Map map = (Map)SIGNATURES_FOR_CLASS_KEY.getValue((PsiElement)aClass);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "getSignaturesMap"));
        }
        return map;
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method, @NotNull Processor<PsiMethod> superMethodProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        if (superMethodProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodProcessor", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "processDirectSuperMethodsSmart"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map cachedMap = (Map)((FactoryMap)SIGNATURES_BY_NAME_KEY.getValue((PsiElement)aClass)).get((Object)method.getName());
        HierarchicalMethodSignature signature = (HierarchicalMethodSignature)cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        if (signature != null) {
            List superSignatures = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process((Object)superSignature.getMethod())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSuperMethodSmart(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/psi/impl/PsiSuperMethodImplUtil", "isSuperMethodSmart"));
        }
        if (method == superMethod) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        PsiClass superClass = superMethod.getContainingClass();
        if (aClass == null || superClass == null || superClass == aClass) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map cachedMap = (Map)((FactoryMap)SIGNATURES_BY_NAME_KEY.getValue((PsiElement)aClass)).get((Object)method.getName());
        HierarchicalMethodSignature signature = (HierarchicalMethodSignature)cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        for (PsiMethod superCandidate : MethodSignatureUtil.convertMethodSignaturesToMethods((List)signature.getSuperSignatures())) {
            if (!superMethod.equals(superCandidate) && !PsiSuperMethodImplUtil.isSuperMethodSmart(superCandidate, superMethod)) continue;
            return true;
        }
        return false;
    }
}

