/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class InitialInferenceState {
    private final Set<InferenceVariable> myInferenceVariables = new HashSet<InferenceVariable>();
    private final PsiElement myContext;
    private final PsiSubstitutor myInferenceSubstitutor;
    private final PsiSubstitutor mySiteSubstitutor;
    private final List<Pair<PsiTypeParameter[], PsiClassType>> myCaptures;
    private final InferenceSessionContainer myInferenceSessionContainer;

    InitialInferenceState(Set<InferenceVariable> inferenceVariables, PsiSubstitutor topInferenceSubstitutor, PsiElement context, PsiSubstitutor inferenceSubstitutor, PsiSubstitutor siteSubstitutor, List<Pair<PsiTypeParameter[], PsiClassType>> captures, InferenceSessionContainer inferenceSessionContainer) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            PsiType substitute = topInferenceSubstitutor.substitute((PsiTypeParameter)inferenceVariable);
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitute);
            if (!(aClass instanceof InferenceVariable)) continue;
            this.myInferenceVariables.add((InferenceVariable)aClass);
            if (!inferenceSubstitutor.getSubstitutionMap().containsValue(PsiSubstitutor.EMPTY.substitute((PsiTypeParameter)inferenceVariable))) continue;
            substitutor = substitutor.put(inferenceVariable.getParameter(), substitute);
            subst = subst.put((PsiTypeParameter)inferenceVariable, substitute);
        }
        this.myInferenceSubstitutor = substitutor;
        this.myContext = context;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myCaptures = new ArrayList<Pair<PsiTypeParameter[], PsiClassType>>();
        for (Pair pair : captures) {
            PsiTypeParameter[] newParameters = new PsiTypeParameter[((PsiTypeParameter[])pair.first).length];
            PsiTypeParameter[] parameters = (PsiTypeParameter[])pair.first;
            for (int i = 0; i < parameters.length; ++i) {
                PsiType substitute = topInferenceSubstitutor.substitute(parameters[i]);
                newParameters[i] = (PsiTypeParameter)PsiUtil.resolveClassInClassTypeOnly((PsiType)substitute);
            }
            this.myCaptures.add((Pair<PsiTypeParameter[], PsiClassType>)Pair.create((Object)newParameters, (Object)((PsiClassType)subst.substitute((PsiType)pair.second))));
        }
        this.myInferenceSessionContainer = inferenceSessionContainer;
    }

    InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    Set<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    PsiSubstitutor getInferenceSubstitutor() {
        return this.myInferenceSubstitutor;
    }

    PsiSubstitutor getSiteSubstitutor() {
        return this.mySiteSubstitutor;
    }

    public List<Pair<PsiTypeParameter[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }
}

