/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.ClassMapCachingNulls;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageManagerImpl
extends InjectedLanguageManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl");
    private final Project myProject;
    private final DumbService myDumbService;
    private volatile DaemonProgressIndicator myProgress;
    private final Set<MultiHostInjector> myManualInjectors = Collections.synchronizedSet(new LinkedHashSet());
    private volatile ClassMapCachingNulls<MultiHostInjector> cachedInjectors;
    private final Map<Class, MultiHostInjector[]> myInjectorsClone = new HashMap<Class, MultiHostInjector[]>();

    public static InjectedLanguageManagerImpl getInstanceImpl(Project project2) {
        return (InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance((Project)project2);
    }

    public InjectedLanguageManagerImpl(Project project2, DumbService dumbService) {
        this.myProject = project2;
        this.myDumbService = dumbService;
        ExtensionPoint multiPoint = Extensions.getArea((AreaInstance)project2).getExtensionPoint(MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME);
        ((ExtensionPointImpl)multiPoint).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<MultiHostInjector>(){

            public void extensionAdded(@NotNull MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$1", "extensionAdded"));
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            public void extensionRemoved(@NotNull MultiHostInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$1", "extensionRemoved"));
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }
        }, false, (Disposable)this);
        ExtensionPointListener<LanguageInjector> myListener = new ExtensionPointListener<LanguageInjector>(){

            public void extensionAdded(@NotNull LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$2", "extensionAdded"));
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }

            public void extensionRemoved(@NotNull LanguageInjector extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$2", "extensionRemoved"));
                }
                InjectedLanguageManagerImpl.this.clearInjectorCache();
            }
        };
        ExtensionPoint psiManagerPoint = Extensions.getRootArea().getExtensionPoint(LanguageInjector.EXTENSION_POINT_NAME);
        ((ExtensionPointImpl)psiManagerPoint).addExtensionPointListener((ExtensionPointListener)myListener, false, (Disposable)this);
        this.myProgress = new DaemonProgressIndicator();
        project2.getMessageBus().connect((Disposable)this).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListenerAdapter(){

            public void daemonCancelEventOccurred(@NotNull String reason) {
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$3", "daemonCancelEventOccurred"));
                }
                InjectedLanguageManagerImpl.this.myProgress.cancel();
            }
        });
    }

    public void dispose() {
        this.myProgress.cancel();
        EditorWindowImpl.disposeInvalidEditors();
    }

    public void startRunInjectors(final @NotNull Document hostDocument, boolean synchronously) {
        if (hostDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostDocument", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "startRunInjectors"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!synchronously && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return;
        }
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        final PsiFile hostPsiFile = documentManager.getCachedPsiFile(hostDocument);
        if (hostPsiFile == null) {
            return;
        }
        final ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        if (injected.isEmpty()) {
            return;
        }
        if (this.myProgress.isCanceled()) {
            this.myProgress = new DaemonProgressIndicator();
        }
        final Set newDocuments = Collections.synchronizedSet(new THashSet());
        Processor<DocumentWindow> commitProcessor = new Processor<DocumentWindow>(){

            public boolean process(DocumentWindow documentWindow) {
                if (InjectedLanguageManagerImpl.this.myProject.isDisposed()) {
                    return false;
                }
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null && indicator.isCanceled()) {
                    return false;
                }
                if (documentManager.isUncommited(hostDocument) || !hostPsiFile.isValid()) {
                    return false;
                }
                InjectedLanguageUtil.enumerate(documentWindow, hostPsiFile, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$4$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$4$1", "visit"));
                        }
                        DocumentWindow newDocument = (DocumentWindow)injectedPsi.getViewProvider().getDocument();
                        if (newDocument != null) {
                            PsiDocumentManagerBase.checkConsistency(injectedPsi, (Document)newDocument);
                            newDocuments.add(newDocument);
                        }
                    }
                });
                return true;
            }
        };
        final Runnable commitInjectionsRunnable = new Runnable((Processor)commitProcessor, newDocuments){
            final /* synthetic */ Processor val$commitProcessor;
            final /* synthetic */ Set val$newDocuments;
            {
                this.val$commitProcessor = processor2;
                this.val$newDocuments = set;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (InjectedLanguageManagerImpl.this.myProgress.isCanceled()) {
                    return;
                }
                JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), InjectedLanguageManagerImpl.this.myProgress, true, this.val$commitProcessor);
                Object object = PsiLock.LOCK;
                synchronized (object) {
                    injected.clear();
                    injected.addAll((Collection)this.val$newDocuments);
                }
            }
        };
        if (synchronously) {
            if (Thread.holdsLock(PsiLock.LOCK)) {
                ContainerUtil.process(new ArrayList<DocumentWindow>((Collection<DocumentWindow>)injected), (Processor)commitProcessor);
            } else {
                commitInjectionsRunnable.run();
            }
        } else {
            JobLauncher.getInstance().submitToJobThread(new Runnable(){

                @Override
                public void run() {
                    ApplicationManagerEx.getApplicationEx().tryRunReadAction(commitInjectionsRunnable);
                }
            }, null);
        }
    }

    public PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        PsiElement host;
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getInjectionHost"));
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file2 == null ? null : file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow && (host = FileContextUtil.getFileContext(file2)) instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)host;
        }
        return null;
    }

    @NotNull
    public TextRange injectedToHost(@NotNull PsiElement injectedContext, @NotNull TextRange injectedTextRange) {
        if (injectedContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedContext", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
        }
        if (injectedTextRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedTextRange", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
        }
        PsiFile file2 = injectedContext.getContainingFile();
        if (file2 == null) {
            TextRange textRange = injectedTextRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
            }
            return textRange;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        if (!(document instanceof DocumentWindowImpl)) {
            TextRange textRange = injectedTextRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
            }
            return textRange;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        ProperTextRange properTextRange = documentWindow.injectedToHost(injectedTextRange);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
        }
        return properTextRange;
    }

    public int injectedToHost(@NotNull PsiElement element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "injectedToHost"));
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return offset;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        if (!(document instanceof DocumentWindowImpl)) {
            return offset;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        return documentWindow.injectedToHost(offset);
    }

    public void processInjectableElements(Collection<PsiElement> in, Processor<PsiElement> processor2) {
        ClassMapCachingNulls<MultiHostInjector> map = this.getInjectorMap();
        for (PsiElement element : in) {
            if (map.get(element.getClass()) == null) continue;
            processor2.process((Object)element);
        }
    }

    private ClassMapCachingNulls<MultiHostInjector> getInjectorMap() {
        ClassMapCachingNulls<MultiHostInjector> cached = this.cachedInjectors;
        if (cached != null) {
            return cached;
        }
        HashMap injectors = ContainerUtil.newHashMap();
        ArrayList allInjectors = ContainerUtil.newArrayList();
        allInjectors.addAll(this.myManualInjectors);
        Collections.addAll(allInjectors, MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)this.myProject));
        if (((LanguageInjector[])LanguageInjector.EXTENSION_POINT_NAME.getExtensions()).length > 0) {
            allInjectors.add(PsiManagerRegisteredInjectorsAdapter.INSTANCE);
        }
        for (MultiHostInjector injector : allInjectors) {
            for (Class place : injector.elementsToInjectIn()) {
                MultiHostInjector[] multiHostInjectorArray;
                LOG.assertTrue(place != null, (Object)injector);
                Object[] existing = (MultiHostInjector[])injectors.get(place);
                if (existing == null) {
                    MultiHostInjector[] multiHostInjectorArray2 = new MultiHostInjector[1];
                    multiHostInjectorArray = multiHostInjectorArray2;
                    multiHostInjectorArray2[0] = injector;
                } else {
                    multiHostInjectorArray = (MultiHostInjector[])ArrayUtil.append((Object[])existing, (Object)injector);
                }
                injectors.put(place, multiHostInjectorArray);
            }
        }
        ClassMapCachingNulls<MultiHostInjector> result2 = new ClassMapCachingNulls<MultiHostInjector>(injectors, new MultiHostInjector[0]);
        this.cachedInjectors = result2;
        return result2;
    }

    private void clearInjectorCache() {
        this.cachedInjectors = null;
    }

    public void registerMultiHostInjector(@NotNull MultiHostInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "registerMultiHostInjector"));
        }
        this.myManualInjectors.add(injector);
        this.clearInjectorCache();
    }

    public boolean unregisterMultiHostInjector(@NotNull MultiHostInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "unregisterMultiHostInjector"));
        }
        try {
            boolean bl = this.myManualInjectors.remove(injector);
            return bl;
        }
        finally {
            this.clearInjectorCache();
        }
    }

    public String getUnescapedText(@NotNull PsiElement injectedNode) {
        if (injectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedNode", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getUnescapedText"));
        }
        final StringBuilder text = new StringBuilder(injectedNode.getTextLength());
        injectedNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                String leafText = InjectedLanguageUtil.getUnescapedLeafText(element, false);
                if (leafText != null) {
                    text.append(leafText);
                    return;
                }
                super.visitElement(element);
            }
        });
        return text.toString();
    }

    @NotNull
    public List<TextRange> intersectWithAllEditableFragments(@NotNull PsiFile injectedPsi, @NotNull TextRange rangeToEdit) {
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "intersectWithAllEditableFragments"));
        }
        if (rangeToEdit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToEdit", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "intersectWithAllEditableFragments"));
        }
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        if (shreds == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "intersectWithAllEditableFragments"));
            }
            return list;
        }
        Object result2 = null;
        int count = 0;
        int offset = 0;
        Iterator iterator = shreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            TextRange encodedRange = TextRange.from((int)(offset + shred.getPrefix().length()), (int)shred.getRangeInsideHost().getLength());
            TextRange intersection = encodedRange.intersection(rangeToEdit);
            if (intersection != null) {
                if (++count == 1) {
                    result2 = intersection;
                } else if (count == 2) {
                    TextRange range = result2;
                    if (range.isEmpty()) {
                        result2 = intersection;
                        count = 1;
                    } else if (intersection.isEmpty()) {
                        count = 1;
                    } else {
                        ArrayList<TextRange> list = new ArrayList<TextRange>();
                        list.add(range);
                        list.add(intersection);
                        result2 = list;
                    }
                } else if (intersection.isEmpty()) {
                    --count;
                } else {
                    ((List)result2).add(intersection);
                }
            }
            offset += shred.getPrefix().length() + shred.getRangeInsideHost().getLength() + shred.getSuffix().length();
        }
        List<TextRange> list = count == 0 ? Collections.emptyList() : (count == 1 ? Collections.singletonList((TextRange)result2) : (List<TextRange>)result2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "intersectWithAllEditableFragments"));
        }
        return list;
    }

    public boolean isInjectedFragment(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "isInjectedFragment"));
        }
        return file2.getViewProvider() instanceof InjectedFileViewProvider;
    }

    public PsiElement findInjectedElementAt(@NotNull PsiFile hostFile, int hostDocumentOffset) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "findInjectedElementAt"));
        }
        return InjectedLanguageUtil.findInjectedElementNoCommit(hostFile, hostDocumentOffset);
    }

    public void dropFileCaches(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "dropFileCaches"));
        }
        InjectedLanguageUtil.clearCachedInjectedFragmentsForFile(file2);
    }

    public PsiFile getTopLevelFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getTopLevelFile"));
        }
        return InjectedLanguageUtil.getTopLevelFile(element);
    }

    @NotNull
    public List<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        if (hostPsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostPsiFile", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getCachedInjectedDocuments"));
        }
        ConcurrentList<DocumentWindow> concurrentList = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getCachedInjectedDocuments"));
        }
        return concurrentList;
    }

    public void enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "enumerate"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "enumerate"));
        }
        InjectedLanguageUtil.enumerate(host, visitor);
    }

    public void enumerateEx(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "enumerateEx"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "enumerateEx"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "enumerateEx"));
        }
        InjectedLanguageUtil.enumerate(host, containingFile, probeUp, visitor);
    }

    @NotNull
    public List<TextRange> getNonEditableFragments(@NotNull DocumentWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getNonEditableFragments"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        int offset = 0;
        Iterator iterator = ((DocumentWindowImpl)window).getShreds().iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            Segment hostRange = shred.getHostRangeMarker();
            if (hostRange == null) continue;
            offset = InjectedLanguageManagerImpl.appendRange(result2, offset, shred.getPrefix().length());
            offset += hostRange.getEndOffset() - hostRange.getStartOffset();
            offset = InjectedLanguageManagerImpl.appendRange(result2, offset, shred.getSuffix().length());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getNonEditableFragments"));
        }
        return arrayList;
    }

    private static int appendRange(List<TextRange> result2, int start, int length) {
        if (length > 0) {
            TextRange lastRange;
            int lastIndex = result2.size() - 1;
            TextRange textRange = lastRange = lastIndex >= 0 ? result2.get(lastIndex) : null;
            if (lastRange != null && lastRange.getEndOffset() == start) {
                result2.set(lastIndex, lastRange.grown(length));
            } else {
                result2.add(TextRange.from((int)start, (int)length));
            }
        }
        return start + length;
    }

    public static void pushInjectors(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "pushInjectors"));
        }
        InjectedLanguageManagerImpl cachedManager = (InjectedLanguageManagerImpl)((Object)project2.getUserData((Key)INSTANCE_CACHE));
        if (cachedManager == null) {
            return;
        }
        try {
            assert (cachedManager.myInjectorsClone.isEmpty()) : cachedManager.myInjectorsClone;
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
        cachedManager.myInjectorsClone.putAll(cachedManager.getInjectorMap().getBackingMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInjectorsAreDisposed(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "checkInjectorsAreDisposed"));
        }
        InjectedLanguageManagerImpl cachedManager = (InjectedLanguageManagerImpl)((Object)project2.getUserData((Key)INSTANCE_CACHE));
        if (cachedManager == null) {
            return;
        }
        try {
            ClassMapCachingNulls<MultiHostInjector> cached = cachedManager.cachedInjectors;
            if (cached == null) {
                return;
            }
            for (Map.Entry<Class, MultiHostInjector[]> entry : cached.getBackingMap().entrySet()) {
                Class key = entry.getKey();
                if (cachedManager.myInjectorsClone.isEmpty()) {
                    return;
                }
                Object[] oldInjectors = cachedManager.myInjectorsClone.get(key);
                for (MultiHostInjector injector : entry.getValue()) {
                    if (!ArrayUtil.contains((Object)injector, (Object[])oldInjectors)) {
                        throw new AssertionError((Object)("Injector was not disposed: " + key + " -> " + injector));
                    }
                }
            }
        }
        finally {
            cachedManager.myInjectorsClone.clear();
        }
    }

    public void processInPlaceInjectorsFor(@NotNull PsiElement element, @NotNull InjProcessor processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "processInPlaceInjectorsFor"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "processInPlaceInjectorsFor"));
        }
        MultiHostInjector[] infos = this.getInjectorMap().get(element.getClass());
        if (infos != null) {
            boolean dumb = this.myDumbService.isDumb();
            for (MultiHostInjector injector : infos) {
                if (dumb && !DumbService.isDumbAware((Object)injector) || processor2.process(element, injector)) continue;
                return;
            }
        }
    }

    @Nullable
    public List<Pair<PsiElement, TextRange>> getInjectedPsiFiles(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl", "getInjectedPsiFiles"));
        }
        if (!(host instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)host).isValidHost()) {
            return null;
        }
        final PsiElement inTree = InjectedLanguageUtil.loadTree(host, host.getContainingFile());
        SmartList result2 = new SmartList();
        InjectedLanguageUtil.enumerate(inTree, new PsiLanguageInjectionHost.InjectedPsiVisitor((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$8", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$8", "visit"));
                }
                for (PsiLanguageInjectionHost.Shred place : places) {
                    if (place.getHost() != inTree) continue;
                    this.val$result.add(new Pair((Object)injectedPsi, (Object)place.getRangeInsideHost()));
                }
            }
        });
        return result2.isEmpty() ? null : result2;
    }

    private static class PsiManagerRegisteredInjectorsAdapter
    implements MultiHostInjector {
        public static final PsiManagerRegisteredInjectorsAdapter INSTANCE = new PsiManagerRegisteredInjectorsAdapter();

        private PsiManagerRegisteredInjectorsAdapter() {
        }

        public void getLanguagesToInject(final @NotNull MultiHostRegistrar injectionPlacesRegistrar, @NotNull PsiElement context) {
            if (injectionPlacesRegistrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionPlacesRegistrar", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter", "getLanguagesToInject"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter", "getLanguagesToInject"));
            }
            final PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
            InjectedLanguagePlaces placesRegistrar = new InjectedLanguagePlaces(){

                public void addPlace(@NotNull Language language, @NotNull TextRange rangeInsideHost, @NonNls @Nullable String prefix, @NonNls @Nullable String suffix) {
                    if (language == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter$1", "addPlace"));
                    }
                    if (rangeInsideHost == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter$1", "addPlace"));
                    }
                    injectionPlacesRegistrar.startInjecting(language).addPlace(prefix, suffix, host, rangeInsideHost).doneInjecting();
                }
            };
            for (LanguageInjector injector : (LanguageInjector[])Extensions.getExtensions((ExtensionPointName)LanguageInjector.EXTENSION_POINT_NAME)) {
                injector.getLanguagesToInject(host, placesRegistrar);
            }
        }

        @NotNull
        public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class> list = Arrays.asList(PsiLanguageInjectionHost.class);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageManagerImpl$PsiManagerRegisteredInjectorsAdapter", "elementsToInjectIn"));
            }
            return list;
        }
    }

    public static interface InjProcessor {
        public boolean process(PsiElement var1, MultiHostInjector var2);
    }
}

