/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConcatenationInjectorManager
extends SimpleModificationTracker {
    public static final ExtensionPointName<ConcatenationAwareInjector> CONCATENATION_INJECTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.concatenationAwareInjector");
    private static final Key<ParameterizedCachedValue<MultiHostRegistrarImpl, PsiElement>> INJECTED_PSI_IN_CONCATENATION = Key.create((String)"INJECTED_PSI_IN_CONCATENATION");
    private static final Key<Integer> NO_CONCAT_INJECTION_TIMESTAMP = Key.create((String)"NO_CONCAT_INJECTION_TIMESTAMP");
    private final List<ConcatenationAwareInjector> myConcatenationInjectors = ContainerUtil.createLockFreeCopyOnWriteList();

    public JavaConcatenationInjectorManager(Project project2, PsiManagerEx psiManagerEx) {
        ExtensionPoint concatPoint = Extensions.getArea((AreaInstance)project2).getExtensionPoint(CONCATENATION_INJECTOR_EP_NAME);
        concatPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConcatenationAwareInjector>(){

            public void extensionAdded(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$1", "extensionAdded"));
                }
                JavaConcatenationInjectorManager.this.registerConcatenationInjector(injector);
            }

            public void extensionRemoved(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$1", "extensionRemoved"));
                }
                JavaConcatenationInjectorManager.this.unregisterConcatenationInjector(injector);
            }
        });
        psiManagerEx.registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                JavaConcatenationInjectorManager.this.incModificationCount();
            }
        });
    }

    public static JavaConcatenationInjectorManager getInstance(Project project2) {
        return (JavaConcatenationInjectorManager)((Object)ServiceManager.getService((Project)project2, JavaConcatenationInjectorManager.class));
    }

    private static Pair<PsiElement, PsiElement[]> computeAnchorAndOperandsImpl(@NotNull PsiElement context) {
        PsiElement anchor;
        PsiExpression[] operands;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "computeAnchorAndOperandsImpl"));
        }
        PsiElement element = context;
        PsiElement parent = context.getParent();
        while (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.PLUS || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType() == JavaTokenType.PLUSEQ || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != element || parent instanceof PsiTypeCastExpression || parent instanceof PsiParenthesizedExpression) {
            element = parent;
            parent = parent.getParent();
        }
        if (element instanceof PsiPolyadicExpression) {
            operands = ((PsiPolyadicExpression)element).getOperands();
            anchor = element;
        } else if (element instanceof PsiAssignmentExpression) {
            PsiExpression rExpression = ((PsiAssignmentExpression)element).getRExpression();
            operands = new PsiElement[]{rExpression == null ? element : rExpression};
            anchor = element;
        } else {
            operands = new PsiElement[]{context};
            anchor = context;
        }
        return Pair.create((Object)anchor, (Object)operands);
    }

    private static MultiHostRegistrarImpl doCompute(@NotNull PsiFile containingFile, @NotNull Project project2, @NotNull PsiElement anchor, @NotNull PsiElement[] operands) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "doCompute"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "doCompute"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "doCompute"));
        }
        if (operands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operands", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "doCompute"));
        }
        MultiHostRegistrarImpl registrar = new MultiHostRegistrarImpl(project2, containingFile, anchor);
        JavaConcatenationInjectorManager concatenationInjectorManager = JavaConcatenationInjectorManager.getInstance(project2);
        for (ConcatenationAwareInjector concatenationInjector : concatenationInjectorManager.myConcatenationInjectors) {
            concatenationInjector.getLanguagesToInject((MultiHostRegistrar)registrar, operands);
            if (registrar.getResult() == null) continue;
            break;
        }
        if (registrar.getResult() == null) {
            registrar = null;
        }
        return registrar;
    }

    public void registerConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "registerConcatenationInjector"));
        }
        this.myConcatenationInjectors.add(injector);
        this.concatenationInjectorsChanged();
    }

    public boolean unregisterConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injector", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager", "unregisterConcatenationInjector"));
        }
        boolean removed = this.myConcatenationInjectors.remove(injector);
        this.concatenationInjectorsChanged();
        return removed;
    }

    private void concatenationInjectorsChanged() {
        this.incModificationCount();
    }

    public static class Concatenation2InjectorAdapter
    extends BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private static final List<Class<PsiLiteralExpression>> LITERALS = Arrays.asList(PsiLiteralExpression.class);

        public Concatenation2InjectorAdapter(Project project2) {
            super(project2);
        }

        @Override
        public Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter", "computeAnchorAndOperands"));
            }
            return JavaConcatenationInjectorManager.computeAnchorAndOperandsImpl(context);
        }

        @NotNull
        public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class<PsiLiteralExpression>> list = LITERALS;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter", "elementsToInjectIn"));
            }
            return list;
        }
    }

    public static abstract class BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private final JavaConcatenationInjectorManager myManager;

        public BaseConcatenation2InjectorAdapter(Project project2) {
            this.myManager = JavaConcatenationInjectorManager.getInstance(project2);
        }

        public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$BaseConcatenation2InjectorAdapter", "getLanguagesToInject"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$BaseConcatenation2InjectorAdapter", "getLanguagesToInject"));
            }
            if (this.myManager.myConcatenationInjectors.isEmpty()) {
                return;
            }
            PsiFile containingFile = ((MultiHostRegistrarImpl)registrar).getHostPsiFile();
            Project project2 = containingFile.getProject();
            long modificationCount = PsiManager.getInstance((Project)project2).getModificationTracker().getModificationCount();
            Pair<PsiElement, PsiElement[]> pair = this.computeAnchorAndOperands(context);
            PsiElement anchor = (PsiElement)pair.first;
            PsiElement[] operands = (PsiElement[])pair.second;
            Integer noInjectionTimestamp = (Integer)anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP);
            ParameterizedCachedValue data = null;
            MultiHostRegistrarImpl result2 = operands.length == 0 || noInjectionTimestamp != null && (long)noInjectionTimestamp.intValue() == modificationCount ? null : ((data = (ParameterizedCachedValue)anchor.getUserData(INJECTED_PSI_IN_CONCATENATION)) == null ? JavaConcatenationInjectorManager.doCompute(containingFile, project2, anchor, operands) : (MultiHostRegistrarImpl)data.getValue((Object)context));
            if (result2 != null && result2.getResult() != null) {
                for (Pair<Place, PsiFile> p : result2.getResult()) {
                    ((MultiHostRegistrarImpl)registrar).addToResults((Place)((Object)p.first), (PsiFile)p.second, result2);
                }
                if (data == null) {
                    CachedValueProvider.Result cachedResult = CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, JavaConcatenationInjectorManager.getInstance(project2)});
                    data = CachedValuesManager.getManager((Project)project2).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<MultiHostRegistrarImpl, PsiElement>(){

                        public CachedValueProvider.Result<MultiHostRegistrarImpl> compute(PsiElement context) {
                            PsiFile containingFile1 = context.getContainingFile();
                            Project project1 = containingFile1.getProject();
                            Pair<PsiElement, PsiElement[]> pair = BaseConcatenation2InjectorAdapter.this.computeAnchorAndOperands(context);
                            MultiHostRegistrarImpl registrar = ((PsiElement[])pair.second).length == 0 ? null : JavaConcatenationInjectorManager.doCompute(containingFile1, project1, (PsiElement)pair.first, (PsiElement[])pair.second);
                            return registrar == null ? null : CachedValueProvider.Result.create((Object)registrar, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, JavaConcatenationInjectorManager.getInstance(project1)});
                        }
                    }, false);
                    ((PsiParameterizedCachedValue)data).setValue(cachedResult);
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)data);
                    if (anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP) != null) {
                        anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, null);
                    }
                }
            } else {
                if (anchor.getUserData(INJECTED_PSI_IN_CONCATENATION) != null) {
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, null);
                }
                anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, (Object)((int)modificationCount));
            }
        }

        protected abstract Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement var1);
    }
}

