/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.changeSignature.RenameChangeInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureGestureDetector
extends PsiTreeChangeAdapter
implements EditorFactoryListener,
Disposable {
    private final Map<VirtualFile, MyDocumentChangeAdapter> myListenerMap = new HashMap();
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeSignatureGestureDetector.class.getName()));
    private boolean myDeaf = false;
    private final FileDocumentManager myDocumentManager;
    private final PsiManager myPsiManager;
    private final FileEditorManager myFileEditorManager;
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public ChangeSignatureGestureDetector(PsiDocumentManager psiDocumentManager, FileDocumentManager documentManager, PsiManager psiManager, FileEditorManager fileEditorManager, Project project2) {
        this.myDocumentManager = documentManager;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myPsiManager = psiManager;
        this.myFileEditorManager = fileEditorManager;
        this.myProject = project2;
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this, (Disposable)this);
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)this, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                LOG.assertTrue(ChangeSignatureGestureDetector.this.myListenerMap.isEmpty(), (Object)ChangeSignatureGestureDetector.this.myListenerMap);
            }
        });
    }

    public static ChangeSignatureGestureDetector getInstance(Project project2) {
        return (ChangeSignatureGestureDetector)((Object)project2.getComponent(ChangeSignatureGestureDetector.class));
    }

    public boolean isChangeSignatureAvailable(@NotNull PsiElement element) {
        ChangeInfo currentInfo;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "isChangeSignatureAvailable"));
        }
        MyDocumentChangeAdapter adapter = this.myListenerMap.get(PsiUtilCore.getVirtualFile((PsiElement)element));
        return adapter != null && (currentInfo = adapter.getCurrentInfo()) != null && element.equals(adapter.getInitialChangeInfo().getMethod());
    }

    public void dismissForElement(PsiElement method) {
        PsiFile psiFile = method.getContainingFile();
        ChangeInfo initialChangeInfo = this.getInitialChangeInfo(psiFile);
        if (initialChangeInfo != null && initialChangeInfo.getMethod() == method) {
            this.clearSignatureChange(psiFile);
        }
    }

    public boolean containsChangeSignatureChange(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "containsChangeSignatureChange"));
        }
        return this.getChangeInfo(file2) != null;
    }

    @Nullable
    public ChangeInfo getChangeInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "getChangeInfo"));
        }
        MyDocumentChangeAdapter adapter = this.myListenerMap.get(file2.getVirtualFile());
        return adapter != null ? adapter.getCurrentInfo() : null;
    }

    @Nullable
    public ChangeInfo getInitialChangeInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "getInitialChangeInfo"));
        }
        MyDocumentChangeAdapter adapter = this.myListenerMap.get(file2.getVirtualFile());
        return adapter != null ? adapter.getInitialChangeInfo() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSignature(PsiFile file2, boolean silently) {
        try {
            LanguageChangeSignatureDetector detector;
            this.myDeaf = true;
            MyDocumentChangeAdapter changeBean = this.myListenerMap.get(file2.getVirtualFile());
            ChangeInfo currentInfo = changeBean.getCurrentInfo();
            if (currentInfo != null && (detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(currentInfo.getLanguage())).performChange(currentInfo, changeBean.getInitialChangeInfo(), changeBean.getInitialText(), silently)) {
                changeBean.reinit();
            }
        }
        finally {
            this.myDeaf = false;
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "beforeChildRemoval"));
        }
        PsiElement child = event.getChild();
        if (child instanceof PsiFile && (virtualFile = (psiFile = (PsiFile)child).getVirtualFile()) != null && this.myListenerMap.containsKey(virtualFile)) {
            Document document = this.myDocumentManager.getDocument(virtualFile);
            if (document != null) {
                this.removeDocListener(document, virtualFile);
            } else {
                this.myListenerMap.remove(virtualFile);
            }
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "childRemoved"));
        }
        this.change(event.getParent());
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "childReplaced"));
        }
        this.change(event.getChild());
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "childAdded"));
        }
        this.change(event.getChild());
    }

    private void change(PsiElement child) {
        MyDocumentChangeAdapter changeBean;
        if (this.myDeaf) {
            return;
        }
        if (child == null || !child.isValid()) {
            return;
        }
        PsiFile file2 = child.getContainingFile();
        if (file2 != null && (changeBean = this.myListenerMap.get(file2.getVirtualFile())) != null && changeBean.getInitialText() != null) {
            Editor editor = this.myFileEditorManager.getSelectedTextEditor();
            if (editor != null && TemplateManager.getInstance(this.myProject).getActiveTemplate(editor) != null) {
                return;
            }
            LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(child.getLanguage());
            if (detector == null) {
                return;
            }
            if (detector.ignoreChanges(child)) {
                return;
            }
            String currentSignature = detector.extractSignature(child, changeBean.getInitialChangeInfo());
            if (currentSignature == null) {
                changeBean.reinit();
            } else {
                changeBean.addSignature(currentSignature);
            }
        }
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "editorCreated"));
        }
        Editor editor = event.getEditor();
        if (editor.getProject() != this.myProject) {
            return;
        }
        this.addDocListener(editor.getDocument());
    }

    public void addDocListener(Document document) {
        if (document == null) {
            return;
        }
        VirtualFile file2 = this.myDocumentManager.getFile(document);
        if (file2 != null && file2.isValid() && !this.myListenerMap.containsKey(file2)) {
            PsiFile psiFile = this.myPsiManager.findFile(file2);
            if (psiFile == null || !psiFile.isPhysical()) {
                return;
            }
            MyDocumentChangeAdapter adapter = new MyDocumentChangeAdapter();
            document.addDocumentListener((DocumentListener)adapter);
            this.myListenerMap.put(file2, adapter);
        }
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "editorReleased"));
        }
        EditorEx editor = (EditorEx)event.getEditor();
        DocumentEx document = editor.getDocument();
        VirtualFile file2 = this.myDocumentManager.getFile((Document)document);
        if (file2 == null) {
            file2 = editor.getVirtualFile();
        }
        if (file2 != null && file2.isValid()) {
            for (FileEditor fileEditor : this.myFileEditorManager.getAllEditors(file2)) {
                if (!(fileEditor instanceof TextEditor) || ((TextEditor)fileEditor).getEditor() == editor) continue;
                return;
            }
        }
        this.removeDocListener(document, file2);
    }

    public void removeDocListener(Document document, VirtualFile file2) {
        MyDocumentChangeAdapter adapter = this.myListenerMap.remove(file2);
        if (adapter != null) {
            document.removeDocumentListener((DocumentListener)adapter);
        }
    }

    public void clearSignatureChange(PsiFile file2) {
        MyDocumentChangeAdapter adapter = this.myListenerMap.get(file2.getVirtualFile());
        if (adapter != null) {
            adapter.reinit();
        }
    }

    @Nullable
    private static ChangeInfo createCurrentChangeInfo(String signature, @NotNull ChangeInfo currentInfo, String initialName) {
        if (currentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInfo", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "createCurrentChangeInfo"));
        }
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(currentInfo.getLanguage());
        return detector != null ? detector.createNextChangeInfo(signature, currentInfo, initialName) : null;
    }

    @Nullable
    private static ChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/changeSignature/ChangeSignatureGestureDetector", "createInitialChangeInfo"));
        }
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        return detector != null ? detector.createInitialChangeInfo(element) : null;
    }

    public void dispose() {
    }

    private class MyDocumentChangeAdapter
    extends DocumentAdapter {
        @NonNls
        private final String PASTE_COMMAND_NAME = EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]);
        @NonNls
        private final String TYPING_COMMAND_NAME = EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]);
        private String myInitialText;
        private String myInitialName;
        private ChangeInfo myInitialChangeInfo;
        private ChangeInfo myCurrentInfo;
        private final List<String> mySignatures = new ArrayList<String>();

        public String getInitialText() {
            return this.myInitialText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo getCurrentInfo() {
            if (this.myInitialChangeInfo == null) {
                return null;
            }
            List<String> list = this.mySignatures;
            synchronized (list) {
                if (!this.mySignatures.isEmpty()) {
                    if (this.myCurrentInfo == null) {
                        this.myCurrentInfo = this.myInitialChangeInfo;
                    }
                    for (String signature : this.mySignatures) {
                        if (this.myInitialText.equals(signature)) {
                            this.reinit();
                            break;
                        }
                        try {
                            this.myCurrentInfo = ChangeSignatureGestureDetector.createCurrentChangeInfo(signature, this.myCurrentInfo, this.myInitialName);
                            if (this.myCurrentInfo != null) continue;
                            this.reinit();
                            break;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                        }
                    }
                    this.mySignatures.clear();
                }
            }
            if (this.myCurrentInfo instanceof RenameChangeInfo) {
                return this.myCurrentInfo;
            }
            return this.myInitialChangeInfo != null && this.myInitialChangeInfo.equals(this.myCurrentInfo) ? null : this.myCurrentInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSignature(String signature) {
            List<String> list = this.mySignatures;
            synchronized (list) {
                if (!this.mySignatures.contains(signature)) {
                    this.mySignatures.add(signature);
                }
            }
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (ChangeSignatureGestureDetector.this.myDeaf) {
                return;
            }
            if (DumbService.isDumb((Project)ChangeSignatureGestureDetector.this.myProject)) {
                return;
            }
            if (this.myInitialText == null) {
                Document document = e.getDocument();
                PsiDocumentManager documentManager = ChangeSignatureGestureDetector.this.myPsiDocumentManager;
                if (!documentManager.isUncommited(document)) {
                    ChangeInfo info;
                    PsiElement element;
                    CommandProcessor processor2 = CommandProcessor.getInstance();
                    String currentCommandName = processor2.getCurrentCommandName();
                    if (!(Comparing.strEqual((String)this.TYPING_COMMAND_NAME, (String)currentCommandName) || Comparing.strEqual((String)this.PASTE_COMMAND_NAME, (String)currentCommandName) || Comparing.strEqual((String)"Cut", (String)currentCommandName) || Comparing.strEqual((String)"Parameter Move", (String)currentCommandName) || Comparing.equal((Object)EditorActionUtil.DELETE_COMMAND_GROUP, (Object)processor2.getCurrentCommandGroupId()))) {
                        return;
                    }
                    PsiFile file2 = documentManager.getPsiFile(document);
                    if (file2 != null && (element = file2.findElementAt(e.getOffset())) != null && (info = ChangeSignatureGestureDetector.createInitialChangeInfo(element)) != null) {
                        PsiElement method = info.getMethod();
                        TextRange textRange = method.getTextRange();
                        if (document.getTextLength() <= textRange.getEndOffset()) {
                            return;
                        }
                        if (method instanceof PsiNameIdentifierOwner) {
                            this.myInitialName = ((PsiNameIdentifierOwner)method).getName();
                        }
                        this.myInitialText = document.getText(textRange);
                        this.myInitialChangeInfo = info;
                    }
                }
            }
        }

        public ChangeInfo getInitialChangeInfo() {
            return this.myInitialChangeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit() {
            List<String> list = this.mySignatures;
            synchronized (list) {
                this.mySignatures.clear();
            }
            this.myInitialText = null;
            this.myInitialName = null;
            this.myInitialChangeInfo = null;
            this.myCurrentInfo = null;
        }
    }
}

