/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor;
import com.intellij.refactoring.ui.YesNoPreviewUsagesDialog;

public class ExtractClassUtil {
    public static void askAndTurnRefsToSuper(Project project2, SmartPsiElementPointer classPointer, SmartPsiElementPointer interfacePointer) {
        PsiElement classElement = classPointer.getElement();
        PsiElement interfaceElement = interfacePointer.getElement();
        if (classElement instanceof PsiClass && classElement.isValid() && interfaceElement instanceof PsiClass && interfaceElement.isValid()) {
            PsiClass superClass = (PsiClass)interfaceElement;
            String superClassName = superClass.getName();
            String className = ((PsiClass)classElement).getName();
            String createdString = superClass.isInterface() ? RefactoringBundle.message((String)"interface.has.been.successfully.created", (Object[])new Object[]{superClassName}) : RefactoringBundle.message((String)"class.has.been.successfully.created", (Object[])new Object[]{superClassName});
            String message = createdString + "\n" + RefactoringBundle.message((String)"use.super.references.prompt", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), className, superClassName});
            YesNoPreviewUsagesDialog dialog = new YesNoPreviewUsagesDialog(RefactoringBundle.message((String)"analyze.and.replace.usages"), message, JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES, null, project2);
            if (dialog.showAndGet()) {
                boolean isPreviewUsages;
                JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES = isPreviewUsages = dialog.isPreviewUsages();
                TurnRefsToSuperProcessor processor2 = new TurnRefsToSuperProcessor(project2, (PsiClass)classElement, superClass, true);
                processor2.setPreviewUsages(isPreviewUsages);
                processor2.run();
            }
        }
    }
}

