/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ControlFlowWrapper {
    private static final Logger LOG = Logger.getInstance((String)("#" + ControlFlowWrapper.class.getName()));
    private final ControlFlow myControlFlow;
    private final int myFlowStart;
    private final int myFlowEnd;
    private boolean myGenerateConditionalExit;
    private Collection<PsiStatement> myExitStatements;
    private PsiStatement myFirstExitStatementCopy;
    private IntArrayList myExitPoints;

    public ControlFlowWrapper(Project project2, PsiElement codeFragment, PsiElement[] elements) throws PrepareFailedException {
        int flowEnd;
        int index;
        try {
            this.myControlFlow = ControlFlowFactory.getInstance(project2).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false, false);
        }
        catch (AnalysisCanceledException e) {
            throw new PrepareFailedException(RefactoringBundle.message((String)"extract.method.control.flow.analysis.failed"), e.getErrorElement());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.myControlFlow.toString());
        }
        int flowStart = -1;
        for (index = 0; index < elements.length && (flowStart = this.myControlFlow.getStartOffset(elements[index])) < 0; ++index) {
        }
        if (flowStart < 0) {
            flowStart = 0;
            flowEnd = 0;
        } else {
            index = elements.length - 1;
            while ((flowEnd = this.myControlFlow.getEndOffset(elements[index])) < 0) {
                --index;
            }
        }
        this.myFlowStart = flowStart;
        this.myFlowEnd = flowEnd;
        if (LOG.isDebugEnabled()) {
            LOG.debug("start offset:" + this.myFlowStart);
            LOG.debug("end offset:" + this.myFlowEnd);
        }
    }

    public PsiStatement getFirstExitStatementCopy() {
        return this.myFirstExitStatementCopy;
    }

    public Collection<PsiStatement> prepareExitStatements(PsiElement[] elements) throws ExitStatementsNotSameException {
        this.myExitPoints = new IntArrayList();
        this.myExitStatements = ControlFlowUtil.findExitPointsAndStatements(this.myControlFlow, this.myFlowStart, this.myFlowEnd, this.myExitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
        if (LOG.isDebugEnabled()) {
            LOG.debug("exit points:");
            for (int i = 0; i < this.myExitPoints.size(); ++i) {
                LOG.debug("  " + this.myExitPoints.get(i));
            }
            LOG.debug("exit statements:");
            for (PsiStatement exitStatement : this.myExitStatements) {
                LOG.debug("  " + exitStatement);
            }
        }
        if (this.myExitPoints.isEmpty()) {
            this.myExitPoints.add(this.myControlFlow.getEndOffset(elements[elements.length - 1]));
        }
        if (this.myExitPoints.size() != 1) {
            this.myGenerateConditionalExit = true;
            this.areExitStatementsTheSame();
        }
        return this.myExitStatements;
    }

    private void areExitStatementsTheSame() throws ExitStatementsNotSameException {
        if (this.myExitStatements.isEmpty()) {
            throw new ExitStatementsNotSameException();
        }
        PsiStatement first = null;
        for (PsiStatement statement2 : this.myExitStatements) {
            if (first == null) {
                first = statement2;
                continue;
            }
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)first, (PsiElement)statement2)) continue;
            throw new ExitStatementsNotSameException();
        }
        this.myFirstExitStatementCopy = (PsiStatement)first.copy();
    }

    public boolean isGenerateConditionalExit() {
        return this.myGenerateConditionalExit;
    }

    public Collection<PsiStatement> getExitStatements() {
        return this.myExitStatements;
    }

    @NotNull
    public PsiVariable[] getOutputVariables() {
        PsiVariable[] psiVariableArray = this.getOutputVariables(this.myGenerateConditionalExit);
        if (psiVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ControlFlowWrapper", "getOutputVariables"));
        }
        return psiVariableArray;
    }

    @NotNull
    public PsiVariable[] getOutputVariables(boolean collectVariablesAtExitPoints) {
        PsiVariable[] myOutputVariables = ControlFlowUtil.getOutputVariables(this.myControlFlow, this.myFlowStart, this.myFlowEnd, this.myExitPoints.toArray());
        if (collectVariablesAtExitPoints) {
            HashSet outputVariables = new HashSet(Arrays.asList(myOutputVariables));
            for (PsiStatement statement2 : this.myExitStatements) {
                statement2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)outputVariables){
                    final /* synthetic */ Set val$outputVariables;
                    {
                        this.val$outputVariables = set;
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        PsiVariable variable;
                        super.visitReferenceExpression(expression);
                        PsiElement resolved = expression.resolve();
                        if (resolved instanceof PsiVariable && this.isWrittenInside(variable = (PsiVariable)resolved)) {
                            this.val$outputVariables.add(variable);
                        }
                    }

                    private boolean isWrittenInside(PsiVariable variable) {
                        List<Instruction> instructions = ControlFlowWrapper.this.myControlFlow.getInstructions();
                        for (int i = ControlFlowWrapper.this.myFlowStart; i < ControlFlowWrapper.this.myFlowEnd; ++i) {
                            Instruction instruction = instructions.get(i);
                            if (!(instruction instanceof WriteVariableInstruction) || !variable.equals(((WriteVariableInstruction)instruction).variable)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
            myOutputVariables = outputVariables.toArray(new PsiVariable[outputVariables.size()]);
        }
        Arrays.sort(myOutputVariables, PsiUtil.BY_POSITION);
        if (myOutputVariables == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ControlFlowWrapper", "getOutputVariables"));
        }
        return myOutputVariables;
    }

    public boolean isReturnPresentBetween() {
        return ControlFlowUtil.returnPresentBetween(this.myControlFlow, this.myFlowStart, this.myFlowEnd);
    }

    private void removeParametersUsedInExitsOnly(PsiElement codeFragment, List<PsiVariable> inputVariables) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<PsiVariable> iterator = inputVariables.iterator();
        block0: while (iterator.hasNext()) {
            PsiVariable variable = iterator.next();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope)) {
                PsiClass psiClass;
                PsiElement element = ref.getElement();
                int elementOffset = this.myControlFlow.getStartOffset(element);
                if (elementOffset >= this.myFlowStart && elementOffset <= this.myFlowEnd && !ControlFlowWrapper.isInExitStatements(element, this.myExitStatements)) continue block0;
                if (elementOffset != -1 || (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) continue;
                TextRange textRange = psiClass.getTextRange();
                if (this.myControlFlow.getElement(this.myFlowStart).getTextOffset() > textRange.getStartOffset() || textRange.getEndOffset() > this.myControlFlow.getElement(this.myFlowEnd).getTextRange().getEndOffset()) continue;
                continue block0;
            }
            iterator.remove();
        }
    }

    private static boolean isInExitStatements(PsiElement element, Collection<PsiStatement> exitStatements) {
        for (PsiStatement exitStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)exitStatement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean needExitStatement(PsiStatement exitStatement) {
        if (exitStatement instanceof PsiContinueStatement) {
            int endOffset;
            PsiStatement statement2 = ((PsiContinueStatement)exitStatement).findContinuedStatement();
            if (statement2 == null) {
                return true;
            }
            if (statement2 instanceof PsiLoopStatement) {
                statement2 = ((PsiLoopStatement)statement2).getBody();
            }
            return (endOffset = this.myControlFlow.getEndOffset((PsiElement)statement2)) > this.myFlowEnd;
        }
        return true;
    }

    public List<PsiVariable> getInputVariables(PsiElement codeFragment, PsiElement[] elements, PsiVariable[] outputVariables) {
        ArrayList<PsiVariable> myInputVariables;
        List<PsiVariable> inputVariables = ControlFlowUtil.getInputVariables(this.myControlFlow, this.myFlowStart, this.myFlowEnd);
        if (this.skipVariablesFromExitStatements(outputVariables)) {
            ArrayList<PsiVariable> inputVariableList = new ArrayList<PsiVariable>(inputVariables);
            this.removeParametersUsedInExitsOnly(codeFragment, inputVariableList);
            myInputVariables = inputVariableList;
        } else {
            ArrayList<PsiVariable> inputVariableList = new ArrayList<PsiVariable>(inputVariables);
            Iterator iterator = inputVariableList.iterator();
            block0: while (iterator.hasNext()) {
                PsiVariable variable = (PsiVariable)iterator.next();
                for (PsiElement element : elements) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)variable, (boolean)false)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            myInputVariables = inputVariableList;
        }
        Collections.sort(myInputVariables, new Comparator<PsiVariable>(){

            @Override
            public int compare(PsiVariable v1, PsiVariable v2) {
                if (v1.getType() instanceof PsiEllipsisType) {
                    return 1;
                }
                if (v2.getType() instanceof PsiEllipsisType) {
                    return -1;
                }
                return v1.getTextOffset() - v2.getTextOffset();
            }
        });
        return myInputVariables;
    }

    public PsiStatement getExitStatementCopy(PsiElement returnStatement, PsiElement[] elements) {
        PsiStatement exitStatementCopy = null;
        for (PsiStatement exitStatement : this.myExitStatements) {
            int endOffset;
            if (exitStatement instanceof PsiReturnStatement) {
                if (!this.myGenerateConditionalExit) {
                    continue;
                }
            } else if (exitStatement instanceof PsiBreakStatement) {
                PsiStatement statement2 = ((PsiBreakStatement)exitStatement).findExitedStatement();
                if (statement2 == null) continue;
                int startOffset = this.myControlFlow.getStartOffset((PsiElement)statement2);
                endOffset = this.myControlFlow.getEndOffset((PsiElement)statement2);
                if (this.myFlowStart <= startOffset && endOffset <= this.myFlowEnd) {
                    continue;
                }
            } else if (exitStatement instanceof PsiContinueStatement) {
                PsiStatement statement3 = ((PsiContinueStatement)exitStatement).findContinuedStatement();
                if (statement3 == null) continue;
                int startOffset = this.myControlFlow.getStartOffset((PsiElement)statement3);
                endOffset = this.myControlFlow.getEndOffset((PsiElement)statement3);
                if (this.myFlowStart <= startOffset && endOffset <= this.myFlowEnd) {
                    continue;
                }
            } else {
                LOG.error(String.valueOf(exitStatement));
                continue;
            }
            int index = -1;
            for (int j = 0; j < elements.length; ++j) {
                if (!exitStatement.equals(elements[j])) continue;
                index = j;
                break;
            }
            if (exitStatementCopy == null && this.needExitStatement(exitStatement)) {
                exitStatementCopy = (PsiStatement)exitStatement.copy();
            }
            PsiElement result2 = exitStatement.replace(returnStatement);
            if (index < 0) continue;
            elements[index] = result2;
        }
        return exitStatementCopy;
    }

    public List<PsiVariable> getUsedVariables(int start) {
        return this.getUsedVariables(start, this.myControlFlow.getSize());
    }

    public List<PsiVariable> getUsedVariables(int start, int end) {
        return ControlFlowUtil.getUsedVariables(this.myControlFlow, start, end);
    }

    public Collection<ControlFlowUtil.VariableInfo> getInitializedTwice(int start) {
        return ControlFlowUtil.getInitializedTwice(this.myControlFlow, start, this.myControlFlow.getSize());
    }

    public List<PsiVariable> getUsedVariables() {
        return this.getUsedVariables(this.myFlowEnd);
    }

    public List<PsiVariable> getUsedVariablesInBody(PsiElement codeFragment, PsiVariable[] outputVariables) {
        List<PsiVariable> variables = this.getUsedVariables(this.myFlowStart, this.myFlowEnd);
        if (this.skipVariablesFromExitStatements(outputVariables)) {
            this.removeParametersUsedInExitsOnly(codeFragment, variables);
        }
        return variables;
    }

    private boolean skipVariablesFromExitStatements(PsiVariable[] outputVariables) {
        return this.myGenerateConditionalExit && outputVariables.length == 0;
    }

    public Collection<ControlFlowUtil.VariableInfo> getInitializedTwice() {
        return this.getInitializedTwice(this.myFlowEnd);
    }

    public void setGenerateConditionalExit(boolean generateConditionalExit) {
        this.myGenerateConditionalExit = generateConditionalExit;
    }

    public static class ExitStatementsNotSameException
    extends Exception {
    }
}

