/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectDialog
extends DialogWrapper
implements AbstractExtractDialog {
    private final Project myProject;
    private final PsiType myReturnType;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiType[] myExceptions;
    private final boolean myStaticFlag;
    private final boolean myCanBeStatic;
    private final PsiElement[] myElementsToExtract;
    private final boolean myMultipleExitPoints;
    private final InputVariables myVariableData;
    private final PsiClass myTargetClass;
    private final boolean myWasStatic;
    private JRadioButton myCreateInnerClassRb;
    private JRadioButton myCreateAnonymousClassWrapperRb;
    private JTextArea mySignatureArea;
    private JCheckBox myCbMakeStatic;
    private JCheckBox myCbMakeVarargs;
    private JCheckBox myCbMakeVarargsAnonymous;
    private JPanel myWholePanel;
    private JPanel myParametersTableContainer;
    private JRadioButton myPrivateRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPackageLocalRadioButton;
    private JRadioButton myPublicRadioButton;
    private EditorTextField myInnerClassName;
    private EditorTextField myMethodName;
    private JPanel myInnerClassPanel;
    private JPanel myAnonymousClassPanel;
    private JCheckBox myFoldCb;
    private ButtonGroup myVisibilityGroup;
    private VariableData[] myInputVariables;

    public ExtractMethodObjectDialog(Project project2, PsiClass targetClass, InputVariables inputVariables, PsiType returnType, PsiTypeParameterList typeParameterList, PsiType[] exceptions, boolean isStatic, boolean canBeStatic, PsiElement[] elementsToExtract, boolean multipleExitPoints) {
        super(project2, true);
        this.myProject = project2;
        this.myTargetClass = targetClass;
        this.myReturnType = returnType;
        this.myTypeParameterList = typeParameterList;
        this.myExceptions = exceptions;
        this.myStaticFlag = isStatic;
        this.myCanBeStatic = canBeStatic;
        this.myElementsToExtract = elementsToExtract;
        this.myMultipleExitPoints = multipleExitPoints;
        boolean canBeVarargs = false;
        this.$$$setupUI$$$();
        for (VariableData data : inputVariables.getInputVariables()) {
            canBeVarargs |= data.type instanceof PsiArrayType;
        }
        this.myWasStatic = canBeVarargs |= inputVariables.isFoldable() && inputVariables.isFoldingSelectedByDefault();
        this.myVariableData = inputVariables;
        this.setTitle("Extract Method Object");
        this.myCbMakeVarargs.setVisible(canBeVarargs);
        this.myCbMakeVarargsAnonymous.setVisible(canBeVarargs);
        this.init();
    }

    @Override
    public boolean isMakeStatic() {
        if (this.myStaticFlag) {
            return true;
        }
        if (!this.myCanBeStatic) {
            return false;
        }
        return this.myCbMakeStatic.isSelected();
    }

    @Override
    public boolean isChainedConstructor() {
        return false;
    }

    @Override
    public PsiType getReturnType() {
        return null;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    public String getChosenMethodName() {
        return this.myCreateInnerClassRb.isSelected() ? this.myInnerClassName.getText() : this.myMethodName.getText();
    }

    @Override
    public VariableData[] getChosenParameters() {
        return this.myInputVariables;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInnerClassName;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.extractMethodObject");
    }

    protected void doOKAction() {
        JCheckBox makeVarargsCb;
        ConflictsDialog conflictsDialog;
        PsiClass innerClass;
        MultiMap conflicts = new MultiMap();
        if (this.myCreateInnerClassRb.isSelected() && (innerClass = this.myTargetClass.findInnerClassByName(this.myInnerClassName.getText(), false)) != null) {
            conflicts.putValue((Object)innerClass, (Object)("Inner class " + this.myInnerClassName.getText() + " already defined in class " + this.myTargetClass.getName()));
        }
        if (conflicts.size() > 0 && !(conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts)).showAndGet()) {
            if (conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            return;
        }
        JCheckBox jCheckBox = makeVarargsCb = this.myCreateInnerClassRb.isSelected() ? this.myCbMakeVarargs : this.myCbMakeVarargsAnonymous;
        if (makeVarargsCb != null && makeVarargsCb.isSelected()) {
            VariableData data = this.myInputVariables[this.myInputVariables.length - 1];
            if (data.type instanceof PsiArrayType) {
                data.type = new PsiEllipsisType(((PsiArrayType)data.type).getComponentType());
            }
        }
        super.doOKAction();
    }

    private void updateVarargsEnabled() {
        boolean enabled;
        boolean bl = enabled = this.myInputVariables.length > 0 && this.myInputVariables[this.myInputVariables.length - 1].type instanceof PsiArrayType;
        if (this.myCreateInnerClassRb.isSelected()) {
            this.myCbMakeVarargs.setEnabled(enabled);
        } else {
            this.myCbMakeVarargsAnonymous.setEnabled(enabled);
        }
    }

    private void update() {
        this.myCbMakeStatic.setEnabled(this.myCreateInnerClassRb.isSelected() && this.myCanBeStatic && !this.myStaticFlag);
        this.updateSignature();
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)this.myProject);
        this.setOKActionEnabled(this.myCreateInnerClassRb.isSelected() && helper.isIdentifier(this.myInnerClassName.getText()) || !this.myCreateInnerClassRb.isSelected() && helper.isIdentifier(this.myMethodName.getText()));
    }

    @Override
    public String getVisibility() {
        if (this.myPublicRadioButton.isSelected()) {
            return "public";
        }
        if (this.myPackageLocalRadioButton.isSelected()) {
            return "packageLocal";
        }
        if (this.myProtectedRadioButton.isSelected()) {
            return "protected";
        }
        if (this.myPrivateRadioButton.isSelected()) {
            return "private";
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        this.mySignatureArea.setEditable(false);
        this.myCreateInnerClassRb.setSelected(true);
        ActionListener enableDisableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodObjectDialog.this.enable(ExtractMethodObjectDialog.this.myCreateInnerClassRb.isSelected());
            }
        };
        this.myCreateInnerClassRb.addActionListener(enableDisableListener);
        this.myCreateAnonymousClassWrapperRb.addActionListener(enableDisableListener);
        this.myCreateAnonymousClassWrapperRb.setEnabled(!this.myMultipleExitPoints);
        this.myFoldCb.setSelected(this.myVariableData.isFoldingSelectedByDefault());
        this.myFoldCb.setVisible(this.myVariableData.isFoldable());
        this.myVariableData.setFoldingAvailable(this.myFoldCb.isSelected());
        this.myInputVariables = this.myVariableData.getInputVariables().toArray(new VariableData[this.myVariableData.getInputVariables().size()]);
        this.myFoldCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodObjectDialog.this.myVariableData.setFoldingAvailable(ExtractMethodObjectDialog.this.myFoldCb.isSelected());
                ExtractMethodObjectDialog.access$402(ExtractMethodObjectDialog.this, ExtractMethodObjectDialog.this.myVariableData.getInputVariables().toArray(new VariableData[ExtractMethodObjectDialog.this.myVariableData.getInputVariables().size()]));
                ExtractMethodObjectDialog.this.myParametersTableContainer.removeAll();
                ExtractMethodObjectDialog.this.myParametersTableContainer.add((Component)ExtractMethodObjectDialog.this.createParametersPanel(), "Center");
                ExtractMethodObjectDialog.this.myParametersTableContainer.revalidate();
                ExtractMethodObjectDialog.this.updateSignature();
                ExtractMethodObjectDialog.this.updateVarargsEnabled();
            }
        });
        this.myParametersTableContainer.add((Component)this.createParametersPanel(), "Center");
        ActionListener updateSugnatureListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractMethodObjectDialog.this.updateSignature();
                IdeFocusManager.getInstance((Project)ExtractMethodObjectDialog.this.myProject).requestFocus((Component)((Object)(ExtractMethodObjectDialog.this.myCreateInnerClassRb.isSelected() ? ExtractMethodObjectDialog.this.myInnerClassName : ExtractMethodObjectDialog.this.myMethodName)), false);
            }
        };
        if (this.myStaticFlag || this.myCanBeStatic) {
            this.myCbMakeStatic.setEnabled(!this.myStaticFlag);
            this.myCbMakeStatic.setSelected(this.myStaticFlag);
            this.myCbMakeStatic.addActionListener(updateSugnatureListener);
        } else {
            this.myCbMakeStatic.setSelected(false);
            this.myCbMakeStatic.setEnabled(false);
        }
        this.updateVarargsEnabled();
        this.myCbMakeVarargs.setSelected(this.myWasStatic);
        this.myCbMakeVarargs.addActionListener(updateSugnatureListener);
        this.myCbMakeVarargsAnonymous.setSelected(this.myWasStatic);
        this.myCbMakeVarargsAnonymous.addActionListener(updateSugnatureListener);
        DocumentAdapter nameListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ExtractMethodObjectDialog.this.update();
            }
        };
        this.myInnerClassName.getDocument().addDocumentListener((DocumentListener)nameListener);
        this.myMethodName.getDocument().addDocumentListener((DocumentListener)nameListener);
        this.myPrivateRadioButton.setSelected(true);
        this.myCreateInnerClassRb.addActionListener(updateSugnatureListener);
        this.myCreateAnonymousClassWrapperRb.addActionListener(updateSugnatureListener);
        Enumeration<AbstractButton> visibilities = this.myVisibilityGroup.getElements();
        while (visibilities.hasMoreElements()) {
            visibilities.nextElement().addActionListener(updateSugnatureListener);
        }
        this.enable(true);
        return this.myWholePanel;
    }

    private void enable(boolean innerClassSelected) {
        UIUtil.setEnabled((Component)this.myInnerClassPanel, (boolean)innerClassSelected, (boolean)true);
        UIUtil.setEnabled((Component)this.myAnonymousClassPanel, (!innerClassSelected ? 1 : 0) != 0, (boolean)true);
        this.update();
    }

    private JComponent createParametersPanel() {
        return new ParameterTablePanel(this.myProject, this.myInputVariables, this.myElementsToExtract){

            @Override
            protected void updateSignature() {
                ExtractMethodObjectDialog.this.updateVarargsEnabled();
                ExtractMethodObjectDialog.this.updateSignature();
            }

            @Override
            protected void doEnterAction() {
                ExtractMethodObjectDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                ExtractMethodObjectDialog.this.doCancelAction();
            }

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ExtractMethodObjectDialog.this.isUsedAfter(variable);
            }
        };
    }

    protected boolean isUsedAfter(PsiVariable variable) {
        return false;
    }

    protected void updateSignature() {
        if (this.mySignatureArea == null) {
            return;
        }
        StringBuffer buffer = this.getSignature();
        this.mySignatureArea.setText(buffer.toString());
    }

    protected StringBuffer getSignature() {
        String INDENT = "    ";
        StringBuffer buffer = new StringBuffer();
        String visibilityString = VisibilityUtil.getVisibilityString((String)this.getVisibility());
        if (this.myCreateInnerClassRb.isSelected()) {
            buffer.append(visibilityString);
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            if (this.isMakeStatic()) {
                buffer.append("static ");
            }
            buffer.append("class ");
            buffer.append(this.myInnerClassName.getText());
            if (this.myTypeParameterList != null) {
                buffer.append(this.myTypeParameterList.getText());
                buffer.append(" ");
            }
            buffer.append("{\n");
            buffer.append("    ");
            buffer.append("public ");
            buffer.append(this.myInnerClassName.getText());
            this.methodSignature("    ", buffer);
            buffer.append("\n}");
        } else {
            buffer.append("new Object(){\n");
            buffer.append("    ");
            buffer.append("private ");
            buffer.append(PsiFormatUtil.formatType((PsiType)this.myReturnType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(" ");
            buffer.append(this.myMethodName.getText());
            this.methodSignature("    ", buffer);
            buffer.append("\n}.");
            buffer.append(this.myMethodName.getText());
            buffer.append("(");
            buffer.append(StringUtil.join((Object[])this.myInputVariables, (Function)new Function<VariableData, String>(){

                public String fun(VariableData variableData) {
                    return variableData.name;
                }
            }, (String)", "));
            buffer.append(")");
        }
        return buffer;
    }

    private void methodSignature(String INDENT, StringBuffer buffer) {
        buffer.append("(");
        int count = 0;
        String indent = "    ";
        for (int i = 0; i < this.myInputVariables.length; ++i) {
            VariableData data = this.myInputVariables[i];
            if (!data.passAsParameter) continue;
            PsiType type = data.type;
            if (i == this.myInputVariables.length - 1 && type instanceof PsiArrayType && (this.myCreateInnerClassRb.isSelected() && this.myCbMakeVarargs.isSelected() || this.myCreateAnonymousClassWrapperRb.isSelected() && this.myCbMakeVarargsAnonymous.isSelected())) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
            String typeText = type.getPresentableText();
            if (count > 0) {
                buffer.append(", ");
            }
            buffer.append("\n");
            buffer.append("    ");
            buffer.append(typeText);
            buffer.append(" ");
            buffer.append(data.name);
            ++count;
        }
        buffer.append(")");
        if (this.myExceptions.length > 0) {
            buffer.append("\n");
            buffer.append("throws\n");
            for (PsiType exception : this.myExceptions) {
                buffer.append(INDENT);
                buffer.append(PsiFormatUtil.formatType((PsiType)exception, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                buffer.append("\n");
            }
        }
        buffer.append("{}");
    }

    public boolean createInnerClass() {
        return this.myCreateInnerClassRb.isSelected();
    }

    static /* synthetic */ VariableData[] access$402(ExtractMethodObjectDialog x0, VariableData[] x1) {
        x0.myInputVariables = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextArea jTextArea;
        JCheckBox jCheckBox2;
        EditorTextField editorTextField;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        EditorTextField editorTextField2;
        JPanel jPanel3;
        JRadioButton jRadioButton6;
        JPanel jPanel4;
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateInnerClassRb = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Create inner class");
        jRadioButton6.setMnemonic('I');
        jRadioButton6.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInnerClassPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Class name:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jLabel.setMinimumSize(new Dimension(62, 24));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInnerClassName = editorTextField2 = new EditorTextField();
        jPanel3.add((Component)((Object)editorTextField2), new GridConstraints(0, 1, 1, 4, 0, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Visibility:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("private");
        jRadioButton5.setMnemonic('V');
        jRadioButton5.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)jRadioButton5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("protected");
        jRadioButton4.setMnemonic('O');
        jRadioButton4.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jRadioButton4, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackageLocalRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("package local");
        jRadioButton3.setMnemonic('K');
        jRadioButton3.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(1, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("public");
        jRadioButton2.setMnemonic('B');
        jRadioButton2.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(1, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbMakeVarargs = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Make varargs");
        jCheckBox4.setMnemonic('V');
        jCheckBox4.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(2, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbMakeStatic = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Make static");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(3, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreateAnonymousClassWrapperRb = jRadioButton = new JRadioButton();
        jRadioButton.setText("Create anonymous class");
        jRadioButton.setMnemonic('A');
        jRadioButton.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAnonymousClassPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Method name:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setMinimumSize(new Dimension(73, 24));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMethodName = editorTextField = new EditorTextField();
        jPanel2.add((Component)((Object)editorTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCbMakeVarargsAnonymous = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Make varargs");
        jCheckBox2.setMnemonic('V');
        jCheckBox2.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setMinimumSize(new Dimension(19, 40));
        jPanel4.add((Component)jBScrollPane, new GridConstraints(8, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySignatureArea = jTextArea = new JTextArea();
        jTextArea.setMinimumSize(new Dimension(0, 64));
        jBScrollPane.setViewportView(jTextArea);
        this.myParametersTableContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Signature preview");
        jPanel4.add((Component)titledSeparator, new GridConstraints(7, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myFoldCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("declare.folded.parameters"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Parameters");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        jLabel.setLabelFor((Component)((Object)editorTextField2));
        jLabel3.setLabelFor((Component)((Object)editorTextField));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton);
        this.myVisibilityGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

