/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.AbstractInplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceConstantPopup
extends AbstractInplaceIntroduceFieldPopup {
    private final String myInitializerText;
    private JCheckBox myReplaceAllCb;
    private JCheckBox myMoveToAnotherClassCb;

    public InplaceIntroduceConstantPopup(Project project2, Editor editor, PsiClass parentClass, PsiExpression expr, PsiLocalVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, PsiElement anchorElement, PsiElement anchorElementIfAll, OccurrenceManager occurrenceManager) {
        super(project2, editor, expr, (PsiVariable)localVariable, occurrences, typeSelectorManager, IntroduceConstantHandler.REFACTORING_NAME, parentClass, anchorElement, occurrenceManager, anchorElementIfAll);
        this.myInitializerText = InplaceIntroduceConstantPopup.getExprText(expr, localVariable);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myWholePanel.add((Component)this.getPreviewComponent(), gc);
        gc.gridy = 1;
        this.myWholePanel.add((Component)this.createRightPanel(), gc);
        gc.gridy = 2;
        this.myWholePanel.add((Component)this.createLeftPanel(), gc);
    }

    @Nullable
    private static String getExprText(PsiExpression expr, PsiLocalVariable localVariable) {
        String exprText;
        String string = exprText = expr != null ? expr.getText() : null;
        if (localVariable != null) {
            PsiExpression initializer = localVariable.getInitializer();
            return initializer != null ? initializer.getText() : exprText;
        }
        return exprText;
    }

    private JPanel createRightPanel() {
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints rgc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myReplaceAllCb = new JCheckBox("Replace all occurrences");
        this.myReplaceAllCb.setMnemonic('a');
        this.myReplaceAllCb.setFocusable(false);
        this.myReplaceAllCb.setVisible(((PsiExpression[])this.myOccurrences).length > 1);
        right.add((Component)this.myReplaceAllCb, rgc);
        return right;
    }

    private JPanel createLeftPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        this.myMoveToAnotherClassCb = new JCheckBox("Move to another class", JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS);
        this.myMoveToAnotherClassCb.setMnemonic('m');
        this.myMoveToAnotherClassCb.setFocusable(false);
        left.add((Component)this.myMoveToAnotherClassCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return left;
    }

    private String getSelectedVisibility() {
        if (this.myParentClass != null && this.myParentClass.isInterface()) {
            return "public";
        }
        String initialVisibility = JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY;
        if (initialVisibility == null) {
            initialVisibility = "public";
        }
        return initialVisibility;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(final String[] names, final PsiType psiType) {
        final PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        return (PsiVariable)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiField>(){

            public PsiField compute() {
                PsiElement anchorElementIfAll;
                PsiElement finalAnchorElement;
                PsiField field = elementFactory.createFieldFromText(psiType.getCanonicalText() + " " + InplaceIntroduceConstantPopup.this.chooseName(names, InplaceIntroduceConstantPopup.this.myParentClass.getLanguage()) + " = " + InplaceIntroduceConstantPopup.this.myInitializerText + ";", (PsiElement)InplaceIntroduceConstantPopup.this.myParentClass);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
                String visibility = InplaceIntroduceConstantPopup.this.getSelectedVisibility();
                if (visibility != null) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)visibility, (boolean)true);
                }
                for (finalAnchorElement = anchorElementIfAll = InplaceIntroduceConstantPopup.this.getAnchorElementIfAll(); finalAnchorElement != null && finalAnchorElement.getParent() != InplaceIntroduceConstantPopup.this.myParentClass; finalAnchorElement = finalAnchorElement.getParent()) {
                }
                PsiMember anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
                field = BaseExpressionToFieldHandler.ConvertToFieldRunnable.appendField((PsiExpression)InplaceIntroduceConstantPopup.this.myExpr, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, InplaceIntroduceConstantPopup.this.myParentClass, InplaceIntroduceConstantPopup.this.myParentClass, field, anchorMember);
                InplaceIntroduceConstantPopup.this.myFieldRangeStart = InplaceIntroduceConstantPopup.this.myEditor.getDocument().createRangeMarker(field.getTextRange());
                return field;
            }
        });
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceConstantDialog.createNameSuggestionGenerator((String)propName, (PsiExpression)(this.myExpr != null && ((PsiExpression)this.myExpr).isValid() ? (PsiExpression)this.myExpr : null), (JavaCodeStyleManager)JavaCodeStyleManager.getInstance((Project)this.myProject), null, (PsiClass)this.myParentClass).getSuggestedNameInfo((PsiType)defaultType).names;
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.STATIC_FINAL_FIELD;
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.myReplaceAllCb.isSelected();
    }

    @Override
    public void setReplaceAllOccurrences(boolean allOccurrences) {
        this.myReplaceAllCb.setSelected(allOccurrences);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/introduceField/InplaceIntroduceConstantPopup", "saveSettings"));
        }
        super.saveSettings(psiVariable);
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY = this.getSelectedVisibility();
    }

    @Override
    protected boolean performRefactoring() {
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS = this.myMoveToAnotherClassCb.isSelected();
        if (this.myMoveToAnotherClassCb.isSelected()) {
            this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    InplaceIntroduceConstantPopup.this.myEditor.putUserData(AbstractInplaceIntroducer.ACTIVE_INTRODUCE, (Object)InplaceIntroduceConstantPopup.this);
                    try {
                        IntroduceConstantHandler constantHandler = new IntroduceConstantHandler();
                        PsiLocalVariable localVariable = (PsiLocalVariable)InplaceIntroduceConstantPopup.this.getLocalVariable();
                        if (localVariable != null) {
                            constantHandler.invokeImpl(InplaceIntroduceConstantPopup.this.myProject, localVariable, InplaceIntroduceConstantPopup.this.myEditor);
                        } else {
                            constantHandler.invokeImpl(InplaceIntroduceConstantPopup.this.myProject, (PsiExpression)InplaceIntroduceConstantPopup.this.myExpr, InplaceIntroduceConstantPopup.this.myEditor);
                        }
                    }
                    finally {
                        InplaceIntroduceConstantPopup.this.myEditor.putUserData(InplaceRefactoring.INTRODUCE_RESTART, (Object)false);
                        InplaceIntroduceConstantPopup.this.myEditor.putUserData(AbstractInplaceIntroducer.ACTIVE_INTRODUCE, null);
                        InplaceIntroduceConstantPopup.this.releaseResources();
                        if (InplaceIntroduceConstantPopup.this.myLocalMarker != null) {
                            InplaceIntroduceConstantPopup.this.myLocalMarker.dispose();
                        }
                        if (InplaceIntroduceConstantPopup.this.myExprMarker != null) {
                            InplaceIntroduceConstantPopup.this.myExprMarker.dispose();
                        }
                    }
                }
            });
            return false;
        }
        return super.performRefactoring();
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.extractConstant";
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return handler2 instanceof IntroduceConstantHandler && super.startsOnTheSameElement(handler2, element);
    }

    @Override
    protected void performIntroduce() {
        final BaseExpressionToFieldHandler.Settings settings = new BaseExpressionToFieldHandler.Settings(this.getInputName(), (PsiExpression)this.getExpr(), (PsiExpression[])this.getOccurrences(), this.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, this.getSelectedVisibility(), (PsiLocalVariable)this.getLocalVariable(), this.getType(), true, this.myParentClass, false, false);
        new WriteCommandAction(this.myProject, this.getCommandName(), this.getCommandName(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/refactoring/introduceField/InplaceIntroduceConstantPopup$3", "run"));
                }
                if (InplaceIntroduceConstantPopup.this.getLocalVariable() != null) {
                    LocalToFieldHandler.IntroduceFieldRunnable fieldRunnable = new LocalToFieldHandler.IntroduceFieldRunnable(false, (PsiLocalVariable)InplaceIntroduceConstantPopup.this.getLocalVariable(), InplaceIntroduceConstantPopup.this.myParentClass, settings, true, (PsiExpression[])InplaceIntroduceConstantPopup.this.myOccurrences);
                    fieldRunnable.run();
                } else {
                    BaseExpressionToFieldHandler.ConvertToFieldRunnable convertToFieldRunnable = new BaseExpressionToFieldHandler.ConvertToFieldRunnable((PsiExpression)InplaceIntroduceConstantPopup.this.myExpr, settings, settings.getForcedType(), (PsiExpression[])InplaceIntroduceConstantPopup.this.myOccurrences, InplaceIntroduceConstantPopup.this.myOccurrenceManager, InplaceIntroduceConstantPopup.this.getAnchorElementIfAll(), InplaceIntroduceConstantPopup.this.getAnchorElement(), InplaceIntroduceConstantPopup.this.myEditor, InplaceIntroduceConstantPopup.this.myParentClass);
                    convertToFieldRunnable.run();
                }
            }
        }.execute();
    }

    @Override
    protected JComponent getComponent() {
        this.myReplaceAllCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InplaceIntroduceConstantPopup.this.restartInplaceIntroduceTemplate();
            }
        });
        return this.myWholePanel;
    }

    @Override
    protected String getActionName() {
        return "IntroduceConstant";
    }
}

