/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.xml.util.XmlStringUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameDialog");
    private SuggestedNameInfo mySuggestedNameInfo;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurences;
    private final JLabel myNewNamePrefix;
    private final String myHelpID;
    @NotNull
    private final PsiElement myPsiElement;
    private final PsiElement myNameSuggestionContext;
    private final Editor myEditor;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"rename.title");
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private final Map<AutomaticRenamerFactory, JCheckBox> myAutomaticRenamers;
    private String myOldName;

    public RenameDialog(@NotNull Project project2, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/RenameDialog", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/refactoring/rename/RenameDialog", "<init>"));
        }
        super(project2, true);
        this.myNewNamePrefix = new JLabel("");
        this.myAutomaticRenamers = new HashMap<AutomaticRenamerFactory, JCheckBox>();
        assert (psiElement.isValid());
        this.myPsiElement = psiElement;
        this.myNameSuggestionContext = nameSuggestionContext;
        this.myEditor = editor;
        this.setTitle(REFACTORING_NAME);
        this.createNewNameComponent();
        this.init();
        this.myNameLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)XmlTagUtilBase.escapeString((String)this.getLabelText(), (boolean)false)));
        boolean toSearchInComments = this.isToSearchInCommentsForRename();
        this.myCbSearchInComments.setSelected(toSearchInComments);
        if (this.myCbSearchTextOccurences.isEnabled()) {
            boolean toSearchForTextOccurences = this.isToSearchForTextOccurencesForRename();
            this.myCbSearchTextOccurences.setSelected(toSearchForTextOccurences);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.validateButtons();
        }
        this.myHelpID = RenamePsiElementProcessor.forElement(psiElement).getHelpID(psiElement);
    }

    public static void showRenameDialog(DataContext dataContext, RenameDialog dialog) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String name = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            dialog.performRename(name);
            dialog.close(0);
        } else {
            dialog.show();
        }
    }

    @NotNull
    protected String getLabelText() {
        String string = RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{this.getFullName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenameDialog", "getLabelText"));
        }
        return string;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/RenameDialog", "getPsiElement"));
        }
        return psiElement;
    }

    @Override
    protected boolean hasPreviewButton() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).showRenamePreviewButton(this.myPsiElement);
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean isToSearchForTextOccurencesForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchForTextOccurrences(this.myPsiElement);
    }

    protected boolean isToSearchInCommentsForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchInComments(this.myPsiElement);
    }

    protected String getFullName() {
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myPsiElement);
        return (UsageViewUtil.getType(this.myPsiElement) + " " + name).trim();
    }

    protected void createNewNameComponent() {
        String[] suggestedNames = this.getSuggestedNames();
        this.myOldName = UsageViewUtil.getShortName(this.myPsiElement);
        this.myNameSuggestionsField = new NameSuggestionsField(suggestedNames, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor){

            @Override
            protected boolean shouldSelectAll() {
                return RenameDialog.this.myEditor == null || RenameDialog.this.myEditor.getSettings().isPreselectRename();
            }
        };
        if (this.myPsiElement instanceof PsiFile && this.myEditor == null) {
            this.myNameSuggestionsField.selectNameWithoutExtension();
        }
        this.myNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                RenameDialog.this.processNewNameChanged();
            }
        };
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
    }

    protected void preselectExtension(int start, int end) {
        this.myNameSuggestionsField.select(start, end);
    }

    protected void processNewNameChanged() {
        this.validateButtons();
    }

    public String[] getSuggestedNames() {
        NameSuggestionProvider[] providers;
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        String initialName = VariableInplaceRenameHandler.getInitialName();
        if (initialName != null) {
            result2.add(initialName);
        }
        result2.add(UsageViewUtil.getShortName(this.myPsiElement));
        for (NameSuggestionProvider provider : providers = (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME)) {
            SuggestedNameInfo info = provider.getSuggestedNames(this.myPsiElement, this.myNameSuggestionContext, result2);
            if (info == null) continue;
            this.mySuggestedNameInfo = info;
            if (provider instanceof PreferrableNameSuggestionProvider && !((PreferrableNameSuggestionProvider)provider).shouldCheckOthers()) break;
        }
        return ArrayUtil.toStringArray(result2);
    }

    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurences.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        this.myNameLabel = new JLabel();
        panel.add((Component)this.myNameLabel, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, "".equals(this.myNewNamePrefix.getText()) ? 0 : 1);
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myNewNamePrefix, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 8, 0);
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 1.0;
        panel.add((Component)this.myNameSuggestionsField.getComponent(), gbConstraints);
        this.createCheckboxes(panel, gbConstraints);
        return panel;
    }

    protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(true);
        panel.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchTextOccurences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurences.setSelected(true);
        panel.add((Component)this.myCbSearchTextOccurences, gbConstraints);
        if (!TextOccurrencesUtil.isSearchTextOccurencesEnabled(this.myPsiElement)) {
            this.myCbSearchTextOccurences.setEnabled(false);
            this.myCbSearchTextOccurences.setSelected(false);
            this.myCbSearchTextOccurences.setVisible(false);
        }
        for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
            if (!factory.isApplicable(this.myPsiElement) || factory.getOptionName() == null) continue;
            gbConstraints.insets = new Insets(0, 0, 4, 0);
            gbConstraints.gridwidth = this.myAutomaticRenamers.size() % 2 == 0 ? 1 : 0;
            gbConstraints.gridx = this.myAutomaticRenamers.size() % 2;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            NonFocusableCheckBox checkBox = new NonFocusableCheckBox();
            checkBox.setText(factory.getOptionName());
            checkBox.setSelected(factory.isEnabled());
            panel.add((Component)checkBox, gbConstraints);
            this.myAutomaticRenamers.put(factory, (JCheckBox)checkBox);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    @Override
    protected void doAction() {
        LOG.assertTrue(this.myPsiElement.isValid());
        String newName = this.getNewName();
        this.performRename(newName);
    }

    public void performRename(String newName) {
        RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(this.myPsiElement);
        elementProcessor.setToSearchInComments(this.myPsiElement, this.isSearchInComments());
        if (this.myCbSearchTextOccurences.isEnabled()) {
            elementProcessor.setToSearchForTextOccurrences(this.myPsiElement, this.isSearchInNonJavaFiles());
        }
        if (this.mySuggestedNameInfo != null) {
            this.mySuggestedNameInfo.nameChosen(newName);
        }
        RenameProcessor processor2 = this.createRenameProcessor(newName);
        for (Map.Entry<AutomaticRenamerFactory, JCheckBox> e : this.myAutomaticRenamers.entrySet()) {
            e.getKey().setEnabled(e.getValue().isSelected());
            if (!e.getValue().isSelected()) continue;
            processor2.addRenamerFactory(e.getKey());
        }
        this.invokeRefactoring(processor2);
    }

    protected RenameProcessor createRenameProcessor(String newName) {
        return new RenameProcessor(this.getProject(), this.myPsiElement, newName, this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (Comparing.strEqual((String)this.getNewName(), (String)this.myOldName)) {
            throw new ConfigurationException(null);
        }
        if (!this.areButtonsValid()) {
            throw new ConfigurationException("'" + this.getNewName() + "' is not a valid identifier");
        }
        Function inputValidator = RenameInputValidatorRegistry.getInputErrorValidator((PsiElement)this.myPsiElement);
        if (inputValidator != null) {
            this.setErrorText((String)inputValidator.fun((Object)this.getNewName()));
        }
    }

    @Override
    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return RenameUtil.isValidName(this.myProject, this.myPsiElement, newName);
    }

    protected NameSuggestionsField getNameSuggestionsField() {
        return this.myNameSuggestionsField;
    }

    public JCheckBox getCbSearchInComments() {
        return this.myCbSearchInComments;
    }
}

