/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.remote.DockerMachineCommandException;
import com.intellij.remote.DockerMachineException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerSupport {
    @Nullable
    public static DockerSupport getInstance() {
        return (DockerSupport)ServiceManager.getService(DockerSupport.class);
    }

    public abstract boolean hasDockerMachine();

    @Deprecated
    @Nullable
    public abstract String getDockerMachineExecutable();

    @Deprecated
    public abstract void setDockerMachineExecutable(String var1);

    @NotNull
    public abstract List<String> getVMs() throws DockerMachineException, DockerMachineCommandException;

    @NotNull
    public abstract String getStatus(@NotNull String var1);

    public abstract void startMachine(@NotNull String var1);

    @NotNull
    public abstract ConnectionInfo getConnectionInfo(@NotNull String var1) throws DockerMachineException, DockerMachineCommandException;

    @NotNull
    public abstract ConnectionInfo getConnectionInfo();

    @NotNull
    public abstract List<String[]> getImages(@NotNull String var1);

    public final void startMachineWithProgressIndicator(@Nullable Project project2, final @NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/remote/DockerSupport", "startMachineWithProgressIndicator"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Void, RuntimeException>(){

            public Void compute() {
                ProgressManager.progress((String)("Starting Docker Machine '" + machineName + "'"));
                DockerSupport.this.startMachine(machineName);
                return null;
            }
        }, "Starting Docker Machine", true, project2);
    }

    public static class ConnectionInfo {
        @NotNull
        private final String myApiUrl;
        @Nullable
        private final String myCertificatesPath;

        public ConnectionInfo(@NotNull String apiUrl, @Nullable String certificatesPath) {
            if (apiUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apiUrl", "com/intellij/remote/DockerSupport$ConnectionInfo", "<init>"));
            }
            this.myApiUrl = apiUrl;
            this.myCertificatesPath = certificatesPath;
        }

        @NotNull
        public String getApiUrl() {
            String string = this.myApiUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/DockerSupport$ConnectionInfo", "getApiUrl"));
            }
            return string;
        }

        @Nullable
        public String getCertificatesPath() {
            return this.myCertificatesPath;
        }
    }
}

