/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoteServersViewImpl
extends RemoteServersView {
    @NotNull
    private final Project myProject;

    public RemoteServersViewImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/RemoteServersViewImpl", "<init>"));
        }
        this.myProject = project2;
    }

    @Override
    public void showServerConnection(final @NotNull ServerConnection<?> connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/RemoteServersViewImpl", "showServerConnection"));
        }
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Application Servers");
        if (toolWindow != null) {
            toolWindow.activate(new Runnable(){

                @Override
                public void run() {
                    ServersToolWindowContent content = RemoteServersViewImpl.getServersViewComponent(toolWindow);
                    if (content != null) {
                        content.select(connection);
                    }
                }
            });
        }
    }

    private static ServersToolWindowContent getServersViewComponent(ToolWindow toolWindow) {
        return (ServersToolWindowContent)UIUtil.findComponentOfType((JComponent)toolWindow.getComponent(), ServersToolWindowContent.class);
    }

    @Override
    public void showDeployment(final @NotNull ServerConnection<?> connection, final @NotNull String deploymentName) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/RemoteServersViewImpl", "showDeployment"));
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentName", "com/intellij/remoteServer/impl/runtime/ui/RemoteServersViewImpl", "showDeployment"));
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        final ToolWindow toolWindow = toolWindowManager.getToolWindow("Application Servers");
        if (toolWindow != null) {
            toolWindowManager.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServersToolWindowContent component = RemoteServersViewImpl.getServersViewComponent(toolWindow);
                    if (component != null) {
                        component.select(connection, deploymentName);
                    }
                }
            });
        }
    }
}

