/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowFactory
implements ToolWindowFactory,
Condition<Project> {
    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowFactory", "createToolWindowContent"));
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ServersToolWindowContent serversContent = new ServersToolWindowContent(project2);
        Content content = contentFactory.createContent((JComponent)serversContent.getMainPanel(), null, false);
        Disposer.register((Disposable)content, (Disposable)serversContent);
        toolWindow.getContentManager().addContent(content);
    }

    public boolean value(Project project2) {
        return ServersToolWindowFactory.isAvailable(project2);
    }

    public static boolean isAvailable(Project project2) {
        if (!RemoteServersManager.getInstance().getServers().isEmpty()) {
            return true;
        }
        for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
            if (!contributor.canContribute(project2)) continue;
            return true;
        }
        return false;
    }
}

