/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowFactory;
import icons.RemoteServersIcons;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindowManager
extends AbstractProjectComponent {
    public static final String WINDOW_ID = "Application Servers";

    public ServersToolWindowManager(Project project2) {
        super(project2);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                ServersToolWindowManager.this.setupListeners();
            }
        });
    }

    public void setupListeners() {
        for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
            contributor.setupAvailabilityListener(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ServersToolWindowManager.this.updateWindowAvailable(true);
                }
            });
        }
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager$3", "serverAdded"));
                }
                ServersToolWindowManager.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager$3", "serverRemoved"));
                }
                ServersToolWindowManager.this.updateWindowAvailable(false);
            }
        });
    }

    private void updateWindowAvailable(final boolean showIfAvailable) {
        final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean doShow;
                boolean available = ServersToolWindowFactory.isAvailable(ServersToolWindowManager.this.myProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(ServersToolWindowManager.WINDOW_ID);
                if (toolWindow == null) {
                    if (available) {
                        ServersToolWindowManager.createToolWindow(ServersToolWindowManager.this.myProject, toolWindowManager).show(null);
                    }
                    return;
                }
                boolean bl = doShow = !toolWindow.isAvailable() && available;
                if (toolWindow.isAvailable() && !available) {
                    toolWindow.hide(null);
                }
                toolWindow.setAvailable(available, null);
                if (showIfAvailable && doShow) {
                    toolWindow.show(null);
                }
            }
        });
    }

    private static ToolWindow createToolWindow(Project project2, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(WINDOW_ID, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(RemoteServersIcons.ServersToolWindow);
        new ServersToolWindowFactory().createToolWindowContent(project2, toolWindow);
        return toolWindow;
    }

    @NotNull
    public String getComponentName() {
        if ("ServersToolWindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindowManager", "getComponentName"));
        }
        return "ServersToolWindowManager";
    }
}

