/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import kotlin.Charsets;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"9\u0015\u0001Q!\u0001\u0005\b\u000b\u0005a\u0011!B\u0001\u0005\t\u0015\t\u0001\"A\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"C\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u00015U\u0001\u0002B\u0007\u0006!\u0013)\"\u0001$\u0001\u0019\u0003a\tQ#\u0001\r\u0002)\u000e\u0015QR\u0002\u0005\u0006\u001b\u0005AZ!F\u0001\u0019\u0003Q\u001b)!\u0004\u0007\t\r5\t\u0001$A\u000b\u00021\u0005IJ\u0001#\u0004\u000e\u0003a\t\u0001k!\u0001U\u0007\u000bii\u0001C\u0004\u000e\u0003a\tQ#\u0001\r\u0002)\u000e\u0015QR\u0002E\b\u001b\u0005A\u0002\"F\u0001\u0019\u0003Q\u001b)!d\u0004\t\u00125\u0011A\u0012\u0001\r\n+\u0005A\u0012\u0001VB\u0003\u001b\u001bA\u0019\"D\u0001\u0019\u0011U\t\u0001$\u0001+\u0004\u000655\u0001BC\u0007\u00021!)\u0012\u0001G\u0001U\u0007\u000bii\u0001#\u0006\u000e\u0003aYQ#\u0001\r\u0002)\u000e\u0015QR\u0003E\f\u001b\u0015\u0001J!\u0006\u0002\r\u0002aa\u0001\u0004D\u000b\u00021\u0005!6QAG\u0007\u00113i\u0011\u0001'\u0001\u0016\u0003a\tAk!\u0002\u000e\u000e!iQ\"\u0001M\u0006+\u0005A\u0012\u0001VB\u0003\u001b1AY\"D\u0001\u0019\u0003U\t\u0001$AM\u0005\u00119i\u0011\u0001\u0007\u0007Q\u0007\u0003!6QAG\u0016\u0011;iQ\u0001%\u0003\u0016\u00051\u0005\u0001d\u0004\r\u0010+\u0005Ar\"'\u0003\t 5\t\u0001\u0014\u0001)\u0004\u0002e%\u0001BD\u0007\u00021\u0003\u00016!\u0001+\u0004\u00065\r\u0002RD\u0007\u00021\u0005)\u0012\u0001G\u0001\u001a\n!}Q\"\u0001M\u0001!\u000e\u0005\u0011\u0014\u0002\u0005\u000f\u001b\u0005AB\u0002U\u0002\u0002)\u000e\u0015Q2\u0005E\u000f\u001b\u0005A\u0012!F\u0001\u0019\u0003e%\u0001rD\u0007\u00021\u0003\u00016\u0011AM\u0005\u00119i\u0011\u0001'\u0001Q\u0007\u0005!6QAI\u000e\t\rC\u0001\u0002A\u0007\u00021\u0003)\u0012\u0001G\u0001\u001dGE\u001b1!\u0004\u0002\u0005\u0004!\u0011Ak!\u0002\u0012\u001c\u0011\u0019\u0005\u0002C\u0002\u000e\u0003a\u0005Q#\u0001\r\u00029\r\n6aA\u0007\u0003\t\u000fA!\u0001VB\u0003"}, strings={"parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "PathKt", "systemIndependentPath", "getSystemIndependentPath", "createDirectories", "kotlin.jvm.PlatformType", "createFile", "", "createSymbolicLink", "target", "deleteRecursively", "exists", "", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "isDirectory", "isFile", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readText", "refreshVfs", "write", "data", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath"}, moduleName="testFramework")
public final class PathKt {
    public static final boolean exists(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    public static final Path createDirectories(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.createDirectories($receiver, new FileAttribute[0]);
    }

    @NotNull
    public static final OutputStream outputStream(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    @NotNull
    public static final Path createSymbolicLink(Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    @NotNull
    public static final Path deleteRecursively(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PathKt.exists($receiver) ? Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                this.deleteFile(file2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                this.deleteFile(dir);
                return FileVisitResult.CONTINUE;
            }

            private final void deleteFile(Path file2) {
                try {
                    Files.delete(file2);
                }
                catch (Exception e) {
                    FileUtil.delete((File)file2.toFile());
                }
            }
        }) : $receiver;
    }

    @Nullable
    public static final FileTime getLastModifiedTime(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.getLastModifiedTime($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final String getSystemIndependentPath(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        if (path == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
    }

    public static final byte[] readBytes(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.readAllBytes($receiver);
    }

    @NotNull
    public static final String readText(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ArraysKt.toString((byte[])PathKt.readBytes($receiver), (Charset)Charsets.getUTF_8());
    }

    public static final VirtualFile writeChild(VirtualFile $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return VfsTestUtil.createFile($receiver, relativePath, data);
    }

    @NotNull
    public static final Path writeChild(Path $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.write($receiver.resolve(relativePath), data);
    }

    @NotNull
    public static final Path writeChild(Path $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return PathKt.writeChild($receiver, relativePath, StringsKt.toByteArray$default((String)data, null, (int)1));
    }

    @NotNull
    public static final Path write(Path $receiver, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Path path3 = Files.write($receiver, data, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.write(this, data)");
        return path3;
    }

    public static final boolean isDirectory(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    public static final void createFile(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path = $receiver.getParent();
        Path path2 = path != null ? PathKt.createDirectories(path) : null;
        Files.createFile($receiver, new FileAttribute[0]);
    }

    public static final void refreshVfs(Path $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            LocalFileSystem $receiver$iv = localFileSystem;
            LocalFileSystem fs = $receiver$iv;
            VirtualFile virtualFile = fs.findFileByPath(PathKt.getSystemIndependentPath($receiver));
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }
}

