/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.ApplicationRule;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PathKt;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ProjectRule;
import com.intellij.testFramework.TemporaryDirectoryKt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0001\u0019\u0001\u0001z!G\u0001\u0019\u0002u\u0005y!)\u0002R\u0007\u0005A\u0011!\n\u0003\u0005\u0017!5Q\"\u0001\r\bS)!1\t\u0003E\u0002\u001b\u0005A\"\u0001H\u0012R\u0007\ri!\u0001\"\u0002\t\u0007%RAa\u0011\u0005\t\b5\t\u0001\u0004\u0002\u000f$#\u000e\u0019QB\u0001C\u0005\u0011\u0015I3\u0002B\"\t\u0011\u0017i!\u0001$\u0001\u0019\tq\u0019\u0013kA\u0002\u000e\u0005\u00111\u0001\"\u0002"}, strings={"Lcom/intellij/testFramework/ProjectRule;", "Lcom/intellij/testFramework/ApplicationRule;", "()V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/ex/ProjectEx;", "getProject", "()Lcom/intellij/openapi/project/ex/ProjectEx;", "projectIfOpened", "getProjectIfOpened", "after", "", "Companion"}, moduleName="testFramework")
public final class ProjectRule
extends ApplicationRule {
    private static ProjectEx sharedProject;
    private static final AtomicBoolean projectOpened;
    public static final Companion Companion;

    public void after() {
        if (ProjectRule.Companion.getProjectOpened().compareAndSet(true, false)) {
            Unit unit;
            ProjectEx projectEx = ProjectRule.Companion.getSharedProject();
            if (projectEx != null) {
                ProjectEx $receiver$iv = projectEx;
                ProjectEx it = $receiver$iv;
                EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(it){
                    final /* synthetic */ ProjectEx $it;

                    public final void invoke() {
                        ProjectManager projectManager = ProjectManager.getInstance();
                        if (projectManager == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.impl.ProjectManagerImpl");
                        }
                        ((ProjectManagerImpl)projectManager).closeProject(this.$it, false, false, false);
                    }
                    {
                        this.$it = projectEx;
                        super(0);
                    }
                }));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    @Nullable
    public final ProjectEx getProjectIfOpened() {
        return ProjectRule.Companion.getProjectOpened().get() ? ProjectRule.Companion.getSharedProject() : (ProjectEx)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ProjectEx getProject() {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = ProjectRule.Companion.getSharedProject();
        if ((ProjectEx)result2.element == null) {
            IdeaTestApplication ideaTestApplication = IdeaTestApplication.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaTestApplication, (String)"IdeaTestApplication.getInstance()");
            IdeaTestApplication lock$iv = ideaTestApplication;
            synchronized (lock$iv) {
                result2.element = ProjectRule.Companion.getSharedProject();
                if ((ProjectEx)result2.element == null) {
                    result2.element = ProjectRule.Companion.createLightProject();
                    ProjectRule.Companion.setSharedProject((ProjectEx)result2.element);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        if (ProjectRule.Companion.getProjectOpened().compareAndSet(false, true)) {
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ProjectRule this$0;

                public final void invoke() {
                    ProjectManagerEx.getInstanceEx().openTestProject(this.this$0.getProject());
                }
                {
                    this.this$0 = projectRule;
                    super(0);
                }
            }));
        }
        ProjectEx projectEx = (ProjectEx)result2.element;
        if (projectEx == null) {
            Intrinsics.throwNpe();
        }
        return projectEx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Module getModule() {
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.getProject();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = FixtureRuleKt.access$getSharedModule$p();
        if ((Module)result2.element == null) {
            void project2;
            EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef)project2, (Ref.ObjectRef)result2){
                final /* synthetic */ Ref.ObjectRef $project;
                final /* synthetic */ Ref.ObjectRef $result;

                public final void invoke() {
                    new LightProjectDescriptor().setUpProject((ProjectEx)this.$project.element, new LightProjectDescriptor.SetupHandler(this){
                        final /* synthetic */ module.1 this$0;

                        public void moduleCreated(@NotNull Module module2) {
                            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                            this.this$0.$result.element = module2;
                            FixtureRuleKt.access$setSharedModule$p(module2);
                        }

                        public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
                            Intrinsics.checkParameterIsNotNull((Object)sourceRoot, (String)"sourceRoot");
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                {
                    this.$project = objectRef;
                    this.$result = objectRef2;
                    super(0);
                }
            }));
        }
        Module module2 = (Module)result2.element;
        if (module2 == null) {
            Intrinsics.throwNpe();
        }
        return module2;
    }

    static {
        Companion = com.intellij.testFramework.ProjectRule$Companion.INSTANCE;
        projectOpened = new AtomicBoolean();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\t\u0001\"\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)C\u0001B\u0001\t\u000e5\t\u0001\u0004B\u0013\u0005\t\u0005Aq!D\u0001\u0019\u0010%ZA!\u0011\u0005\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!K\b\u0005\u0003rA9!\u0004\u0002\r\u0002a!\u0011k\u0001\u0005\u0006\u00031\u0005QB\u0001C\u0005\u0011\u0015\t\"\u0001b\u0003\t\r\u0001"}, strings={"Lcom/intellij/testFramework/ProjectRule$Companion;", "", "()V", "projectOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getProjectOpened", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "sharedProject", "Lcom/intellij/openapi/project/ex/ProjectEx;", "getSharedProject", "()Lcom/intellij/openapi/project/ex/ProjectEx;", "setSharedProject", "(Lcom/intellij/openapi/project/ex/ProjectEx;)V", "createLightProject", "disposeProject", ""}, moduleName="testFramework")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final ProjectEx getSharedProject() {
            return sharedProject;
        }

        private final void setSharedProject(ProjectEx projectEx) {
            sharedProject = projectEx;
        }

        private final AtomicBoolean getProjectOpened() {
            return projectOpened;
        }

        private final ProjectEx createLightProject() {
            PersistentFS persistentFS = PersistentFS.getInstance();
            if (persistentFS == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl");
            }
            ((PersistentFSImpl)persistentFS).cleanPersistedContents();
            Path projectFile = TemporaryDirectoryKt.generateTemporaryPath("light_temp_shared_project" + ".ipr");
            String projectPath = PathKt.getSystemIndependentPath(projectFile);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ExceptionsKt.printStackTrace((Throwable)new Throwable(projectPath, null), (PrintStream)new PrintStream(buffer));
            Project project2 = PlatformTestCase.createProject(projectPath, "Light project: " + buffer);
            if (project2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.ex.ProjectEx");
            }
            ProjectEx project3 = (ProjectEx)project2;
            Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)new Disposable(projectFile){
                final /* synthetic */ Path $projectFile;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void dispose() {
                    try {
                        com.intellij.testFramework.ProjectRule$Companion.access$disposeProject(ProjectRule.Companion);
                    }
                    finally {
                        Files.deleteIfExists(this.$projectFile);
                    }
                }
                {
                    this.$projectFile = path;
                }
            });
            VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
            if (virtualFilePointerManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
            }
            ((VirtualFilePointerManagerImpl)virtualFilePointerManager).storePointers();
            return project3;
        }

        private final void disposeProject() {
            ProjectEx projectEx = this.getSharedProject();
            if (projectEx == null) {
                return;
            }
            ProjectEx project2 = projectEx;
            this.setSharedProject(null);
            FixtureRuleKt.access$setSharedModule$p(null);
            Disposer.dispose((Disposable)((Disposable)project2));
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }

        public static final /* synthetic */ void access$disposeProject(Companion $this) {
            $this.disposeProject();
        }
    }
}

