/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PathKt;
import com.intellij.testFramework.TemporaryDirectory$sanitizedName$1;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"G\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0003\u0011!Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u00031\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002K\u0011!!\u0002c\u0004\u000e\u0003aAQ\u0005\u0004\u0003\f\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\n3\rA!\"D\u0001\u0019\u0016\u0015JA!\u0001\u0005\f\u001b\u0005A*!\u0007\u0003\t\u00185\u0011A\u0012\u0001M\u0004K%AA\"D\u0001\u0019\u001ae)A!\u0001\u0005\u000e\u001b\ta\t\u0001g\u0002&\u001d!mQ\"\u0001M\u00033\u0015!\u0011\u0001C\u0007\u000e\u00051\u0005\u0001tA\r\u0005\t\u0005Aa\"D\u0001\u0019\u001e\u0015J\u0001bD\u0007\u00021?IR\u0001B\u0001\t\u001b5\u0011A\u0012\u0001M\u0004S)!\u0011\t\u0003E\u0002\u001b\u0011I!!C\u0001\u0019\u0006a\u0011\u0011kA\u0001\u0006\u0001%*B!\u0011\u000f\t\t5\t\u0001tA\r\u0004\u0011\ri\u0011\u0001g\u0002\u001dC\u0001\n\u0013kA\u0005\u0006\u0005\u00115\u0001bB\u0007\u0003\t\u0013AQ!\u0005\u0002\u0005\f!1\u0001"}, strings={"Lcom/intellij/testFramework/TemporaryDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "paths", "Lcom/intellij/util/SmartList;", "Ljava/nio/file/Path;", "<set-?>", "", "sanitizedName", "getSanitizedName", "()Ljava/lang/String;", "setSanitizedName", "(Ljava/lang/String;)V", "sanitizedName$delegate", "Lkotlin/properties/ReadWriteProperty;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "generatePath", "suffix", "newDirectory", "Ljava/io/File;", "directoryName", "newPath", "refreshVfs", "", "newVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="testFramework")
public final class TemporaryDirectory
extends ExternalResource {
    private final SmartList<Path> paths = new SmartList();
    private final ReadWriteProperty<Object, String> sanitizedName$delegate = Delegates.INSTANCE.notNull();
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final String getSanitizedName() {
        return (String)this.sanitizedName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSanitizedName(String string) {
        this.sanitizedName$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        String string = FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.sanitizeFileNam\u2026iption.methodName, false)");
        this.setSanitizedName(string);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    protected void after() {
        SmartList errors = new SmartList();
        for (Path path : this.paths) {
            try {
                PathKt.deleteRecursively(path);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
        this.paths.clear();
    }

    @NotNull
    public final File newDirectory(@Nullable String directoryName) {
        File file2 = this.generatePath(directoryName).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"generatePath(directoryName).toFile()");
        return file2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File newDirectory$default(TemporaryDirectory temporaryDirectory, String string, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.newDirectory(string);
    }

    @NotNull
    public final Path newPath(@Nullable String directoryName, boolean refreshVfs) {
        Path path = this.generatePath(directoryName);
        if (refreshVfs) {
            PathKt.refreshVfs(path);
        }
        return path;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path newPath$default(TemporaryDirectory temporaryDirectory, String string, boolean bl, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return temporaryDirectory.newPath(string, bl);
    }

    private final Path generatePath(String suffix) {
        String fileName = this.getSanitizedName();
        if (suffix != null) {
            fileName = fileName + ("_" + suffix);
        }
        Path path = TemporaryDirectoryKt.generateTemporaryPath(fileName);
        this.paths.add((Object)path);
        return path;
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@Nullable String directoryName) {
        Path path = this.generatePath(directoryName);
        PathKt.createDirectories(path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath(path));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ VirtualFile newVirtualDirectory$default(TemporaryDirectory temporaryDirectory, String string, int n) {
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.newVirtualDirectory(string);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)TemporaryDirectory$sanitizedName$1.INSTANCE};
    }

    @NotNull
    public static final /* synthetic */ String access$getSanitizedName$p(TemporaryDirectory $this) {
        return $this.getSanitizedName();
    }

    public static final /* synthetic */ void access$setSanitizedName$p(TemporaryDirectory $this, @NotNull String string) {
        $this.setSanitizedName(string);
    }
}

