/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.testFramework.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u00015M\u0001\u0002A\u0007\u00021\u0003IB\u0001C\u0001\u000e\u00051\u0005\u00014\u0001+\u0004\u0005\u0001"}, strings={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "TemporaryDirectoryKt"}, moduleName="testFramework")
public final class TemporaryDirectoryKt {
    @NotNull
    public static final Path generateTemporaryPath(@Nullable String fileName) {
        Path tempDirectory = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Path path = tempDirectory.resolve(fileName);
        for (int i = 0; PathKt.exists(path) && i < 9; ++i) {
            path = tempDirectory.resolve(fileName + "_" + i);
        }
        if (PathKt.exists(path)) {
            throw (Throwable)new IOException("Cannot generate unique random path");
        }
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        return path2;
    }
}

